/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*
** MANUAL
**	DIHDRCLK 3x, "October, 26 1993"
**
** NAME
**	dihdrowl - read in sclk coeff header write SFDU
**	header for double precision sclk coefficient file.
**
** SYNOPSIS
**
**	  #include  <glowsce.h>
**
**	  int dihdrowl(rtcode);
**
**	  char      *rtcode;
**
** PARAMETERS
**
**	 1. rtcode - return code. 4 characters.
**
** EXTERNS
**
**	 1. fdowlt - SFFDEFOPEN - input coefficient file.
**	    glowlsce.h
**	 2. fdowlt_out - SFFDEFOPEN - output dp coefficient file.
**	    glowsce.h.
**	 3. dpowlt_file - char - double precision file name.
**
** DESCRIPTION
**
**	'dihdrowl' reads in an ASCII OWLT file.
**	Reads in the header and creates meta-data for
**	an SFDU file.
**
**	The header consists of 80 byte records and looks
**	like the following.
**	 $$ULS       LIGHT TIME FILE
**	 *LITIME     OWLT5(  )       
**	 *PREP                                
**	 *TITLE                               
**	 *SCID       5                         
**	 *RUNID      ENTER LITIME  8-OCT-1990 23:43:56 
**	 *CREATION   JPL 90-281/23:43:56                             
**	 *BEGIN      SCE 90-280/00:25:00.000  ERT 90-280/00:25:57.952
**	 *CUTOFF     SCE 93-196/00:00:00.000                 
**	 *PFILE                                               
**	 *1W LIGHT TIME FOR ULYSSES (U90280B)                       
**	 *     SCE                     DOWN-LEG        UP-LEG       
**	 $$EOS                                                      
**
**	The output double precision OLWT file header looks like
**	 CCSD3ZF0000100000001NJPL3KS0L015$$owlt$$
**	 MISSION_NAME=ULYSSES;
**	 SPACECRAFT_NAME=ULS;
**	 DATA_SET_ID=DOUBLE_PRECISION_OWLT;
**	 FILE_NAME=uls.dp1owlt.data;
**	 PRODUCT_CREATION_TIME=1990-285T14:49:10;
**	 PRODUCT_VERSION_ID=1;
**	 PRODUCER_ID=DMT;
**	 APPLICABLE_START_TIME=1990-285T14:49:10;
**	 APPLICABLE_STOP_TIME=1999-12-30T12:00:00.000;
**	 MISSION_ID=3;
**	 SPACECRAFT_ID=55;
**	 TARGET_PARAMETER_NAME=SCET_AND_ERT;
**	 TARGET_PARAMETER_EPOCH=1950-001T00:00:00.000;
**	 CCSD$$MARKER$$owlt$$NJPL3IFxxxx00000001
** END MAN PAGES
*/
#endif
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"DCHDROW0") csect(STATIC,"DCHDROW1")
#endif
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<glbltme.h>
#include	<glowlsce.h>
#include	<dictmerr.h>
#include	<dihdrowl.h>


dihdrowl(rtcode)

char	*rtcode;

{


int	read;
int	toread;

/*initia;ize here*/
if (strcmp(times_data_init,"YES"))
{
	ditminit();
}
/*start with the first two SFDU labels */
fprintf(fdowlt_out,
	"%s\n",LEADING_OWLT_SFDU);
owlsfdunominal(rtcode);
toread = 160;
r0owlt(toread,hdr_rec,&read,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d0creowlhdr(rtcode);
if (rtcode[3] == 'X')
{
	/*error in getting header*/
	return;
}
/*finish header*/
d0owlhdrfin(rtcode);
return;
}

static
owlsfdunominal(rtcode)

char	*rtcode;

{

char	*pntr;
char	*pntr1;

/*ok do it now*/
/*get current time*/
strcpy(type_in,"CURRENT");
strcpy(type_out,"CCSDSDOY");
dictmcnv(tarray,NULL,NULL,dptimes,tstrng,type_in,
		type_out,strng,rtcode);
fprintf(fdowlt_out,"%s=%s;\n",
	meta_data[CREATION_INDX],
	strng);
/*do epochs here*/
fprintf(fdowlt_out,"%s=%s;\n",
	meta_data[TP_EPOCH_INDX],
	CLOWEPS.epoch);
fprintf(fdowlt_out,"%s=%s;\n",
	meta_data[TP_NAME_INDX],
	OWLT_TP_NAME);
/*dataset id*/
fprintf(fdowlt_out,"%s=%s;\n",
	meta_data[DATA_SET_ID_INDX],
	OWLT_DATA_SET_ID);
/*file name here,dpowlt_file*/
/*get file name sans path*/
pntr = dpowlt_file;
pntr1 = strchr(pntr,'/');
while (pntr1 != NULL)
{
        pntr = pntr1 + 1;
        pntr1 = strchr(pntr,'/');
}
fprintf(fdowlt_out,"%s=%s;\n",
        meta_data[FILE_NAME_INDX],
        pntr);
return;
}	

static
d0owlhdrfin(rtcode)

char *rtcode;

{

/*write out tail of sfdu info*/
fprintf(fdowlt_out,"%s",
	TRAILING_OWLT_SFDU);
return;
}

static
d0creowlhdr(rtcode)

char	*rtcode;

{
	
char	*pntr;
int	i;
BOOL	noeol; /*no end of line*/
int	len;
int	msn_indx;
long	int	minus_offset;
/*
*     SCE                     DOWN-LEG        UP-LEG
$$EOS 
*/                       
/*find '*' starts next record*/
pntr = strchr(hdr_rec,'*');
if (pntr == NULL)
{
	/*is not an SCLK/SCET file*/
	printf("This is not an SCET/SCLK file\n");
	strcpy(rtcode,err_rtrn_code[CLN_INDX]);
	return;
}
/*find record length*/
owlrecsize = (long int)pntr - (long int)hdr_rec;
/*find if '\n' last character of size*/
/*go to start of record*/
SFFSEEK(fdowlt,0,SFSEEK_SET);
owlnhdrec = 0;
while (TRUE)
{
	r0owlt(owlrecsize,hdr_rec,&read,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	owlnhdrec++;
	if (!strncmp(hdr_rec,"$$EOS",5))
	{
		break;
	}
}
/*compute offset to data*/
owloffset = owlnhdrec * owlrecsize;
/*first mision and spacecraft info*/
msn_indx = msn_case_nmbr*3;
/*mission name*/
fprintf(fdowlt_out,"%s=%s;\n",
	meta_data[MSN_NAME_INDX],
	msn_names_etc[msn_indx]);
/*spacecraft name*/
fprintf(fdowlt_out,"%s=%s;\n",
	meta_data[SC_NAME_INDX],
	msn_names_etc[msn_indx+1]);
/*mission id*/
fprintf(fdowlt_out,"%s=%d;\n",
	meta_data[MSN_ID_INDX],
	msn_case_nmbr);
/*spacecraft id or number*/
fprintf(fdowlt_out,"%s=%s;\n",
	meta_data[SC_ID_INDX],
	msn_names_etc[msn_indx+2]);
/*producers id*/
fprintf(fdowlt_out,"%s=DMT;\n",
	meta_data[PRODUCER_ID_INDX]);
/*get start and stop times*/
/***************************************
          1         2         3         4
01234567890123456789012345678901234567890
*1W LIGHT TIME FOR ULYSSES (U90280B)           
*     SCE                     DOWN-LEG       
$$EOS                                                      
90-275/00:00:00                   0.000                 03
*****************************************/
r0owlt(owlrecsize,hdr_rec,&read,rtcode);
/*read in ASCII count scet etc*/
if (rtcode[3] == 'X')
{
	return;
}
owlnhdrec++;
memcpy(tstrng,&hdr_rec[0],15);
tstrng[19] = '\0';
strcpy(type_in,"CHAR");
strcpy(type_out,"CCSDSDOY");
dictmcnv(tarray,NULL,NULL,dptimes,tstrng,type_in,
		type_out,strng,rtcode);
fprintf(fdowlt_out,"%s=%s;\n",
	meta_data[START_TIME_INDX],
	strng);
/*go to end of file*/
SFFSEEK(fdowlt,0,SFSEEK_END);
/* End is **************************************************************
93-196/00:00:00                2577.247       2576.942  03 9303182233255    8749
$$EOF 
***************************/                
/*go back 2 records length*/
minus_offset = (long int)(owlrecsize*2);
SFFSEEK(fdowlt,-minus_offset,SFSEEK_CUR);
/*see if we are there*/
to_read = 160;
r0owlt(to_read,hdr_rec,&read,rtcode);
/*read in ASCII count scet etc*/
if (rtcode[3] == 'X')
{
	return;
}
if (strncmp(&hdr_rec[owlrecsize],"$$EOF",5))
{
	/*no end of file mark so do not try*/
	return;
}
owlnhdrec++;
if (hdr_rec[2] == '-'  &&
    hdr_rec[6] == '/')
{
	/*this is a proper time*/
	memcpy(tstrng,&hdr_rec[0],15);
	tstrng[19] = '\0';
	dictmcnv(tarray,NULL,NULL,dptimes,tstrng,type_in,
		type_out,strng,rtcode);
	fprintf(fdowlt_out,"%s=%s;\n",
		meta_data[STOP_TIME_INDX],
		strng);
}
return;
}
		
static
r0owlt(toread,buf,read,rtcode)

int	toread;
char	*buf;
int	*read;
char	*rtcode;

{

read[0] = SFFREAD(fdowlt,buf,toread);
if (read[0] !=  toread)
{
	strcpy(rtcode,err_rtrn_code[OWR_INDX]);
}
return;
}

