/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef	Header
/*****************************************************************
 * TITLE: streader.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 *****************************************************************
** MANUAL
**	CORWINC 3x,"September 7, 1993"
**
** NAME 
**	forwinc - FORTRAN opens closes reads writes in 'C'
**
** SYNOPSIS
**
**	  long int copennc(fds_indx,file_name,option);
**
**	  long int *fds_indx;
**	  char *file_name;
**	  char *option;
**
**	  long int cbgnfil(fds_indx);
**
**	  long	int	*fds_indx;
**
**	  long int crdnc(fds_indx,buf,len);
**
**	  long int *fds_indx;
**	  char *buf;
**	  long	*len;
**
**	  long int cwrtnc(fds_indx,buf,len);
**
**	  long int *fds_indx;
**	  char *buf;
**	  long	*len;
**
**	  void crnta8(fds_indx,buf,len6,cde)
**
**	  long int *fds_indx;
**	  char *buf;
**	  long int *len6;
**	  long int *cde;
**	   
**	  long int cclosnc(fds_indx);
**
**	  long int *fds_indx;
**
**	  long int cfrcln(fds_indx)
**
**	  long int *fds_indx;
**
** PARAMETERS
**
**	 1. file_name - name of file to open. Input.
**	 2. fds_indx - long int - index to file descriptor.
**	    output from open. Input from reads and writes.
**	 3. option - byte stream not string. FORTRAN option for
**	    opens 'OLD', 'NEW', 'UNKNOWN'. Where 'OLD' is read only
**	   'NEW' is write only and 'UNKNOWN' is write only.
**	 4. buf - points to buffer to read, 'crdnc', or write buffer,
**	   'cwrtnc'. Input.
**	 5. len - long int pointer - points to length to read or write.
**	    Input.
**	 6. len6 - write length, need to multiply by 6
**	 7. cde - code, usually number of lines to skip;
**
** DESCRIPTION
**
**	The input is from FORTRAN the file names are 100 characters in 
**	length. There is no ending NULL for character byte streams in 
**	FORTRAN.
**
** RETURNS
**	
**	'copennc' returns '0' for success and '-1' for failure.
**	'flosnc' returns '0' for success and '-1' file not open.
**	'crdnc' returns -1 for falure and the lenght, in bytes
**	read into 'buf'
**	'cwrtnc' returns -1 for failure and the length, in bytes,
**	written to the file from buf.
**
*/
#endif /*  Header */
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"CCRWINC0") csect(STATIC,"CCRWINC1")
#endif

#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<sftypes.h>
#include	<sffile.h>

#if (NOPROTO)
static	long	int	fnd_curr_indx();
#else
static	long	int	fnd_curr_indx(long int *);
#endif

SFFSEEKDEF;

static	char	init_status[8];
struct	fds_struct {
	SFFOPDEF(fds);
	long	int	fds_indx;
	char	file_name[100];
	char	*next;
	char	*prev;
};
typedef struct fds_struct FDS;
static	long	int	curr_fds_indx;
static	long	int	last_fds_indx;
static	char	*start_fds;	/*points to first malloced area*/
static	char	*last_fds;
static	FDS	*prev_fds;
static	FDS	*curr_fds;
static	FDS	*next_fds;
static	char	*str_int_pntr;
struct  intervals
{
	long	int	rate;
	long	int	interval;
	long	int	ntraj;
	long	int	nahfs;
	char	sttraj[50];
	char	entraj[50];
	char	stahfs[50];
	char	enahfs[50];
	char	*next;
	char	*prev;
};

static	struct	intervals	*INTERVAL;
static	struct	intervals	*PREV_I;
static	BOOL	ahfst;
static	BOOL	ahfen;
static	BOOL	scest;
static	BOOL	sceen;


void
corwinc()

{

return;
}

long int
copennc(fds_indx,file_name,option)

long	int	*fds_indx;
char	*file_name;
char	*option;

{

char	open_option[4];
char	*curr_pntr;
char	*pntr;
int	chr = ' ';
int	i;

/*check to see if init*/
if(strcmp(init_status,"ATLEAST"))
{
	/*ok we have none to start with*/
	strcpy(init_status,"ATLEAST");
	curr_pntr = malloc(sizeof(struct fds_struct));
	start_fds = curr_pntr;
	if (start_fds == NULL)
	{
		perror("Error in malloc");
		return(-1);
	}
	curr_fds_indx = 1;
	last_fds_indx = 1;
	curr_fds = (FDS *)start_fds;
	curr_fds->prev = NULL;
	last_fds = start_fds;
	prev_fds = (FDS *)NULL;
}
else
{
	prev_fds = (FDS *)last_fds;
	curr_pntr = malloc(sizeof(FDS));
	if (curr_pntr == NULL)
	{
		perror("Error in malloc");
		return(-1);
	}
	prev_fds->next = curr_pntr;
	curr_fds_indx = last_fds_indx + 1;
	curr_fds = (FDS *)prev_fds->next;
	curr_fds->prev = (char *)prev_fds;
	last_fds_indx++;
	last_fds = prev_fds->next;
}
curr_fds->fds_indx = curr_fds_indx;
curr_fds->next = NULL;
/*ok now open*/
switch (option[0])
{
	case 'O': /*old*/
		strcpy(open_option,SFRDONLY);
	break;
	case 'N': /*NEW*/
	case 'U': /*UNKNOWN*/
		strcpy(open_option,SFWRTONLY);
	break;
	case 'W': /*WRTREAD*/
		strcpy(open_option,SFWRTRD);
        break;
        default:
		printf("%s is an unknown option\n",option);
	        return(-1);
	break;
} /*end of switch*/
/*find end of file name*/
memcpy(curr_fds->file_name,file_name,99);
for ( i = 0 ; i < 99 ; i++)
{
	if (curr_fds->file_name[i] == ' '  ||
	    iscntrl(curr_fds->file_name[i]))
	{
		curr_fds->file_name[i] = '\0';
		break;
	}
}
SFFOPEN(curr_fds->fds,curr_fds->file_name,open_option);
if (SFFERROPEN(curr_fds->fds))
{
	perror("error in open");
	printf("for file %s\n",file_name);
	/*ok go down*/
	free(curr_pntr);
	fds_indx[0] = 0;
	if (prev_fds == (FDS *)NULL)
	{
		init_status[0] = '\0';
	}
	else
	{
		prev_fds->next = NULL;
		last_fds_indx--;
		last_fds = (char *)prev_fds;
	}
	return(-1);
}
fds_indx[0] = curr_fds_indx;
return(0);
}

long int
cclosnc(fds_indx)

long	int	*fds_indx;

{

char	*fds_pntr;
long	int	rtc;

/*check to see if init*/
if(strcmp(init_status,"ATLEAST"))
{
	/*There are none open*/
	return(-1);
}
rtc = fnd_curr_indx(fds_indx);
if (rtc)
{
	return(rtc);
}
/*ok now close this up*/
SFFCLOSE(curr_fds->fds);
fds_pntr = (char *)curr_fds;
if (curr_fds->prev == NULL)
{
	/*this is first in line*/
	if (curr_fds->next == NULL)
	{
		/*this is the one and only*/
		free(start_fds);
		init_status[0] = '\0';
		return(0); /*ok fini*/
	}
	next_fds = (FDS *)curr_fds->next;
	next_fds->prev = NULL;
	free(fds_pntr);
	curr_fds = next_fds;
	curr_fds_indx = curr_fds->fds_indx;
	start_fds = (char *)curr_fds; /*this is the bottom*/
	return(0);
}
else if (curr_fds->next == NULL)
{
	/*no next but there is a previous*/
	prev_fds = (FDS *)curr_fds->prev;
	prev_fds->next = NULL;
}
else
{
	/*there is a previous and a next rechain*/
	next_fds = (FDS *)curr_fds->next;
	prev_fds = (FDS *)curr_fds->prev;
	prev_fds->next = curr_fds->next;
	next_fds->prev = curr_fds->prev;
}
free(fds_pntr);
curr_fds = prev_fds;
curr_fds_indx = curr_fds->fds_indx;
return(0);
}

long int
crdahf(fds_indx,buf,len)

long	int	*fds_indx;
char	*buf;
long	int	*len;

{

long	int	rtc;
int	len_to_read;
int	len_read;
char	year_2[3];
int	i;
int	year_2_i;
long	int	pos;

/*check to see if init*/
if(strcmp(init_status,"ATLEAST"))
{
	/*There are none open*/
	return(-1);
}
rtc = fnd_curr_indx(fds_indx);
if (rtc)
{
	return(rtc);
}
/*ok read in minimum record length + 10 for attitude history file*/
/*
         1         2         3         4         5         6         7
1234567890123456789012345678901234567890123456789012345678901234567890122345679
90 279 22 07 44     90 284 17 15 06     110.244  27.720 0.7166    0.0000    001
*/
year_2[2] = '\0';
len_to_read = (int)len[0]+10;
len_read = SFFREAD(curr_fds->fds,buf,len_to_read);
if (len_read < 0)
{
	perror("Error in read");
	printf("For file %s\n",curr_fds->file_name);
	return(-1);
}
if (!len_read)
{
	return(0);
}
if (len_read < len_to_read)
{
	return(len_read);
}
/*looking for YY DOY*/
for ( i = (int)len[0] ;  i < len_to_read ; i++)
{
	/*buf[i] will be first part of year*/
	if (!isalnum(buf[i]))
	{
		continue;
	}
	if (isalpha(buf[i]))
	{
		continue;
	}
	/*buf[i+2] should be blank if i is YY*/
	if (buf[i+2] != ' ')
	{
		continue;
	}
	/*second part of year*/
	if (!isalnum(buf[i+1]))
	{
		continue;
	}
	if (isalpha(buf[i+1]))
	{
		continue;
	}
	memcpy(year_2,&buf[i],2);
	sscanf(year_2,"%d",&year_2_i);
	if (year_2_i >= 90 && year_2_i <= 99)
	{
		break; /*found it*/
	}
}
/* i has where we want to be*/

pos = i - len_to_read; /*negative*/
/*ok now close this up*/
SFFSEEK(curr_fds->fds,pos,SFSEEK_CUR);
return(len_read);
}

long int
cbgnfil(fds_indx)

long	int	*fds_indx;

{

char	*fds_pntr;
long	int	rtc;

/*check to see if init*/
if(strcmp(init_status,"ATLEAST"))
{
	/*There are none open*/
	return(-1);
}
rtc = fnd_curr_indx(fds_indx);
if (rtc)
{
	return(rtc);
}
/*ok now close this up*/
SFFSEEK(curr_fds->fds,0,SFSEEK_SET);
return(0);
}


long	int
crdnc(fds_indx,buf,len)

long	int	*fds_indx;
char	*buf;
long	int	*len;

{

long	int	rtc;
int	len_to_read;
int	len_read;

rtc = fnd_curr_indx(fds_indx);
if (rtc)
{
	return(rtc);
}
/*we have current*/
/*read*/
len_to_read = (int)len[0];
len_read = SFFREAD(curr_fds->fds,buf,len_to_read);
if (len_read < 0)
{
	perror("Error in read");
	printf("For file %s\n",curr_fds->file_name);
	return(-1);
}
rtc = len_read;
return(rtc);
}

long	int
cwrtnc(fds_indx,buf,len)

long	int	*fds_indx;
char	*buf;
long	int	*len;

{

long	int	rtc;
int	len_to_write;
int	len_write;

rtc = fnd_curr_indx(fds_indx);
if (rtc)
{
	return(rtc);
}
/*we have current*/
/*write*/
len_to_write = (int)len[0];
len_write = SFFWRITE(curr_fds->fds,buf,len_to_write);
if (len_to_write < 0)
{
	perror("Error in write");
	printf("For file %s\n",curr_fds->file_name);
	return(-1);
}
rtc = len_write;
return(rtc);
}


void
crnta8(fds_indx,buf,len6,cde)

long	int	*fds_indx;
char	*buf;
long	int	*len6;
long	int     *cde;

{

char	pbuf[80];
long	int	rtc;
int	len_to_write;
int	i;

rtc = fnd_curr_indx(fds_indx);
if (rtc)
{
	return;
}
/*we have current*/
if (cde[0] == 63)
{
	/*this is new page*/
	fprintf(curr_fds->fds,"\n\n\n");
}
/*write*/
len_to_write = (int)len6[0]*6;
memcpy(pbuf,buf,len_to_write);
pbuf[len_to_write] = '\0';
fprintf(curr_fds->fds,"%s",pbuf);
rtc = len_to_write;
if (cde[0] == 63)
{
	/*this is new page*/
}
else
{
	for ( i = 0 ; i < cde[0] ; i++)
	{
		fprintf(curr_fds->fds,"\n");
	}
}
return;
}


long int
cfrcln(fds_indx)

long	int	*fds_indx;

{

char	*fds_pntr;
long	int	rtc;
char	buf[120];
int	rdl;
char	*pntr;

/*check to see if init*/
if(strcmp(init_status,"ATLEAST"))
{
	/*There are none open*/
	return(-1);
}
rtc = fnd_curr_indx(fds_indx);
if (rtc)
{
	return(rtc);
}
rdl = 119;
rdl = SFFREAD(curr_fds->fds,buf,rdl);
if (rdl < 0)
{
	perror("Error in read");
	printf("For file %s\n",curr_fds->file_name);
	return(-1);
}
buf[rdl] = '\0';
pntr = strchr(buf,'\n');
if (pntr != NULL)
{
	rtc = (long int)pntr - (long int)buf + 1;
}
else
{
	rtc = 0;
}
/*ok now seek to start*/
SFFSEEK(curr_fds->fds,0,SFSEEK_SET);
return(rtc);
}

static	long	int	
fnd_curr_indx(fds_indx)

long	int	*fds_indx;

{

if (curr_fds_indx != fds_indx[0])
{
	if (fds_indx[0] < 1  || fds_indx[0] > last_fds_indx)
	{
		/*index into linked list is out of bounds*/
		return(-1);
	}
	/*search for indx*/
	curr_fds = (FDS *)start_fds;
	while (TRUE)
	{
		if (curr_fds->fds_indx == fds_indx[0])
		{
			curr_fds_indx = curr_fds->fds_indx;
			break;
		}
		if (curr_fds->next == NULL)
		{
			/*none to close*/
			curr_fds_indx = curr_fds->fds_indx;
			return(-1);
		}
		/*get next*/
		curr_fds = (FDS *)curr_fds->next;
	}
}
return(0);
}

long int
cplcint(lasrate,numints,instsce,inensce,numtrajs,
        instahf,inenahf,numahfs)

long	int	*lasrate;
long	int	*numints;
char	*instsce;
char	*inensce;
long	int	*numtrajs;
char	*instahf;
char	*inenahf;
long	int	*numahfs;

{

int	i;

if (numints[0] == 1L)
{
	/*first time thru*/
	/*malloc*/
	str_int_pntr = malloc(sizeof(struct intervals));
	if (str_int_pntr == NULL)
	{
		printf("Error in getting core for intervals\n");
		return(-1);
	}
	INTERVAL = (struct intervals *)str_int_pntr;
	INTERVAL->prev = NULL;
}
else
{
	PREV_I->next =malloc(sizeof(struct intervals));
	if (PREV_I->next == NULL)
	{
		printf("Error in getting core for intervals\n");
		return(-1);
	}
	INTERVAL = (struct intervals *)PREV_I->next;
	INTERVAL->prev = (char *)PREV_I;
}
INTERVAL->rate = lasrate[0];	
INTERVAL->nahfs = numahfs[0];
INTERVAL->ntraj = numtrajs[0];
INTERVAL->interval = numints[0];
ahfen = TRUE;
ahfst = TRUE;
scest = TRUE;
sceen = TRUE;
i = 0;
for (;;)
{
	if (scest)
	{
		if (instsce[i] == ' ')
		{
			scest = FALSE;
			INTERVAL->sttraj[i] = '\0';
		}
		else
		{
			INTERVAL->sttraj[i] = instsce[i];
		}
	}
	if (sceen)
	{
		if (inensce[i] == ' ')
		{
			sceen = FALSE;
			INTERVAL->entraj[i] = '\0';
		}
		else
		{
			INTERVAL->entraj[i] = inensce[i];
		}
	}
	if (ahfst)
	{
		if (instahf[i] == ' ')
		{
			ahfst = FALSE;
			INTERVAL->stahfs[i] = '\0';
		}
		else
		{
			INTERVAL->stahfs[i] = instahf[i];
		}
	}
 	if (ahfen)
	{
		if (inenahf[i] == ' ')
		{
			ahfen = FALSE;
			INTERVAL->enahfs[i] = '\0';
		}
		else
		{
			INTERVAL->enahfs[i] = inenahf[i];
		}
	}
	i++;
	if (!scest  &&  !sceen  && !ahfst  &&  !ahfen)
	{
		break;
	}
}
PREV_I = INTERVAL;
return(0);
}


long int
cprtint(fds_indx)

long	int	*fds_indx;

{

long	int	rtc;

/*check to see if init*/
if(strcmp(init_status,"ATLEAST"))
{
	/*There are none open*/
	return(-1);
}
rtc = fnd_curr_indx(fds_indx);
if (rtc)
{
	return(rtc);
}
/*curr_fds->fds is pointer to summary file*/
/****************************************************
struct  intervals
{
	long	int	rate;
	long	int	interval;
	long	int	ntraj;
	long	int	nahfs;
	char	sttraj[50];
	char	entraj[50];
	char	stahfs[50];
	char	enahfs[50];
	char	*next;
	char	*prev;
};

******************************************************/
INTERVAL = (struct intervals *)str_int_pntr;
for (;;)
{
	fprintf(curr_fds->fds,
		"\nINTERVAL %d\n\n",INTERVAL->interval);	
	fprintf(curr_fds->fds,
		"    AHF SCET . . . . %s -To - %s\n",
		INTERVAL->stahfs,
		INTERVAL->enahfs);
	fprintf(curr_fds->fds,
		"    SCET . . . . . . %s -To - %s\n",
		INTERVAL->sttraj,
		INTERVAL->entraj);
	fprintf(curr_fds->fds,
		"    RATE . . . . . . 1 RECORD / %ld SECONDS\n\n",
		INTERVAL->rate);
	fprintf(curr_fds->fds,
		"    SUBTOTALS  . . . AHF RECORDS USED %ld",
		INTERVAL->nahfs);
	fprintf(curr_fds->fds,
	     "DATA RECORDS %ld\n\n",
		INTERVAL->ntraj);
	if (INTERVAL->next == NULL)
	{
		break;
	}
	PREV_I = INTERVAL;
	INTERVAL = (struct intervals *)INTERVAL->next;
	free (INTERVAL->prev);
}

return(0);
}

long int
cprtsmry(fds_indx,lasrate,instsce,inensce,numtrajs,
        instahf,inenahf,numahfs,sedrid,gendate,gentime)

long	int	*fds_indx;
long	int	*lasrate;
char	*instsce;
char	*inensce;
long	int	*numtrajs;
char	*instahf;
char	*inenahf;
long	int	*numahfs;
char	*sedrid;
long	int	*gendate;
long	int	*gentime;

{


long	int	rtc;
char	idsedr[7];
int	i;

/*check to see if init*/
if(strcmp(init_status,"ATLEAST"))
{
	/*There are none open*/
	return(-1);
}
rtc = fnd_curr_indx(fds_indx);
if (rtc)
{
	return(rtc);
}
/*curr_fds->fds is pointer to summary file*/
str_int_pntr = malloc(sizeof(struct intervals));
if (str_int_pntr == NULL)
{
	printf("Error in getting core for intervals\n");
	return(-1);
	}
INTERVAL = (struct intervals *)str_int_pntr;
INTERVAL->prev = NULL;
ahfen = TRUE;
ahfst = TRUE;
scest = TRUE;
sceen = TRUE;
i = 0;
for (;;)
{
	if (scest)
	{
		if (instsce[i] == ' ')
		{
			scest = FALSE;
			INTERVAL->sttraj[i] = '\0';
		}
		else
		{
			INTERVAL->sttraj[i] = instsce[i];
		}
	}
	if (sceen)
	{
		if (inensce[i] == ' ')
		{
			sceen = FALSE;
			INTERVAL->entraj[i] = '\0';
		}
		else
		{
			INTERVAL->entraj[i] = inensce[i];
		}
	}
	if (ahfst)
	{
		if (instahf[i] == ' ')
		{
			ahfst = FALSE;
			INTERVAL->stahfs[i] = '\0';
		}
		else
		{
			INTERVAL->stahfs[i] = instahf[i];
		}
	}
 	if (ahfen)
	{
		if (inenahf[i] == ' ')
		{
			ahfen = FALSE;
			INTERVAL->enahfs[i] = '\0';
		}
		else
		{
			INTERVAL->enahfs[i] = inenahf[i];
		}
	}
	i++;
	if (!scest  &&  !sceen  && !ahfst  &&  !ahfen)
	{
		break;
	}
}
memcpy(idsedr,sedrid,6);
idsedr[6] = '\0';
fprintf(curr_fds->fds,
	"\nSEDR SUMMARY\n\n");
fprintf(curr_fds->fds,
	"    PROJECT ID . . . . . . . . . ULS\n");
fprintf(curr_fds->fds,
	"    FILE ID  . . . . . . . . . . SEDR\n");
fprintf(curr_fds->fds,
	"    SPACECRAFT ID  . . . . . . . 55\n");
fprintf(curr_fds->fds,
	"    SEDR PACKAGE ID  . . . . . . %s\n",
	idsedr);
fprintf(curr_fds->fds,
	"    SEDR GENERATION DATE . . . . %ld\n",
	gendate[0]);
fprintf(curr_fds->fds,
	"    SEDR GENERATION TIME . . . . %06ld\n\n",
	gentime[0]);
fprintf(curr_fds->fds,
	"    AHF SCET . . . . %s -To - %s\n",
	INTERVAL->stahfs,
	INTERVAL->enahfs);
fprintf(curr_fds->fds,
	"    SCET . . . . . . %s -To - %s\n",
	INTERVAL->sttraj,
	INTERVAL->entraj);
if (lasrate[0] > 0)
{
	fprintf(curr_fds->fds,
		"    RATE . . . . . . 1 RECORD / %ld SECONDS\n\n",
		lasrate[0]);
}
fprintf(curr_fds->fds,
	"    TOTALS ...... AHF RECORDS USED %ld",
	numahfs[0]);
fprintf(curr_fds->fds,
	"     DATA RECORDS GENERATED %ld\n\n",
	numtrajs[0]);

return(0);
}
