/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*****************************************************************
 * TITLE: diertscecnv.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 *****************************************************************
** MANUAL
**	CNVBTC 3x "August 18, 1993"
**
** NAME
**	cnvbtc - convert integer(s) to binary characters
**
** SYNOPSIS
**
**	   void  cnvbtc(int_in,bit_pos,nchars,char_out);
**
**	   long  int   *int_in;
**	   long  int   *bit_pos;
**	   long  int   *nchars;
**	   char  *char_out;
**
** PARAMETERS
**
**	  1. int_in - points to a long integer.
**	  2. bit_pos - which bit to start at in integer.
**	     Most signifigant is zero.
**	  2. nchars - number of bits to convert to character.
**	  3. char_out - where to place character output.
**
** DESCRIPTION
**
**	'cnvbtc' converts a bit strream (input as a long int)
**	to character output. i.e. if int_in[0] = 11 (hex 
**	0000000B) and bit_pos is 24 and nchars is 8 the output 
**	character stream is
**	   '0','0','0','0','1','0','1','1'
**
*/
#endif /*  Header */
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"CCVBTC0") csect(STATIC,"CCVBTC1")
#endif

#include	<stdio.h>
#include	<sftypes.h>
#if (NOPROTO)
extern	void	cnvbtcne();
extern	void	cnvbtcs();
#else
extern	void	cnvbtcne(unsigned long int *,int,int,char *);
extern	void	cnvbtcs(unsigned int,int,int,char *);
#endif
#define	NBITS	8*SIZE_INT;

void
cnvbtc(int_in,bit_posl,ncharsl,char_out)

unsigned long *int_in;
long	int	*bit_posl;
long	int	*ncharsl;
char	*char_out;

{

int	i;
int	unsigned shifti;
int	bit_pos;
int	nchars;
bit_pos = bit_posl[0];
nchars = ncharsl[0];	
if (SIZE_LONG != SIZE_INT)
{
	/*ok size of int is not same as long*/
	cnvbtcne(int_in,bit_pos,nchars,char_out);
	return;
}
/*shift bit_pos  if not zero*/
if (bit_pos)
{
	shifti = int_in[0] << bit_pos;
}
else
{
	shifti = int_in[0];
}
for ( i = 0 ; i < nchars ; i++)
{
	if (shifti & 0x80000000) 
	/* Zero except bit 0 for four byte int*/
	{
		char_out[i] = '1';
	}
	else
	{
		char_out[i] = '0';
	}
	shifti <<= 1; /*shift it down one*/
}
return;
}

void
cnvbtcne(int_in,bit_pos,nchars,char_out)

unsigned long *int_in;
int	bit_pos;
int	nchars;
char	*char_out;

{

int	n;
int	nbits;
int	bit_pos2;
int	nchars2;
int	nchars1;
union	{
	unsigned long int li;
	unsigned int  si[2];
} ui;

nbits = NBITS;
ui.li = int_in[0];
if (bit_pos >= nbits)
{
	/*start in second part of long int*/
	bit_pos2 = bit_pos - nbits;
	cnvbtcs(ui.si[1],bit_pos2,nchars,char_out);
	return;
} 
n = bit_pos + nchars;
if (n >= nbits)
{
	nchars2 = n - nbits;
	bit_pos2 = 0;
	nchars1 = nbits - bit_pos;
}
else
{
	nchars2 = 0;
	nchars1 = nchars1;
}
cnvbtcs(ui.si[0],bit_pos,nchars1,char_out);
if (!nchars2)
{
	return;
}
cnvbtcs(ui.si[1],bit_pos2,nchars2,&char_out[nchars1]);
return;
}
	
void
cnvbtcs(int_in,bit_pos,nchars,char_out)

unsigned int	int_in;
int	bit_pos;
int	nchars;
char	*char_out;

{

int	i;
int	unsigned shifti;
	
/*shift bit_pos  if not zero*/
if (bit_pos)
{
	shifti = int_in << bit_pos;
}
else
{
	shifti = int_in;
}
for ( i = 0 ; i < nchars ; i++)
{
	if (shifti & 0x8000) /*zero all but bit zero for 2 byte int*/
	{
		char_out[i] = '1';
	}
	else
	{
		char_out[i] = '0';
	}
	shifti <<= 1; /*shift it down one*/
}
return;
}

