#ifndef TIMTYPS
#define	TIMTYPS	1
#include	<sftypes.h>
#include	<sffile.h>

#define		SIZE_OF_TARRAY	16
#define		SIZE_OF_DPS	4

struct	epoch_struct {
	char	char_epoch[24];
	long	int	epoch_tarray[SIZE_OF_TARRAY];
	DBL	epoch_dptimes[SIZE_OF_DPS];
	char	epoch_mon[4];
	char	epoch_dow[4];
	char	new_epoch[4];
	BOOL	find_epoch_times;
};
typedef struct epoch_struct EPOCH_STRUCT;

struct clowep_struct {	
	long	int	epoch_indx;
	char	epoch_type[12];
	char	epoch[24];
	EPOCH_STRUCT	clow_ep_save;
};

typedef	struct	clowep_struct CLOWEP_STRUCT;

struct trajep_struct {	
	long	int	epoch_indx;
	char	epoch_type[12];
	char	epoch[24];
};

typedef	struct	trajep_struct TRJEP_STRUCT;

struct	sclkrec /*overall scet clk rec*/
{
	DBL	sclk;		/*counter for any sclk*/
	union	{
		DBL	scet;	/*spacecraft efent time*/
		DBL	A0;	/*constant for function of x (sclk to 
				  scet)*/
	}su;
	DBL	A1;		/*constant times x (sclk to scet)*/
	DBL	dut;		/*difference between UTC and ephemerus 
				  time*/
};
typedef struct	sclkrec	SCLKR;

struct	owltrec /*OWLT rec*/
{
	union	{
		DBL	scet;	/*spacecraft efent time*/
		DBL	A0;	/*constant for function of x (sclk to 
				  scet)*/
	}su;
	DBL	down_leg;
	DBL	up_leg;
	union	{			
		DBL	ert;	/*Earth recieve time*/
		DBL	EA0;	/*constant for funtion of x (ert to 
				  scet)*/
	}eu;	
	DBL	EA1;		/*the constant for x (function for 
				  ert to scet)*/
	DBL	station;/*station number of received data*/
};
typedef	struct owltrec	OWLTREC;

#endif

