      PROGRAM EDR
C
C       This program was obtained from 
C       spdf.gsfc.nasa.gov_pub_data/vgmag-data/raw/source/edrpgm
C
C       ORIGINAL: version of jul 1, 2002
C       MODIFIED: Dec 3, 2021 - Ray Bambery
C		fixed open and read statements
C       	Dec 17, 2021 
C		deleted code, changed open using R*4 reads
C		extensive revisions
C               Dec 21, 2012 - Ray Bambery
C               eng and dcom data added
C               Dec 27, 2021 - Ray Bambery
C		removed debug print statements,
C               print out that must be weekly edr if dcom is 
c		first intrument, Added counters for various intrument 
C		records, added output summary file 
C		Dec 28, 2021 - Ray Bambery
C		correct magxxxxxx.a int*4 value from 108860667 to
C		1105383892.  magxxxxxxx.b int*4 value from 1195383892
C		to 1088606676
C		Fix dcom31.cr and dcom32.cr to stop
C		at 1 hdr + 1 data record
C               added 3rd param for ERT
C 		Dec 30, 2021 - Ray Bambery
C		Changed SCID = 0 to SCID = 2 in subroutine DISPLAY
C               Jan 02, 2022 - Ray Bambery
C		change scid from 1 to 2 for pls/pws
C               Jun 06, 2022 - Ray Bambery
C                put (y/n) after ERT?
C
C       It must be compiled under at least gfortran 7.1 with
C       the -fdec switch
C       
C       All logical*1 were converted to byte since in gfortran 7.1
C       Logical*1 are always T or F
C       NOTE: byte values are always signed
C
C   For EDR format see document 618-306  VGR Experiment Data Record
C	Rev D Chg 4 - 5-1-1986
C   and Rev D Chg 5 - 5-1-1989
C
C EDR HEADER UNPACKING PROGRAM WRITTEN TO BE IMPLEMENTED UNDER VMS
C ARCHITECTURE.  EDR DATA IS WRITTEN FOR THE IBM 360 ARCHITECTURE.
C
C     LOGICAL*1 REC(11280)
C      BYTE rec(5000000)
      CHARACTER*3 instrument,ertopt
      CHARACTER*4 TFLAG
      CHARACTER*10 rec_id
      CHARACTER*50 DSN,OUTF
      INTEGER*2 EDRTIME(6),SCETIME(6),SERTIME(6),EERTIME(6)
        integer*4 reclen,totreclen     ! originally integer*2
        integer*4 stat,rstat,J,I,bytesize,reclensize
C       integer*2 rec4(5000000)
       integer*4 rec3(3000), header(60),rec4(3060)
       integer*4 dsn_len,hdr_len
       integer*4 crs_reclen,crs_datalen, crs_subhdr_len
       integer*4 lec_reclen,lec_datalen, lec_subhdr_len
       integer*4 mag_reclen,mag_datalen, mag_subhdr_len
       integer*4 pls_reclen,pqls_datalen, pls_subhdr_len
       integer*4 pws_reclen,pws_datalen, pws_subhdr_len
       integer*4 subhdr_len,data_len
       integer*4 dcom_cnt,eng_cnt,crs_cnt,lec_cnt,mag_cnt
       integer*4 pls_cnt,pws_cnt
       logical*4 weekly,showert
C
C
      INCLUDE 'unpack.inc'
C
      weekly = .false.
      TFLAG = 'SCET'
C    all in 32-bit words
       hdr_len = 60		!240 bytes
       dcom_reclen = 179        !716
       dcom_subhdr = 7          !28
       dcom_datalen = 112       !448
       eng_reclen = 965         !3860
       eng_subhdr = 5           !20
       eng_datalen =  900       !3600
       crs_reclen = 850		!3400
       crs_datalen = 780	!3120
       crs_subhdr_len = 10	!40
       lec_reclen = 141     	!564
       lec_datalen = 80     	!320
       lec_subhdr_len = 1   	!4
       mag_reclen = 428		!1712
       mag_datalen = 260	!1040
       mag_subhdr_len = 108	!432
       pls_reclen = 168		!674
       pls_datalen = 100	!400
       pls_subhdr_len = 8	!32
       pws_reclen = 135		!540
       pws_datalen = 55		!220
       pws_subhdr_len = 20	!80
C
       dcom_cnt = 0
       eng_cnt = 0
       crs_cnt = 0
       lec_cnt = 0
       mag_cnt = 0
       pls_cnt = 0
       pws_cnt = 0

C  REMOVED 12-03-2021
C CREATE BIT FLIP TRANSLATION TABLE FOR LOGICAL*1 WORDS.  
C ASSIGN FLIP(0:255) THE BIT FLIP INVERSE OF VALUES 0 TO 255.
C
CC      DO J=0,255
CC       DO I=0,7
CC        CALL MOVBIT(J, I, 1, FLIP(J), 7-I)
CC       END DO
CC      END DO
C
C OPEN BINARY EDR INPUT DATASET
C
      WRITE(6,*) 
      WRITE(6,*) 'ENTER EDR INPUT DSN '
C      READ(5,'(Q,A)') LEN,DSN
      Read *, DSN
      print * ,' '
      print *, DSN
      print * , ' '
      WRITE(6,*) 'ENTER OUTPUT SUMMARY FILE'
      read *, OUTF
        INQUIRE(FILE=DSN, SIZE=bytesize)
        print *, 'file size of DSN = ',bytesize
        reclensize = bytesize/4
        if (bytesize .le. 0) goto 1000
       dsn_len = len(DSN)
         if (DSN(1:3) .eq. 'crs') then
             reclen = crs_reclen
             instrument = 'crs'
         endif
         if (DSN(1:3) .eq. 'lec') then
             reclen = lec_reclen
             instrument = 'lec'
         endif
         if (DSN(1:3) .eq. 'mag') then
             reclen = mag_reclen
             instrument = 'mag'
         endif
         if (DSN(1:3) .eq. 'pls') then
             reclen = pls_reclen
             instrument = 'pls'
         endif
         if (DSN(1:3) .eq. 'pws') then
             reclen = pws_reclen
             instrument = 'pws'
         endif
         if (DSN(1:3) .eq. 'eng') then
            reclen = eng_reclen
            instrument = 'eng'
         endif
         if (DSN(1:3) .eq. 'dco') then
            reclen= dcom_reclen
            instrument = 'dco'
         endif
C
C	add 3rd param
C
        print *,' '
        print *," ERT (y/n)? "
        print *,' '
        read *, ertopt
        showert = .false.
        if (ertopt .eq. 'y' .or. ertopt .eq. 'Y') then
           showert = .true.
        endif

C
C	open output summary file, added to code 12-27-2021
        open (2,FILE=OUTF,FORM='FORMATTED')
C
C       As originally described, the stream formatted edr was transformed
C       by the program edr_reblock_sort.for from "UNFORMATTED" to
C       "UNFORMATTED" RECORDTYPE="VARIABLE". Then the OPEN statement
C       was used to open the reformatted file.
C 
C       Today the input file, a vgr edr was writen with gcc on a solaris system.
C       Fortran needs to know that the UNFORMATTED file has no embedded
C       record markers that a file written in fortran expects.Thus,
C       you need to use UNFORMATTED STREAM to read properly. Otherwise
C       you will get a fortran error message 5017 - 
C       "unformatted file structure has been corrupted".
C       what it is saying is that it doesn't find the record markers
C       that fortran expects
C       Also no reclen allowed for OPEN
C
C       how about convert='SWAP' or 'LITTLE_ENDIAN' or 'BIG_ENDIAN'
c       SPARC = BIG_ENDIAN, INTEL = LITTLE_ENDIAN, Motorola = BIG_ENDIAN
C
C	Originally opened the file first and read with byte rec array
C	In this fashion read the MJS magic number as well
C	as file (instrument) type and Spacecraft ID.
C       if byte data is read as D4 D1 E2 F0 then integer*2 data will be
C	 D1D4  F0E2
C       However, 12-17-2021 made only read in integer*4 format
C       Had to read 32-bit integers in signed 32-bit numbers and that's
C	why larged negative numbers to do logic.

      OPEN(50,FILE=DSN,FORM='UNFORMATTED',ACCESS='STREAM',
     & ERR=999,CONVERT='LITTLE_ENDIAN')
C        print *, 'OPEN stat = ',stat
C
C
C
C      OPEN(50,FILE=DSN,STATUS='OLD',FORM='FORMATTED',
C     &     RECORDTYPE='VARIABLE',RECL=8191,READONLY)
C      OPEN(50,FILE=DSN,STATUS='OLD',FORM='FORMATTED',
C     &     RECL=7924,READONLY)
C
      NCNT = 0
C       reclen = 60
       totreclen = 0
10     continue

C         print *,"READ.... hdr_len = ",hdr_len
        read(50,ERR=999,END=100,iostat=rstat) (header(I),I=1,hdr_len)
C
C
C        print *,"instrument = ",instrument		!,rec3(2),rec3(3),rec3(4)
C        print *, "header(1) = ",header(1)
        if (header(1) .eq. -236793388 .or. header(1) .eq. -253570604) 
     & then
            if (instrument .ne. "dco" .and. ncnt .eq. 0) then
              
                if (instrument .ne. 'dco') then
               	    print *,' filename not dcom but 1st rec is dcom'
               	    print *,' This must be a weekly file' 
                    weekly = .true.
                endif   
            endif
            close (50)
            OPEN(50,FILE=DSN,FORM='UNFORMATTED',ACCESS='STREAM',
     & ERR=999,CONVERT='LITTLE_ENDIAN')
            reclen = dcom_reclen
C           print *,"reclen bfore read= ",hdr_len

           read(50,ERR=999,END=100,iostat=rstat) (header(I),I=1,hdr_len)
C           print *, "rstat = ",rstat
       endif


c         print *,"header(1) = ",header(1), " header(2) = ",header(2)
c
C        write(6,10001) header(1)
C10001  format (2x,Z16)
        NCNT = NCNT + 1
c       if (rec(4) .eq. -16)  then    !hex f0
        if (header(1) .eq. -236793388) then       !d1d4 f0e2   (little endian) -774573854
           scid = 2
           dcom_reclen = 179        !716
           dcom_subhdr = 7          !28
           dcom_datalen = 112       !448
           subhdr_len = dcom_subhdr
           data_len = dcom_datalen
           reclen = dcom_subhdr + dcom_datalen
           instrument = 'dco'
           recid = 15
           dcom_cnt = dcom_cnt + 1
       endif
c       if (rec(4) .eq. -15)  then    !hex f1
       if (header(1) .eq. -253570604) then        !d1d4 f1e2  -774573598
            scid = 1
            dcom_reclen = 179        !716
            dcom_subhdr = 7          !28
            dcom_datalen = 112       !448
            subhdr_len = dcom_subhdr
            data_len = dcom_datalen
            reclen = dcom_subhdr + dcom_datalen
            instrument = 'dco'
            recid = 15
            dcom_cnt = dcom_cnt + 1 
       endif
c		7244423833 = d4d1 e2f1   -724442384 = d4d1 e2f0 
       if (header(1) .eq. -487467823 .or. header(1) .eq. 
     & -487533359) then 
            goto 1001
       endif
c       if (rec(4) .eq. -80)  then    !hex b0
       if (header(1) .eq. -1327312428) then       !d1d4 b0e2  -774590238
           scid = 2
           eng_reclen = 965         !3860
           eng_subhdr = 5           !20
           eng_datalen =  900       !3600
           subhdr_len = eng_subhdr
           data_len = eng_datalen
           reclen = eng_subhdr + eng_datalen
           instrument = 'eng'
           recid = 11
           eng_cnt = eng_cnt + 1
       endif
c       if (rec(4) .eq. -79)  then    !hex b1
       if (header(1) .eq. -1310535212) then       !d1d4 b1e2   -774589982
            scid = 1
            eng_reclen = 965         !3860
            eng_subhdr = 5           !20
            eng_datalen =  900       !3600
            subhdr_len = eng_subhdr
            data_len = eng_datalen
            reclen = eng_subhdr + eng_datalen
            instrument = 'eng'
            recid = 11
            eng_cnt = eng_cnt + 1
       endif
c                 -724442447 = d4d1 e2b1    -724442448 = d4d1 d2b0
       if (header(1) .eq. -491662127 .or. header(1) .eq. -491727663) 
     & then 
              goto 1001
       endif
c         print *,"HERE"
c
c       if (rec(4) .eq. 16)  then    !hex 10
       if (header(1) .eq. 283300308) then         !d1d4 10e2  - 774631198
           scid = 2
           crs_reclen = 850         !3400
           crs_datalen = 780        !3120
           crs_subhdr_len = 10      !40
            subhdr_len = crs_subhdr_len
            data_len = crs_datalen
            reclen = crs_subhdr_len + crs_datalen
           instrument = 'crs'
           recid = 1
           crs_cnt = crs_cnt + 1
       endif
c       if (rec(4) .eq. 17)  then    !hex 11
       if (header(1) .eq. 300077524) then        !d1d4 11e2 - 774630942
            scid = 1
            crs_reclen = 850         !3400
            crs_datalen = 780        !3120
            crs_subhdr_len = 10      !40
            subhdr_len = crs_subhdr_len
            data_len = crs_datalen
            reclen = crs_subhdr_len + crs_datalen
            instrument = 'crs'
            recid = 1
C            crs_cnt = crs_cnt + 1
       endif
c                     -724442607 = d4d1 e211     -724442608 = d4d1 e210
       if (header(1) .eq. -502213423 .or. header(1) .eq. -502147887) 
     & then 
             goto 1001
       endif
c
c       if (rec(4) .eq.  48)  then    !hex 30
C        print *,"HEADER2 = ",header(1)
       if (header(1) .eq. 820171220) then		!d1d4 30e2  -774623006
C          print *," lec   header scid = 2"
           scid = 2
           lec_reclen = 141         !564
           lec_datalen = 80         !320
           lec_subhdr_len = 1       !4
           subhdr_len = lec_subhdr_len
           data_len = lec_datalen
           reclen = lec_subhdr_len + lec_datalen
           instrument = 'lec'
           recid = 3
           lec_cnt = lec_cnt + 1
       endif
c       if (rec(4) .eq.  49)  then    !hex 31
       if (header(1) .eq. 836948436) then 	!d1d4 31e2   -774627750
C            print *, "lec header scid = 1"
            scid = 1
            lec_reclen = 141         !564
            lec_datalen = 80         !320
            lec_subhdr_len = 1       !4
            subhdr_len = lec_subhdr_len
            data_len = lec_datalen
            reclen = lec_subhdr_len + lec_datalen
            instrument = 'lec'
            recid = 3
            lec_cnt = lec_cnt + 1
       endif
c           -724425755 = d4d1 e231   -724442576 = d4d1 e230
       if (header(1) .eq. -500116271 .or. header(1) .eq. -5000050735)
     &  then 
            goto 1001
       endif
c       if (rec(4) .eq.  64)  then    !hex 40
       if (header(1) .eq. 1088606676) then	!d1d4 41e2   -774618654  (prev:  1195383892) 12-28-2021
           scid = 2
           mag_reclen = 428         !1712
           mag_datalen = 260        !1040
           mag_subhdr_len = 108     !432
           subhdr_len = mag_subhdr_len
           data_len = mag_datalen
           reclen = mag_subhdr_len + mag_datalen
           instrument = 'mag'
           recid = 4
           mag_cnt = mag_cnt + 1
       endif
c       if (rec(4) .eq.  65)  then    !hex 41
       if (header(1) .eq. 1105383892) then	!d1d4 40e2  -774618910   (prev: 1088606676) 12-28-2021
            scid = 1
            mag_reclen = 428         !1712
            mag_datalen = 260        !1040
            mag_subhdr_len = 108     !432
            subhdr_len = mag_subhdr_len
            data_len = mag_datalen
            reclen = mag_subhdr_len + mag_datalen
            instrument = 'mag'
            recid = 4
            mag_cnt = mag_cnt + 1
       endif
c	-724442559 = d4d1 e241     -724442560 = d4d1 e240
      if (header(1) .eq. -499002159 .or. header(1) .eq. -499067695) 
     & then 
           goto 1001
      endif
c
c       if (rec(4) .eq. 80)  then    !hex 50
c      if (header(1) .eq. -774614558) then         !d1d4 51e2
c           pls_reclen = 168         !674
c           pls_datalen = 100        !400
c           pls_subhdr_len = 8       !32
c           subhdr_len = pls_subhdr_len
c           data_len = pls_datalen
c           reclen = pls_subhdr_len + pls_datalen
c           instrument = 'pls'
c           recid = 6
c       endif
c       if (rec(4) .eq. 81)  then    !hex 51
       if (header(1) .eq. 1357042132) then	!d1d4 50e2    -774614814
            scid = 2
            pls_reclen = 168         !674
            pls_datalen = 100        !400
            pls_subhdr_len = 8       !32
            subhdr_len = pls_subhdr_len
            data_len = pls_datalen
            reclen = pls_subhdr_len + pls_datalen
            instrument = 'pls'
            recid = 5
            pls_cnt = pls_cnt + 1
       endif
c       -724442544 = d4d1 e250      -724442543 = d4d1 e251
       if (header(1) .eq. -498019119 ) then
             goto 1001
       endif
c
C       if (rec(4) .eq. -128)  then    !hex 80
       if (header(1) .eq. -2115841580) then	!d1d4 81e2    -774602270
           scid = 1
           pws_reclen = 135         !540
           pws_datalen = 55         !220
           pws_subhdr_len = 20      !80
           subhdr_len = pws_subhdr_len
           data_len = pws_datalen
           reclen = pws_subhdr_len + pws_datalen
           instrument = 'pws'
            recid = 8
            pws_cnt = pws_cnt + 1
       endif
C       if (rec(4) .eq. -127)  then    !hex 81
       if (header(1) .eq. -2132618796) then	!d1d4 80e2  -774602526
            scid = 2
            pws_reclen = 135         !540
            pws_datalen = 55         !220
            pws_subhdr_len = 20      !80
            subhdr_len = pws_subhdr_len
            data_len = pws_datalen
            reclen = pws_subhdr_len + pws_datalen
            instrument = 'pws'
            recid = 8
            pws_cnt = pws_cnt + 1
       endif
c         -724442495 = d4d1 e281        -724442496 = d4d1 e280
       if (header(1) .eq. -494873391 .or. header(1) .eq. -491807855) 
     & then
           goto 1001
       endif
       PROJID = 'MJS'
C           print *, 'SCID = ',scid,'  instument = ', instrument
C       close (50)

C        print *,"HERE"
C
CC      OPEN(50,FILE=DSN,FORM='UNFORMATTED',ACCESS='STREAM',
CC     & ERR=999,CONVERT='LITTLE_ENDIAN')
CC        print *, 'OPEN stat = ',stat
C
C        print *,"before read 50 rec3"
        read(50,ERR=999,END=100,iostat=rstat) (REC3(I),I=1,RECLEN)
C
C        print *,"rstat = ",rstat
        do j=1,60
           rec4(j) = header(j)
        enddo
        do j=1,reclen
          rec4(j+60) = rec3(j)
        enddo  
C
       if (instrument .eq. 'dco' .and.  .not. weekly) then
           goto 90
       endif
      	totreclen = totreclen +  reclen + 60
C        print *, "totreclen + reclen +60 = ",totreclen," + ",reclen,
C     & " + ",60
C        print *,"reclensize = ",reclensize
       if (totreclen .ge. reclensize) then
              goto 100
        endif 
CC       print *,"rec3 = ",rec3(1),rec3(2),rec3(3),rec3(4)

90     continue
C        print *,"before unhead"
       CALL UNHEAD(header)
       CALL GETTIME(TFLAG,SERTIME,EERTIME,SCETIME,EDRTIME)
       CALL DISPLAY(RECLEN,NCNT,TFLAG,EDRTIME)
       if (showert .eqv. .true.) then
            CALL DISPLAY2(RECLEN,NCNT,'SERT',SERTIME)
            CALL DISPLAY2(RECLEN,NCNT,'EERT',EERTIME)
       endif
C      if (NCNT .eq. 10) then 
C          stop
C      endif
      GOTO 10
c
  100 CONTINUE
      WRITE(6,*) 
      WRITE(6,*) NCNT-1,' TOTAL EDR''S'
      if (dcom_cnt .gt. 0) print *, "dcom_cnt = ",dcom_cnt
      if (eng_cnt .gt. 0) print *, " eng_cnt = ",eng_cnt
      if (crs_cnt .gt. 0) print *, " crs_cnt = ",crs_cnt
      if (lec_cnt .gt. 0) print *, " lec_cnt = ",lec_cnt
      if (mag_cnt .gt. 0) print *, " mag_cnt = ",mag_cnt
      if (pls_cnt .gt. 0) print *, " pls_cnt = ",pls_cnt
      if (pws_cnt .gt. 0) print *, " pws_cnt = ",pws_cnt
      print *
      WRITE(6,*)
      goto 1010 
C
C
999   print *, 'err on read'
        goto 1010
1000  print *, 'File not found'
       goto 1010
1001  continue
      print *, " Data Set is byte swapped"
      print *, " Please run program byteswap"

1010   continue
      close (50)
      close (2)
      STOP
      END
******************************************************************
C
C DISPLAY KEY VALUES FROM UNPACKED EDR
C
      SUBROUTINE DISPLAY(RECLEN,NCNT,TFLAG,TIME)
      INTEGER*2 TIME(6)
      integer*4 reclen
      CHARACTER*4 TFLAG,EX(0:15)
      CHARACTER*6 DM(0:31),SC
      CHARACTER*7 DDT(32:48)
C
      INCLUDE 'unpack.inc'
C
      DATA EX/'***','CRS','IRIS','LECP','MAG','PLS','PPS','PRA','PWS',
     &        'UVS','RSS','ENG','***','ISR','MR','DMR'/
      DATA DM/'ENG','CR-2','CR-3','CR-4','CR-5','CR-6','CR-7','CR-1',
     &        'GS-10A','***','GS-3','***','GS-7','***','GS-6','GS-4',
     &        '***','GS-2','***','***','***','***','OC-2','OC-1',
     &        'CR-5A','GS-10','GS-8','***','***','UV-5A','***','***'/
      DATA DDT/'IRIS','CRS','LECP','MAG','PLS','PPS','PRA','PWS','UVS',
     &         'ISR','DCOM','MON 5-8','ENGS','ENGE','DCMS','ENGC',
     &         'MON 5-9'/
C
       SC = "VGR1"
       if (SCID .eq. 2) SC = "VGR2"			!changed from 0 to 2 - 12-30-2021
      WRITE(6,900) NCNT,RECNUM,RECLEN*4,PROJID,EX(RECID),SC,
     &             TFLAG,TIME,DM(DATMOD),DDT(DRSDAT)
      WRITE(2,900) NCNT,RECNUM,RECLEN*4,PROJID,EX(RECID),SC,
     &             TFLAG,TIME,DM(DATMOD),DDT(DRSDAT)
      RETURN
  900 FORMAT(1X,I6,1X,I6,1X,I5,' BYTES',1X,A3,1X,A4,1X,A4,1X,A4,
     &       1X,I2,'-',I3,'T',I2.2,2(':',I2.2),'.',I3.3,1X,A6,1X,A7)
      END
******************************************************************
C
C  DISPLAY SERTIME and EERTIME
C
      SUBROUTINE DISPLAY2(RECLEN,NCNT,TFLAG,TIME)
      INTEGER*2 TIME(6)
      integer*4 reclen
      CHARACTER*4 TFLAG

      include 'unpack.inc'
C
      WRITE(6,901) NCNT,RECNUM,TFLAG,TIME
901   FORMAT (1x,I6,1X,I6,27x,A4,1X,I2,'-',I3,'T',I2.2,2(':',I2.2),
     &I3.3)

      RETURN
      END
********************************************************************
*
*	TITLE:  UNPACK VOYAGER 60 WORD EDR HEADER
*
*	FILE NAME:  UNHEAD.FOR
*
*	PURPOSE:  TO UNPACK THE HEADER BLOCK
*
*	HISTORY:
*
*	AUTHOR            DATE             CHANGE
*	--------          ----             ------
*	S. J. KEMPLER     8/12/85          ORIGINAL CODE
*       S. B. KRAMER      9/27/92          MODIFIED FOR VIM-5 MODE
*       S. B. KRAMER     10/26/93          MODIFIED FOR ALL MODES
*
*	CALLING SEQUENCE:  SUBROUTINE UNHEAD(INBUF)
*
*	MODULES REFERENCED:
*
*		MOVBIT
*
*	COMMON AREAS:
*
*		SEE unpack.inc FOR COMMON AREA DEFINITIONS
*
*	PDL:
*
*		GET HEADER BLOCK FROM EDR RECORD
*		CALL MOVBIT TO LOAD DATMOD WITH DATA MODE
*		CALL MOVBIT TO LOAD MOD60 WITH MOD 60 COUNT WORD
*		LOAD PROJID WITH THE 3 CHARACTER PROJECT ID
*		CALL MOVBIT TO LOAD ALL OTHER ITEMS OF THE HEADER FIELD 
*                INTO INDIVIDUAL I*2 VARIABLES
*		RETURN
*
******************************************************************* 
C
      SUBROUTINE UNHEAD(headx)     !INBUF)
C
C      LOGICAL*1 INBUF(11280),LPROJ(3)
      BYTE INBUF(5000000),LPROJ(3)
      integer*4 headx(60)

      integer*4 recnumx,ertshrx,ertehrx,physrnx
C
      INCLUDE 'unpack.inc'
C
      EQUIVALENCE (PROJID,LPROJ(1))
C
C   REMOVED following 12-17-2021
C ASSIGN FIRST 240 BYTES OF EDR RECORD TO HEADER ARRAY (ALL MODES)
C
C HEAD is defined as BYTE(240) unpack.incp
CC      goto 25
CC      DO I = 1,240
CC
CC       HEAD(I) = INBUF(I)
CC       HEADX(I) = HEAD(I) + 256                !transform to I*4
CC      END DO
C
C     LPROJ(1) = HEAD(1)
C     LPROJ(2) = HEAD(2)
C     LPROJ(3) = HEAD(3)
C
C     ISTAT = LIB$TRA_EBC_ASC(PROJID,PROJID)
C
C IDENTIFY MARINER JUPITER SATURN (MJS) PROJECT ID
C
C     IF (PROJID.NE.'MJS') RETURN
C
C SEARCH FOR DECIMAL EQUIVALENT OF EBCDIC 'MJS'
C
CC      IF ( ZEXT(HEAD(1)).EQ.212 .AND.
CC     &     ZEXT(HEAD(2)).EQ.209 .AND.
CC     &     ZEXT(HEAD(3)).EQ.226 ) THEN
CC       PROJID = 'MJS'
CC      ELSE
CC        print *,'HEAD: not MJS return'
CC        stop
CC      END IF
C
C ERROR IN KEMPLER'S DECOMMUTATION REVERSES RECID AND SCID 
C CORRECTED FOR VIM-5 PROCESSING (SBK - 10/8/92)
C
CC      HEAD(4) = FLIP(ZEXT(HEAD(4))

C	MOVBIT(DATA,POS,NBITS,VAL,IBEG)

CC byte 4
CC25    continue
CC      print *,"headx(1) = ",headx(1)
CC      RECID = 0
C      CALL MOVBIT(  HEADX,  24,  1,  RECID,   3)
C      CALL MOVBIT(  HEADX,  25,  1,  RECID,   2)
C      CALL MOVBIT(  HEADX,  26,  1,  RECID,   1)
C      CALL MOVBIT(  HEADX,  27,  1,  RECID,   0)
CC      CALL MOVBIT(  HEADX,  19,  1,  RECID,   3)
CC      CALL MOVBIT(  HEADX,  18,  1,  RECID,   2)
CC      CALL MOVBIT(  HEADX,  17,  1,  RECID,   1)
CC      CALL MOVBIT(  HEADX,  16,  1,  RECID,   0)
CC      print *, "RECID = ",RECID				!3
CC      SCID = 0
C      CALL MOVBIT(  HEADX,  28,  1,   SCID,   3)
C      CALL MOVBIT(  HEADX,  29,  1,   SCID,   2)
C      CALL MOVBIT(  HEADX,  30,  1,   SCID,   1)
C      CALL MOVBIT(  HEADX,  31,  1,   SCID,   0)
CC      CALL MOVBIT(  HEADX,  18,  1,   SCID,   3)
CC      CALL MOVBIT(  HEADX,  19,  1,   SCID,   2)
CC      CALL MOVBIT(  HEADX,  20,  1,   SCID,   1)
CC      CALL MOVBIT(  HEADX,  21,  1,   SCID,   0)
 
C       print *, "SCID = ",SCID                         !1 
C
C    END - removal of 12-17-2021
cc byte 5,6 - recnum is
C=============================================================
C     d4d1 e2                 Project ID         byte  0,1,2
C            f0               RecID, SCID        byte  3
C                0000         Physical Record ID byte  4,5
C                     18      S/C Data Mode      byte  6
C                       c0    A,B,spare          byte  7
C
C Reverse
C     d1d4 f0e2  0000 c018
C                0018 0400
C      print *, "headx(2) = ",headx(2)
C      write (6,10000) headx(2)
C10000 format ("(Z) headx(2)",z8)
        
      RECNUM = 0
      CALL MOVBIT(  HEADX,  40,  8, RECNUM,   0)
      CALL MOVBIT(  HEADX,  32,  8, RECNUM,   8)
C      print *,"RECNUM = ",RECNUM			!0001
c      recnumx = recnum + 32767
c      print *, "recnumx = ",recnumx
      DATMOD = 0
CC byte 7
      CALL MOVBIT(  HEADX,  48,  8, DATMOD,   0)
C      print *,"DATMOD = ",DATMOD			!18
C
CC      HEAD(8) = FLIP(ZEXT(HEAD(8)))
cc byte 7

      EEXTFL = 0					!c0
      CALL MOVBIT(  HEADX,  56,  1, EEXTFL,   1)
      CALL MOVBIT(  HEADX,  57,  1, EEXTFL,   0)
      SCPLAB = 0
      CALL MOVBIT(  HEADX,  58,  1, SCPLAB,   0)
      RECTIM = 0
      CALL MOVBIT(  HEADX,  59,  1, RECTIM,   4)
      CALL MOVBIT(  HEADX,  60,  1, RECTIM,   3)
      CALL MOVBIT(  HEADX,  61,  1, RECTIM,   2)
      CALL MOVBIT(  HEADX,  62,  1, RECTIM,   1)
      CALL MOVBIT(  HEADX,  63,  1, RECTIM,   0)
C
C      PRINT *,"RECTIM = ",RECTIM			!00
C==========================================================

cc byte 8,9
      ERTSHR = 0					
      CALL MOVBIT(  HEADX,  72,  8, ERTSHR,   0)
      CALL MOVBIT(  HEADX,  64,  8, ERTSHR,   8)
C      PRINT *,"ERTSHR = ",ERTSHR                       !0b40
c      ertshrx = ertshr + 32167
c      print *, "ertshrx = ",ertshrx
cc byte 10,11
      ERTSSC = 0
      CALL MOVBIT(  HEADX,  88,  8, ERTSSC,   0)
      CALL MOVBIT(  HEADX,  80,  8, ERTSSC,   8)
C      PRINT *,"ERTSSC = ",ERTSSC                       !0003
c byte 12,13
      ERTSML = 0
      CALL MOVBIT(  HEADX, 104,  8, ERTSML,   0)
      CALL MOVBIT(  HEADX,  96,  8, ERTSML,   8)
C      PRINT *,"ERTSML = ",ERTSML                       !03af
cc byte 14
      YEAR1 = 0
      CALL MOVBIT(  HEADX, 112,  8,  YEAR1,   0)
C      PRINT *,"YEAR1 = ",YEAR1                         !14
C
CC      HEAD(16) = FLIP(ZEXT(HEAD(16)))
cc byte 15
      DATSRC = 0
      CALL MOVBIT(  HEADX, 120,  1, DATSRC,   1)
      CALL MOVBIT(  HEADX, 121,  1, DATSRC,   0)
      GOLAY = 0
      CALL MOVBIT(  HEADX, 122,  1,  GOLAY,   1)
      CALL MOVBIT(  HEADX, 123,  1,  GOLAY,   0)
      SEGNUM = 0
      CALL MOVBIT(  HEADX, 124,  1, SEGNUM,   3)
      CALL MOVBIT(  HEADX, 125,  1, SEGNUM,   2)
      CALL MOVBIT(  HEADx, 126,  1, SEGNUM,   1)
      CALL MOVBIT(  HEADX, 127,  1, SEGNUM,   0)
C
cc  byte 16,17
      ERTEHR = 0
      CALL MOVBIT(  HEADX, 136,  8, ERTEHR,   0)
      CALL MOVBIT(  HEADX, 128,  8, ERTEHR,   8)
C      PRINT *,"ERTEHR = ",ERTEHR                       !0b40
c      ertehrx = ertehr + 32767
c      print *, "ertehrx = ",ertehrx
cc byte 18,19
      ERTESC = 0
      CALL MOVBIT(  HEADX, 152,  8, ERTESC,   0)
      CALL MOVBIT(  HEADX, 144,  8, ERTESC,   8)
C      PRINT *,"ERTESC = ",ERTESC                        !0054   
cc byte 20,21
      ERTEML = 0
      CALL MOVBIT(  HEADX, 168,  8, ERTEML,   0)
      CALL MOVBIT(  HEADX, 160,  8, ERTEML,   8)
C      PRINT *,"ERTEML = ",ERTEML                       !02e7
cc byte 22
      YEAR2 = 0
      CALL MOVBIT(  HEADX, 176,  8,  YEAR2,   0)
C      PRINT *,"YEAR2 = ",YEAR2                       !14  
cc byte 23
      SWVERS = 0
      CALL MOVBIT(  HEADX, 184,  8, SWVERS,   0)
C      PRINT *,"SWVERS = ",SWVERS                       !00  
cc  24,25
      SCETHR = 0
      CALL MOVBIT(  HEADX, 200,  8, SCETHR,   0)
      CALL MOVBIT(  HEADX, 192,  8, SCETHR,   8)
C      print *,"SCETHR = ",SCETHR			!0b2b
cc byte 26,27
      SCETSC = 0
      CALL MOVBIT(  HEADX, 216,  8, SCETSC,   0)
      CALL MOVBIT(  HEADX, 208,  8, SCETSC,   8)
C      print *, "SCETSC = ",SCETSC			!060c
cc byte 28,29
      SCETML = 0
      CALL MOVBIT(  HEADX, 232,  8, SCETML,   0)
      CALL MOVBIT(  HEADX, 224,  8, SCETML,   8)
C      print *, "SCETML = ",SCETML			!02e9
cc byte 30
      YEAR3 = 0
      CALL MOVBIT(  HEADX, 240,  8,  YEAR3,   0)
C      print *, "YEAR3 = ",YEAR3				!14
C
CC      HEAD(32) = FLIP(ZEXT(HEAD(32)))a
cc byte 31
      SCEVFL = 0
      CALL MOVBIT(  HEADX, 248,  1, SCEVFL,   3)
      CALL MOVBIT(  HEADX, 249,  1, SCEVFL,   2)
      CALL MOVBIT(  HEADX, 250,  1, SCEVFL,   1)
      CALL MOVBIT(  HEADX, 251,  1, SCEVFL,   0)
      CORRFL = 0
      CALL MOVBIT(  HEADX, 252,  1, CORRFL,   3)
      CALL MOVBIT(  HEADX, 253,  1, CORRFL,   2)
      CALL MOVBIT(  HEADx, 254,  1, CORRFL,   1)
      CALL MOVBIT(  HEADx, 255,  1, CORRFL,   0)
C
cc byte 32,33
      MOD216 = 0
      CALL MOVBIT(  HEADX, 264,  8, MOD216,   0)
      CALL MOVBIT(  HEADX, 256,  8, MOD216,   8)
C      PRINT *,"MOD216 = ",MOD216                       !6576
cc byte 34
      MOD60 = 0
      CALL MOVBIT(  HEADX, 272,  8,  MOD60,   0)
C      PRINT *,"MOD60  = ",MOD60                      !26  
cc byte 35,36
      LINCNT = 0
      CALL MOVBIT(  HEADX, 288,  8, LINCNT,   0)
      CALL MOVBIT(  HEADX, 280,  8, LINCNT,   8)
C      PRINT *,"LINCNT = ",LINCNT                       !0001
cc  byte 37
      TELRAT = 0
      CALL MOVBIT(  HEADX, 296,  8, TELRAT,   0)
C      PRINT *,"TELRAT = ",TELRAT                       !05  
cc byte 38
      EFFRAT = 0
      CALL MOVBIT(  HEADX, 304,  8, EFFRAT,   0)
C      PRINT *,"EFFRAT = ",EFFRAT                       !05  
cc byte 39
      FORMID = 0
      CALL MOVBIT(  HEADX, 312,  8, FORMID,   0)
C      PRINT *,"FORMID = ",FORMID                       !00  
cc  byte 40
      BERTOL = 0
      CALL MOVBIT(  HEADx, 320,  8, BERTOL,   0)
C      PRINT *,"BERTOL = ",BERTOL                       !03  
cc byte 41
      DSNCON  = 0
      CALL MOVBIT(  HEADx, 328,  8, DSNCON,   0)
C      PRINT *,"DSNCON = ",DSNCON                       !03  
cc byte 42,43
      RECAGC = 0
      CALL MOVBIT(  HEADx, 344,  8, RECAGC,   0)
      CALL MOVBIT(  HEADx, 336,  8, RECAGC,   8)
C      PRINT *,"RECAGC = ",RECAGC                       !af30i
      if (RECAGC .lt. 0) RECAGC = RECAGC + 32767
C      print *, "RECAGC = ",RECAGC
cc byte 44
      DSNNUM = 0
      CALL MOVBIT(  HEADX, 352,  8, DSNNUM,   0)
C      PRINT *,"DSNNUM = ",DSNNUM                      !3f  
cc byte 45 - SPARE
cc byte 46,47
      EBEC = 0
      CALL MOVBIT(  HEADX, 376,  8,   EBEC,   0)
      CALL MOVBIT(  HEADx, 368,  8,   EBEC,   8)
C      PRINT *,"EBEC = ",EBEC                          !0000
cc byte 48,49
      SYMSNR = 0
      CALL MOVBIT(  HEADX, 392,  8, SYMSNR,   0)
      CALL MOVBIT(  HEADX, 384,  8, SYMSNR,   8)
C      PRINT *,"SYMSNR = ",SYMSNR                       !0237
cc byte 50,51
      DECSNR = 0
      CALL MOVBIT(  HEADX, 408,  8, DECSNR,   0)
      CALL MOVBIT(  HEADX, 400,  8, DECSNR,   8)
C      PRINT *,"DECSNR = ",DECSNR                      !0000
cc byte 52/53 - Unused
      PHYSRN = 0
      CALL MOVBIT(  HEADX, 424,  8, PHYSRN,   0)
      CALL MOVBIT(  HEADX, 416,  8, PHYSRN,   8)
C      PRINT *,"PHYSRN = ",PHYSRN                       !0000
c      physrnx = physrn + 32767
c      print *,"physrnx = ",physrnx
C 8 BIT DATA QUALITY STATUS WORD//8 BIT DATA QUALITY INDICATOR
C
      DO 10 I=1,10
         J = (I-1) * 16
         DQSW(I) = 0
         CALL MOVBIT(  HEADX, 432+J,  8, DQSW(I),   0)
         DQI(I) = 0
         CALL MOVBIT(  HEADX, 440+J,  8,  DQI(I),   0)
  10  CONTINUE
C
C UNPACK 4 BIT DATA PRESENCE INDICATORS (80 MF MAX)
C CR-7 AND VIM-5 MODES
C
      IF ( MODE(IMODE).NE.13 .AND. MODE(IMODE).NE.9 ) GOTO 20
      DO 20 I=1,40
         J = (I-1) * 8
         K = I*2 - 1
         L = I*2
         DPI(K) = 0
         DPI(L) = 0
         CALL MOVBIT(  HEADX, 592+J,  4, DPI(L),   0)
         CALL MOVBIT(  HEADX, 596+J,  4, DPI(K),   0)
  20  CONTINUE
C
C UNPACK 8 BIT DATA PRESENCE INDICATORS (150 MF MAX)
C CR-1 THROUGH CR-6 MODES
C
      IF ( MODE(IMODE).LT.1 .OR. MODE(IMODE).GT.6 ) GOTO 30
      DO 30 I=1,150
       J = (I-1)*8
       DPI(I) = 0
       CALL MOVBIT(  HEADX, 592+J,  8, DPI(I),   0)
  30  CONTINUE
C
C UNPACK 8 BIT DATA PRESENCE INDICATORS AND 8 BIT GOLAY CORRECTION
C INDICATORS (80 MF MAX)
C GS-3 MODE
C
      IF ( MODE(IMODE).NE.0 ) GOTO 40
      DO 40 I=1,80
       J = (I-1)*16
       DPI(I) = 0
       CALL MOVBIT(  HEADX, 592+J,  8, DPI(I),   0)
       GCI(I) = 0
       CALL MOVBIT(  HEADX, 600+J,  8, GCI(I),   0)
  40  CONTINUE
C
C FIELDS GCI, DPIRIS, GPIRIS ARE NOT USED IN VIM-5 MODE.
C THEREFORE BITS 892 - 1887 ARE SPARES.
C
      DRSDAT = 0
      CALL MOVBIT(  HEADX, 1888,  8, DRSDAT,   0)
      GCBEC = 0
      CALL MOVBIT(  HEADX, 1896,  8,  GCBEC,   0)
      GBITES = 0
      CALL MOVBIT(  HEADX, 1912,  8, GBITES,   0)
      CALL MOVBIT(  HEADX, 1904,  8, GBITES,   8)
C
C	stop
C        print *,"end of unhead"
      RETURN
      END
******************************************************************
      SUBROUTINE CONSEC(SOH,TIME)
C
C CONVERT I*2 SECONDS OF HOUR INTO MINUTES AND SECONDS.
C
      INTEGER*2 SOH,TIME(6)
      TIME(4) = INT(SOH/60.0)
      TIME(5) = NINT(((SOH/60.0)-TIME(4))*60.0)
CC      PRINT *,"TIME(4) = ",TIME(4)
CC      PRINT *,"TIME(5) = ",TIME(5)
      RETURN
      END
******************************************************************
      SUBROUTINE CONHOUR(HOY,TIME)
C
C CONVERT I*2 HOUR OF YEAR INTO DAYS AND HOURS.
C
      INTEGER*2 HOY,TIME(6)
      TIME(2) = INT(HOY/24.0)
      TIME(3) = NINT(((HOY/24.0)-TIME(2))*24.0)
CC      PRINT *,"TIME(2) = ",TIME(2)
CC      PRINT *,"TIME(3) = ",TIME(3)
      RETURN
      END
******************************************************************
      SUBROUTINE GETTIME(TFLAG,SERTIME,EERTIME,SCETIME,EDRTIME)
C
C CONVERT EDR TIME TAGS TO CALENDAR UNITS
C
      CHARACTER*4 TFLAG
      INTEGER*2 SERTIME(6),EERTIME(6),SCETIME(6),EDRTIME(6)
C
      INCLUDE 'unpack.inc'    
C
      SERTIME(1) = YEAR1
      CALL CONHOUR(ERTSHR,SERTIME)
      CALL CONSEC(ERTSSC,SERTIME)
      SERTIME(6) = ERTSML
C
      EERTIME(1) = YEAR2
      CALL CONHOUR(ERTEHR,EERTIME)
      CALL CONSEC(ERTESC,EERTIME)
      EERTIME(6) = ERTEML
C
      SCETIME(1) = YEAR3
CC      PRINT *,"TIME(1) = ",YEAR3
      CALL CONHOUR(SCETHR,SCETIME)
      CALL CONSEC(SCETSC,SCETIME)
CC      PRINT *,"TIME(6) = ",SCETML
      SCETIME(6) = SCETML
C
C SELECT TIME TYPE FOR EDR TIME
C
      IF (TFLAG.EQ.'ERTS') THEN
       DO I = 1,6
        EDRTIME(I) = SERTIME(I)
       END DO
      ELSE IF (TFLAG.EQ.'ERTE') THEN
       DO I = 1,6
        EDRTIME(I) = EERTIME(I)
       END DO
      ELSE IF (TFLAG.EQ.'SCET') THEN
       DO I = 1,6
        EDRTIME(I) = SCETIME(I)
       END DO
      END IF
C
      RETURN
      END
******************************************************************
C
C ROUTINE TO EXTRACT N BITS FROM ARRAY DATA STARTING AT BIT POSITION IOFF
C AND PLACE THESE BITS INTO WORD VAL STARTING AT BIT POSITION IBEG.
C
      SUBROUTINE MOVBIT(DATA,POS,NBITS,VAL,IBEG)
C
C DATA  INPUT DATA ARRAY
C POS   STARTING BIT POSITION WITHIN ARRAY DATA (0 = FIRST BIT)
C NBITS NUMBER OF BITS TO BE MOVED
C VAL   OUTPUT WORD
C IBEG  STARTING BIT FOR INSERTION OF COPIED BITS
C
C      INTEGER*4 VAL
      INTEGER*4 DATA(1),I,POS,IVAL4,IBEG,NBITS,IWORD,IOFF
      LOGICAL*4 IVAL
      integer*2 VAL
C
C      print *,"MOVBIT val = ",val," nbits = ",nbits," ibeg= ",ibeg
        val4 = val
      IWORD = INT(POS/32) + 1
      IOFF = MOD(POS,32)
C       if (data(iword) .lt.0) data(iword) = data(iword) + 2147483647
C      print *,"MOVBIT data(",iword,") = ",data(iword)," ioff = ",ioff
      DO I=0,NBITS-1
C        print *,"i = ",i
       IVAL = BTEST(DATA(IWORD),IOFF+I)
C        print *,"here"
       IF (IVAL) VAL4 = (IBSET(VAL,IBEG+I))
       val = val4
C        print *,"here2 ival =",ival4,val
       IF (.NOT.IVAL) VAL4 = (IBCLR(VAL,IBEG+I))
C        print *,"here3"
      END DO
C
        val = val4
C        print *,"movbit return"
      RETURN
      END
C************************************************************************
      INTEGER FUNCTION MODE(ISTAT)
C
C THIS FUNCTION IDENTIFIES THE APPROPRIATE TELEMETRY MODE FOR PROCESSING
C  updated this on 12-17-2021
C
C From 618-306 Rev D - Chg 5 Table C-1 pg 122
C
C  ENG = 0  
C  CR-2 = 1  
C  CR-3 = 2
C  CR-4 = 3
C  CR-5 = 4
C  CR-6 = 5
C  CR-7 = 6
C  CR-1 = 7
C  GS-10A = 8
C  N/A = 9
C  GS-3 = 0A = 10
C  N/A = 0B = 11
C  GS-7 = 0C = 12
C  N/A = 0D = 13
C  GS-6 = 0E = 14
C  GS-4 = 0F = 15
C  N/A = 10 = 16
C  GS-2 = 11 = 17
C  N/A = 12 = 18
C  N/A = 13 = 19
C  N/A = 14 = 20
C  N/A = 15 = 21
C  OC-2 = 16 = 22
C  OC-1 = 17 = 23
C  CR=5A = 18 = 24
C  GS-10 = 19 = 25
C  GS-8 = 1A = 26
C  N/A = 1B = 27
C  N/A = 1C = 28
C  UV-5A = 1D = 29
C  N/A = 1E = 30
C  N/A = 1F = 31
C
C from Chg  4
C  IM-S = 8 
C  IM-7/PB-6 = 9
C  GS-3/IM2 = 0A = 10
C  IM-9/PB-10 = 0B = 11
C  GS-7/PV-3 = 0C = 12
C  PB-1/PB-12 = 0D = 13
C  GS-6/PB-1 = 0E = 14
C  IM-14/IM-Q = 12 = 18
C  IM-12 = 14 = 20
C  IM-11 = 15 = 21
C  OC-2/IM-10 = 16 = 22
C  IM-8/IM-15 = 18 = 24
C  IM-0  = 19 = 25
C  IM-6 = 1A = 26
C  IM-5/IM-T = 1B = 27
C  IM-4/IM-K = 1C = 28
C  IM-3 = 1D = 29
C  IM-2 = 1E = 30
C  IM-13 = 1F = 31
C
      INCLUDE 'unpack.inc'
C
      ISTAT = 0
C
      IF (DATMOD.EQ.0) MODE = 0		!8  ENGR - Zero
      IF (DATMOD.EQ.1) MODE = 2		
      IF (DATMOD.EQ.2) MODE = 3
      IF (DATMOD.EQ.3) MODE = 4
      IF (DATMOD.EQ.4) MODE = 5
      IF (DATMOD.EQ.5) MODE = 6
      IF (DATMOD.EQ.6) MODE = 7         !9
      IF (DATMOD.EQ.7) MODE = 1		!1
      IF (DATMOD.EQ.8) MODE = -1
      IF (DATMOD.EQ.9) MODE = -1
      IF (DATMOD.EQ.10) MODE = 10	!0
      IF (DATMOD.EQ.11) MODE = -1
      IF (DATMOD.EQ.12) MODE = 12	!0
      IF (DATMOD.EQ.13) MODE = -1
      IF (DATMOD.EQ.14) MODE = 14	!0
      IF (DATMOD.EQ.15) MODE = 15	!0
      IF (DATMOD.EQ.16) MODE = -1
      IF (DATMOD.EQ.17) MODE = 17	!-1
      IF (DATMOD.EQ.18) MODE = -1
      IF (DATMOD.EQ.19) MODE = -1
      IF (DATMOD.EQ.20) MODE = -1
      IF (DATMOD.EQ.21) MODE = -1
      IF (DATMOD.EQ.22) MODE = 22	!0
      IF (DATMOD.EQ.23) MODE = 23	!0
      IF (DATMOD.EQ.24) MODE = 24	!13
      IF (DATMOD.EQ.25) MODE = 25	!-1
      IF (DATMOD.EQ.26) MODE = 26	!0
      IF (DATMOD.EQ.27) MODE = -1
      IF (DATMOD.EQ.28) MODE = -1
      IF (DATMOD.EQ.29) MODE = 29	!13
      IF (DATMOD.EQ.30) MODE = -1
      IF (DATMOD.EQ.31) MODE = -1
C
      IF (DATMOD.LT.0.OR.DATMOD.GT.31) THEN
       WRITE(6,*)
       WRITE(6,*) '***INVALID DATMOD VALUE***'
       ISTAT = 1
       MODE = -1
      END IF
C
C     WRITE(6,*) 'DATMOD,MODE ',DATMOD,MODE
C
      RETURN
      END
