#ifdef _TED_INIT_
#define INIT(x) x
#define ALLOC
#else
#define INIT(x)
#define ALLOC extern
#endif

typedef	unsigned char	ubyte;

/* size of SFDU label in bytes */
#define LABEL_LENGTH			20
#define PRIMARY_SIZE			4
#define CHDO_SIZE			4
#define PRIMARY_HDR_DATA_OFFSET	LABEL_LENGTH+(2*CHDO_SIZE)
/* offset to start of secondary hdr */
#define SECONDARY_HDR_OFFSET	LABEL_LENGTH+PRIMARY_SIZE+(2*CHDO_SIZE)
/*  size of secondary hdr */
#define SECONDARY_HDR_SIZE		80 + CHDO_SIZE	
/* size of tertiary hdr */
#define TERTIARY_HDR_SIZE		22 + CHDO_SIZE
/*  offset to start of tertiary hdr */
#define TERTIARY_HDR_OFFSET	SECONDARY_HDR_OFFSET + SECONDARY_HDR_SIZE	
/* offset to start of quaternary hdr */
#define QUATERNARY_HDR_OFFSET TERTIARY_HDR_OFFSET+TERTIARY_HDR_SIZE
/* Ulysses SC ID offset in 2nd hdr = PRIMARY_HDR_DATA_OFFSET+10 bytes */
#define SC_ID_OFFSET                    SECONDARY_HDR_OFFSET+CHDO_SIZE+2
#define MAX_SFDU_LENGTH   		32768+LABEL_LENGTH
#define NJPL				"NJPL"
#define AUTHORITY_ID			"NJPL2I00"
#define STAT_ERR			"STAT/ERR"
#define TDSQUERY			"TDSQUERY"
#define QUERYSPC			"QUERYSPC"
#define TDSQDATA			"TDSQDATA"
#define K_HEADER			"NJPL3KS0L009"
#define K_HEADER_LENGTH			12
#define END_OBJECT_LABEL		"END_OBJECT"
#define END_OBJECT_LENGTH		28
#define OBJECT_LABEL			"OBJECT"
#define OBJECT_LENGTH			24
#define STATUS				"Status Message"
#define TDS_STATUS			0
#define ERROR				"Error Message"
#define TDS_ERROR			1
ALLOC   char*    MESSAGE_TYPE_LABEL INIT(= {"MESSAGE_TYPE"});
#define MESSAGE_TYPE_LENGTH		12
ALLOC	char*   MESSAGE_NUM_LABEL INIT(= {"MESSAGE_NUM"});
#define MESSAGE_NUM_LENGTH		11
ALLOC	char*   MESSAGE_LABEL	INIT(= {"MESSAGE "});
#define MESSAGE_LENGTH			7

/* SFDU length in label can be ascii or binary, this field */
/* contains the value that determines the length type      */
#define SFDU_LENGTH_TYPE_OFFSET 	4
/* ASCII length type value */
#define ASCII_LENGTH_TYPE		'1'
/* offset to start of ASCII length field */
#define ASCII_LENGTH_OFFSET		12
/* Binary length type value */
#define BINARY_LENGTH_TYPE		'2'
/* offset to start of Binary length field */
#define BINARY_LENGTH_OFFSET		9
/* Variable length type value */
#define VARIABLE_LENGTH_TYPE		'3'

#define HOURS_PER_DAY		24
#define SECONDS_PER_HOUR	3600
#define SECONDS_PER_MINUTE	60
#define SECONDS_PER_DAY		SECONDS_PER_HOUR*HOURS_PER_DAY
#define MILLISECONDS_PER_DAY	SECONDS_PER_DAY*1000

struct mission_time_struct
   {
   unsigned short days;
   long milliseconds;
   };

struct mission_sclk
   {
   unsigned int   sclk;         /* spacecraft clock */
   unsigned short fract;        /* fractional clock value */
   };
/*******************************************************/
/*** PVL LABEL AND TRAILER USED TO FRAME QUERY      ***/
/*******************************************************/
ALLOC	char*   PVL_LABEL INIT(= {"CCSD3ZS00001QUERYSPC"});
ALLOC	char*   PVL_TRAILER INIT(= {"CCSD3RE00000QUERYSPC"});

/*******************************************************/
/*** NJPL LABEL AND TRAILER USED TO FRAME QUERY      ***/
/*******************************************************/
ALLOC	char*   SFDU_LABEL INIT(= {"NJPL3IS0L009TDSQUERY"});
ALLOC	char*   SFDU_TRAILER INIT(= {"CCSD3RE00000TDSQUERY"});

/******************************/
/*** TDS END OF DATA LABEL  ***/
/******************************/
ALLOC	char*   SFDU_EOD_LABEL INIT(= {"CCSD3RE00000TDSQDATA"});

/*******************************************************/
/*** NJPL LABEL AND TRAILER INDICATING A TDS MESSAGE ***/
/*******************************************************/
ALLOC	char*   TDS_MESSAGE_LABEL INIT(= {"NJPL3KS0L009STAT/ERR"});
ALLOC	char*   TDS_MESSAGE_TRAILER INIT(= {"CCSD3RE00000STAT/ERR"});

/*******************************************************/
/*** NJPL LABEL SIGNIFYING QUERY ECHO FROM TDS       ***/
/*******************************************************/
ALLOC	char*   QUERY_ECHO_LABEL INIT(= {"CCSD3ZS00001TDSQDATA"});

/*******************************************************/
/* PVL parameters used to build TDS query              */
/*******************************************************/
/* If ANY of these character array  sizes are modified */
/* the corresponding TextWidget Column parameter has   */
/* to be adjusted also!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/*******************************************************/
enum    {PVL_OBJECT,
	 PVL_DESCRIPTION,
	 PVL_NAME,
	 PVL_MISSION,
	 PVL_SC_NAME,
	 PVL_TIME_TYPE,
	 PVL_START_TIME,
	 PVL_STOP_TIME,
	 PVL_TIME_ORDER,
	 PVL_DSS_ID,
	 PVL_SOURCE,
	 PVL_LOADER,
	 PVL_PROTOCOL,
	 PVL_GROUP,
	 MAX_PVL_FIELDS};
ALLOC int pvl_indicators[MAX_PVL_FIELDS];
ALLOC char 	object[35];
ALLOC char* DESCRIPTION_LABEL INIT(={"DESCRIPTION = \"ULS_PROJECT_SERVER\""});
ALLOC char* 	EO_LABEL INIT(= {"END_OBJECT = ULS_DATA_RECORDS"});
ALLOC char* 	O_LABEL INIT(= {"OBJECT = ULS_DATA_RECORDS"});
ALLOC char* 	MISSION_LABEL INIT(= {"MISSION_NAME = "});
ALLOC char*	NAME_LABEL INIT(= {"REQUESTER_NAME = "});
ALLOC char*	SC_LABEL INIT(= {"SPACECRAFT_NAME = "});
ALLOC char	mission[25];
ALLOC char	sc_name[30];
/***********************************************************/
/* store the spacecraft ID for possible verification       */
/* of SFDUs from TDS(This is mostly to prevent GLL         */
/* Testbed data from getting confused with spacecraft data */
/***********************************************************/
ALLOC int	sc_num;
ALLOC int       sc_id_test_enabled INIT(=FALSE);

/* TIME TYPE CONSTANTS */
enum	{ERT,
	 SCLK,
	 RCT,
	 SCET,
	 MAX_TIME_TYPES};

ALLOC int	time_type_index;
ALLOC char*   TIME_TYPE_LABEL INIT(= {"TIME_TYPE = "});
static char	*time_type_names[MAX_TIME_TYPES] 
				= {"ERT","SCLK","RCT","SCET"};

ALLOC char*   START_TIME_LABEL INIT(= {"START_TIME = "});
ALLOC char*   STOP_TIME_LABEL INIT(= {"STOP_TIME = "});
/* the only time order parameters are ERT or SCLK */
#define MAX_ORDER_TYPES         2
ALLOC int       time_order_index;
ALLOC char*   TIME_ORDER_LABEL INIT(= {"TIME_ORDER = "});

enum		{NERT,RT,MAX_SOURCE_TYPES};
ALLOC char*   DATA_SOURCE_LABEL INIT(= {"SFOC_DATA_SOURCE = {"});
static char*  tds_data_source_names[MAX_SOURCE_TYPES] = {"NERT","RT"};
ALLOC int     tds_data_source[MAX_SOURCE_TYPES];

ALLOC char*   DSS_ID_LABEL INIT(= {"DSS_ID = ALL;"});

/* group indicies */
enum	{FRAME_GROUP,CHANNEL_GROUP,MAX_GROUPS};
ALLOC int	group_index;
ALLOC char*   GROUP_LABEL INIT(= {"GROUP = "});
static char	*group_names[MAX_GROUPS]={"FRAME","CHANNEL"};
ALLOC char*   END_GROUP_LABEL INIT(= {"END_GROUP = "});

ALLOC char	end_object[40];

/*******************************************************/
/* parameters used by frame or packet group query      */
/*******************************************************/
/* Packet/Frame Group Offsets */
/* FOR BEST RESULTS DO NOT REORDER THIS LIST */
enum    {ENG_DATA,  
	 SCI_DATA,
	 QQC_DATA,
	 CHQQC_DATA,
	 MON_DATA,
	 CHMON_DATA,
	 FILL_DATA,
	 MISC_DATA,  /*<--- THIS IS THE LAST DATA TYPE */
	 TLM_MODE,
	 MAX_PFG_FIELDS};

/* Packet/Frame Group Flags */
ALLOC short	pfg_indicators[MAX_PFG_FIELDS];

/*********************************************************************/
/* LAST DATA TYPE MUST BE USED TO DETERMINE THE MAX_DATA_TYPES VALUE */
/*********************************************************************/
#define MAX_DATA_TYPES		MISC_DATA+1
ALLOC short	data_types[MAX_DATA_TYPES];
ALLOC char*   DT_NAME_LABEL INIT(= {"DATA_TYPE = "});
static char	*data_type_names[MAX_DATA_TYPES]
		 = {"ENG","SCI","QQC","CHQQC","MON","CHMON","FILL","MISC"};
ALLOC char*   BUS_CODE_LABEL INIT(= {"BUS_CODE = "});
ALLOC char*   ADDRESS_RANGE_LABEL INIT(= {"ADDRESS_RANGE = "});

/*****************************************************************/
/* All data types are separated into 2 catagories.  The enum     */
/* variables that end in MAX_*_TYPES(where * is a wildcard) are  */
/* TDS specific.  They are used in PVL queries to TDS.           */
/* The enum variables that end in MAX_*_SFDUS(where * is a wild- */
/* card) are created by TIS and defined in SFOC-5-SYS-*DU-NJPL   */
/*****************************************************************/

enum	{ALL_QQC_MSGS,
	HBEAT_IN_SYNC,
	HBEAT_OUT_SYNC,
	HBEAT_NO_DATA,
	TDM_FAIL_ACQ,
	IN_SYNC,
	OUT_SYNC,
	QQC_NO_DATA,
	SCLK_CHANGE,
	FID_CHANGE,
	DECOM,
	QQC_SUMMARY,
	QQC_DATA_SUMMARY,
	MAX_QQC_TYPES};
static char*	qqc_types[MAX_QQC_TYPES] =
				{"qqc","qqc_hbeat_in_sync",
				"qqc_hbeat_out_sync",
                                "qqc_hbeat_no_data", "qqc_tdm_fail_acq",
                                "qqc_in_sync", "qqc_out_sync", "qqc_no_data",
                                "qqc_sclk_change","qqc_fid_change","qqc_decom",
                                "qqc_summary","qqc_data_summary"};

enum	{QQC_HBEAT_IN_SYNC_SFDU,
	QQC_HBEAT_OUT_SYNC_SFDU,
	QQC_HBEAT_NO_DATA_SFDU,
	QQC_TDM_FAIL_SFDU,
	QQC_IN_SYNC_SFDU,
	QQC_OUT_SYNC_SFDU,
	QQC_NO_DATA_SFDU,
	QQC_SCLK_CHANGE_SFDU,
	QQC_FID_CHANGE_SFDU,
	QQC_DECOM_SFDU,
	QQC_SUMMARY_SFDU,
	QQC_DATA_SUMMARY_SFDU,
	MAX_QQC_SFDUS};


static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into qqc_types */
	char*		ddp_id;
	} qqc_sfdus[MAX_QQC_SFDUS] = {
	{13,0,3,21,0,1,"C521"},
	{13,0,3,22,0,2,"C522"},
	{13,0,3,23,0,3,"C523"},
	{13,0,3,24,0,4,"C414"},
	{13,0,3,26,0,6,"C524"},
	{13,0,3,27,0,7,"C525"},
	{13,0,3,28,0,8,"C526"},
	{13,0,3,29,0,9,"C527"},
	{13,0,3,30,0,10,"C420"},
	{13,0,3,31,0,11,"C421"},
	{13,0,3,34,0,14,"C529"},
	{13,0,3,35,0,15,"C530"}};



ALLOC int	qqc_selected[MAX_QQC_TYPES];

enum	{ALL_CHQQC_SFDU,CHQQC_HBEAT_IN_SYNC_SFDU,CHQQC_HBEAT_OUT_SYNC_SFDU,
	 CHQQC_HBEAT_NO_DATA_SFDU,
	 CHQQC_TDM_FAIL_SFDU,CHQQC_IN_SYNC_SFDU,CHQQC_OUT_SYNC_SFDU,
	 CHQQC_NO_DATA_SFDU,CHQQC_SCLK_CHANGE_SFDU,CHQQC_FID_CHANGE_SFDU,
	 CHQQC_DECOM_SFDU, CHQQC_SUMMARY_SFDU,CHQQC_DATA_SUMMARY_SFDU,
	 MAX_CHQQC_SFDUS};

static char*  	ch_qqc_types[MAX_QQC_TYPES] =
				{"chqqc","ch_qqc_hbeat_in_sync",\
				"ch_qqc_hbeat_out_sync",\
                                "ch_qqc_hbeat_no_data","ch_qqc_tdm_fail_acq",\
                                "ch_qqc_in_sync", "ch_qqc_out_sync",\
                                "ch_qqc_no_data", "ch_qqc_sclk_change",\
                                "ch_qqc_fid_change", "ch_qqc_decom",\
                                "ch_qqc_summary", "ch_qqc_data_summary"};
ALLOC int	ch_qqc_selected[MAX_QQC_TYPES];


static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into ch_qqc_types */
	char*		ddp_id;
	} chqqc_sfdus[MAX_CHQQC_SFDUS] = {
	{11,3,1,21,3,1,"C531"},
	{11,3,1,22,3,2,"C532"},
	{11,3,1,23,3,3,"C533"},
	{11,3,1,24,3,4,"C434"},
	{11,3,1,26,3,6,"C534"},
	{11,3,1,27,3,7,"C535"},
	{11,3,1,28,3,8,"C536"},
	{11,3,1,29,3,9,"C537"},
	{11,3,1,30,3,10,"C440"},
	{11,3,1,31,3,11,"C441"},
	{11,3,1,34,3,14,"C539"},
	{11,3,1,35,3,15,"C540"}};

/* Telemetry Mode Offsets */
enum	{MERGED_MODE,
	 REALTIME_MODE,
	 PLAYBACK_MODE,
	 MAX_TLM_MODES};
ALLOC int			tlm_mode_index;
ALLOC char*   TELEMETRY_MODE_LABEL INIT(= {"TELEMETRY_MODE = "});
static char	*tlm_mode_names[MAX_TLM_MODES] 
			= {"MERGED","REALTIME","PLAYBACK"};
ALLOC char*   WSE_FILTER_LABEL INIT(= {"WSE_FILTER = "});
/*******************************************************/
/* parameters used by channel group query 	       */
/*******************************************************/
/* If ANY of these character array  sizes are modified */
/* the corresponding TextWidget Column parameter has   */
/* to be adjusted also!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/*******************************************************/
/* Channel Group Offsets */
enum	{CG_CHANNEL_SET,
	 CG_SAMPLE_MODE,
	 CG_COMPRESS_HEADER,
	 CG_DELTA_TIME,
	 CG_FREQUENCY,
	 MAX_CG_FIELDS};
ALLOC   short			cg_indicators[MAX_CG_FIELDS];
ALLOC char*   CHANNEL_SET_LABEL INIT(= {"CHANNEL_SET = "});
/* sample mode indicies */
enum	{SAMPLE_ON_SAMPLE,
	 SAMPLE_ON_CHANGE,
	 SAMPLE_CHANGE_ONLY,
	 SAMPLE_DELTA_TIME,
	 SAMPLE_FREQUENCY,
	 MAX_SAMPLE_MODES};
ALLOC char*   SAMPLE_MODE_LABEL INIT(= {"SAMPLE_MODE = "});
ALLOC int       		sample_mode_index;
static char	*sample_mode_names[MAX_SAMPLE_MODES] =
			{"ON_SAMPLE","ON_CHANGE","CHANGES_ONLY",
				"DELTA_TIME","FREQUENCY"};
ALLOC char 			compress_headers[5];
ALLOC char*   TIME_DELTA_LABEL INIT(= {"TIME_DELTA = "});
ALLOC char*   FREQUENCY_LABEL INIT(= {"FREQUENCY = "});

#define COMMA                   ","
#define SEMI_COLON              ";"
#define OPEN_BRACE              "{"
#define CLOSE_BRACE             "}"
#define NEW_LINE		0x0a
ALLOC char	new_line;

/* TDS Query Buffer */
#define MAX_TDS_QUERY_LENGTH	1000
ALLOC char 			tds_query_buffer[MAX_TDS_QUERY_LENGTH];
ALLOC int  			tds_query_length;
ALLOC int  			tds_query_sent;
ALLOC int  			tds_query_ready;

/* pointer to SFDU received from TDS */
ALLOC char			*sfdu_pointer;

/* buffer for data received from TDS */
union data_rcvd{
		ubyte		byte_buffer[MAX_SFDU_LENGTH];
		unsigned short	short_buffer[MAX_SFDU_LENGTH/2];
	      };
ALLOC union data_rcvd 		input_data;

ALLOC int 			record_count;


enum  {ALL_MON,MON59_BLK1,MON59_BLK2,MON59_BLK3,MON59_BLK4,MAX_MON_TYPES};
static char* mon_types[MAX_MON_TYPES] = {"mon","gif_mon_block1",
		 "gif_mon_block2","gif_mon_block3","gif_mon_block4"};
ALLOC int	mon_selected[MAX_MON_TYPES];

enum	{MON_59_1_SFDU,MON_59_2_SFDU,MON_59_3_SFDU,MON_59_4_SFDU,MAX_MON_SFDUS};
static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into mon_types */
	char*		ddp_id;
	} mon_sfdus[MAX_MON_SFDUS] = {
	{6,1,3,128,0,1,"C294"},
	{6,1,3,129,0,2,"C294"},
	{6,1,3,130,0,3,"C294"},
	{6,1,3,131,0,4,"C294"}};


enum  {ALL_CH_MON,CH_MON59_BLK1,CH_MON59_BLK2,CH_MON59_BLK3,CH_MON59_BLK4,
       MAX_CH_MON_TYPES};
static char* ch_mon_types[MAX_CH_MON_TYPES]={"chmon","ch_gif_mon_block1",
            "ch_gif_mon_block2","ch_gif_mon_block3", "ch_gif_mon_block4"};
ALLOC int	ch_mon_selected[MAX_CH_MON_TYPES];

enum	{CHMON_59_1_SFDU,CHMON_59_2_SFDU,CHMON_59_3_SFDU,
	 CHMON_59_4_SFDU, MAX_CHMON_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into ch_mon_types */
	char*		ddp_id;
	} chmon_sfdus[MAX_CHMON_SFDUS] = {
	{11,2,3,128,0,1,"C295"},
	{11,2,3,129,0,2,"C295"},
	{11,2,3,130,0,3,"C295"},
	{11,2,3,131,0,4,"C295"}};

enum   {ALL_SCI,NON_IL,PB_UNK_IL,PB_1_1,PB_1_3,PB_1_7,
	FILL_UNK_IL, FILL_1_1, FILL_1_3, FILL_1_7, MAX_SCI_TYPES};
ALLOC	int	sci_selected[MAX_SCI_TYPES];

enum	{ALL_SCI_SFDUS,NON_IL_SFDUS,PB_UNK_IL_SFDUS,PB_1_1_SFDUS,
	 PB_1_3_SFDUS,PB_1_7_SFDUS, FILL_UNK_IL_SFDUS,FILL_1_1_SFDUS,
	 FILL_1_3_SFDUS,FILL_1_7_SFDUS, MAX_SCI_SFDUS};
static char*	sci_types[MAX_SCI_SFDUS]={"sci","sci_non_il",
                        "sci_pb_unk_il","sci_pb_1_1_il",
                        "sci_pb_1_3_il","sci_pb_1_7_il",
			"sci_fill_unk_il","sci_fill_1_1_il",
			"sci_fill_1_3_il","sci_fill_1_7_il"};
static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into tds_channelized_names */
	char*		ddp_id;
	} sci_sfdus[MAX_SCI_SFDUS] = {
	{3,0,3,0,0,1,"C291"},
	{3,0,3,1,0,2,"C291"},
	{3,0,3,2,0,3,"C291"},
	{3,0,3,3,0,4,"C291"},
	{3,0,3,4,0,5,"C291"},
	{3,0,3,17,0,6,"C292"},
	{3,0,3,18,0,7,"C292"},
	{3,0,3,19,0,8,"C292"},
	{3,0,3,20,0,9,"C292"}};

static	struct sfdu_struct{
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into *_types */
	char*		ddp_id;
	};
/***********************************************/
/* These entries represent all TDS data types  */
/* there are no Ulysses TDS channelized SFDUs  */
/***********************************************/
#define MAX_TDS_TYPES	MAX_DATA_TYPES
static 	struct	{
	int	num_sfdu_types;
	struct	sfdu_struct	*sfdus;
	char	**name_list;
        } frame_sfdus[MAX_TDS_TYPES] = {
	{0,NULL,NULL},/* eng data */
  	{MAX_SCI_SFDUS,(struct sfdu_struct*)sci_sfdus,sci_types},
	{MAX_QQC_SFDUS,(struct sfdu_struct*)qqc_sfdus,qqc_types},
	{MAX_CHQQC_SFDUS,(struct sfdu_struct*)chqqc_sfdus,ch_qqc_types},
	{MAX_MON_SFDUS,(struct sfdu_struct*)mon_sfdus,mon_types},
	{MAX_CHMON_SFDUS,(struct sfdu_struct*)chmon_sfdus,ch_mon_types},
	{0,NULL,NULL},/* fill data */
	{0,NULL,NULL}};/* misc data */

ALLOC	int	unknown_sfdus_rcvd;
