#! /bin/csh
# 2-20-2021
# test script generated by Fernando Peralta for Ray Bambery's
# rebuilding of VGR_EDR on shock3-vm under Solaris 10.2 -
# Oracle 11.2 and gcc/g++ 4.5.2 
#
# Original script had root directory as /export/home (for shock3.jpl.nasa.gov)
# Shock3-vm uses /home
#
# The original home of VGR_EDR executable was /export/home/nertops/bin/z0_Vedr
# The original home of data_fetch was /export/home/nertops/bin
#
unalias rm

if ($#argv < 2) then
   echo " "
   echo "Usage: EDR_daily_31.csh YY DOY"
   echo " "
   exit 1
endif

set date="20"$argv[1]-$argv[2]
set year=$argv[1]
set doy=$argv[2]
set yeardoy=$year$doy

set ext="b"
set sc="2"

ls /home/rjb/3$sc/*.$ext
echo "ls /home/rjb/3$sc/*.$ext"
rm /home/rjb/3$sc"/*"$ext

#########################################

set vgrmsgfile="vgr_msg."$year$doy$ext
echo "vgrmsgfile = $vgrmsgfile"
##exit(0)
echo "/home/rjb/3$sc/VGR_MSG/vgr_msg.*$ext /home/rjb/VGR_MSG/vgr_msg.*$ext"
cp /home/rjb/3$sc/VGR_MSG/vgr_msg.*$ext /home/rjb/VGR_MSG/vgr_msg.*$ext
#rm /home/rjb/3$sc/VGR_MSG/vgr_msg.*$ext

#########################################

set crsfile="crs"$yeardoy"."$ext
set crsctfile="crs"$yeardoy"."$ext"ct"
set plsfile="pls"$yeardoy"."$ext
set lecfile="lec"$yeardoy"."$ext
set magfile="mag"$yeardoy"."$ext
set pwsfile="pws"$yeardoy"."$ext

echo " "
echo "Files to be generated"
echo $crsfile
echo $crsctfile
echo $plsfile
echo $lecfile
echo $magfile
echo $pwsfile

echo "################   RUNNING VGR-"$sc" EDR DAILY PROCESS FOR "$yeardoy"   ################"
echo " "

ls -lrt /home/rjb/ftp_FILES/VGR2/crs1* | tail
cd /home/rjb/3$sc
#******************************************
#******************************************
echo "Running TED TDS Query"
#run31
# Running TED TDS Query
# This is is IP address of the local AMMOS workstation
# nertops1 or nertops2 - Where 'TCP' is running
#
setenv DATA_PATH /home/rjb/3$sc"/"
setenv TDS_HOST 137.228.89.17 ## CDR
#setenv TDS_HOST 137.228.89.141 ## opsana18
#
##echo /home/nertops/bin/data_fetch VOYAGER_$sc SCI ERT $date"T00:00:00.000" $date"T23:59:59.000" ERT datafile.$ext
##/home/nertops/bin/data_fetch VOYAGER_$sc SCI ERT $date"T00:00:00.000" $date"T23:59:59.000" ERT datafile.$ext

###
###echo "/home/rjb/edr2/data_fetch/src/data_fetch VOYAGER_'$sc' SCI ERT '$date'T00:00:00.000 '$date'T23:59:59.000 ERT datafile.'$ext'"
###/home/rjb/edr2/data_fetch/src/data_fetch  VOYAGER_$sc SCI ERT $date"T00:00:00.000" $date"T23:59:59.000" ERT datafile.$ext
#
##echo /home/nertops/bin/VGR_EDR /export/home/nertops/3$sc"/"datafile.$ext /export/home/nertops/3$sc"/"SCLK_SCET.3$sc QUICK_LOOK OUTPUT
##/home/nertops/bin/VGR_EDR /home/nertops/3$sc"/"datafile.$ext /home/nertops/3$sc"/"SCLK_SCET.3$sc QUICK_LOOK OUTPUT
echo '/home/rjb/edr2/edr/sql/VGR_EDR /home/rjb/3'$sc'"/"datafile.$ext /home/rjb/3$sc"/"SCLK_SCET.3$sc QUICK_LOOK OUTPUT'
/home/rjb/edr2/edr/sql/VGR_EDR /home/rjb/3$sc"/"datafile.$ext /home/rjb/3$sc"/"SCLK_SCET.3$sc QUICK_LOOK OUTPUT
#
#******************************************
#******************************************
echo " "
echo "Displaying created instrument files"
ls *$yeardoy*
#
echo "If the boundaries are acceptable, the press Return to continue or ^C to exit."
#cat vgr_msg.$doy$ext
cat vgr_msg.*$ext
read CR
#
exit 1
#
