/***********************************************************************
TITLE:       scegen.h -- common header file for scegen 
CIN: scegen.h,v 1.1.1.1 1994/08/31 19:22:02 root Exp
FILE NAME:      scegen.h
AUTHOR:         D. Flora-Adams
CREATED:        Jan 4, 1991
LAST UPDATE:    1994/08/31 19:22:02
LAST UPDATE:    Dec 07, 2021 - Ray Bambery
VERSION:    1.10
COMPILER:   gcc 7.2 on Centos 7 (pistol.jpl.nasa.gov)
OS:         Solaris 10.2 and Centos 7 

REFERENCES:
WARNINGS:
BUGS:
UNIT TEST:
WAIVERS:
CHANGE HISTORY:
 * scegen.h,v
 * Change BUFSIZ to BUFSIZE to avoid conflict with
 * /usr/include/malloc.h:25:0,
 *               from read_sclk.c:86:
 * /usr/include/stdio.h:127:0: note: this is the location of the previous definition
 * #define BUFSIZ _IO_BUFSIZ
 *
 * Revision 1.1.1.1  1994/08/31  19:22:02  root
 * Initial Release
 *
 * Revision 1.9  1993/11/15  20:27:25  dsfa
 * changed $Header to $Id
 *
 * Revision 1.8  1993/10/05  17:02:43  dsfa
 * Incremented MAX_FILE_TYPES by 1 to include LEAPSEC_FILE.
 *
 * Revision 1.7  1992/08/20  16:46:26  dsfa
 * Removed plot type, added nper value.
 *
 * Revision 1.6  1992/02/20  00:25:30  dsfa
 * Modified sclkert_done() function.
 *
 * Revision 1.5  1991/10/07  22:36:48  dsfa
 * *** empty log message ***
 *
 * Revision 1.4  1991/07/03  16:24:29  dsfa
 * added buffer delay to scegen_table
 *
 * Revision 1.3  1991/04/01  15:45:39  dsfa
 * *** empty log message ***
 *
 * Revision 1.2  1991/03/28  22:43:46  dsfa
 * *** empty log message ***
 *
 * Revision 1.1  1991/03/13  17:42:03  dsfa
 * Initial revision
 *
***********************************************************************/
#   ifndef scegen_h
#   define scegen_h
#   include <math.h>
#   include <stdio.h>
#   ifndef	ERROR
#   	define	ERROR	(-1)
#   endif
#   ifndef	OK
#	define	OK	(0)
#   endif
#   ifndef	SEC_PER_DAY
#	define	SEC_PER_DAY	(86400.0)
#   endif
#   ifndef      SEC_PER_MIN
#  	define SEC_PER_MIN     60
#   endif
#   ifndef	SEC_PER_HR
#	define SEC_PER_HR      3600
#   endif
#   ifndef       SEC_PER_12HR
#	define SEC_PER_12HR    43200
#   endif
#   ifndef	SEC_PER_DAY
#	define	SEC_PER_DAY	86400
#   endif
#   ifndef	SEC_PER_3DAY
# 	define	SEC_PER_3DAY	259200
#   endif
#   ifndef      SEC_PER_WEEK
#	define SEC_PER_WEEK    604800
#   endif
#   define EPOCH_DIFF	(852120000.0) /* second difference */
				   /* between 1958 and 1985 */
#   define  BUFSIZE              1024
#   define STD_DOY_TIME_SIZE    22
#   define FILENAME_SIZE	32
#   define MAX_NUM_SCLKERTS	3000
#   define MAX_NUM_LEAPSECS     1000
#   define MAX_FILE_TYPES	5 /* sclkscet, sclkert, litime, *
				   * delay and leapsecond files  */
#   define MAX_SCLK_SIZE	16
#   define MAX_YEAR_SIZE	5  /* yyyy\0 */
#   define MAX_TIME_SIZE	4
#   define MAX_ID_SIZE		10
#   define FILE_DELIMITERS	" ,\r\t"
#ifdef DEBUG
# define DEBUG_PRS(f) fprintf(stderr, f)
# define DEBUG_MSG(s) fprintf(stderr, "%s\n", s)
# define DEBUG_PRN(f,s) fprintf(stderr, f, s)
# define DEBUG_PRN2(f,s,v) fprintf(stderr, f, s, v)
#else
# define DEBUG_PRS(f)
# define DEBUG_MSG(s)
# define DEBUG_PRN(f,s)
# define DEBUG_PRN2(f,s,v)
#endif

#define	sclkert_done()	free(SCEGEN_TABLE); SCEGEN_TABLE = NULL;
#define delay_done()  free(DELAY_TABLE); DELAY_TABLE = NULL;

/* global variable declarations */ 
/******************************************************************************/

/* MISSION IDs for conversions */
#define         GALILEO         1
#define         VOYAGER         2
#define         ULYSSES         3
#define         MAGELLAN        4
#define         MARS_OBSERVER   5

/* SPACECRAFT IDs */
#define         SC_MAGELLAN             18
#define         SC_VOYAGER1             31
#define         SC_VOYAGER2             32
#define         SC_GALILEO              77
#define         SC_ULYSSES              55
#define         SC_MARS_OBSERVER1       94
    extern	char	*file_array[];
    extern	char	*lp_file;  /* leap second filename */ 
    extern	char	*new_ss_file;           
    extern	float	discard_tol;  	/* discard tolerance defined in discard.c */
    extern	double  regenerate_tol; /* regenerate tolerance defined in scegen.c */
    extern      double  mission_tol;  	/* mission tolerance defined in scegen.c */
    extern	int 	mission_id; 	/* mission id defined in scegen.c */
    extern	double	nper;		/* nper value for polyfit defined in scegen.c */
    extern 	int	spacecraft_id;	/* spacecraft id defined in scegen.c */
    extern	double  buffer_delay;	/* buffer delay (data rate) defined in scegen.c */
    extern	int	ready_to_plot;	/* if it is ok to plot this flag is set to TRUE */
    extern	int	read_error;	/* if error occurs when reading files 
						this flag is set to TRUE */
    extern	double  leap_value;	/* leap second value, defined in filemenu.c */

/*  define global functions */
/******************************************************************************/
    extern      int     any_sclk_to_double();
    extern      int     seconds_to_ascii_time();
    extern      int     erttoscet();
    extern	int	selectrange();
    extern	double  *polyfit();
    extern	int	compare_delay(); /* defined in read_delay.c */

/* define structures */
/******************************************************************************/
typedef struct scegen_table {
        double      sclk;   /* space craft clock value */
	double      ert;    /* ERT Earth-received time value from SCLK_ERT file */
	int         dssc;    /* DSN station complex id number (default = 0) */
	char	    delay_key[20];	/* delay key value (data mode or bitrate) */
	double      pscet; /* space craft event time SCET computed from 
			       SCLK_SCET data */
	double      cscet; /* space craft event time computed from 
			       lighttime data */ 
	double      diff;  /* difference between predict scet and calculated scet */
} scegen_tbl, * scegen_tblptr;

typedef struct buffer_delay_t {
	char    key_value[20]; /* either char bitrate or char data_mode */ 
	float   delay; 	    /* buffer_delay value */
} delay_tbl, *delay_tblptr;

extern  delay_tblptr    delay_find();
extern	delay_tblptr	DELAY_TABLE; /* pointer to internal delay table */
extern	scegen_tblptr	SCEGEN_TABLE;  /* pointer to internal scegen table */
extern	scegen_tblptr	first_sclkert;	/* pointer to first member in SCEGEN_TABLE */
extern	scegen_tblptr	last_sclkert;	/* pointer to last member in SCEGEN_TABLE */ 
extern	int 	delay_rows;	/* number of entries in DELAY_TABLE */
extern	int	delay_mission;  /* mission identifier for delay file */
extern	int	scegen_rows;	/* number of entries in SCEGEN_TABLE*/
extern	int	sclkert_mission; /* mission number in the sclk_ert file */ 
extern	int	leap_flag;	/* flag set by Read_leapsec(): TRUE or FALSE */
#endif
