/**************************************************************************
TITLE:  vgr_def.H

AUTHOR:         Judy Yin
CREATED:        Aug 4, 1994
modified:       4-2-2021 
		4-2-2021 - Ray Bambery - add commentsa
                2-3-2022 - Ray Bambery - add CR_7A
		2-4-2022 - Ray Bambery - add GS_10, GS_10A, GS_8, MAX_DDP to 3
OS:		Solaris 10.2
COMPILER:       gcc 4.5.2
****************************************************************************/
#ifndef VGR_DEF_HH
#define VGR_DEF_HH

#define PUBLIC public
#define PRIVATE private

#define TRUE 1
#define FALSE 0
//#define NULL  0
#define FAIL  -1

#define MSG_FILE_NAME "vgr_msg"
#define PROC_NO  0
#define PROC_YES 1
#define INT_CONV 2
#define NOT_DEF  3

// see 618-306_RevD_ch5 Table C-1 pg C-122
// data_mode numbers
#define CR_5A  0x18  //24 decimal
#define UV_5A  0x1d  //29 decimal
#define CR_7A  0x1f  //31 decimal (this is adummy number)
#define GS_10  0x19  //25 decimal
#define GS_10A 0x08  //8 decimal
#define GS_8   0X1a  //26 decimal

//#define PRIM_LABL_ID  0
//#define AGGR_CHDO_ID  1

// sfdu
// see:
// From: 820-013_182  DSN External Interface Specification
// JPL D-16765
// Telemetry Standard Format Data Unit (SFDU) Interface
// Rev A: Aug 29, 2008
//
#define PRIM_LABL_LEN 20
#define AGGR_CHDO_LEN 4
#define PRIM_HDR_LEN  8
#define SEC_HDR_LEN   84
#define TERT_HDR_LEN  30
#define QUAT_HDR_LEN  16
#define DATA_CHDO_LEN 196

#define PRIM_HDR_ID   0
#define SEC_HDR_ID    1
#define TERT_HDR_ID   2
#define QUAT_HDR_ID   3
#define DATA_SEG_ID   4

#define MAX_HDRS      5

#define ENG_MF_PARTS  5
// 820-013_0182-Telecomm-VGR Rev F Jun 23, 2011 SFDUs Generated from
// TIS for Voyager
// See Table 4-1: Voyager Record Sizes for CR_5A
// offsets into DATA CHDO - 196 bytes - starts at offset 242 (octal from start)i
// sfdu type 2
// see Table 4.2.1.5.1 (pg4-38)
// octal offsets from start of datafile.a or datafile.b
#define ENG_DATA_LOC  256	//174 
#define CMD_DATA_LOC  272	//186
#define UVS_DATA_LOC  274	//188
#define MAG_DATA_LOC  302	//194	//byte offset in data starting a 	
#define CRS_DATA_LOC  365	//245
#define PLS_DATA_LOC  434	//284
#define LECP_DATA_LOC 460	//304
#define PRA_DATA_LOC  500	//320
#define PWS_DATA_LOC  507	//327
#define FILL_LOC      522	//338

#define ENG_DATA_LEN  12		//bytes
#define CMD_DATA_LEN   2
#define UVS_DATA_LEN   6
#define MAG_DATA_LEN  51
#define CRS_DATA_LEN  39
#define PLS_DATA_LEN  20
#define LECP_DATA_LEN 16
#define PRA_DATA_LEN   7
#define PWS_DATA_LEN  11
#define FILL_LEN      20
//      
//sfdu
#define CRS  0
#define LECP 1
#define PLS  2
#define PRA  3
#define PWS  4
#define UVS  5
#define ENG  6  // It's going to affect the merging
#define MAG  7  // DON'T change the values here
#define MAX_INSTR_NUM    8
#define MAX_LAST_STAT    2
#define MAX_DECOM_MAPS   8

//EDR
#define DECOM_FILE_LEN 716 
#define MAX_SUBHDR_LEN 432
#define MAX_STANDHDR_LEN 240
#define MAX_MODE 2
#define MODE_CR5A 0
#define MODE_UV5A 1

#define EDRHDR_ITEMS_PART1 50
#define MAX_DDP   6       //increased from 2 to 6 - 2-4-2022 - Ray Bambery

#define EDR_HDR_LEN 	   240
#define DQSW_LOCATION 	    54          //in EDR hdr
#define DATA_PRESENCE_LOC   74      //in EDR hdr
#define VAR_BUF_SIZE 	     6
#define DATA_COMMAND_LOC   161
//-------------------------------------------------
// ? to be done
//-------------------------------------------------
// see  
// Documented in 618-306 Rev D Ch 4 -May 1986 
// Voyager Experiment Data Record Format Specification
//
#define item_0_FILLER	  0
#define item_1_PRJ_ID     1
#define item_2_REC_ID 	  2
#define item_3_SCID       3
#define item_4_PH_RECID   4
#define item_5_DT_MODE    5
#define item_6_ENG_FLG    6
#define item_7_SCPB_FLG   7
//#define item_8
#define item_9_SERT_HR    9
#define item_9_SERT_DAY   9  // for SFOC sfdu
#define item_10_SERT_SEC 10
#define item_11_SERT_MSEC 11
#define item_12_SERT_YR  12
#define item_13_SOURCE	 13
#define item_14_GOLAY    14
#define item_15_SEG_NO   15
#define item_16_EERT_HR  16
#define item_17_EERT_SEC 17
#define item_18_EERT_MSEC 18
#define item_19_EERT_YR  19 
#define item_20_SF_VER   20
#define item_21_SCET_HR  21
#define item_21_SCET_DAY 21  // for SFOC sfdu
#define item_22_SCET_SEC 22
#define item_23_SCET_MSEC 23
#define item_24_SCET_YR   24
#define item_25_SCET_FLG  25
#define item_26_FDSC_FLG 26
#define item_27_M16      27
#define item_28_M60      28
#define item_29_LN_CNT   29
#define item_32_BIT_RATE 32 
#define item_33_EF_BRATE 33
#define item_34_FMT_ID   34
#define item_35_BET      35
#define item_36_LOCK_CNF 36
#define item_37_AGC      37
#define item_38_DSN_ST   38
#define item_40_EBEC     40
#define item_41_SNR      41
#define item_44_LOCK_ST  44
#define item_46_DQSW     46
#define item_47_DQI      47
#define item_48_PN_ERR   48
#define item_49_DATA_FLG 49
#define item_50_GCF_ERR  50
#define item_60_REPLY_F  60		//SFOC
#define item_61_ORG_SRC  61 		//SFOC
#define ITEM_99          99

//--------------------------------------------------------------------------
// 	status/error return code
//--------------------------------------------------------------------------

#endif

