/***************************************************************************
TITLE:  vgr_edr.C

AUTHOR:         Judy Yin
CREATED:        Aug 4, 1994
COMPILER:       gcc - 4.5.2
OS:		Solaris 10.2
Modified:	Ray Bambery - 11-18-2020
		removed debug_on statements
                Ray Bambery - 3-30-2021 
                reimplemented FINAL option
		Ray Bambery - 4-2 2021
		created new function get_sfdu_ptr() in vgr_sfdu.H to allow finding
		data in sfdu in routine vgr_edr::copy_MF_data_block(
		Ray Bambery - 4-3-2021
		subtracted 4 from src_ptr at beginning of vgr_edr::copy_MF_data_block
		This made data values in pws and pls edrs correct with Dec 16th data
		Ray Bambery - 4-6-2021 
		passed record_processed variable into vgr_edr::store_or_write_MFs
		record_processed is for sfdu records
		implemented debug_on == 1 or 2
		Ray Bambery - 4-14-2021
		added memcpy routine in CRS case in vgr_edr::copy_MF_data_block
		This fixed all zero values in data of crs_edr
		However, there is misalignment of data values from Dec 16 version
 		Ray Bambery - 5-3-2021
		added new routine crs_pad to align crs data from datafile to crs_edr
		Ray Bambery - 5-8-2021
		fixed logic in write_edr_rec that gave short 8300 byte crs_edr
                Ray Bambery - 5-17-2021
                added debug_on lines where necessary
                Ray Bambery - 8-25-2021 
                Add comments about FINAL beceause of missing eng and decom data
                in FINAL (weekly) products
		Ray Bambery - 9-30-2021
		debug read_write_decom
		Ray Bambery - 10-03-2021
		fix code to read dcom31.cr and dcom32.cr in /31 and /32 directories
		and force decom_tbl[i].file_name to be dcom31.c when sc_id is 1 
		copy dcom table into edrs for "FINAL" edrs
		Ray Bambery - 10-4-2021
		improved logic to read & write decom tbl
		change pistol dir with shock3-vm dir in read_write_decom
		Ray Bambery - 11-17-2021
		removed logic that would occasionally make dcom file be wrong version
		i.e., com32.cr when sc_id == 1
		Ray Bambery - 11-19-2021
		Ray Bambery - 12-09-2021
		change printf ("    %02x ",sub_hdr_ptr[i]); to printf ("    %02x ",sub_hdr_ptr[ii]);
		in routine write_edr_rec
		Ray Bambery - 12-30-2021
                change dcom32,cr to dcom32.cr
                Ray Bambery - 01-01-2022
                discriminate between ENG and FINAL and ENG and DAILY in write_edr_rec
		Ray Bambery - 01-07-2022
    		final debug printfs removed (//#)	
		correct ERT year in print_time_msg from 19%02d to 20%02d
		Ray Bambery - 01-09-2022
		Make beg_ert_day and first_rec global to allow  final_cleanup routine
		to user first ERT OY to name output files
		rename instrument edr names to beg_ert_day in routine print_final_status
		Ray Bambery - 01-10-2022 
		remove beg_ert_day printfs 
		Ray Bambery - 02-04-2022
                Handle GS_10 case 
		Ray Bambery - 04-07-2022
		enumerate all debug_on == 1 clauses
		modify D-58 to always perform to remove excess ENG records
                Ray Bambery - 04-08-2022
                put in debug= 10 option
		Ray Bambery - 05-19-2022
		remove final traces of debug code when DEBUG is not specified on
		command line - see comments in vgr_edr::store_or_write_MFs
		D-00 numbers refer to debug printouts in log in order seen 
		when debug_on == 1 or 10
References:
1) 618-306_Rev. D, CHG 4 Voyager Experiment Data Record Format - 1 May 1986
2) 618-306_RevD_ch5 - 1 May 1989       CR5A format 
3) 618-609_RevB_chg6_VGR_swreq_edr - 2 June 1986
4) 820-013_0171-telecomm-VGR-NJPL-Rev G Appendix_L5 - 9-29-2009
5) 820-013_0161-Telecomm_RevB-L5 - 19 Nov 2014
6) 820-013_0172-Telecomm-CHDO_RevI-L5-1 - 10-03-2019

This version contains debug printfs	
Routines contained:			CALLED BY:
vgr_edr::vgr_edr			vgr_edrgen
vgr_edr::get_rec_id			vgr_edr::vgr_edr
vgr_edr::open_file			vgr_edr::vgr_edr
vgr_edr::fill_cur_stat_tbl		vgr_edrgen
vgr_edr::fill_last_stat_tbl		vgr_edrgen
vgr_edr::data_mode_changed		vgr_edrgen,vgr_edr::store_or_write_MFs
vgr_edr::last_stat_tbl_changed		vgr_edrgen,vgr_edr::store_or_write_MFs
vgr_edr::sclk_regression		vgr_edr::store_or_write_MFs
vgr_edr::update_format_id		vgr_edr::init_format_id,vgr_edr::store_or_write_MFs
vgr_edr::init_format_id			vgr_edrgen
get_edr_hdr_maps_index			NOT USED
vgr_edr::add_bit_error_cnt		NOT USED
vgr_edr::set_dqi_dqsw			vgr_edr::store_or_write_MFs
vgr_edr::store_last_sclk		vgr_edrgen
vgr_edr::get_MF_no			vgr_edr::store_or_write_MFs
vgr_edr::get_seg_no			vgr_edr::store_or_write_MFs
vgr_edr::store_hdrs_of_first_MF		vgr_edr::store_or_write_MFs
vgr_edr::store_scet			vgr_edr::store_hdrs_of_first_MF
vgr_edr::get_scet			vgr_edr::store_scet,vgr_edr::set_subhdr
vgr_edr::get_store_ert			vgr_edr::store_hdrs_of_first_MF,vgr_edr::store_or_write_MFs
vgr_edr::reset_edr_rec			vgr_edr::store_or_write_MFs
vgr_edr::allocate_data_buf		vgr_edr::reset_edr_rec,vgr_edr::store_or_write_MFs
vgr_edr::write_edr_rec			vgr_edr::store_or_write_MFs
vgr_edr::read_write_decom		vgr_edr::store_or_write_MFs
vgr_edr::store_or_write_MFs		vgr_edrgen
vgr_edr::copy_MF_data_block		vgr_edr::store_or_write_MFs
vgr_edr::copy_to_hdr			vgr_edr::store_hdrs_of_first_MF,vgr_edr::store_or_write_MFs
vgr_edr::overwrite_byte_to_hdr		vgr_edr::store_scet,vgr_edr::get_store_ert
vgr_edr::set_mf_dt_presence		vgr_edr::store_or_write_MFs
vgr_edr::set_subhdr			vgr_edr::store_or_write_MFs
vgr_edr::subhdr_bit_copy		vgr_edr::set_subhdr
vgr_edr::bit_shifting			vgr_edr::subhdr_bit_copy
vgr_edr::extract_hdr			vgr_edr::store_hdrs_of_first_MF
vgr_edr::bit_copy			vgr_edr::copy_to_hdr,vgr_edr::extract_hdr
vgr_edr::debug_print			vgr_edr::set_subhdr
vgr_edr::crs_pad			vgr_edr::


Routines disabled:
vgr_edr::golay_reed_status
vgr_edr::get_bit_rate_index
vgr_edr::last_stat_value
****************************************************************************/
#include <iostream>     //09-11-2020 - Ray Bambery - remove .h
#include <ios>		//09-11-2020 - Ray Bambery - added
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "type_conv.H"
#include "vgr_edr_sfdu.H"
#include "vgr_sfdu.H"
#include "vgr_scet.h"
#include "vgr_edr.H"
#include "vgr_edr.h"
#include "vgr_edr_static.H" 		//first_DECOM == TRUE
#include "copy_util.H"

int beg_ert_day;
int end_ert_day;
extern int first_rec;
/*****************************************************************************/
vgr_edr::vgr_edr(U16 instr)
{
  char dir_path_name[80] = "";

  fflush(stdout);
  instr_no = instr;
  first_MF = TRUE;
  data_len = 0;                 // edr data size
  data_ptr = (U8*) NULL;        //ptr to edr data
  sub_hdr_len = 0;              //sub_hdr size
  sub_hdr_ptr = (U8*) NULL;     //ptr or sub_hdr 
// D-23
  if (debug_on == 1) {
	printf ("vgr_edr:  Entry instr_no= %d\n",instr);
  }

  strncpy(dir_path_name, "./", 2);

  strncat(dir_path_name, file_name_maps[instr], strlen(file_name_maps[instr]));

  out_fd[instr_no] = open_file((const char *)dir_path_name, (char *) "w");
// D-24
  if (debug_on == 1 || debug_on == 10) {
	printf (">>>> FOPEN %d   %s   \n",instr_no,dir_path_name);
  }


//  msg_fd           = open_file(MSG_FILE_NAME, "a+");

    
  if (out_fd[instr_no] == NULL)
	perror( "vgr_edr::vgr_edr:  cann't open edr file \n");
  
  last_seg_no = 0;	//init last segment number  
  phy_rec_no  = 0;	//init physical record number
  eng_rec_no = 0;	//ENG record number
 
  // item_1, write mjs
  hdr[0] = 0xd4; hdr[1] = 0xd1; hdr[2] = 0xe2;
  
  // item_2, rec_id
  //  hdr[3] = (get_rec_id(instr, rec_id_map));
  //	printf ("vgr_er::vgr_edr: hdr[3] = %x\n");
  hdr[3] = ((get_rec_id(instr, rec_id_map) & 0x0f) << 4);  //changes CRS from 1 to 10
  hdr[236] = get_rec_id(instr, data_type_map);

    		if (debug_on == 2)
			{
			printf("vgr_edr::vgr_edr  \n");
   			printf("instr=%d  file_name=%s hdr=%x out_fd[instr_no]=%x  hdr[3]= %x  hdr[236] = %X \n", 
				instr, file_name_maps[instr], hdr,out_fd[instr_no], hdr[3], hdr[236] );

       			printf("sub_hdr_ptr=%x   data_ptr=%x   ",sub_hdr_ptr, data_ptr);
      			printf("data_len=%d  sub_hdr_len=%d  \n", data_len,sub_hdr_len);
		}
// D-25
   if (debug_on == 1) {
	printf ("===RETURN\n");
   }

} 
/*****************************************************************************/
vgr_edr::~vgr_edr(void)
{

   char cmd[80]="";
   int  ert_day = cur_ert.hour/24;
   delete[] data_ptr;
   delete[] sub_hdr_ptr;
 

/*
   printf (" reaching ~vgr_edr----\n");
   fclose (out_fd[instr_no]);

   sprintf(cmd," mv %s  %s.%d", file_name_maps[instr_no], 
               file_name_maps[instr_no],ert_day);

   system (cmd);
*/
}
 

/*****************************************************************************/
// item_2
unsigned char vgr_edr::get_rec_id(int instr, REC_ID_STRUC* id_map)
{
//typedef struct rec_id_struc {
//        int instr;
//        U8  rec_id;
// } REC_ID_STRUC;
//
  unsigned char rec_id;
  int i;

//	printf ("get_rec_id instr = %d\n",instr);
  rec_id = 0x00;

  for  ( i=0; i < MAX_INSTR_NUM ; i++)
  {
    if (id_map[i].instr == instr)
    {
       rec_id = id_map[i].rec_id;
       break;
    }
  }
	if (debug_on == 2)
 		 printf("instr= %d  rec_id= %d ", instr, rec_id);
  return (rec_id);
}

/*****************************************************************************/
FILE* vgr_edr::open_file(const char* file_name, char* type)
{
    FILE *fds;
    char err_msg[50];

    if ((fds = fopen(file_name, type)) == NULL)
    {
      printf("vgr_edr::open_file: can not open file- %s with  %s \n", file_name, type);
      fflush(stdout); 
        exit(0);
    }

    return fds;
}

/*****************************************************************************/
void vgr_edr::fill_cur_stat_tbl(vgr_sfdu& sfdu_obj)
{
/* this routine gets sclk struct from SFOC_SCLK_TIME struct as shown in
 * vgr_struct.H - 3 ints m16,m60 and ln_cnt
 * Notice: sfdu_obj is from public in class vgr_sfdu as shown in vgr_sfdu.H
 *     caller passes sfoc_data
 *  m16 is from item 27, m60 is from item 28 and ln_cnt is from item 29
 *
 * item_27 and item_28 are from tertiary CHDO of datafile at
 *   locations byte 10 (16-bits) and byte 12 (16-bits)
 *   ln_cnt is from byte 14 (16 bits)
 *
 * data_mode is from 618-306_Rev. D, CHG 5 Voyager Experiment Data Record Format
 *  Table C-1 Standard Experiment Data Record Header
 *  Item 5, word 2, bits 15-8, HEX 18 (decimal 24) is CR5A
 *                             HEX 1D (decimal 29) is UV5A
 *                             HEX 19 (decimal 25) is GS10
 */
   int i;

   cur_data_mode = (U8) (sfdu_obj.ddp_to_data_mode() & 0xFF);

   memcpy(&cur_sclk.m16[0],  (sfdu_obj.get_sclk()).m16, 2);
   memcpy(&cur_sclk.m60[0],  (sfdu_obj.get_sclk()).m60, 2);
   memcpy(&cur_sclk.ln_cnt[0],  (sfdu_obj.get_sclk()).ln_cnt, 2);
	if (debug_on == 3) {
		printf ("vgr_edr::fill_cur_stat_tbl:  cur_sclk.m16[0,1] = %x %x  cur_sclk.m60[0,1] = %x %x  cur_sclk.ln_cnt[0,1] = %x %x\n",
			cur_sclk.m16[0],cur_sclk.m16[1],cur_sclk.m60[0],cur_sclk.m60[1],cur_sclk.ln_cnt[0],cur_sclk.ln_cnt[1]);
	}
/*   go thru sfdu_edr_hdr_map and extract 
 *      MAX_LAST_STAT = 2
 * 	item_3_SCID, item_7_SCPB_FLG
*/
   for (i = 0; i < MAX_LAST_STAT; i++)
   {
	if (debug_on == 3)  {
		printf ("vgr_edr::fill_cur_stat_tbl - memcpy into cur_stat_tbl\n");
		printf ("        i=%d   last_stat_items[i] = %d\n",i,last_stat_items[i]);
	}
    memcpy (&vgr_edr::cur_stat_tbl[i],  
		sfdu_obj.get_field_by_hdrmap(last_stat_items[i]),
             	sizeof( vgr_edr::last_stat_tbl[i]));
	if (debug_on == 3) {
		printf("vgr_edr::fill_cur_stat_tbl i=%d cur_stat_tbl[i] = %d\n",i,cur_stat_tbl[i]);
		printf("vgr_edr::fill_cur_stat_tbl sizeof( vgr_edr::last_stat_tbl[i])) = %d\n",sizeof( vgr_edr::last_stat_tbl[i]));
	}
   }
}

/*****************************************************************************/
void vgr_edr::fill_last_stat_tbl(vgr_sfdu& sfoc_data)
{
/*  * data_mode is from 618-306_Rev. D, CHG 5 Voyager Experiment Data Record Format
 *  Table C-1 Standard Experiment Data Record Header
 *  Item 5, word 2, bits 15-8, HEX 18 (decimal 24) is CR5A
 *                             HEX 1D (decimal 29) is UV5A
 *			       HEX 19 (decimal 25) is GS10
 *
*/
	if (debug_on == 2) {
   		printf ("last_stat_tbl sizeof = %d\n", 
 			sizeof( vgr_edr::last_stat_tbl[0]));
        }
  int i;

  last_data_mode = cur_data_mode;
                if (debug_on == 2) {
                        printf ("last_data_mode = %02x \n",last_data_mode);
 		}

  for (i = 0; i < MAX_LAST_STAT; i++)
  {   
		 if (debug_on == 2) {
 			 printf("getfield: %s \n", sfoc_data.get_field_by_hdrmap
 				 (last_stat_items[i]));
   		 }
    memcpy (&vgr_edr::last_stat_tbl[i],  sfoc_data.get_field_by_hdrmap(
             last_stat_items[i]), sizeof( vgr_edr::last_stat_tbl[i]));
  }
}
/*****************************************************************************/
int vgr_edr::data_mode_changed()
{
/*
 * data_mode is from 618-306_Rev. D, CHG 5 Voyager Experiment Data Record Format
 *  Table C-1 Standard Experiment Data Record Header
 *  Item 5, word 2, bits 15-8, HEX 18 (decimal 24) is CR5A
 *                             HEX 1D (decimal 29) is UV5A
 *                             HEX 19 (decimal 25) is GS10
 *
 */
  int status;

  status = FALSE;

  if (cur_data_mode != last_data_mode)
  {
// D-26
   if (debug_on == 1) {
       printf("vgr_edr::data_mode_changed:   ### data mode changed from %02x to %02x \n",
             last_data_mode, cur_data_mode);
   }

     status = TRUE;
  }
  return (status);

}

/*****************************************************************************/
int vgr_edr::last_stat_tbl_changed()
{
  int i;
  int status;

  status = FALSE;

  for (i = 0; i < MAX_LAST_STAT; i++)
  {
   if (strncmp((char *)&vgr_edr::last_stat_tbl[i], 
               (char*)&vgr_edr::cur_stat_tbl[i],
               sizeof( vgr_edr::last_stat_tbl[i]))) {
// D-27
	if (debug_on == 1) {
      		printf("vgr_edr::last_stat_tbl: ### item id = %d changed \n", last_stat_items[i]);
	}

      status = TRUE;
   }
  }
  return (status);
}
/*****************************************************************************/
int vgr_edr::sclk_regression ( SFOC_SCLK_TIME cur_sclk)
{
    if (strncmp((char*)&cur_sclk,(char*)&vgr_edr::last_sclk,
        sizeof(vgr_edr::last_sclk)) < 0)
    {
// D-28
	if (debug_on == 1) {
            printf("vgr_edr::sclk regression: last_sclk = %x, cur_sclk = %x",
	        last_sclk, cur_sclk);
	}

        return (TRUE); 
    }
    else
        return (FALSE);
}
/*****************************************************************************/
int vgr_edr::update_format_id( vgr_sfdu& sfdu_obj)
{ 
  	U16 	      ln_count;
	U8	      eng_fid;      //engineering format id - word 34 in std edr header
	U8	      tmp_fid1, tmp_fid2;
	U8*	      src_ptr;

/* data_mode is from 618-306_Rev. D, CHG 5 Voyager Experiment Data Record Format
 *  Table C-1 Standard Experiment Data Record Header
 *  Item 5, word 2, bits 15-8, HEX 18 (decimal 24) is CR5A
 *                             HEX 1D (decimal 29) is UV5A
 *                             HEX 19 (decimal 25) is GS10
 *  Item 34, word 10, bits 7-0, bits 7&6   format type
 *				bits 5&4   Engineering data rate (bps)
 *				bits 3,2,1 Engineering data mode  6=CCS memory readout, 7=FDS memory readout
 *				bit 0      S/C ID
 */
  	int type;
  	type = data_mode_index();
	


	ln_count = C16_TO_U16(cur_sclk.ln_cnt); //?  using science edr hdr

//	if (instr_no == ENG && ln_count == 1)
	if (ln_count == 1)
	{
            src_ptr = sfdu_obj.get_data_ptr();
            src_ptr =  src_ptr + (int)(subhdr_info[type][ENG].sfdu_offset);


	    if (src_ptr != NULL)
	    {
	       memcpy (&eng_fid,  src_ptr + 4, 1); 
	       tmp_fid1 = fid & 0x3e;		// compare bit rate and 
	       tmp_fid2 = eng_fid  & 0x3e;      // data type
	      
	       if (tmp_fid1 != tmp_fid2)
	       {
// D-29
		if (debug_on == 1) {
			printf ("vgr_edr::update_format_id:  FORMAT ID changed !! \n");
		}

		   fid &= 0xc1; //11000001  to erase bit rate, datatype
		   fid |= (eng_fid & 0x3e);
		   return (TRUE);
	       }
	    } 
	    else 
	 	printf("vgr_edr::update_format_id:  ERROR::ENG data, LN_CNT 1 with no data block!! ");
	    
	         
	}
	return (FALSE);
}

/*****************************************************************************/
void vgr_edr::init_format_id(vgr_sfdu& sfdu_obj )
{
        fid = 0x02;             // 00000011  - datatype is cruise

        if (sc_id > 0)
           fid |= 0x01;         // scid is 31 or 32

        update_format_id(sfdu_obj);
}

/*****************************************************************************/

int get_edr_hdr_maps_index(int def_item_id)
{
/*  go thru item list in edr_hdr_maps and get which new item number is needed */
/*  if not found then return 0						*/
   int i;

	for (i=0; edr_hdr_maps[i].item_id < ITEM_99; i++)
        {
	  if  (edr_hdr_maps[i].item_id != def_item_id)
	      return (i);
	}
	return (FAIL);
}

/*****************************************************************************/
int vgr_edr::add_bit_error_cnt(int bit_err_cnt)
{
	this->estimated_bit_err_cnt =+ bit_err_cnt;
	return (estimated_bit_err_cnt);
}

/*****************************************************************************/
void vgr_edr::set_dqi_dqsw(vgr_sfdu& sfdu_obj, int MF_no, 
                           U8* dqi_dqsw)
{
      
  unsigned char  dqi_mask=0x1b;
  int            offset; 
  U8             pn_err, bet;
  int		 tmp_MF;

/* data_mode is from 618-306_Rev. D, CHG 5 Voyager Experiment Data Record Format
 *  Table C-1 Standard Experiment Data Record Header
 *  Item 5, word 2, bits 15-8, HEX 18 (decimal 24) is CR5A
 *                             HEX 1D (decimal 29) is UV5A
 *                             HEX 19 (decimal 25) is GS10
 */
  int 		 type;
  type = data_mode_index();

  tmp_MF = (int) fmod(MF_no - 1,  instr_info[type][instr_no].mfs_per_seg );
  if (tmp_MF <= 75) {

  	offset = tmp_MF / 8 * 2 ;

  	dqi_dqsw[offset] |= sfdu_obj.get_dqsw_status();
  	pn_err = (sfdu_obj.get_field_by_hdrmap(item_48_PN_ERR))->buf[0];
  	bet    = (sfdu_obj.get_field_by_hdrmap(item_35_BET))->buf[0];
  
  	if (pn_err > bet) 
     		dqi_dqsw[offset + 1] |= 0x10;

  	if (pn_err > 0 && pn_err < bet)
     		dqi_dqsw[offset + 1] |= 0x08;

  	if ((sfdu_obj.get_field_by_hdrmap(item_49_DATA_FLG))->buf[0] > 0)
     		dqi_dqsw[offset + 1] |= 0x02;

  	if ((sfdu_obj.get_field_by_hdrmap(item_50_GCF_ERR))->buf[0] > 0)
     		dqi_dqsw[offset + 1] |= 0x01;

		if (debug_on == 2)
 			{
			printf (" item_50_GCF == %02x  dqi_dqsw =%02x \n",
  			    (sfdu_obj.get_field_by_hdrmap(item_50_GCF_ERR))->buf[0], dqi_dqsw[offset + 1] ); 
	  		printf(":::instr=%d MF=%d offset=%d dqsw=%x dqi=%x\n",
  				instr_no, MF_no, offset, dqi_dqsw[offset], dqi_dqsw[offset+1]);
//  			fflush(stdout);
  			} 
  }
}
/*****************************************************************************/
void vgr_edr::store_last_sclk(SFOC_SCLK_TIME sfdu_sclk)
{
int i;
 memcpy(&last_sclk.m16[0],  &sfdu_sclk.m16[0], 2);
 memcpy(&last_sclk.m60[0],  &sfdu_sclk.m60[0], 2);
 memcpy(&last_sclk.ln_cnt[0],  &sfdu_sclk.ln_cnt[0], 2);
			if (debug_on == 2) 
			{
			i = strncmp((char* )&last_sclk.m16[0], (char *)&sfdu_sclk.m16[0], 6);
			printf ("vgr_edr::store_last_sclk: cur_sclk.m16=%0x %0x last_sclk.m16=%0x %0x comp=%d\n",
			cur_sclk.m16[0],cur_sclk.m16[1], last_sclk.m16[0],last_sclk.m16[0], i);
			}
//   vgr_edr::last_sclk = sfdu_sclk;              
}
/*****************************************************************************/

/*

   item_16_EERT_HR
   item_17_EERT_SEC
   item_18_EERT_MSEC
   item_19_EERT_YR
// need test the first mf
   memcpy (&sclk_buf[0], sfoc_time.m16, 2);
   sclk_buf[2] = sfoc_time.m60[1] & 0xFF; 
   memcpy (&sclk_buf[3], sfoc_time.ln_cnt, 2); 
*/
/*****************************************************************************/

/*****************************************************************************/
int vgr_edr::get_MF_no (int data_mod, SFOC_SCLK_TIME sfoc_time)
{
/* get minor frame number 
 *typedef struct vgr_time_struc{
 *       U8 m16[2];
 *       U8 m60[2];
 *       U8 ln_cnt[2];
 *} SFOC_SCLK_TIME;
 *  data_mod is CR_5A (18x = 24)  -  UV_5A (1Dx = 29) - GS_10 (18x = 25)
 */
   int MF;
// D-30
   	if (debug_on == 1) {
		printf ("vgr_edr::get_MF_no: data_mode = %d\n",data_mod);
        }

   switch (data_mod) {
	case CR_5A: case UV_5A: 
   		if (fmod(C16_TO_U16(sfoc_time.ln_cnt), 160) == 1)
   		{
      		  MF = (C16_TO_U16(sfoc_time.ln_cnt ) /160 + 1) + 
                       (C16_TO_U16(sfoc_time.m60) *5);
      		  return (MF);
   		}
		break;
	case GS_10:
		return(FAIL);
//		break;
	default:
		break;
    }
    printf ("vgr_edr::get_MF_no: Cann't convert to right Minor Frame number !! \n");
    return (FAIL);

}
 
/*****************************************************************************/
U8 vgr_edr::get_seg_no (int MF, U16 m16, U16 m60)
{
   int seg_no;

   int type;
/* 
 * data_mode is from 618-306_Rev. D, CHG 5 Voyager Experiment Data Record Format
 *  Table C-1 Standard Experiment Data Record Header
 *  Item 5, word 2, bits 15-8, HEX 18 (decimal 24) is CR5A
 *                             HEX 1D (decimal 29) is UV5A
 *                             HEX 19 (decimal 25) is GS10
 *
 * instr_no: crs=0, lecp=1, pls=2, pra=3, pws=4, uvs=5, eng=6, mag=7
*/
   type = data_mode_index();		//0=CR_5A 1=other(UV_5A)   vgr_edr.H
// D-31
	if (debug_on == 1) { 
		printf ("vgr_edr::get_seg_no:  MF = %d m16 = %d m60 = %d\n",MF,m16,m60);
	}

   switch (instr_no)
   {
     case  PRA:
		{
      		if (!fmod(m16, 2))       //if !fmod then = 0
           	   seg_no = (MF + instr_info[type][instr_no].mfs_per_seg -1)
			    /instr_info[type][instr_no].mfs_per_seg;
     	 	else
         	   seg_no = (MF+ 20 + instr_info[type][instr_no].mfs_per_seg -1)
			    /instr_info[type][instr_no].mfs_per_seg + 7;
   		}
 		break;

     case  UVS:
		  if (cur_data_mode == UV_5A)
		  {
		     if ( fmod( m60, 2) == 0) 
		     {
		        seg_no = 1;
		     }
		     else 
	 	        seg_no = 2; 

		     break;
		  }
		  else 
		  {
	           seg_no = (MF + instr_info[type][instr_no].mfs_per_seg -1) /
                   instr_info[type][instr_no].mfs_per_seg;
		   break;
		  }
		
     case  ENG:
		  seg_no = 1;
	  	  break; 
      
     default: 
		{
		seg_no = (MF + instr_info[type][instr_no].mfs_per_seg -1) / 
                  	instr_info[type][instr_no].mfs_per_seg;
		}
		break;
   }
  
   if (debug_on == 2) {
		if (instr_no==UVS ) { 
			printf ("UVS::: cur_data_mode = %d   ",cur_data_mode);
                       	printf ("instr_no=%d seg_no=%d MF=%d mfs_per_seg=%d \n", 
				instr_no, seg_no, MF,
	                       	instr_info[type][instr_no].mfs_per_seg);
		}
  }
   return (seg_no & 0xFF); //?????
}
/*****************************************************************************/
//void vgr_edr::store_hdrs_of_first_MF(vgr_sfdu& sfdu_obj, vgr_scet& scet_co)
void vgr_edr::store_hdrs_of_first_MF(vgr_sfdu& sfdu_obj)
{
/* get values from sfdu HDR and transfer to EDR
// use sfdu_obj.(get_item) from sfdu and copy to EDR header 
// with copy_to_hdr
 tmp_sc_id              edr hdr word 1 - bits 8-4 	byte 3
 tmp_eng_flg            edr hdr word 2 - bits 8-7	byte 7
 scet_flag	`	edr hdr word 8 - bits 8-4       byte 17
 reed_golay		edr hdr word 3 - bits 5-4	byte 9
 bit_rate               edr hdr word 10 - bits 16-8     byte 20
 data_source		edr hdr word 4 - bits 7-6       byte 9
 efec_bit_rate		edr hdr word 10 - bits 15-8     byte
 fid                    edr hdr word 10 - bits 8-0      byte
 cur_data_mode          edr hdr word 2 - bits 16-8	byte   
 scet  (store_scet)	edr hdr word 7 - bits 31-0, word 8 bits 31-8  - bytes 17-20
 ert   (store_ert)      edr hdr word 5 - bits 31-0, word 6 bits 31-8  - bytes 13-16
*/
  U8 tmp_sc_id;						//edr hdr word 1 - bits 8-4

  U8 tmp_eng_flg ;					//edr hdr word 1 - bits 8-7 ?
	
  U8 scet_flag = 0xf0;		

  U8 reed_golay = sfdu_obj.get_reed_golay(); 		//edr hdr word 4 - bits 5-4

  U8 bit_rate = sfdu_obj.get_bit_rate_index();		 

  U8 data_src = sfdu_obj.get_data_source_status();	//edr hdr word 4 - bits 7-6

  U8 efec_bit_rate ;					//edr hdr word 10 - bits 16-8

  if (instr_no == ENG)  
	efec_bit_rate = 0x01;
  else 
	efec_bit_rate = bit_rate;			//edr hdr word 20 - bits 15-8

//
// extract sfdu values
  extract_hdr(edr_hdr_maps, EDRHDR_ITEMS_PART1, sfdu_obj);
  memcpy (&sc_id, (sfdu_obj.get_field_by_hdrmap(item_3_SCID))->buf, 1);
  tmp_sc_id  = sc_id << 4;
  copy_to_hdr(&tmp_sc_id, sizeof(tmp_sc_id), item_3_SCID);
	/* change debug_on to 2 on 11-18-2021 */
// D-32
  if (debug_on == 1) { 
	printf ("vgr_edr::store_hdrs_of_first_MF: ITEM_3_SCID    tmp_sc_id = %d\n",tmp_sc_id);
  }

//  init_format_id ();
  copy_to_hdr(&data_src, sizeof(data_src), item_13_SOURCE);
  if (debug_on == 2) {
	printf ("vgr_edr::store_hdrs_of_first_MF: ITEM_13_SOURCE data_src = %d (%X)\n",data_src,data_src);
  }
  if (instr_no != ENG) 
     copy_to_hdr(&reed_golay, sizeof(reed_golay), item_14_GOLAY);
  if (debug_on == 2)  {
  	printf ("vgr_edr::store_hdrs_of_first_MF: ITEM_13_SOURCE data_src = %d (%X)\n",data_src,data_src);
  }
  if (instr_no == ENG) 
  {
     copy_to_hdr(&fid, sizeof(fid), item_34_FMT_ID);
	if (debug_on == 2) {
	 	printf ("vgr_edr::store_hdrs_of_first_MF: ITEM_34_FMT_ID fid = %d (%X)\n",fid,fid);
        }
     tmp_eng_flg = 0xc0;
     copy_to_hdr(&tmp_eng_flg, sizeof(tmp_eng_flg), item_6_ENG_FLG);
	if (debug_on == 2)  {
		 printf ("vgr_edr::store_hdrs_of_first_MF: ITEM_6_ENG_FLG tmp_eng_flg = %d (%X)\n",tmp_eng_flg,tmp_eng_flg);
	}
  }

  copy_to_hdr(&cur_data_mode, sizeof(cur_data_mode), item_5_DT_MODE);
  if (debug_on == 2) { 
	 printf ("vgr_edr::store_hdrs_of_first_MF: ITEM_5_DT_MODE cur_data_mode = %d (%X)\n",cur_data_mode,cur_data_mode);
  }
  copy_to_hdr(&bit_rate, sizeof(bit_rate), item_32_BIT_RATE);
  if (debug_on == 2) {
   	printf ("vgr_edr::store_hdrs_of_first_MF: ITEM_32_BIT_RATE bit_rate = %d (%X)\n",bit_rate,bit_rate);
  }
  copy_to_hdr(&efec_bit_rate, sizeof(efec_bit_rate), item_33_EF_BRATE);
  if (debug_on == 2) {
   	printf ("vgr_edr::store_hdrs_of_first_MF: ITEM_33_EF_BRATE efec_bit_rate = %d (%X)\n",efec_bit_rate,efec_bit_rate);
  }
  copy_to_hdr(&scet_flag, sizeof(scet_flag), item_25_SCET_FLG);
  if (debug_on == 2)  {
	      printf ("vgr_edr::store_hdrs_of_first_MF: ITEM_25_SCET_FLG scet_flag = %d (%X)\n",scet_flag,scet_flag);
  }
  store_scet();        

  get_store_ert( sfdu_obj.get_ert());
	if (debug_on == 2) { 
	   printf ("vgr_edr::store_hdrs_of_first_MF: ert = \n");
        }
	
}


/*****************************************************************************/

//void vgr_edr::store_scet(vgr_scet& scet_co)
void vgr_edr::store_scet()
{ 
  VGR_SCET  tmp_scet;
/*  Following is from get_scet 
  U32      msec_of_day;
  U8       u8_msec[4];
 

  double    sclk_dbl, scet_dbl;
  char      buff[40];
  int       year, day, hour, min, sec, msec;

  sclk_dbl = (double)(C16_TO_U16(cur_sclk.m16)) +
                (((double)(C16_TO_U16(cur_sclk.m60)) +
                (double)(C16_TO_U16(cur_sclk.ln_cnt) -1)/800.0)/60.0);

  sclktoscet( sclk_dbl, &scet_dbl, 0.0); 
			if (debug_on == 2)
			{
                        printf(" BEFOREscet_dbl= %lf \n",scet_dbl);
                        printf("SCET: %30s \n",buff);
			}


  seconds_to_ascii_time(scet_dbl, 0, buff); 
  sscanf(buff, "%04d-%03dT%02d:%02d:%06d.%03d",&year,&day,&hour,&min,&sec,&msec); 
			if (debug_on == 2) 
			{
  			printf("scet_dbl= %lf \n",scet_dbl);
  			printf("SCET: %30s \n",buff);
		printf("SCET:  yr=%d  day=%d hour=%d  min=%d   sec=%d  msec=%d \n",
       			year, day, hour, min, sec, msec);
			}
  
  hour += day * 24;
  sec  += min * 60;
  
  I16_TO_C16(tmp_scet.hr, hour);
  I16_TO_C16(tmp_scet.sec, sec);
  I16_TO_C16(tmp_scet.msec, msec);
  tmp_scet.yr = (int) (fmod(year, 100)) & 0xFF;

//return provides tmp_scet structure //
*/
	
  get_scet(tmp_scet); 
	if (debug_on == 3) {
	    printf ("vgr_edr::store_scet:  after get_scet\n");
	    printf ("      tmp_scet.hr[0] = %x  tmp_scet.sec[0] = %x tmp_scet.msec[0] = %x, scet.yr = %x\n",
		tmp_scet.hr[0], tmp_scet.sec[0],tmp_scet.msec[0], tmp_scet.yr);
            printf ("      tmp_scet.hr[1] = %x  tmp_scet.sec[1] = %x tmp_scet.msec[1] = %x, scet.yr = %x\n",
                tmp_scet.hr[1], tmp_scet.sec[1],tmp_scet.msec[1], tmp_scet.yr);
       }
  overwrite_byte_to_hdr(&tmp_scet.hr[0], 2, item_21_SCET_HR); 		//edr hdr word 7 bits 31-16 - byte 24,25
  overwrite_byte_to_hdr(&tmp_scet.sec[0], 2, item_22_SCET_SEC);		//edr hdr word 7 bits 15-0  - byte 26,27
  overwrite_byte_to_hdr(&tmp_scet.msec[0], 2, item_23_SCET_MSEC);	//edr hdr word 8 bits 31-16 - byte 28,29
  overwrite_byte_to_hdr(&tmp_scet.yr, 1, item_24_SCET_YR);		//edr hdr word 8 bits 15-8  - byte 30
/*
  if (instr_no == MAG || instr_no == PLS)
  {
    msec_of_day = hour * 60 *1000 + sec * 1000 + msec;
    U32_TO_C32(u8_msec, msec_of_day);
    subhdr_bit_copy(sub_hdr_ptr + 24,
                    u8_msec,
                    0,
                    32 );
			if (debug_on == 2)
                    printf("PLS:: u8_msec=[%02x %02x %02x %02x ]",
                    u8_msec[0],u8_msec[1],u8_msec[2],u8_msec[3]);
  }
*/

//  			if (debug_on == 2) {
//			printf("tmp: %x %x \n", tmp_scet.hr, tmp_scet.sec);
//			printf("tmp_scet: %x %x %x %x %x %x %x \n",
//			tmp_scet.hr[0], tmp_scet.hr[1],
//			tmp_scet.sec[0], tmp_scet.sec[1],
//			tmp_scet.msec[0], tmp_scet.msec[1],
//			tmp_scet.yr);
//  			debug_print("after ", &hdr[24],6);
//			}    
 }
/*****************************************************************************/

void vgr_edr::get_scet( VGR_SCET& tmp_scet, SFOC_SCLK_TIME new_sclk )
{
  double    sclk_dbl, scet_dbl;
  char      buff[40];
  int       year, day, hour, min, sec, msec;

  sclk_dbl = (double)(C16_TO_U16(new_sclk.m16)) +
                (((double)(C16_TO_U16(new_sclk.m60)) +
                (double)(C16_TO_U16(new_sclk.ln_cnt) -1)/800.0)/60.0);

	if (debug_on == 2) {
			printf("BEFORE:: sclk_dbl= %lf \n",sclk_dbl);
		printf("vgr_edr::get_scet:  new_sclk.m16 = %x new_sclk.m60 = %x new_sclk.ln_cnt = %x\n",
			new_sclk.m16[0],new_sclk.m60[0],new_sclk.ln_cnt[0]);
                printf("vgr_edr::get_scet:  new_sclk.m16 = %x new_sclk.m60 = %x new_sclk.ln_cnt = %x\n",
                        new_sclk.m16[1],new_sclk.m60[1],new_sclk.ln_cnt[1]);
		printf ("decimal:\n");
                printf("vgr_edr::get_scet:  new_sclk.m16 = %d new_sclk.m60 = %d new_sclk.ln_cnt = %d\n",
                        new_sclk.m16[0],new_sclk.m60[0],new_sclk.ln_cnt[0]);
                printf("vgr_edr::get_scet:  new_sclk.m16 = %d new_sclk.m60 = %d new_sclk.ln_cnt = %d\n",
                        new_sclk.m16[1],new_sclk.m60[1],new_sclk.ln_cnt[1]);

		printf ("           new_sclk.m16 = %d  new_sclk = %d   (%f)\n",
			new_sclk.m16[0]*256 + new_sclk.m16[1], new_sclk.m60[0]*256 + new_sclk.m60[1],
			(new_sclk.m60[0]+new_sclk.m60[1])/60.0); 
	}
  sclktoscet( sclk_dbl, &scet_dbl, 0.0);

  seconds_to_ascii_time(scet_dbl, 0, buff);
  sscanf(buff, "%04d-%03dT%02d:%02d:%06d.%03d",&year,&day,&hour,&min,&sec,&msec);

// D-33
                 if (debug_on == 1) {
                        printf("scet_dbl= %lf \n",scet_dbl);
                        printf("SCET: %30s \n",buff);
                        printf("SCET:  yr=%d  day=%d hour=%d  min=%d   sec=%d  msec=%d \n",
                            year, day, hour, min, sec, msec);
			printf ("HEX:\n");
			printf("SCET:  yr=%x  day=%x hour=%x  min=%x   sec=%x  msec=%x \n",
                            year, day, hour, min, sec, msec);
                  }

  cur_scet.doy = day;
  cur_scet.hour = hour;
  cur_scet.min  = min;
  cur_scet.sec  = sec;
  cur_scet.msec = msec;
  cur_scet.year = year;
 
  hour += day * 24;
  sec  += min * 60;

  I16_TO_C16(tmp_scet.hr, hour);
  I16_TO_C16(tmp_scet.sec, sec);
  I16_TO_C16(tmp_scet.msec, msec);
  tmp_scet.yr = (int) (fmod(year, 100)) & 0xFF;
}
/*****************************************************************************/
 SDR_TIME_DCL vgr_edr::get_store_ert(const SFOC_ERT_TIME& sfoc_ert)
{
    /* variable declarations */
    static  SDR_TIME_DCL    sdr_time;   /* converted sfoc ert or rct    */
    U16                     ds1958;
    U32                     msecs;
    U16                     days;       /* day counter                  */
    U16                     years;      /* year counter                 */

    U8      tmp_hr[2],
            tmp_sec[2],
            tmp_msec[2],
            tmp_yr;
   
    ds1958  =   C16_TO_U16(sfoc_ert.ds1958);
    msecs   =   C32_TO_U32(sfoc_ert.msec); 
    if (debug_on == 2)
    {
        printf("get_store_ert in dec::ds1958= %x %x, msec= %x %x %x %x \n",
            sfoc_ert.ds1958[0], sfoc_ert.ds1958[1],
            sfoc_ert.msec[0], sfoc_ert.msec[1],
            sfoc_ert.msec[2], sfoc_ert.msec[3]);

        printf(" get_store_ert::ds1958= %d, msecs = %d \n",
            ds1958, msecs);
    }
  
    /* calculate years since 1958 & days left in current year */

    //  given the "day of year" of 1958 and milliseconds of day,
    //  calculate the the current year, hour of year,
    //      seconds and milliseconds

    days    =   ds1958+1;
    years   =   1958;
    while (1)
    {
        int days_in_year;

        days_in_year = 365;
        if (
                (((years % 4) == 0) && ((years % 100) != 0)) ||
                ((years %400) == 0)
            )
        {
            //  adjust for leap year
            days_in_year = 366;
        }

        if (days > days_in_year)
        {
            days    =   days - days_in_year;
            years   =   years + 1;
        }
        else
        {
            break;
        }
    }

    /* calculate sdr time */

    //  keep last two digits of year
    sdr_time.year   =   years % 100;

    //  calculate hour of year
    sdr_time.hour = ((days ) * HOURS_PER_DAY) + (msecs / MSECS_PER_HOUR);

    //  calculate seconds
    sdr_time.sec    =   (msecs % MSECS_PER_HOUR) / 1000;

    //  and milliseconds
    sdr_time.msec   =   msecs % 1000;

#if 0
//  change previous line to "#if 1" to compile this debug statement
    printf
    (
        " ERT:: days= %d  yr= %d hr= %d sec= %d msec= %d \n",
        days,
        sdr_time.year,
        sdr_time.hour,
        sdr_time.sec,
        sdr_time.msec
    );
#endif

    tmp_yr                   =  sdr_time.year;
    U16_TO_C16(&tmp_sec[0],     sdr_time.sec);
    U16_TO_C16(&tmp_msec[0],    sdr_time.msec);
    U16_TO_C16(&tmp_hr[0],      sdr_time.hour); 

    cur_ert.hour    =   sdr_time.hour;
    cur_ert.sec     =   sdr_time.sec;
    cur_ert.msec    =   sdr_time.msec;
    cur_ert.year    =   sdr_time.year;

    if (first_rec == TRUE) {

	beg_ert_day = cur_ert.hour/24;
//	printf ("beg_ert_day = %d\n",beg_ert_day);
//	first_rec = FALSE;

    }
    end_ert_day = cur_ert.hour/24; 
    if (first_MF) {
        overwrite_byte_to_hdr(tmp_hr, sizeof(tmp_hr), 
                item_9_SERT_HR);					//edr hdr word 3 bits 31-16 - bytes 5,6
        overwrite_byte_to_hdr(tmp_sec, sizeof(tmp_sec), 
                                item_10_SERT_SEC);			//edr hdr_word 3 bits 15-0  = bytes 7,8
        overwrite_byte_to_hdr(tmp_msec, sizeof(tmp_msec), 
                                item_11_SERT_MSEC);			//edr hdr word 4 bits 31-16 = bytes 9,10
        overwrite_byte_to_hdr(&tmp_yr, sizeof(tmp_yr), 
                                item_12_SERT_YR);			//edr hdr word 4 bits 15-8 = bytes 11
    }
    else {
        overwrite_byte_to_hdr(tmp_hr, sizeof(tmp_hr),                
                                item_16_EERT_HR);			//edr hdr word 5 bits 31-16 - bytes 13,14
        overwrite_byte_to_hdr(tmp_sec, sizeof(tmp_sec),
                item_17_EERT_SEC);					//edr hdr word 5 bits 15-0  - byes 15,16
        overwrite_byte_to_hdr(tmp_msec, sizeof(tmp_msec),           
                                item_18_EERT_MSEC);			//edr_hdr_word 6 bits 31-16 - bytes 17,18
        overwrite_byte_to_hdr(&tmp_yr, sizeof(tmp_yr),               
                                item_19_EERT_YR);			//edr hdr word 6 bits 15-8  - bytes 19
    }
	if (debug_on == 3 ) {
		printf ("vgr_edr::get_store_ert: hr,sec,msec,yr  (%d,%d,%d,%d)\n",cur_ert.hour,cur_ert.sec,cur_ert.msec,cur_ert.year);
	}
    /* return pointer to sdr time */
    return(sdr_time);
} 

/*****************************************************************************/
void vgr_edr::reset_edr_rec(void)
{
/* data_mode is from 618-306_Rev. D, CHG 5 Voyager Experiment Data Record Format
 *  Table C-1 Standard Experiment Data Record Header
 *  Item 5, word 2, bits 15-8, HEX 18 (decimal 24) is CR5A
 *                             HEX 1D (decimal 29) is UV5A
 *                             HEX 19 (decimal 25) is GS10
 */
  int            type;
  int 		 dp_len;
  int		 i;

     type = data_mode_index();

     dp_len = instr_info[type][instr_no].mfs_per_seg / 2;

     if (instr_no == ENG)  dp_len /= ENG_MF_PARTS;

     memset (hdr+4, 0, EDR_HDR_LEN - 8);

     if (instr_no == ENG)
     {
	for (i = 0; i < 60; i++)
	{
	    hdr[DATA_PRESENCE_LOC + i * 2] = 0xff;
	    hdr[DATA_PRESENCE_LOC + i * 2 + 1] = 0x00;
	}
     }
     else
     {
     	memset (hdr+DATA_PRESENCE_LOC, 0xff, dp_len);
     	if (fmod(instr_info[type][instr_no].mfs_per_seg, 2) > 0) 
     	{
            hdr[DATA_PRESENCE_LOC+dp_len] |= 0xf0;
     	}
     }
     if (last_data_mode != cur_data_mode)
     {
         allocate_data_buf();
     }
     else { 
//fill with 0
     	if (sub_hdr_len > 0 && sub_hdr_ptr != NULL)
        	memset (sub_hdr_ptr, 0, sub_hdr_len);
     	if (data_len > 0 && data_ptr != NULL)
        	memset (data_ptr, 0, data_len);
     }
}

/*****************************************************************************/
void vgr_edr::allocate_data_buf()
{
/* data_mode is from 618-306_Rev. D, CHG 5 Voyager Experiment Data Record Format
 *  Table C-1 Standard Experiment Data Record Header
 *  Item 5, word 2, bits 15-8, HEX 18 (decimal 24) is CR5A
 *                             HEX 1D (decimal 29) is UV5A
 *                             HEX 19 (decimal 25) is GS10
 */
   int type;

   type = data_mode_index();

   if (data_ptr != NULL)
      delete[] data_ptr;
   if (sub_hdr_ptr != NULL)
      delete[] sub_hdr_ptr;

   if (instr_no == UVS && cur_data_mode == CR_5A)
   {
      data_len = (instr_info[type][instr_no].mfs_per_seg - 5) *
	         instr_info[type][instr_no].mf_size;
   }
   else
   {
   data_len = instr_info[type][instr_no].mf_size * 
              instr_info[type][instr_no].mfs_per_seg ;
   }
	if (debug_on == 3) { 
		printf("vgr_edr::allocate_data_buf: (before) data_ptr = %x   data_len = %d\n",data_ptr,data_len);
	}
   data_ptr = new  unsigned char[data_len];
   sub_hdr_len = instr_info[type][instr_no].sub_hdr_size;
   sub_hdr_ptr = new unsigned char[sub_hdr_len];
	if (debug_on == 3) {
		printf("vgr_edr::allocate_data_buf: data_ptr = %x\n",data_ptr);	
		printf("vgr_edr::allocate_data_buf: sub_hdr_ptr = %x\n",sub_hdr_ptr);
	}

   if ( data_ptr != NULL && sub_hdr_ptr != NULL) 
   {
        if (sub_hdr_len > 0 && sub_hdr_ptr != NULL)
                memset (sub_hdr_ptr, 0, sub_hdr_len);
        if (data_len > 0 && data_ptr != NULL)
                memset (data_ptr, 0, data_len);
   }

   if ( data_ptr == NULL || sub_hdr_ptr == NULL)
   {
      printf("vgr_edr::allocate_data_buf:  cann't allocate data buffer !!!");
      exit(0); 
   }
//			if (debug_on == 2) 
//			{
//			printf(" *** ");
//printf("instr=%d  data_ptr=%d  data_len=%d  sub_hdr_ptr=%d  sub_hdr_len=%d \n",
//			 instr_no, data_ptr,data_len, sub_hdr_ptr, sub_hdr_len);
//			}

}
/*****************************************************************************/
void vgr_edr::write_edr_rec(int FINAL, int print_decom, int record_processed)
{
   int status, i, ii;
   unsigned short int *ctar_ptr;  //for CRS data 
   char instr_char[5]; 
   phy_rec_no ++;
   
   U16_TO_C16(&hdr[4], phy_rec_no);

// D-34
		if (debug_on == 1) 
			{
                        printf("vgr_edr::write_edr_rec: ENTRY   instr_no = %d\n",instr_no);
                        printf("   crs=0, lecp=1, pls=2, pra=3, pws=4, uvs=5, eng=6, mag=7\n");
                        printf(">>> phy_rec_no=%d  hdr_ptr = %x hdrlen=%d  hdr[3]=%x  hdr[5]=%x out_fd=%x \n",
                                 phy_rec_no, hdr, EDR_HDR_LEN, hdr[3], hdr[5], out_fd[instr_no]);
                        printf(">>> sub_hdr_ptr = %x  sub_hdr_len= %d  data_ptr=%x data_len=%d \n",
                              sub_hdr_ptr, sub_hdr_len, data_ptr, data_len);
		}

//			fflush(stdout);
                if (debug_on == 2) {
                        for (i=0; i < EDR_HDR_LEN; i++)
                        {  printf(" %x ", hdr[i]);
                        }
                        printf ("\n\n");
                        fflush(stdout);
                }

//if (instr_no == ENG)
// D-35
if (debug_on == 1) {
	printf("vgr_edr::write_edr_rec:  ENTRY2 instr_no = %d   FINAL = %d \n", instr_no,FINAL);
}

/*   if (instr_no == ENG && FINAL  && first_DECOM)    // test 11-18-2021 //
 *   This test gives only a starting DECOM file and all rest Data records 
 *   The other call read_write_decom in store_or_write_MFS doesnt run
 *
 *   11-19-2021 changing to != ENG && FINAL gives:
 *   Number of data records   = 5149
 *   Number of Header records = 1
 *   Number of Engineering records = 0
 *   Number of Decomutation records = 1 
 *   
 */

// if (instr_no == ENG && FINAL )      /* do only if engineering data and WEEKLY datafile */ 
   if (instr_no == ENG) 
   {
      if (FINAL) { 
// D-36
        if (debug_on == 1 || debug_on == 10) { 
        	printf ("**  DO for instrument ENG if WEEKLY (FINAL)\n");
	}

        /* only do dcom if 1st record */
     	if (first_DECOM) {   /* I think this was added by me */ 
    	  if (print_decom) 
	    {  
		// print decom header
		printf ("******************** ENG && FINAL: writing decom record\n");
		printf ("vgr_edr::write_edr_rec:  before read_write_decom(instr_n==%d)\n",instr_no);
	       read_write_decom(instr_no);
//	       read_write_decom(out_fd[i]);
	    }

//		if (debug_on == 2)
//		{
// 	    	printf("*****write eng ");
//		}
	    first_DECOM = FALSE;   /* I think this was added by me */
       }   //FIRST_DECOM


        eng_rec_no++;
// D-37
	if (debug_on == 1 || debug_on == 10) {
		printf ("** instr_no:  CRS=0, LECP=1, PLS=2, PRA=3, PWS=4, UVS=5, ENG=6, MAG=7\n");
	}

	for (i = 0; i < MAX_INSTR_NUM ; i++)
	{
// D-38
		if (debug_on == 1)  {
			printf ("vgr_edr::write_edr_rec: HEADER = 240 Bytes\n");
			printf (">>>>>>>>>>>>>>>>>>>>>> FWRITE header (%d bytes) into out_fd[%d]\n",EDR_HDR_LEN,instr_no); 
		}
//
//#	    printf (">>>>>>>>ENG & FINAL >>>>> FWRITE header (%d bytes) into out_fd[%d]\n",EDR_HDR_LEN,instr_no);	
	    status =  fwrite(hdr, EDR_HDR_LEN, 1, out_fd[i]);
	    if (status <= FALSE)
      		printf ("vgr_edr::write_edr_rec:  instr_no = %d  write hdr error !",instr_no);

    	    if (sub_hdr_len > 0 && sub_hdr_ptr != NULL) {
		if (debug_on == 2) {
			printf ("(1)  vgr_edr::write_edr_rec: sub_hdr_ptr instr_no = %d\n",instr_no);
			for (ii=0;ii<sub_hdr_len;ii++) {
				printf ("    %02x ",sub_hdr_ptr[ii]);
			}
			printf ("\n\n");
 		}
// D-39
		if (debug_on == 1) {
			printf (">>>>>>ENG & FINAL>>>>> FWRITE sub_header (%d bytes) into out_fd[%d]\n",sub_hdr_len,instr_no);
		}
//
      		status=fwrite(sub_hdr_ptr, sub_hdr_len, 1, out_fd[i]);
	    }
	    if (status <= FALSE) {
      		printf("vgr_edr::write_edr_rec:  instr_no = %d  write sub_hdr error !",instr_no);
	    }
// 5-6-2021 - Ray Bambery -fixed for CRS format- instrument 0
//		see vgr_edr::copy_MF_data_block 
//
   	    if (data_len > 0 && data_ptr != NULL) {
		if (i == 0) {
			ctar_ptr = (U16*)data_ptr;
// D-40
			if (debug_on == 1 || debug_on == 10) {
                                if (instr_no == 0) {strcpy(instr_char,"CRS");}
                                if (instr_no == 1) {strcpy(instr_char,"LECP");}
                                if (instr_no == 2) {strcpy(instr_char,"PLS");}
                                if (instr_no == 3) {strcpy(instr_char,"PRA");}
                                if (instr_no == 4) {strcpy(instr_char,"PWS");}
                                if (instr_no == 5) {strcpy(instr_char,"UVS");}
                                if (instr_no == 6) {strcpy(instr_char,"ENG");}
                                if (instr_no == 7) {strcpy(instr_char,"MAG");}

				printf (">>>>>>>ENG & FINAL >>> FWRITE data [ctar_ptr] (%d bytes) into out_fd[%d]\n",data_len,instr_no);
				printf ("0===>>> %d    %d     %s     %d  <<<===\n",phy_rec_no,instr_no,instr_char,record_processed);
			}
//
			status = fwrite (ctar_ptr, data_len ,1, out_fd[i]);
			if (debug_on == 2) {
				printf ("vgr_edr::write_edr_rec:  ctar_ptr = %x\n",ctar_ptr);
			}
		} else {
/*  04-08-2022 - following not necessary - deleted
			printf ("i = %d  instr_no = %d\n",i,instr_no);
// D-41
			if (debug_on == 1 || debug_on == 10) {
                                if (instr_no == 0) {strcpy(instr_char,"CRS");}
                                if (instr_no == 1) {strcpy(instr_char,"LECP");}
                                if (instr_no == 2) {strcpy(instr_char,"PLS");}
                                if (instr_no == 3) {strcpy(instr_char,"PRA");}
                                if (instr_no == 4) {strcpy(instr_char,"PWS");}
                                if (instr_no == 5) {strcpy(instr_char,"UVS");}
                                if (instr_no == 6) {strcpy(instr_char,"ENG");}
                                if (instr_no == 7) {strcpy(instr_char,"MAG");}

				printf (">>>>>>ENG & FINAL>>>>> FWRITE data [data_ptr] (%d bytes)into out_fd[%d]\n",data_len,instr_no);
				printf ("1===>>> %d    %d     %s     %d  <<<===\n",phy_rec_no,instr_no,instr_char,record_processed);
			}
//
      			status = fwrite(data_ptr, data_len, 1, out_fd[i]);
			if (debug_on == 2) {
				printf ("vgr_edr::write_edr_rec:  data_ptr = %x\n",data_ptr);
			}
*/
	      	}
	    }

	    if (status <= FALSE)
      		printf("vgr_edr::write_edr_rec:  instr_no = %d  write data error !\n",instr_no);
	

	}  //for (i = 0; i < MAX_INSTR_NUM

     } // if (FINAL)

   }
   else 		//other instruments
   {
// D-42
   if (debug_on == 1) {
   	printf ("DO for instruments including  ENG,  DAILY\n");
   }

   if (debug_on == 2) {
	printf ("vgr_edr::write_edr_rec:   out_fd[inst_no] = %x\n",out_fd[instr_no]);
        printf ("vgr_edr::write_edr_rec:  instr_no = %d  sub_hdr_len = %x\n",instr_no,sub_hdr_len);
        printf  ("                                       sub_hdr_ptr = %x\n",sub_hdr_ptr),
        printf ("vgr_edr::write_edr_rec:                 data_len = %x\n",data_len);
        printf ("                                        data_ptr = %x\n",data_ptr);
	printf (">>>>>>>>>>>>>>>>>>>>>> FWRITE header (%d bytes) into out_fd[%d]\n",EDR_HDR_LEN,instr_no);
   }
// D-43
	if (debug_on == 1) {
	    printf (">>>>>>>>>>>>>>>>>>>>>> FWRITE header (%d bytes) into out_fd[%d]\n",EDR_HDR_LEN,instr_no);
	}

    	    status =  fwrite(hdr, EDR_HDR_LEN, 1, out_fd[instr_no]);
            if (status <= FALSE)  {
                printf("vgr_edr::write_edr_rec: - instr_no = %d  write hdr error !",instr_no);
            }
	    if (debug_on == 2) {
                printf("vgr_edr::write_edr_rec: instr_no = %d fwrite   edr_hdr\n",instr_no);
                for (ii=0; ii < EDR_HDR_LEN; ii++)
                        {  printf(" %02x ",hdr[ii]);
                }
                printf ("\n\n");
	    }
            if (sub_hdr_len > 0 && sub_hdr_ptr != NULL) {
// D-44
		if (debug_on == 1 ) {
                        printf ("(2) vgr_edr::write_edr_rec: sub_hdr_ptr instr_no = %d\n",instr_no);
		}

		if (debug_on == 2) {	
                        for (ii=0;ii<sub_hdr_len;ii++) {
                                printf ("    %02x ",sub_hdr_ptr[ii]);
                        }
                        printf ("\n\n");
		}
// D-45
		if (debug_on == 1) {
			printf (">>>>>>>>>>>>>>>>>>>>>> FWRITE sub_header (%d bytes) into out_fd[%d]\n",sub_hdr_len,instr_no);
		}

                status=fwrite(sub_hdr_ptr, sub_hdr_len, 1, out_fd[instr_no]);
                if (debug_on == 2)  {
                     printf("vgr_edr::write_edr_rec:  instr_no = %d fwrite  sub_hdr\n",instr_no);
                        for (ii=0; ii < sub_hdr_len; ii++)
                        {
			    printf(" %02x ",sub_hdr_ptr[ii]);
                        }
                        printf ("\n\n");
                }
            }
            if (status <= FALSE) {
                printf("vgr_edr::write_edr_rec:  instr_no = %d  write sub_hdr error !",instr_no);

	    }
  	    if (debug_on == 2) {
	    	printf ("vgr_edr::write_edr_rec ++++++++++++++++++++++++++++ INSTRUMENT = %d +++++++\n",instr_no);
		printf ("vgr_edr::write_edr_rec: - data_len = %x  data_ptr = %x\n",data_len,data_ptr);
	    }
            if (data_len > 0 && data_ptr != NULL) {
//* 5-8-2021 - Ray Bambery -fixed for CRS format- instrument 0
//              see vgr_edr::copy_MF_data_block 
//
                if (instr_no == 0) {
                        ctar_ptr = (U16*)data_ptr;
// D-46
			if (debug_on == 1 || debug_on == 10) {
				if (instr_no == 0) {strcpy(instr_char,"CRS");}
                                if (instr_no == 1) {strcpy(instr_char,"LECP");}
                                if (instr_no == 2) {strcpy(instr_char,"PLS");}
                                if (instr_no == 3) {strcpy(instr_char,"PRA");}
                                if (instr_no == 4) {strcpy(instr_char,"PWS");}
                                if (instr_no == 5) {strcpy(instr_char,"UVS");}
                                if (instr_no == 6) {strcpy(instr_char,"ENG");}
                                if (instr_no == 7) {strcpy(instr_char,"MAG");}

                        	printf (">>>>>>>>>>>>>>>>>>>>>> FWRITE data INSTRUMENT = %d [ctar_ptr] (%d bytes) into out_fd[%d]\n",
					instr_no,data_len,instr_no);
				printf ("===>>> %d    %d     %s     %d  <<<===\n",phy_rec_no,instr_no,instr_char,record_processed);   
			}

			if (debug_on == 2 ) {
                        	for (i=0; i < data_len; i++)       //subhdr_info[type][CRS].data_len
                        	{
                           		printf (" %04x ",(ctar_ptr[i]));
                        	}
 	                	printf ("\n================\n\n");
			}
                        status = fwrite (ctar_ptr, data_len ,1, out_fd[instr_no]);
			if (debug_on == 2)  {
                        	printf ("vgr_edr::write_edr_rec:  instr_no = 0 ctar_ptr = %x\n",ctar_ptr);
				for (ii=0; ii < data_len; ii++)
                        	{
                                	printf(" %04x ",ctar_ptr[ii]);
                        	}
                        	printf ("\n\n");
			}
                } else {
// D-47
			if (debug_on == 1 || debug_on == 10) {
                                if (instr_no == 0) {strcpy(instr_char,"CRS");}
                                if (instr_no == 1) {strcpy(instr_char,"LECP");}
                                if (instr_no == 2) {strcpy(instr_char,"PLS");}
                                if (instr_no == 3) {strcpy(instr_char,"PRA");}
                                if (instr_no == 4) {strcpy(instr_char,"PWS");}
                                if (instr_no == 5) {strcpy(instr_char,"UVS");}
                                if (instr_no == 6) {strcpy(instr_char,"ENG");}
                                if (instr_no == 7) {strcpy(instr_char,"MAG");}

                        	printf (">>>>>>>>>>>>>>>>>>>>>> FWRITE data INSTRUMENT = %d [data_ptr] (%d bytes) into out_fd[%d]\n",instr_no,data_len,instr_no);
				printf ("===>>> %d    %d     %s     %d  <<<===\n",phy_rec_no,instr_no,instr_char,record_processed);
			}

			if (debug_on == 2) {    
                    	for (i=0; i < data_len; i++)       //subhdr_info[type][CRS].data_len
                        	{
                         	  printf (" %02x ",(data_ptr[i]));
                        	}
	                	printf ("\n================\n\n");
			}
                        status = fwrite(data_ptr, data_len, 1, out_fd[instr_no]);
			if (debug_on == 2)  { 
                        	printf ("vgr_edr::write_edr_rec:  instr_no = %d data_ptr = %x\n",instr_no,data_ptr);
				for (ii=0; ii < data_len; ii++)
                        	{  
					printf(" %02x ",data_ptr[ii]);
                        	}
                        	printf ("\n\n");
                	}
	       }
/*
            if (data_len > 0 && data_ptr != NULL) {
                status = fwrite(data_ptr, data_len, 1, out_fd[instr_no]);
                printf("vgr_edr::write_edr_rec:  datai instr_no = %d\n",instr_no);
                        for (i=0; i < data_len; i++)
                        {  printf(" %X ",data_ptr[i]);
                        }
                        printf ("\n\n");
	    }
*/
	    }
	if (debug_on == 2) 
		printf ("+++++++++++++++++++++++++++++++++++++++++++++\n");
	
            if (status <= FALSE) {
                printf("vgr_edr::write_edr_rec:  instr_no = %d write data error !\n",instr_no);
            }
   }  //other INSTRUMENTS

//			if (debug_on == 2) { printf(" ---hdr written \n");
//  			printf (" fwrite status = %d \n", status);   
//			fflush(stdout);
//			fflush(out_fd[instr_no]);
//		        }

//			if (debug_on == 2)
//			printf("---instr=%d  sub_hdr_ptr=%d \n", 
//			instr_no, sub_hdr_ptr);

//           		if (debug_on == 2) { 
//			printf(" ---hdr written \n");
//			printf (" fwrite status = %d \n", status);
//                      fflush(stdout);
//			fflush(out_fd[instr_no]);
//                     }
   fflush(out_fd[instr_no]);
}

/*****************************************************************************/
//void vgr_edr::read_write_decom(FILE* output_fd)
void vgr_edr::read_write_decom(int instr_num)
//void vgr_edr::read_write_decom()
{
	FILE* output_fd;
	FILE* decom_fd;
	U8    decom_buf[1000];
	int i, status, instr_id;
	U8 tmp_mode;
	char sc_number[4];
	char dcom_root[50];
	char dcom_filename[100],dcomfn[16];
//	FILE* output_fd;
// D-48
if (debug_on == 1) {
	printf ("instr_num = %d\n",instr_num);
	printf ("******* print decom\n");
}

	fflush (stdout);
	if (instr_num >= MAX_INSTR_NUM	) 

	{
		printf (" instrument number %d  too big !! \n", instr_num);
		exit(1);
	}
	else
	{
// D-49
	     if (debug_on == 1) {
		printf ("instr_num = %d  out_fd[instr_num] = %x\n",instr_num,out_fd[instr_num]);
             }

	     output_fd = out_fd[instr_num];
	}

// fid - format ID from 618-306 Rev D Change 4 Table C9 - EDR header
// Item 34 - Word 10 Bits 7 & 6
//  0 0 Engineering without AACS Memory Readout
//  0 1 Engineering with AACS Memory Readout
//  1 0 Imaging Playback
//  1 1 GS & E  (General Science and Engineering)    
	tmp_mode = fid & 0x0e;			//FDS memory readout	
	memset(decom_buf, 0, DECOM_FILE_LEN); 
// D-50
	if (debug_on == 1) {
		printf ("read_write_decom:  MAX_DECOM_MAPS = %d  DECOM_FILE_LEN = %d\n",MAX_DECOM_MAPS,DECOM_FILE_LEN);
	}

	for (i=0; i < MAX_DECOM_MAPS; i++)
	{
	     if (sc_id == decom_tbl[i].sc_id  &&
		 tmp_mode == decom_tbl[i].data_mode)
	     {
		 break;
	     }
        }
//	printf ("FINAL Fails in Here --------------------------- <---------------\n");
 	if (i >= MAX_DECOM_MAPS){
	   i = MAX_DECOM_MAPS -1;
           printf("vgr_edr::read_write_decom: WARNING::engineering data_mode =%02x  sc_id = %d \n",
                  tmp_mode, sc_id);
 	}
// point to correct location of decom file - 10-01-2021
//  decom_tbl[i].file_name  only gives dcom31.cr or dcom32.cr
// need to prepend path - on shock3-vm this is /home/nertops/31/dcom31.cr
//  or /home/nertops/32/decom32.cr
// D-51
	if (debug_on == 1) {
		printf (" sc_id =%d\n",sc_id);
	}

	if (sc_id == 1 ) {strcpy(sc_number, "31/");}
//	printf ("00\n");
	if (sc_id == 0 ) {strcpy(sc_number, "32/");}
//	printf ("1 sc_id = %d\n",sc_id);


	strcpy (dcom_root,"/home/nertops/");			// on shock3-vm
//	strcpy(dcom_root,"/data/rjb/shock3-vm/nertops/");    	// ON pistol
	strcpy (dcomfn,decom_tbl[i].file_name);
//   testing
//	if (strcmp("dcom32.cr", dcomfn)) {
//		printf ("decom_tbl = decom32.cr\n");
//		if (sc_id == 1) {
//			strcpy(dcomfn,"dcom31.cr");
//			printf ("vgr_edr::read_write_decom: decom_tbl[i].file_name changed to dcom31.cr");
//		}
//	}
//	if (strcmp("dcom32.cr", dcomfn) && sc_id == 1) {
	if (sc_id == 1) {
		strcpy(dcomfn,"dcom31.cr");
	} else {
		strcpy(dcomfn,"dcom32.cr");
	}
	strcat(dcom_root,sc_number);
	strcat(dcom_root,dcomfn);
//	printf ("i = %d decom_tbl[i].file_name = %s\n",i,decom_tbl[i].file_name);
	strcpy(dcom_filename,dcom_root);
//	fflush (stdout);
//	fflush (stderr);
// D-52
	if (debug_on == 1  || debug_on == 10) {
		printf ("for  sc_id = %d  dcom_filename  = %s\n",sc_id,dcom_filename);
	}

//	if ((decom_fd = fopen( decom_tbl[i].file_name, "r")) == NULL) {
	if ((decom_fd =  fopen(dcom_filename,"r")) == NULL) {
	   printf("vgr_edr::read_write_decom: WARNING::engineering data_mode =%02x  sc_id = %d \n",
		  tmp_mode, sc_id); 
	   printf("  %%%%%%%%%%%%%%%%%%%%     can't open decom file %s !! \n", 
		dcom_filename);
//		decom_tbl[i].file_name);
	   
	}
	else
	{
		if (!feof(decom_fd)) {


		   status = fseek(decom_fd, 240L, 1); // skip header 
            	   if (status != 0)
                	printf ("vgr_edr::read_write_decom:  skipping decom file header error: ");

		   memcpy(&decom_buf[0], hdr, EDR_HDR_LEN);
// D-53
		  if (debug_on == 1) {
		  	printf (">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> FREAD %s\n",dcom_filename);
		  }

		   status = fread(&decom_buf[EDR_HDR_LEN], 1,
				(DECOM_FILE_LEN - MAX_STANDHDR_LEN), decom_fd );

///                 status = fread(decom_buf, 1,
///                           (DECOM_FILE_LEN ), decom_fd );
            	   if (status <= FALSE)
                	perror("vgr_edr::read_write_decom:  Reading decom file error: ");
//		   status = fwrite(decom_buf, (DECOM_FILE_LEN - 
//				 MAX_STANDHDR_LEN), 1, output_fd );
//			printf ("vgr_edr::read_write_decom: ####################### fwrite to output_fd\n");
		   memcpy (&decom_buf[32], cur_sclk.m16, 2);
		   memcpy (&decom_buf[34], cur_sclk.m60, 1);
		   memcpy (&decom_buf[35], cur_sclk.ln_cnt, 2);

		   memset (&decom_buf[DATA_PRESENCE_LOC], 0, 120);
		   memcpy (&decom_buf[39], &fid, 1);

		   decom_buf[3] &= 0x0f;
		   decom_buf[3] |= 0xf0;  // set record id
		   decom_buf[236] &=0x00;
		   decom_buf[236] |= 0x2a; // set data type
// D-54
                   if (debug_on == 1 ) {
			debug_print("decom_buf=", decom_buf, 42);
		   }

		   decom_rec_no ++;

        	   for (instr_id = 0; instr_id < MAX_INSTR_NUM; instr_id++)
        	   {
                	output_fd = out_fd[ instr_id];
// D-55
			if (debug_on == 1  || debug_on == 10) {
				printf (">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> FWRITE %s\n",dcom_filename);
			}

	                status = fwrite(decom_buf, DECOM_FILE_LEN, 
                                   1, output_fd );

            	   	if (status <= FALSE)
                	   perror("vgr_edr::read_write_decom:  copy decom file to files error: ");
			  
		   }
		}
	}
 
} 

/*****************************************************************************/
//void vgr_edr::store_or_write_MFs( vgr_sfdu& sfdu_obj, vgr_scet& scet_co)
void vgr_edr::store_or_write_MFs( vgr_sfdu& sfdu_obj , int FINAL, int record_processed)
{
// added record_processed to parameters - 4-6-2021 - sfdu record processed
  int MF_no;
  U8 seg_no;
  U8 tmp_seg_no;
//  int ln_count;
  int fid_changed;
  int i, type,status;
  unsigned short int *ctar_ptr;
  U16 cur_m16, last_m16;
	FILE output_fd;
// D-56
	if (debug_on == 1) {
		printf ("vgr_edr::store_or_write_MFs:  Entry  FINAL = %d\n",FINAL);
	}

	type = data_mode_index(); 
   cur_m16 = C16_TO_U16(cur_sclk.m16);
   last_m16 = C16_TO_U16(cur_sclk.m60);

   MF_no = get_MF_no(cur_data_mode, cur_sclk);
	if (debug_on == 3) 
		printf ("vgr_edr::stor_or_write_MFs:  cur_m16 = %x  last_m16 = %x\n",cur_m16,last_m16);
   seg_no = get_seg_no ( MF_no, C16_TO_U16(cur_sclk.m16), 
			        C16_TO_U16(cur_sclk.m60));
// D-57
	if (debug_on == 1  || debug_on == 10) {
       		printf ("++++++++++++++++++++++ INSTRUMENT = %d +++ sfdu_record = %d +++++++++++++++++++\n",
			instr_no,record_processed);
		 printf("   crs=0, lecp=1, pls=2, pra=3, pws=4, uvs=5, eng=6, mag=7\n");
	}

/*   following commented out before 9-22-2020 - RJB 
 *  if (eng_sync == FALSE) {
 *      if (instr_no == ENG ) {
 *   	ln_count = C16_TO_U16(cur_sclk.ln_cnt);
 *	if (ln_count == 1)
 *	   eng_sync = TRUE;
 *     } 
 *  }
 *
 *			if (debug_on == 2)
 *			{
 *       printf("eng_sync=%d instr =%d  MF= %d last_seg_no=%02x  seg_no= %02x\n ",
 *                        eng_sync, instr_no, MF_no, last_seg_no, seg_no);
 *                        printf("m16=%d  m60=%d  ln_cnt=%d ",
 *                        C16_TO_U16(cur_sclk.m16), C16_TO_U16(cur_sclk.m60),
 *                        C16_TO_U16(cur_sclk.ln_cnt));
 *			}
 *                      if (debug_on == 2) 
 *			{
 *                        printf(">>> hdr[8 >>]= %o %o %0 %0 %0 \n",
 *                        hdr[8], hdr[9],hdr[10],hdr[11],hdr[12]);
 *
 *                      printf("cur_data_mode = %x \n", cur_data_mode);
 *                        printf("vgr_edr::store_or_write_MFs:  first_MF=%x  ", first_MF);
 *
 *                     }
 *
 * if (instr_no != ENG || (instr_no == ENG && eng_sync == TRUE)) 
 * 
 *	printf ("HERE++++++++++++++++++++++++++\n");
*/
   if(seg_no > 0x00) {

   	if (first_MF == TRUE) {
		last_seg_no = seg_no;
   	}


//			if (debug_on == 2)
//			{
//printf("seg_no=%d, last_seg_no=%d,instr_no=%d MF_no=%d  cur_m16=%0x last_m16=%0x\n",
//	seg_no, last_seg_no,instr_no, MF_no, cur_sclk.m16, last_sclk.m16);
//			}
// regression
  	fid_changed = 0;

  	if (first_MF == FALSE) {

//???	put checking with time calculation here
/* instr_no: crs=0, lecp=1, pls=2, pra=3, pws=4, uvs=5, eng=6, mag=7  */
  	    status = data_mode_changed();
//  for VGR-1 21302.a which is crs=288, eng=78 
// if this debug_on == 1 is blocked out then get crs=288, eng=551. lecp=797, eng=551
//

// D-58 - always execute to eliminate extra ENG records
// 5-19-2022 - Ray Bambery removed // on debug_on == 1
	    if (debug_on == 1) {
		printf ("vgr_edr::store_or_write_MFs: status from data_mode_changed() = %d\n",status);
		printf ("     instr_no PRA=(3), ENG=6               instr_no = %d\n",instr_no); 
		printf ("     if ( data_mode_changed() == %d\n",data_mode_changed());
		printf ("     (instr_no != PRA) && (last_seg_no == seg_no)  = %d\n",
                           ((instr_no != PRA) && (last_seg_no == seg_no) && (strncmp((char*)cur_sclk.m16, (char*)last_sclk.m16,2))));
                printf ("                  last_seq_no = %d      seg_no = %d\n",last_seg_no,seg_no);
                printf ("                   (char*)cur_sclk.m16 = %s    (char*)last_sclk.m16 = %s \n",(char*)cur_sclk.m16,(char*)last_sclk.m16);
		printf ("                  (strncmp((char*)cur_sclk.m16, (char*)last_sclk.m16,2) = %d\n",
                           (strncmp((char*)cur_sclk.m16, (char*)last_sclk.m16,2)));
		printf ("     ((instr_no != ENG) && ( last_stat_tbl_changed( ) = %d\n",((instr_no != ENG) && ( last_stat_tbl_changed( ))));
		printf ("     sclk_regression(cur_sclk) = %d\n",sclk_regression(cur_sclk) );
		printf ("     (last_seg_no != seg_no) =%d\n",(last_seg_no != seg_no));
		printf ("     ((instr_no == ENG) && ((fid_changed = update_format_id(sfdu_obj)) = %d\n",
				((instr_no == ENG) && ((fid_changed = update_format_id(sfdu_obj)))));
		printf ("     (MF_no == 1) =%d\n",(MF_no == 1));
            }

     		if ( data_mode_changed() ||
		  ((instr_no != PRA) && (last_seg_no == seg_no) && (strncmp((char*)cur_sclk.m16, (char*)last_sclk.m16,2))) || 
    	  	  ((instr_no != ENG) && ( last_stat_tbl_changed( ) || 
	   	  sclk_regression(cur_sclk) || 
		  (last_seg_no != seg_no) ))   	||
          	  ((instr_no == ENG) && ((fid_changed = update_format_id(sfdu_obj)) ||
		  (MF_no == 1) )) )
     		{
//			if (debug_on == 2)
//			{
//			  if (data_mode_changed())
//				printf ("instr_no = %d \n", instr_no);
//			  if (instr_no == ENG)
//				printf ("fid_changed =%d ** instr_no=%d MF_no =%d seg_no=%d cmp=%d\n", 
//					fid_changed,instr_no,MF_no,seg_no,
//					strncmp((char*)cur_sclk.m16, (char*)last_sclk.m16,2));
//			}
// D-59
			if (debug_on == 1 || debug_on == 10) {
				printf ("inside expresssion\n");
			}

  			int type;
  			type = data_mode_index();
			if (debug_on == 2) {
				printf("vgr_edr::store_or_write_MFs - before write_edr_rec\n");	
                       		printf("     $$$instr =%d  MF= %d sc_id= %d last_seg_no=%d  seg_no= %d type= %d \n",
                               		instr_no, MF_no, sc_id,last_seg_no, seg_no,type);
				printf("     cur_sclk.m16 = %x last_sclk.m16 = %x  cur_sclk.m60 = %x last_sclk.m16 = %x\n",
					cur_sclk.m16,last_sclk.m16,cur_sclk.m60,last_sclk.m60);
			
				printf ("vgr_edr::  fid_changed = %d\n",fid_changed);
			}
// D-60
			if (debug_on == 1) {
                		printf ("vgr_edr::store_or_write_MFs:  before write_edr_rec  FINAL = %d\n",FINAL);
                        	printf ("vgr_edr::store_or_write_MFs;  cur_sclk.m16 = %x last_sclk.m16 = %x  cur_sclk.m60 = %x last_sclk.m60 = %x\n",
                                        cur_sclk.m16,last_sclk.m16,cur_sclk.m60,last_sclk.m60);
 			}

	       		write_edr_rec(FINAL, fid_changed, record_processed);    
        		reset_edr_rec();
        		last_seg_no = seg_no;

        		first_MF = TRUE;
     		}
  	}


/*  Make Headers for all instrument EDRS    */
  	if (first_MF && (MF_no > FALSE)) 
  	{
// D-61
		if (debug_on == 1) {
			printf ("CREATE EDR HEADERS!! \n");
		}

     		reset_edr_rec();
// D-62
		if (debug_on == 1) printf ("vgr_edr::store_or_write_MF:  before store_hdrs_of_first_MF\n");

     		store_hdrs_of_first_MF(sfdu_obj);             


//   first_MF = FALSE;
  	}
// D-63
   	if (debug_on == 1) printf ("vgr_edr::store_or_write_MFs:  MF_no = %d\n",MF_no); 


  	if (MF_no > FALSE) {

    	if (data_ptr == NULL || sub_hdr_ptr == NULL)
       			allocate_data_buf();

    	get_store_ert(sfdu_obj.get_ert()); 
    	tmp_seg_no= seg_no << 4;
		if (debug_on == 2)
			{
    			printf("seg_no after<< = %02x \n",seg_no);
			debug_print("before SEG_NO:: ",&hdr[15], 1);
			}
    	if (instr_no != ENG)
       		copy_to_hdr( &tmp_seg_no, 1, item_15_SEG_NO);		//edr hdr word  4 bits 3-0  - byte 8
      
    		copy_MF_data_block(sfdu_obj, MF_no, cur_sclk);

		ctar_ptr = (U16*)data_ptr;
		if (debug_on == 2) {
			printf ("after copy_MF_data_block: instr_no = %d  data_ptr = %x\n",instr_no,data_ptr);

        		printf ("vgr_edr::store_or_write_MFs:  output to edr  ===================instr_no = %d\n",instr_no);
		}
		if (instr_no == 0) {
			if (debug_on == 2) {
				printf ("vgr_edr::store_or_write_MFs:   ctar_ptr = %x  instr_no = %d\n",ctar_ptr,instr_no);
				for (i=0; i < 26; i++)
                        	{
                           		printf (" %04x ",(ctar_ptr[i]));
                        	}
                		printf ("================\n\n");
			}
		} else {
			if (debug_on == 2) {
				printf ("vgr_edr::store_or_write_MFs:   data_ptr = %x  instr_no = %d\n",data_ptr,instr_no);
                		for (i=0; i < subhdr_info[type][instr_no].data_len; i++)
                        	{
                           		printf (" %04x ",(data_ptr[i]&0xff));
                        	}
                		printf ("================\n\n");
			}
		}

    		if (instr_no != ENG)
       			set_dqi_dqsw(sfdu_obj, MF_no, &hdr[DQSW_LOCATION] );    //edr hdr words 14 thru words 19 


    		set_mf_dt_presence(MF_no, &hdr[DATA_PRESENCE_LOC]);        //edr hdr byte 236
		if (debug_on == 2)  {
			printf ("vgr_edr::store_or_write_MFs  edr header for instr_no = %d\n",instr_no);
			for (i=0;i<240;i++) {
				printf (" %0x ",hdr[i]);
			}
			printf ("\n\n");

//			printf ("vgr_edr::store_or_write_MFs: before set_subhdr  - cur_sclk.m16 = %x cur_sclk.m60 =  %x,cur_sclk.ln_cnt = %d\n",
//				cur_sclk.m16,cur_sclk.m60,cur_sclk.ln_cnt); 	
	 	}
    		set_subhdr( sfdu_obj, MF_no, C16_TO_U16(cur_sclk.m16),
                	C16_TO_U16(cur_sclk.m60), C16_TO_U16(cur_sclk.ln_cnt ));


/*   deleted before 9-22-2020
    if (first_MF )
    {

       store_hdrs_of_first_MF(sfdu_obj);

       first_MF = FALSE;
    }
*/
// D-64
		if (debug_on == 1) {
    			printf ("vgr_edr::store_or_write_MFs  ENG = %d, first_DECOM = %d, FINAL = %d\n",ENG,first_DECOM,FINAL);
		}

    		if (instr_no == ENG && first_DECOM && FINAL)
    		{
// D-65
                    if (debug_on == 1) {
			printf ("vgr_edr::stor_or_wite_MFs: instr_no == ENG && first_DECOM && FINAL\n");
			printf ("vgr_edr::stor_or_write_MFs: before read_write_decom(instr_no =%d\n",instr_no);
		    }

		read_write_decom (instr_no);
        	first_DECOM = FALSE;
    		}
    		if (first_MF )
    		{
       			first_MF = FALSE;
    		}

    		last_seg_no = seg_no;
  	} // if (MF > FALSE
    }    // if (seg_no > 0x00)
	/* commented out before 9-22-2021 
	*  if (!fmod(MF_no, instr_info[type][instr].mfs_per_seg))
	*/
}

/*****************************************************************************/
void vgr_edr::copy_MF_data_block(vgr_sfdu& sfdu_obj,int MF_no, 
                                 SFOC_SCLK_TIME cur_sclk)
{

  U8* tar_ptr;          //edr - data_ptr //output buf out_buf[instr_info[type][instr_no].mf_size]
  U8* src_ptr;          //sfdu           //input buf in_buf[subhdr_info[type][instr_no].data_len]
  U8* sfdu_pointer;

  unsigned short int *csrc_ptr, *ctar_ptr;
  unsigned short int sbuff[40],tbuff[52];
  int tmp_off;
  int i;
  int type;
//	char *p = (char *)&subhdr_info[type][instr_no].sfdu_offset;
  type = data_mode_index();

  if (MF_no > 0 ) {
     sfdu_pointer = sfdu_obj.get_sfdu_ptr();		//added 4-2-2021

     src_ptr = sfdu_obj.get_data_ptr();			//sfoc_hdr[ DATA_SEG_ID=4].data_ptr (vgr_sfdu.H)
//     char *s = (char *)&src_ptr; 
     src_ptr = src_ptr - 4;                     //4-3-2021 - RJB - This works for pws and pls

     tar_ptr = data_ptr;
//     char *d = (char *)&data_ptr;

		if (debug_on == 2) {
                        printf("vgr_edr::copy_MF_data_block:  on entry  src_ptr=%x tar_ptr=%x (data_ptr) sfdu_pointer = %x ",
                          src_ptr, tar_ptr,sfdu_pointer);
                        printf("sfdu_offset= %d \n",
                                subhdr_info[type][instr_no].sfdu_offset);
                        printf ("  subhdr_info[type=%d][instr_no=%d].data_len = %d\n",
                                type,instr_no,subhdr_info[type][instr_no].data_len);
                        printf ("src_ptr - sfdu_pointer = %x (%d) \n",
                        (src_ptr - sfdu_pointer), (src_ptr - sfdu_pointer));
		}

     src_ptr =  src_ptr + (int)(subhdr_info[type][instr_no].sfdu_offset);

// D-66
	if (debug_on == 1) {
		printf ("    before switch (instr_no) updated\n   src_ptr = %x, sfdu_offset = %d\n",
                                src_ptr,subhdr_info[type][instr_no].sfdu_offset);
	}

     switch (instr_no) {
/*---------------------------------------------------------------------------------*/

	case CRS:
	if (debug_on == 2) {
		printf ("CRS:: sub_hdr length = %d\n",subhdr_info[type][CRS].data_len);
                for (i=0; i < subhdr_info[type][CRS].data_len; i++)
                        {
                           printf (" %02x ",src_ptr[i]);
                        }
                printf ("\n================\n\n");
	}
          tar_ptr = tar_ptr +
                  ((int)fmod(MF_no -1 , instr_info[type][instr_no].mfs_per_seg))
                  * instr_info[type][instr_no].mf_size;
                  if (debug_on == 2)  {
                	printf ("CRS:: instr_no = %d   MF_no - 1 = %d\n",instr_no,MF_no-1);
                	printf ("     mfs_per_seg * mf_size = %d (edr data size)\n",
                        	instr_info[type][instr_no].mfs_per_seg*instr_info[type][instr_no].mf_size);

                	printf ("vgr_edr::copy_MF_data_block\n");
                	printf ("vgr_edr:: (CRS) tar_ptr update = %x \n",tar_ptr);
                	printf ("   src_ptr = %x  diff = %d = sfdu_offset \n",src_ptr,(src_ptr - sfdu_pointer));
                	printf ("   subhdr_info[type][instr_no=%d].data_len = %d\n",instr_no,subhdr_info[type][instr_no].data_len);
                	printf ("   instr_info[type][instr_no].mf_size = %d\n",instr_info[type][instr_no].mf_size);
		}
//  temp 5-8-2021 - not where short 8300 byte crs_edr is
       csrc_ptr = (U16*)src_ptr;
       ctar_ptr = (U16*)tar_ptr;
	memcpy(sbuff,csrc_ptr,40);
	if (debug_on == 2)  {
		printf ("CRS:: csrc_ptr = %x\n",csrc_ptr);
		printf ("vgr:edr::copy_MF_data_block:  src_ptr[0] = %04x\n",src_ptr[0]);
		printf ("vgr_edr::copy_MF_data_block: csrc_ptr[0] = %04x\n",sbuff[0]);
		printf ("\n\n");
	}
/*	Removed 5-3-2021 - Ray Bambery
 *	void bit_R_shifting(unsigned char* src_buf, int start_bit, int bit_len)
 *
 *	  expend_bit_fields_Rjust(     
 *                 src_ptr, subhdr_info[type][instr_no].data_len, 12, 
 *	         tar_ptr, instr_info[type][instr_no].mf_size, 16  
 *         );
 *
 *		bit_R_shifting ((unsigned char*) &src_ptr[0], 4, 8);
 */
//added for special padding for CRS	
	crs_pad (sbuff,(subhdr_info[type][instr_no].data_len+1)/2, ctar_ptr, instr_info[type][instr_no].mf_size/2);
	memcpy(tbuff,ctar_ptr,52);
	if (debug_on == 2) {
		printf ("vgr_edr::copy_MF_data_block: tbuff[0] = %04x\n",tbuff[0]);
        	printf ("CRS2:: ctar_ptr = %x\n",ctar_ptr);	//unsigned short int* (U16*)
		printf ("CRS2::  tar_ptr = %x\n", tar_ptr);	//U8*
		printf ("CRS2:: data_len = 26\n",data_ptr);	//U8*
                        for (i=0; i < 26; i++)       //subhdr_info[type][CRS].data_len
                        {
                           printf (" %02x ",(ctar_ptr[i]));
                        }
                printf ("\n================\n\n");
//			for (i=0;i<instr_info[type][instr_no].mf_size;i++) {
//			   printf (" %04x ",data_ptr[i]);
//			}
//		printf ("\n================\n\n");
 
                printf ("vgr_edr::copy_MF_data_block:          mfs_per_seg = %d  num_of segs = %d  mf_size = %d sub_hdr_size= %d\n",
                        instr_info[type][instr_no].mfs_per_seg,instr_info[type][instr_no].num_of_segs,
                        instr_info[type][instr_no].mf_size, instr_info[type][instr_no].sub_hdr_size);
                printf ("vgr_edr::copy_MF_data_block:    src_ptr = %x      sfdu_offset = %d  data_len = %d\n", src_ptr,
                        subhdr_info[type][instr_no].sfdu_offset, subhdr_info[type][instr_no].data_len);
	}
	
	  break;
/*---------------------------------------------------------------------------------*/

        case PRA:

    	  int tmp_size;
			
          if  (fmod(C16_TO_U16(cur_sclk.m16), 2) ) {


           	tar_ptr = tar_ptr + ((int)fmod(MF_no + 20 -1, 
		          instr_info[type][instr_no].mfs_per_seg))
		    	   * instr_info[type][instr_no].mf_size;
			
			tmp_size = ((int)fmod(MF_no + 20 -1,
                          instr_info[type][instr_no].mfs_per_seg))
                           * instr_info[type][instr_no].mf_size;
	

	        memcpy(tar_ptr, src_ptr, subhdr_info[type][instr_no].data_len);
          }
          else {

                tar_ptr = tar_ptr + ((int)fmod(MF_no -1, 
			  instr_info[type][instr_no].mfs_per_seg))
			  * instr_info[type][instr_no].mf_size;

	  	memcpy(tar_ptr, src_ptr, subhdr_info[type][instr_no].data_len);

                        tmp_size = ((int)fmod(MF_no -1,
                          instr_info[type][instr_no].mfs_per_seg))
                          * instr_info[type][instr_no].mf_size;

          }
//		*p = (char *)&subhdr_info[type][instr_no].sfdu_offset;
		if (debug_on == 2) {
               		printf ("vgr_edr::  PRA:  instr = %d \n",instr_no);
               		printf ("vgr_edr::          mfs_per_seg = %d  num_of segs = %d  mf_size = %d sub_hdr_size= %d\n",
                        	instr_info[type][instr_no].mfs_per_seg,instr_info[type][instr_no].num_of_segs,
                        	instr_info[type][instr_no].mf_size, instr_info[type][instr_no].sub_hdr_size);
                	printf ("vgr_edr::    src_ptr = %x      sfdu_offset = %d  data_len = %d\n",src_ptr,
                        	subhdr_info[type][instr_no].sfdu_offset, subhdr_info[type][instr_no].data_len);
                	printf ("vgr_edr:  sfdu buffer (input) ===============instr_no = %d\n",instr_no);
                        for (i=0; i < subhdr_info[type][instr_no].data_len; i++)
                        {
                           printf (" %X ",src_ptr[i]&0xff);
                        }

                        printf ("=============\n\n");
                	printf ("vgr_edr::  PRA:  instr = %d   sfdu_offset = %d  data_len = %d\n",instr_no,
                        	subhdr_info[type][instr_no].sfdu_offset, subhdr_info[type][instr_no].data_len);
                	printf ("        sfdu_offset = %d\n",subhdr_info[type][instr_no].sfdu_offset);
		}

			if (debug_on == 3) {
				printf("PRA:: tar_ptr + %d   data_len =%d \n",
					tmp_size, subhdr_info[type][instr_no].data_len);
                        }
          break;
/*---------------------------------------------------------------------------------*/

        case UVS:
        
	  if (cur_data_mode == CR_5A) {
// D-67
		if (debug_on == 1) {
			printf ("CR_5A mode for UVS::\n");
		} 

            if (fmod(MF_no,5) != 1) {
		
  		tmp_off  =  (int)(fmod((MF_no - 1), instr_info[type][
		                 instr_no].mfs_per_seg) -
                            (int)fmod(MF_no-1, instr_info[type][
			         instr_no].mfs_per_seg)/5 - 1)
                            * instr_info[type][instr_no].mf_size;
			if (debug_on == 3) 
			{
			printf("UVS:: mf_size=%d  type=%d \t",
				instr_info[type][instr_no].mf_size, type);
			printf("UVS MF_no=%d  mfs_seg=%d tmp_off=%d \n",
				MF_no, instr_info[type][instr_no].mfs_per_seg, tmp_off);
			}


			int tmp_mod, tmp_dev;
			tmp_mod = (int)fmod((MF_no - 1), instr_info[type][
			instr_no].mfs_per_seg);
			tmp_dev = (int)fmod(MF_no-1, instr_info[type][
				instr_no].mfs_per_seg)/5;
			tmp_off = tmp_mod-tmp_dev-1;

			if (debug_on == 3)
			printf("mod=%d, /5=%d tmp_off=%d  tar_ptr+%d len=%d \n",
				tmp_mod, tmp_dev, tmp_off, tmp_off * 
				instr_info[type][instr_no].mf_size, 
				subhdr_info[type][instr_no].data_len);

	     tar_ptr = tar_ptr +  tmp_off * instr_info[type][instr_no].mf_size;
		if (debug_on == 2 ) {
       	         	printf ("UVS:: instr_no = %d   MF_no - 1 = %d\n",MF_no-1);
                	printf ("     mfs_per_seg * mf_size = %d (edr data size)\n",
                        	instr_info[type][instr_no].mfs_per_seg*instr_info[type][instr_no].mf_size);
                	printf ("copy_MF_data_block\n");
                	printf ("vgr_edr:: (UVS) tar_ptr update = %x \n",tar_ptr);
		}

	     memcpy(tar_ptr, src_ptr, subhdr_info[type][instr_no].data_len);
		if (debug_on == 2) {
                	printf ("   src_ptr = %x  diff =%x (%d) = sfdu_offset \n",
				src_ptr,(src_ptr - sfdu_pointer),(src_ptr - sfdu_pointer));
                	printf ("   instr_info[type][instr_no].mf_size = %d\n",instr_info[type][instr_no].mf_size);
                	printf ("vgr_edr::    src_ptr = %x      sfdu_offset = %d  data_len = %d\n",src_ptr,
                        	subhdr_info[type][instr_no].sfdu_offset, subhdr_info[type][instr_no].data_len);

                	printf ("vgr_edr:  sfdu buffer (input) ===================instr_no = %d\n",instr_no);
                        for (i=0; i < subhdr_info[type][instr_no].data_len; i++)
                        {
                           printf (" %X ",(src_ptr[i]&0xff));
                        }
                	printf ("================\n\n");
		}

//	     tar_ptr =tar_ptr +
//                    ((int)fmod(MF_no-1, instr_info[type][instr_no].mfs_per_seg)
//		     -(int)fmod(MF_no-1, instr_info[type][instr_no].mfs_per_seg)/5-1)
//			* instr_info[type][instr_no].mf_size;

	   }
         }
	 else   /******************************  UV_5A */ 
	 {
                if (debug_on == 3)
                {
	                printf(" UVS:: tar_ptr+ %d \n",((int)fmod(MF_no -1 ,
	      	          instr_info[type][instr_no].mfs_per_seg))
	                * instr_info[type][instr_no].mf_size );
                }
		printf ("NOT  CR_5A mode for UVS::\n");
	        tar_ptr = tar_ptr +
                ((int)fmod(MF_no -1 , instr_info[type][instr_no].mfs_per_seg))
                * instr_info[type][instr_no].mf_size;

		if (debug_on == 2) {
                	printf ("vgr_edr:: tar_ptr 1 = %x \n",tar_ptr);
                	printf ("copy_MF_data_block\n");
                	printf ("---instr_no = %d (UVS)  last 3 bytes MAG\n",instr_no);
                	printf ("vgr_edr::copy_MF_data_block\n");
                	printf ("   src_ptr = %x  diff =%d\n",src_ptr,(src_ptr - sfdu_pointer));
                	printf ("   subhdr_info[type][instr_no=%d].data_len = %d\n",instr_no,subhdr_info[type][instr_no].data_len);
                	printf ("   instr_info[type][instr_no].mf_size = %d\n",instr_info[type][instr_no].mf_size);
		}
        	expend_bit_fields_Rjust(     
                 src_ptr, subhdr_info[type][instr_no].data_len, 10, 
                 tar_ptr, instr_info[type][instr_no].mf_size, 16  
                 );
		if (debug_on == 2) {
                	printf ("vgr_edr:: UVS: UV_5A tar_ptr 2 = %x \n",tar_ptr);
                	printf ("vgr_edr::copy_MF_data_block\n");
                	printf ("vgr_edr::  UVS:    src_ptr = %x  data_ptr = %x\n",src_ptr,data_ptr);
                	printf ("vgr_edr::          mfs_per_seg = %d  num_of segs = %d  mf_size = %d sub_hdr_size= %d\n",
                        	instr_info[type][instr_no].mfs_per_seg,instr_info[type][instr_no].num_of_segs,
                        	instr_info[type][instr_no].mf_size, instr_info[type][instr_no].sub_hdr_size);
                	printf ("vgr_edr::          sfdu_offset = %d  data_len = %d\n",
                        	subhdr_info[type][instr_no].sfdu_offset, subhdr_info[type][instr_no].data_len);
                	printf ("        sfdu_offset = %d\n",subhdr_info[type][instr_no].sfdu_offset);
		}
		if (debug_on == 3) 
		debug_print(" UVS-uv5 ", tar_ptr,
				instr_info[type][instr_no].mf_size);

	 }
		if (debug_on == 2) {
                	printf ("vgr_edr:: UVS::   src_ptr = %x      sfdu_offset = %d  data_len = %d\n",src_ptr,
                        	subhdr_info[type][instr_no].sfdu_offset, subhdr_info[type][instr_no].data_len);

               		printf ("vgr_edr:  sfdu buffer (input) ===================instr_no = %d\n",instr_no);
                        for (i=0; i < subhdr_info[type][instr_no].data_len; i++)
                        {
                           printf (" %X ",(src_ptr[i]&0xff));
                        }
                	printf ("================\n\n");
		}

         break;

/*---------------------------------------------------------------------------------*/
// PWS, LECP, ENG, MAG, PLS
        default:
	  tar_ptr = tar_ptr + 
                  ((int)fmod(MF_no -1 , instr_info[type][instr_no].mfs_per_seg))
	 	  * instr_info[type][instr_no].mf_size;
		if (debug_on == 2) {
			printf("	   crs=0, lecp=1, pls=2, pra=3, pws=4, uvs=5, eng=6, mag=7\n");
                	printf ("default:: instr_no = %d   MF_no - 1 = %d\n",instr_no,MF_no-1);
                	printf ("     mfs_per_seg * mf_size = %d (edr data size)\n",
                        	instr_info[type][instr_no].mfs_per_seg*instr_info[type][instr_no].mf_size);
                	printf ("copy_MF_data_block\n");
                	printf ("vgr_edr:: (default) tar_ptr update = %x \n",tar_ptr);
		}

	  memcpy(tar_ptr, src_ptr, subhdr_info[type][instr_no].data_len);

		if (debug_on == 2) {
                	printf ("vgr_edr::    src_ptr = %x      sfdu_offset = %d  data_len = %d\n", src_ptr,
                        	subhdr_info[type][instr_no].sfdu_offset, subhdr_info[type][instr_no].data_len);

               		printf ("vgr_edr:  sfdu buffer (input) LECP, ENG, MAG, PLS, PWS  instr_no = %d\n",instr_no);
                        for (i=0; i < subhdr_info[type][instr_no].data_len; i++)
                        {
                           printf (" %02x ",(src_ptr[i]&0xff));
                        }
               	 	printf ("================\n\n");
		}
   

  //                   printf ("\n");
//        memcpy(&buffer[0],fd,100);              //cp char by char at beginning of primary CHDO
//        printf ("  buf_len = %d   fd data\n",buf_len);
//        for (i=buf_len;i<8+buf_len;i++) {
//                printf ("%x ",buffer[i]&0xff);        //sf[i]&0xff);   // (char*)prim_labl_hdr_ptr
//        }
//        printf ("\n\n");

     }   // end switch instr_no

//			if (debug_on == 2) {
//			printf(" MF_size=%d tar_ptr=%x  src_ptr=%x  data_len=%d  \n",
//			instr_info[type][instr_no].mf_size, tar_ptr, src_ptr, 
//			subhdr_info[type][instr_no].data_len);
//			}

  }    // end if MF >0
}
 
/*****************************************************************************/
void vgr_edr::crs_pad (unsigned short int * in_buf, int in_buf_len,unsigned short int * out_buf, int out_buf_len)
{

  int i;
  unsigned short int rmdr;
  const char* bin_out;

  unsigned short int   mask32c=0x0fff, buf32=0;


out_buf[0] = in_buf[0]>>4;
//printf (" %04x  out_buf[0]\n",out_buf[0]);

out_buf[1] = in_buf[1]>>8;
rmdr = in_buf[0]<<8;
//printf (" %04x\n",rmdr);
out_buf[1] = out_buf[1] + rmdr;
out_buf[1] = out_buf[1] & mask32c;
//printf (" %04x out_buf[1]\n",out_buf[1]);
//
out_buf[2] = in_buf[1]<<4;
rmdr = in_buf[2]>>12 ;
//printf (" %04x\n",rmdr);
out_buf[2] = out_buf[2] + rmdr;
out_buf[2] = out_buf[2] & mask32c;
//printf (" %04x out_buf[2]\n", out_buf[2]);
//
out_buf[3] = in_buf[2] & mask32c;
//printf (" %04x out_buf[3]\n",out_buf[3]);

out_buf[4] = in_buf[3]>>4;
//printf (" %04x out_buf[4]\n",out_buf[4]);


out_buf[4] = in_buf[3]>>4;
//printf (" %04x out_buf[4]\n",out_buf[4]);

out_buf[5] = in_buf[4]>>8;
rmdr = in_buf[3]<<8;            //(in_buf[3] & mask32d);
//printf (" %04x\n",rmdr);
out_buf[5] = out_buf[5] + rmdr;
out_buf[5] = out_buf[5] & mask32c;
//printf (" %04x out_buf[5]\n",out_buf[5]);

out_buf[6] = in_buf[4]<<4;
//printf (" %04x\n",out_buf[6]); 
rmdr = in_buf[5]>>12;
//printf (" %04x\n",rmdr);
out_buf[6] = out_buf[6] + rmdr;
out_buf[6] = out_buf[6] & mask32c;
//printf (" %04x out_buf[6]\n",out_buf[6]);

out_buf[7] = in_buf[5] & mask32c;
//printf (" %04x out_buf[7]\n",out_buf[7]);

out_buf[8] = in_buf[6]>>4;
//printf (" %04x out_buf[8]\n",out_buf[8]);

out_buf[9] = in_buf[7]>>8;
rmdr = in_buf[6]<<8;
out_buf[9] = out_buf[9] + rmdr;
out_buf[9] = out_buf[9] & mask32c;
//printf (" %04x out_buf[9]\n",out_buf[9]);
out_buf[10] = in_buf[7]<<4;
//printf (" %04x\n",out_buf[10]);

rmdr = in_buf[8]>>12;
//printf (" %04x\n",rmdr);
out_buf[10] = out_buf[10] + rmdr;
out_buf[10] = out_buf[10] & mask32c;
//printf (" %04x out_buf[10]\n",out_buf[10]);


out_buf[11] = in_buf[8] & mask32c;
//printf (" %04x out_buf[11]\n",out_buf[11]);

out_buf[12] = in_buf[9]>>4;
//printf (" %04x out_buf[12]\n",out_buf[12]);

out_buf[13] = in_buf[10]>>8;
rmdr = in_buf[9]<<8;
out_buf[13] = out_buf[13] + rmdr;
out_buf[13] = out_buf[13] & mask32c;
//printf (" %04x out_buf[13]\n",out_buf[13]);
//
out_buf[14] = in_buf[10]<<4;
//printf (" %04x\n",out_buf[14]);
rmdr = in_buf[11]>>12;
//printf (" %04x\n",rmdr);
out_buf[14] = out_buf[14] + rmdr;
out_buf[14] = out_buf[14] & mask32c;
//printf (" %04x out_buf[14]\n",out_buf[14]);

out_buf[15] = in_buf[11] & mask32c;
//printf (" %04x out_buf[15]\n",out_buf[15]);

out_buf[16] = in_buf[12]>>4;
//printf (" %04x out_buf[16]\n",out_buf[16]);

out_buf[17] = in_buf[13]>>8;
rmdr = in_buf[12]<<8;
//printf (" %04x\n",rmdr);
out_buf[17] = out_buf[17] + rmdr;
out_buf[17] = out_buf[17] & mask32c;
//printf (" %04x out_buf[17]\n",out_buf[17]);

out_buf[18] = in_buf[14]>>12;
rmdr = in_buf[13]<<4;
out_buf[18] = out_buf[18] + rmdr;
out_buf[18] = out_buf[18] & mask32c;
//printf (" %04x out_buf[18]\n",out_buf[18]);

out_buf[19] = in_buf[14];
out_buf[19] = out_buf[19] & mask32c;
//printf (" %04x out_buf[19]\n",out_buf[19]);

out_buf[20] = in_buf[15]>>4;
//printf (" %04x out_buf[20]\n",out_buf[20]);

out_buf[21] = in_buf[16]>>8;
//printf (" %04x\n",out_buf[21]);
rmdr = in_buf[15]<<8;
out_buf[21] = out_buf[21] + rmdr;
out_buf[21] = out_buf[21] & mask32c;
//printf (" %04x out_buf[21]\n",out_buf[21]);
out_buf[22] = in_buf[17]>>12;
rmdr = in_buf[16]<<4;
//printf (" %04x\n",rmdr);
out_buf[22] = out_buf[22] + rmdr;
out_buf[22] = out_buf[22] & mask32c;
//printf (" %04x out_buf[22]\n",out_buf[22]);

out_buf[23] = in_buf[17] & mask32c;
//printf (" %04x out_buf[23]\n",out_buf[23]);

out_buf[24] = in_buf[18]>>4;
//printf (" %04x out_buf[24]\n",out_buf[24]);


out_buf[25] = in_buf[19]>>8;
rmdr = in_buf[18]<<8;
//printf (" %04x\n",rmdr);
out_buf[25] = out_buf[25] + rmdr;
out_buf[25] = out_buf[25] & mask32c;
//printf (" %04x out_buf[25]\n",out_buf[25]);

}
/*****************************************************************************/
void vgr_edr::copy_to_hdr(U8* buf, int buf_len, int def_item_id)
{
// copy items shown in edr_hdr_maps in vgr_edr.h into EDR hdr 
// buf contains value from sfdu, buf_len its length 
//
// TRANS_BUF_STRUCT has 2 items, ->buf char with max size = 10
// 	and ->buf_len, its actual size
//  value is returned in hdr[]
  int i;
  int start_bit, start_byte ;
  TRANS_BUF_STRUCT* buf_ptr;

  static TRANS_BUF_STRUCT new_buf;
  buf_ptr = &new_buf;

//    buf_ptr = transfer items into  TRANS_BUF_STRUCT  buf_ptr;
    buf_ptr->buf_len = buf_len;
    memcpy(buf_ptr->buf, buf, buf_len);

    for (i=0; (edr_hdr_maps[i].item_id  < ITEM_99 )&& 
	      (edr_hdr_maps[i].item_id != def_item_id); i++);
    {
    if (edr_hdr_maps[i].item_id < ITEM_99) {

         start_bit = (int) (fmod((31 - edr_hdr_maps[i].start_bit), 8));
         start_byte = edr_hdr_maps[i].start_wd * 4 + 
                      ((31-edr_hdr_maps[i].start_bit) / 8);

// now transfer to hdr using edr_hdr_maps shown in vgr_edr.h
         bit_copy(&hdr[start_byte], buf_ptr, 
             	         start_bit, edr_hdr_maps[i].bit_len);
		if (debug_on == 3)
			{
                       	if (edr_hdr_maps[i].item_id ==item_14_GOLAY){
                        	printf("item_id = %d start_bit=%d buf=%02x   ", 
                        		edr_hdr_maps[i].item_id, start_bit, buf[0] );
				debug_print("_SEG_NO",&hdr[start_byte], 2);
			}
                }
    
         }
    }
		/* change do debug_on =2 on 11-18-2021 */
	if (debug_on == 3) {
    		printf ("vgr_edr::copy_to_hdr:  hdr[]\n");
		for (i=0;i<240;i++) {
			printf ("  %02x ",hdr[i]);
		}
		printf ("\n\n");
	}
//  delete[] buf_ptr;
} 

       
/*****************************************************************************/
int vgr_edr::overwrite_byte_to_hdr(U8* buf, int buf_len, int def_item_id)
{

  int i;
  int start_bit, start_byte ;

    for (i=0; (edr_hdr_maps[i].item_id  < ITEM_99 )&&
              (edr_hdr_maps[i].item_id != def_item_id); i++);

    if (edr_hdr_maps[i].item_id < ITEM_99) {

         start_bit = (int) (fmod((31 - edr_hdr_maps[i].start_bit), 8));
	 if (((int)fmod(32 - start_bit,8) !=0) || 
	      ((int)fmod(edr_hdr_maps[i].bit_len , 8) !=0)) {
	    printf("vgr_edr::overwrite_byte_to_hdr:  program error, exit!!\n");
	    return(FALSE);
	 } 
         
         start_byte = edr_hdr_maps[i].start_wd * 4 +
                      ((31-edr_hdr_maps[i].start_bit) / 8);

                if (debug_on == 3) {
                      printf("item_id = %d start_byte=%d hdr_addr=%d  ",
	                      edr_hdr_maps[i].item_id, start_byte, hdr);
		      printf("bit_len=%d  buf_len=%d  buf=%02x\n",
			      edr_hdr_maps[i].bit_len, buf_len, buf[0]);
		}

         if (buf_len < (edr_hdr_maps[i].bit_len/8))
	    memcpy(&hdr[start_byte], buf, buf_len);
 	 else
            memcpy(&hdr[start_byte], buf, edr_hdr_maps[i].bit_len/8);
    }
    else return (FALSE);
    return(TRUE);
}

/*****************************************************************************/
void vgr_edr::set_mf_dt_presence(int MF_no, U8* data_presence) 
{


   int tmp_MF_no;
   int type;

   type = data_mode_index();

   static int  eng_mf_parts;
   static int  eng_mf_stat;

   if (instr_no == ENG)
   {

	tmp_MF_no = (MF_no -1) / 5 + 1; 
	
	if (eng_mf_stat != tmp_MF_no)
	{
	   eng_mf_stat = tmp_MF_no;
	   eng_mf_parts = 0;
	}
	eng_mf_parts++;	
   }
   else 
   {     
        tmp_MF_no = (int)fmod(MF_no -1, 
			instr_info[type][instr_no].mfs_per_seg) +1;
   }
 
   if (instr_no == PRA)
   { 

      if  (fmod(C16_TO_U16(cur_sclk.m16), 2) ) {

                tmp_MF_no =  (int)fmod(MF_no + 20 -1,
                                  instr_info[type][instr_no].mfs_per_seg)
			     + 1;
      }
   }
    


   if ((instr_no == ENG) && (eng_mf_parts ==ENG_MF_PARTS )) 
   {
                if (tmp_MF_no <= 60)
                {
                        data_presence[(tmp_MF_no - 1) * 2] = 0x00;
                }

   }
   else { 
   	if  (instr_no != ENG)  
   	{
      		if (tmp_MF_no <= 75) 
      		{ 
       	 	   if (fmod(tmp_MF_no, 2))
   	   		data_presence[(tmp_MF_no - 1)/ 2] &= 0x0f;
      	  	   else
   	   		data_presence[(tmp_MF_no - 1)/ 2] &= 0xf0;
       		}
   	}
   }
		if (debug_on == 3) {
   int test_i;
			test_i =  DATA_PRESENCE_LOC+(tmp_MF_no - 1)/ 2;
			printf(" instr= %d  MF=%d  tmp_MF_no=%d  hdr [ %d ]=%x \n",
				instr_no, MF_no, tmp_MF_no,test_i, hdr[test_i]);
		} 
} 

/*****************************************************************************/
void vgr_edr::set_subhdr(vgr_sfdu& sfdu_obj, U16 MF_no, U16 m16, U16 m60, 
                         U16 ln_cnt)
{
/*
 * instr_no: crs=0, lecp=1, pls=2, pra=3, pws=4, uvs=5, eng=6, mag=7
 */
   int i;
   int sub_start_bit;

   sub_start_bit = 0;
   U8  buf[2];
   int type;
   int tmp_MF;

   VGR_SCET tmp_mf_scet;
   U32      msec_of_day;
   U8       u8_msec[4];
   U8*      src_ptr;
   U8*      tar_ptr;   

	if (debug_on == 2) 
			{
		printf("vgr_edr::set_subhdr-- MF_no=%d,  m60=%d, m16=%d, ln_cnt=%d\n",
         		MF_no, m60, m16, ln_cnt);
	}

   type = data_mode_index();

	     	if (debug_on == 3) {	
			printf("cur_data_mode = %x  type = %d\n",
				cur_data_mode, type);
		}
   switch (instr_no)
   {
/*---------------------------------------------------------------------------*/

    case PRA:

// 			printf("--PRA ");
//			 fflush(stdout);


     for (i=0; i < pra_subhdr_max; i++){
         if ( ( fmod(MF_no, instr_info[type][instr_no].mfs_per_seg)  == 
                  pra_subhdr_map[i].MF )
            && (fmod(m60, 8) == pra_subhdr_map[i].mod60) 
            && (ln_cnt == pra_subhdr_map[i].ln_cnt)) {

//??? can tell from here, sfdu_obj should separate
	     if (fmod(m16, 2))
	     tmp_MF =(int)(fmod(MF_no+20,instr_info[type][instr_no].mfs_per_seg));
	     else
	     tmp_MF = (int) (fmod(MF_no,
			 instr_info[type][instr_no].mfs_per_seg));
// D-68
	     if (debug_on == 1) {
	        printf ("  PRA: sub_hdr_ptr = %x before memcpy  tmp_MF = %d\n",sub_hdr_ptr,tmp_MF );
	     }

	     memcpy(sub_hdr_ptr + (tmp_MF/20)*4 + (int)( fmod(tmp_MF, 2) * 2), 
		    (sfdu_obj.get_data_bits( 
	             pra_subhdr_map[i].start_bit, 
		     pra_subhdr_map[i].bit_len))->buf,
                     2); 

                    if (debug_on == 2) 
			{

				printf(" ----PRA :: i*2 = %d \n", i*2);
               			printf(" --set_subhdr-- MF_no=%d,  m60=%d, m16=%d, ln_cnt=%d\n",
                        		MF_no, m60, m16, ln_cnt);
				debug_print("PRA subhdr::",sub_hdr_ptr + i*2, 2);
                     }
           
         }
     }

     break;
/*-----------------------------------------------------------------------------*/

    case UVS:
     i = 0;

    if (cur_data_mode == CR_5A) 
    {

    if (fmod(MF_no, 10) == 5) 
    {
       if (fmod(MF_no, 20) ==5) 
       {
        
         if (fmod(MF_no, 100)==25)    i += 2; 

         memcpy(sub_hdr_ptr + i, 
		(sfdu_obj.get_data_bits(
                 DATA_COMMAND_LOC, 16))->buf, 
		 2); 

                 if (debug_on == 3)
                 {
                        printf(" UVS MF=%d sub_hdr_ptr=%x  i=%d \n",
				MF_no, sub_hdr_ptr, i);
		}
 

        }
     }
     else 
     {
        for (i=0; i< uvs_subhdr_max; i++)
        {

	   if ( fmod(MF_no, 25) == uvs_subhdr_map[i].MF) 
	   {

	     if ( i > 2) 
  	     {
               subhdr_bit_copy(sub_hdr_ptr +4+(i-2)*2, 
		               (sfdu_obj.get_data_bits(
               		        uvs_subhdr_map[i].start_bit,
			        uvs_subhdr_map[i].bit_len))->buf,
               			16 - uvs_subhdr_map[i].bit_len, 
				uvs_subhdr_map[i].bit_len);
	
		if (debug_on == 3)
			{
			printf("UVS MF=%d  sub_hdr_ptr=%x  i=%d  bit_len=%d\n",
				MF_no, sub_hdr_ptr, i, uvs_subhdr_map[i].bit_len);
			}
	     }
	   break;
 	   }
        }
     }
    }
    else
    {
         if ( (fmod(m60, 4) == 0)  && (ln_cnt == 641 ) )
	 {
	    subhdr_bit_copy(sub_hdr_ptr, 
			   (sfdu_obj.get_data_bits( 161, 16))->buf,  
		       	   0, 16); 

         }
    }

    break;

/*-----------------------------------------------------------------------------*/
	    
/*
         if ((fmod(MF_no, 10) == uvs_subhdr_map[i].MF) &&
            (fmod(m60, 4) == uvs_subhdr_map[i].mod60) &&
            (m60 == (fmod(uvs_subhdr_map[i].mod60, 4) + 
                    (uvs_subhdr_map[i].MF / 20) * 4))  &&
            (ln_cnt == uvs_subhdr_map[i].ln_cnt)) {

            sub_start_bit += (MF_no / 20) * uvs_sub_sec_len ;

            subhdr_bit_copy(buf, (sfdu_obj.get_data_bits(
                     uvs_subhdr_map[i].start_bit,uvs_subhdr_map[i].bit_len))->,  
                     sub_start_bit, uvs_subhdr_map[i].bit_len); 
         }
*/

    case CRS:

     for (i=0; i < crs_subhdr_max; i++)
     {

         if ((fmod(MF_no, instr_info[type][instr_no].mfs_per_seg) ==
            crs_subhdr_map[i].MF) && ((MF_no / 60) == (m60 / 12)) &&
            (fmod(m60, 12) == crs_subhdr_map[i].mod60) &&
            (ln_cnt == crs_subhdr_map[i].ln_cnt)) 
	 {
	
		if (debug_on == 2)  {
			printf ("  =CRS:: mfs_per_seg = %d  MF = %d  ln_cnt = %d\n",
				instr_info[type][instr_no].mfs_per_seg,crs_subhdr_map[i].MF,crs_subhdr_map[i].ln_cnt);
			printf(" -CRS:: MF=%d start_bit=%d, bit_len=%d , i=%d\n",
				MF_no,crs_subhdr_map[i].start_bit, crs_subhdr_map[i].bit_len,i);
			debug_print("CRS:: buf=",(sfdu_obj.get_data_bits(
                            crs_subhdr_map[i].start_bit,
                             crs_subhdr_map[i].bit_len))->buf, 8);		//buf,2);
		}

            //  to use optimized map
            subhdr_bit_copy(sub_hdr_ptr + i*2, 
		            (sfdu_obj.get_data_bits( 
                             crs_subhdr_map[i].start_bit, 
			     crs_subhdr_map[i].bit_len))->buf,  
                	     16 - crs_subhdr_map[i].bit_len, 
			     crs_subhdr_map[i].bit_len); 

	    break;
         }  
     }

     break;
/*-----------------------------------------------------------------------------*/

   case PWS:

    
    tmp_MF = (int) fmod(MF_no, instr_info[type][instr_no].mfs_per_seg );

    if (tmp_MF == 0) 
	tmp_MF = 20;

    for (i=0; i < pws_subhdr_max; i++) 
    {

	if (fmod(tmp_MF, 5) == pws_subhdr_map[i].MF) 
	{
           if (ln_cnt == pws_subhdr_map[i].ln_cnt) 
	   {

		if (debug_on == 3)
			{
			  U8 tmp_buf[3];
			  memcpy(tmp_buf,( sfdu_obj.get_data_bits(
					  pws_subhdr_map[i].start_bit,
					  pws_subhdr_map[i].bit_len))->buf,
				 2);
			  printf("PWS:: subhdr->[%02x %02x] \n",
				tmp_buf[0], tmp_buf[1]);
		}

           subhdr_bit_copy(sub_hdr_ptr+ 2*i + pws_subhdr_max * 2*((tmp_MF-1)/5), 
             		   ( sfdu_obj.get_data_bits( 
			     pws_subhdr_map[i].start_bit,
                             pws_subhdr_map[i].bit_len))->buf,  
              		     16 - pws_subhdr_map[i].bit_len, 
			     pws_subhdr_map[i].bit_len); 
           }
         }
     };
     break;
/*-----------------------------------------------------------------------------*/

   case MAG: 
	src_ptr = sfdu_obj.get_data_ptr();
	src_ptr =  src_ptr + (int)(subhdr_info[type][PLS].sfdu_offset);
	src_ptr = src_ptr - 4; 			//rjb - 4-14-2021 fixes mag_edr - dont know why
	if (debug_on == 2)  {
		printf ("MAG:  print src_ptr to data_len for PLS\n");
                        for (i=0; i < subhdr_info[type][PLS].data_len; i++)
                        {
                           printf (" %X ",(src_ptr[i]&0xff));
                        }
                printf ("================\n\n");
	}

	tar_ptr =  sub_hdr_ptr + 32;
	tar_ptr = tar_ptr + 
                  ((int)(fmod(MF_no -1 , instr_info[type][PLS].mfs_per_seg))) 
                  * instr_info[type][PLS].mf_size;
			if (debug_on == 3)
			{
			printf("MAG:: src_ptr+ %d  tar_ptr+ %d  len=%d \n",
				src_ptr, tar_ptr);

                        printf("      subhdr_info[type][MAG].sfdu_offset = %d\n",
                                subhdr_info[type][MAG].sfdu_offset);
                        printf("      instr_info[type][MAG].mfs_per_seg = %d\n",
                                instr_info[type][MAG].mfs_per_seg);
                        printf("      instr_info[type][MAG].mf_size = %d\n",
                                instr_info[type][MAG].mf_size);
                        printf("      instr_info[type][MAG].data_len = %d\n",
                                subhdr_info[type][MAG].data_len);


			printf("      subhdr_info[type][PLS].sfdu_offset = %d\n",
				subhdr_info[type][PLS].sfdu_offset);
			printf("      instr_info[type][PLS].mfs_per_seg = %d\n",
				instr_info[type][PLS].mfs_per_seg);
			printf("      instr_info[type][PLS].mf_size = %d\n",
                                instr_info[type][PLS].mf_size);
			printf("      instr_info[type][PLS].data_len = %d\n",
                                subhdr_info[type][PLS].data_len);

//			(int)(subhdr_info[type][PLS].sfdu_offset),
//			((int)(fmod(MF_no -1 , instr_info[type][PLS].mfs_per_seg)))
//	                  * instr_info[type][PLS].mf_size + 32,
//			subhdr_info[type][PLS].data_len ;
			}

	memcpy(tar_ptr, src_ptr, subhdr_info[type][PLS].data_len);
/*-----------------------------------------------------------------------------*/

   case PLS:
 
     tmp_MF = (int) fmod(MF_no, instr_info[type][instr_no].mfs_per_seg) ;
     if (tmp_MF ==0)
	 tmp_MF = 20;
  
     if (first_MF == TRUE)
     { 
        get_scet( (tmp_mf_scet));
  	msec_of_day = fmod( C16_TO_U16(tmp_mf_scet.hr), 24) * 60 *60 *1000 +
		      C16_TO_U16(tmp_mf_scet.sec) * 1000    +
		      C16_TO_I16(tmp_mf_scet.msec);
 	U32_TO_C32(u8_msec, msec_of_day);
	subhdr_bit_copy(sub_hdr_ptr + 24,
			u8_msec,
			0,
			32 );
		if (debug_on == 3)
			printf("PLS:: u8_msec=[%02x %02x %02x %02x ]",
				u8_msec[0],u8_msec[1],u8_msec[2],u8_msec[3]);
     }

     for (i=0; i < mag_subhdr_max; i++) 
     {

//      if ( (fmod(MF_no, instr_info[type][instr_no].mfs_per_seg) == 
	if (
//	    (tmp_MF == mag_subhdr_map[i].MF) && 
	    (fmod(m60, 4) == mag_subhdr_map[i].mod60)
             && (ln_cnt == mag_subhdr_map[i].ln_cnt)) 
        {
 	   subhdr_bit_copy(sub_hdr_ptr + i*2, 
		           (sfdu_obj.get_data_bits(
	      		    mag_subhdr_map[i].start_bit, 
			    mag_subhdr_map[i].bit_len))->buf, 
              		    16 - mag_subhdr_map[i].bit_len,  
			    mag_subhdr_map[i].bit_len);

//			debug_print("MAG::", sub_hdr_ptr + i*2, 2);
//			printf(" i=%d \n",i);
   	} 
     }
     break; 

    //??????????????????????????????????????
    // stick msecs here
/*-----------------------------------------------------------------------------*/

   case LECP:


    for (i=0; i < lecp_subhdr_max; i++) {

        if ((fmod(MF_no, instr_info[type][instr_no].mfs_per_seg) ==
            lecp_subhdr_map[i].MF) 
//		&& (fmod(m60, 4) ==lecp_subhdr_map[i].mod60)
            	&& (ln_cnt == lecp_subhdr_map[i].ln_cnt)
	   ) 
	{
           
            subhdr_bit_copy(sub_hdr_ptr + i*2, 
	                    (sfdu_obj.get_data_bits(
               		     lecp_subhdr_map[i].start_bit, 
			     lecp_subhdr_map[i].bit_len))->buf,
                   	     16 - lecp_subhdr_map[i].bit_len, 
			     lecp_subhdr_map[i].bit_len);
         }
     }
     break;

  default:
// D-69
        if (debug_on == 1) {
		printf ("vgr_edr::set_subhdr:  case default - instr_no = %d   \n",instr_no);
	}

	break;

}  //switch   (instr_no)


}

/*****************************************************************************/
void vgr_edr::subhdr_bit_copy(unsigned char* subhdr, unsigned char* sfdu_data, 
              int start_bit,  int bit_len)
{
  int           start_byte;      // input data left justified
  int           start, i;

  start_byte = start_bit / 8;
  start = (int) fmod(start_bit, 8);



                  	if (debug_on == 3) {
                         	printf(" subhdr_bit_copy  start=%d bit_len=%d start_byte=%d  start_bit=%d \n",
					start,bit_len,start_byte,start_bit);
			}


  bit_shifting(sfdu_data, start, bit_len);            //???

 
  for (i = 0; i < (bit_len + start + 7)/8 ; i++) {
      subhdr[start_byte+i] |= sfdu_data[i];

		if (debug_on == 3) 
			{
			printf("vgr_edr::subhdr_bit_copy: i=%d start_byte+i =%d  [ %02x ]  sfdu_data[i] = %x\n ",i,start_byte+i, 
			subhdr[start_byte+i],sfdu_data[i]);
			}
  }
} 
/*****************************************************************************/
void vgr_edr::bit_shifting(unsigned char* sfdu_data, int start_bit, int bit_len)
{
 unsigned char R_mask, L_mask ;
 int      byt_len, i; 
 R_mask = L_mask = 0xFF;

 L_mask <<= start_bit;
 R_mask >>= (8 - start_bit); 

 byt_len = (bit_len + start_bit + 7) / 8; 

 for (i = byt_len; i > 0; i--) {
     sfdu_data[i] = ((sfdu_data[i]   & L_mask) >> start_bit)       |
                   ((sfdu_data[i-1] & R_mask) << (8 - start_bit));

		if (debug_on == 3)
			printf("bit_shifting:: sfdu_data[%d] = %02x  \t",
				i, sfdu_data[i]);
 }
 (sfdu_data[0] &= L_mask) >>= start_bit; 
		if (debug_on == 3)
			printf("  sfdu_data[0] = %02x \n",sfdu_data[0]);
}
 
/*****************************************************************************/
void vgr_edr::extract_hdr (EDR_STND_HDR* map_tbl, int max_item, vgr_sfdu& sfdu_obj) 
{     
/* extract from EDR_STND_HDR edr_hdr_maps[]  */
  int i, start_bit, start_byte;

  // edr_hdr_maps start from high order bit 31

  for (i = 0; (i < max_item) && (map_tbl[i].item_id < ITEM_99); i++) {
     
      if (map_tbl[i].copy_flg == PROC_NO) { 
         start_bit = (int) (fmod((31 - map_tbl[i].start_bit), 8));
	 start_byte = map_tbl[i].start_wd * 4 + ((31-map_tbl[i].start_bit) / 8);


		if (debug_on == 3)
			{
			  printf("map_tbl:: item_id=%d  start_byte=%d, start_bit=%d \n",
				  map_tbl[i].item_id, start_byte, start_bit);
			 }

            
//       bit_copy(&hdr[map_tbl[i].start_wd], 

         bit_copy(&hdr[start_byte], 
                sfdu_obj.get_field_by_hdrmap(map_tbl[i].item_id),
                start_bit, map_tbl[i].bit_len);
		if (debug_on == 2)
			{
			 if (map_tbl[i].item_id == item_35_BET)
				 printf ("item_35_BET = %02x \n",
				   hdr[start_byte] );
			}

      }
  }
   
}

/*****************************************************************************/
void vgr_edr::bit_copy(unsigned char* target, TRANS_BUF_STRUCT* source,
                       int start_bit, int bit_len)           
{
   int i, byte_len, bits_left;

   unsigned char R_mask, L_mask;
 
   U8* buf_ptr;

   buf_ptr = source->buf ;
 
   byte_len = (start_bit + bit_len + 7) / 8;
   
   if (byte_len < source->buf_len)
      buf_ptr = &source->buf[ (source->buf_len - byte_len)];

		if (debug_on == 3)
			{ 
         		for (i=0; i< byte_len; i++) {
	                	printf("buf[ %02x ]", buf_ptr[i]);
          		}
		}

if (byte_len > 1) 
{

   R_mask = L_mask = 0xFF;

   R_mask >>= (8 - start_bit);
   L_mask <<= start_bit;

//   			if (debug_on == 2)
//  			{
//
//  	  printf(" bit_copy: bit_len=%d,byte_len=%d, start_bit=%d, R-mask=%x, L=%x \n",
//  		bit_len, byte_len, start_bit, R_mask, L_mask);
//	  printf("source: ");
//	  for (i=0; i< byte_len; i++) {
//		printf(" %x ", buf_ptr[i]);
//	  }
//	  printf("\n");
//  			}
  
   for (i = byte_len ; i > 0; i--) {
       buf_ptr[i] = (buf_ptr[i] >> start_bit) | 
                   ((buf_ptr[i - 1] & R_mask) << (8 - start_bit));
   }             
  
   bits_left = 0xFF << (8 - (int)fmod(start_bit + bit_len, 8));
   
   buf_ptr[byte_len] &= bits_left;
}
else
{
   buf_ptr[0] = buf_ptr[0] >> start_bit;
}

   for (i = 0; i < byte_len; i++) {

			if (debug_on == 3) {
				printf(" before TARGET:: buf=%02x, target=%02x  ", 
					buf_ptr[0], target[i]);
 			}
       target[i] |= buf_ptr[i];

		if (debug_on == 3)
			{
			printf(" TARGET::  ");
	 		printf(" %02x ", target[i]);
			printf("\n");
		}
	}
}



/*****************************************************************************/
void vgr_edr::debug_print(const char* name, U8* buf, int len)
{
/* print a record, buf, in octal (and hexadecimal) of length len */
  int i;


  printf("%s -> ", name);
  for (i = 0; i < len; i++)
  {
    printf(" %o (%02x) ",  buf[i],buf[i]);
  }
  printf("\n");
}
/*****************************************************************************/
void vgr_edr::debug_print(const char* name, int len)
{
  int i;

  printf(" in debug_print \n");
  for (i = 0; i < len; i++)
  {
    printf("%s  (%X) \n", name, hdr[i]);
  }
}
/*****************************************************************************/
void vgr_edr::print_time_msg(const char* txt_msg, FILE* msg_Fd)
{   //
    //   try YYYY-DDDTHH:MM:SS MSEC
   char cmd[80]="";
   int  ert_day = cur_ert.hour/24;
   int  ert_hr =  (int)fmod(cur_ert.hour, 24);
   int  ert_sec = (int)fmod(cur_ert.sec, 60);
   int  ert_min = cur_ert.sec / 60;
   U16  U_m16, U_m60, U_ln_cnt;

   U_m16 = C16_TO_U16(cur_sclk.m16);   
   U_m60 = C16_TO_U16(cur_sclk.m60);
   U_ln_cnt = C16_TO_U16(cur_sclk.ln_cnt);

   if (first_rec == 1) {
	beg_ert_day = ert_day;
   }
   fprintf(msg_Fd, " %s \n\n", txt_msg);
   fprintf(msg_Fd, " SCET: %04d-%03dT%02d:%02d:%02d:%03d \n\n",
	   cur_scet.year, cur_scet.doy, cur_scet.hour, cur_scet.min,
	   cur_scet.sec, cur_scet.msec );

   fprintf(msg_Fd, " ERT:  20%02d-%03dT%02d:%02d:%02d:%03d \n\n",
	   cur_ert.year, ert_day, ert_hr, ert_min, ert_sec, cur_ert.msec);

   fprintf(msg_Fd, " SCLK: %d.%d.%d \n\n", U_m16, U_m60, U_ln_cnt); 

   fflush(msg_Fd);
}
/*****************************************************************************/
void vgr_edr::print_final_status(FILE* msg_Fd)
{
/* mv instrum_edr to instrumYRDOY.a or .b  */
   char cmd[80]="";
   int  ert_day = vgr_edr::cur_ert.hour/24;
   int  ert_yr  = (int)fmod(vgr_edr::cur_ert.year, 100);
   char  _sc;

 
    const char* instru_names[MAX_INSTR_NUM] = { "CRS",
			 		  "LECP",
                                        "PLS",
                                          "PRA",
                                          "PWS",
                                          "UVS",
                                          "ENG",
                                          "MAG"
                                        };

    const char* out_names[MAX_INSTR_NUM] = { "crs",
                                          "lec",
                                          "pls",
                                          "pra",
                                          "pws",
                                          "uvs",
                                          "eng",
                                          "mag"
                                        };


    const char* out_names_final[MAX_INSTR_NUM] = { "crsf",
                                          "lecf",
                                          "plsf",
                                          "praf",
                                          "pwsf",
                                          "uvsf",
                                          "engf",
                                          "magf"
                                        };

   if (sc_id > 0) _sc = 'a';
   else  _sc = 'b';

//    printf ("PRINT_FINAL_STATUS\n");
//    if (instr_num < MAX_INSTR_NUM)
    {
       fprintf(msg_Fd, 
	"%s\t has %d\t EDR records,  %d DECOM records & %d ENG records\n",
        instru_names[instr_no], phy_rec_no, decom_rec_no, eng_rec_no);
    }

    fflush(msg_Fd);

    fclose (out_fd[instr_no]);
/* change instrument edr filename from inst_edr to instYRDOY  */
/* D-70
	if (debug_on == 1) {
		printf ("print_final_status:: beg_ert_day = %d\n",beg_ert_day  );
		printf ("print_final_status:: end_ert_day = %d\n",end_ert_day  );
	}
*/
    if (beg_ert_day == 0) {
	beg_ert_day = end_ert_day;
    }    
    if (instr_no == UVS)
    {
    	if (FINAL) {
        	sprintf(cmd," mv %s  %3s%03d.%c", file_name_maps[instr_no],
               		out_names_final[instr_no],beg_ert_day,_sc);
    	} else {
    		sprintf(cmd," mv %s  %3s%03d.%c", file_name_maps[instr_no],
               		out_names[instr_no],beg_ert_day,_sc);
    	}
    }
    else
    {
    	if (FINAL) {
		sprintf(cmd," mv %s  %3s%02d%03d.%c", file_name_maps[instr_no],
              		 out_names_final[instr_no],ert_yr,beg_ert_day,_sc);
	} else {

    		sprintf(cmd," mv %s  %3s%02d%03d.%c", file_name_maps[instr_no],
               		out_names[instr_no],ert_yr,beg_ert_day,_sc);
	}
    }

    system (cmd);

} 
/*****************************************************************************/
/*   deprecated routines
 *
int vgr_edr::get_bit_rate_index(unsigned long bit_rate)
{

   int i;

        for (i=1; i <= MAX_BIT_RATE_NO; i++)
        {
          if (bit_rate_tbl[i] == bit_rate)
             break;
        }
        if (i > MAX_BIT_RATE_NO)
           i = FALSE;
        return(i);
}
*****************************************************************************
U8 vgr_edr::last_stat_value(int item_id)
{
   for (i = 0; i < MAX_LAST_STAT; i++)
   {
      if (last_stat_items[i] == item_id) 
         break;
   }
   if (i < MAX_LAST_STAT)
      return (last_stat_tbl[i]);
   else
      return (FALSE);
}
*****************************************************************************
void vgr_edr::store_last_sclk( sfdu& sfoc_data)
//
{
   memcpy(last_sclk, sfdu_obj.get_sclk(), sizeof(last_sclk));
} 
*/

