/**************************************************************************
TITLE:  copy_util.C

AUTHOR:         $Judy Yi
CREATED:        Aug 4, 1994
COMPILER:       gcc 4.5.2
OS:		Solaris 10.2
Modified:       Ray Bambery - 11-18-2020
		removed debug_on statements
		Ray Bambery - 4-6-2021
		implemented debug_on == 1 or 2
                Ray Bambery - 5-17-2021
                added debug_on lines where necessary
		Ray Bambery - 01-07-2022
    		final debug printfs removed (//#)	

get_bits_given_bytes			vgr_sfdu::get_data_bits
get_bits_per_byte			NOT USED
bit_OR_copy				NOT USED
bit_R_shifting				bit_OR_copy
bit_OR_copy_from_Rjust_buf		NOT USED
expend_bit_fields_Rjust			vgr_edr::copy_MF_data_block

****************************************************************************/
#include <stdlib.h>
#include <memory.h>
#include <math.h>
#include <string.h>
#include <stdio.h>

#include "type_conv.H"
#include "vgr_struc.H"

/* prototypes */
TRANS_BUF_STRUCT* 
get_bits_given_bytes (U8* src_buf, int start_bit, int bit_len); 

U8
get_bits_per_byte(U8 src_char, int start_bit, int bit_len);

void
bit_OR_copy(U8 * dest_buf, U8* src_buf,
            int start_bit,  int bit_len);

void 
bit_R_shifting(unsigned char* src_buf, int start_bit, int bit_len);

void
bit_OR_copy_from_Rjust_buf(unsigned char* target,
                           TRANS_BUF_STRUCT* source,
                           int start_bit, int bit_len);

void
expend_bit_fields_Rjust(U8* in_buf, int in_buf_len, int in_bit_len,
                        U8* out_buf, int out_bit_len, int out_buf_len);


//------------------------------------------------------------------------
// ** from vgr_sfdu::get_bits_given_byt
//------------------------------------------------------------------------


TRANS_BUF_STRUCT*  
get_bits_given_bytes (U8* src_buf, int start_bit, int bit_len) 
{
  int i, byte_len;

  static TRANS_BUF_STRUCT data_buf ; 
  unsigned char R_mask, L_mask ;


  memset(&data_buf.buf[0], 0, DATA_TRANSFER_SIZE);

  if (bit_len > (DATA_TRANSFER_SIZE * 8)) {
     printf ("copy_util: get_bits_given_byt: data transfer buffer size is bigger that %d \n", 
              DATA_TRANSFER_SIZE);
     exit(0);
  }
 
  R_mask = L_mask = 0xFF;

  R_mask >> start_bit;
  L_mask << (8 - start_bit);

  byte_len   = (start_bit + bit_len + 7) / 8;

/*
                        if (debug_on)
                        printf(" start_bit=%d,bit_len=%d, byt-len=%d\n ",
                                 start_bit, bit_len, byte_len);
*/

  memcpy((unsigned char*)&data_buf.buf[0], src_buf , byte_len);

  if (start_bit > 0) { 
     for (i = 0; i < byte_len; i++) {
         data_buf.buf[i] = ((data_buf.buf[i]   & R_mask) << start_bit)       |
                           ((data_buf.buf[i+1] & L_mask) >> (8 - start_bit));
     } 
  }
  data_buf.buf_len = byte_len;
/*
                                if (debug_on)
                                {
                                  printf("sfdu: ");
                                  for (i = 0; i< byte_len; i++) {
                                  printf(" %x", data_buf.buf[i]);
                                  }
                                  printf(" \n");
                                }       
*/
  return (&data_buf);
   
}


//---------------------------------------------------------------------
// how to connect position parameters & subroutine ptrs together????
// ? need to modify
// ** from vgr_sfdu::get_byte_val
//---------------------------------------------------------------------
U8 get_bits_per_byte(U8 src_char, int start_bit, int bit_len)
{
    unsigned char return_val;
    unsigned char mask_val = 0xff;

    mask_val >> (8 - start_bit - bit_len) << (8 - start_bit - bit_len);
    mask_val << start_bit >> start_bit; 


    return_val = ( src_char & mask_val) >> (8 - bit_len);
    return (return_val);
}
    
//---------------------------------------------------------------------n
// ** from vgr_edr::subhdr_bit_copy
//----------------------------------------------------------------------

void 
bit_OR_copy(U8 * dest_buf, U8* src_buf, 
                              int start_bit,  int bit_len)
{
  int           start_byte;      // input data left justified
  int           start, i;

  start_byte = start_bit / 8;
  start = (int) fmod(start_bit, 8);



//                                if (debug_on == 2) {
//                                printf(" subhdr_bit_copy  start=%d bit_len=%d start_byte=%d  start_bit=%d \n",
//                                start,bit_len,start_byte,start_bit);
//                                }


  bit_R_shifting(src_buf, start, bit_len);            //???

 
  for (i = 0; i < (bit_len + start + 7)/8 ; i++) {
      dest_buf[start_byte+i] |= src_buf[i];
  }
} 
//----------------------------------------------------------------------
// ** from vgr_edr::bit_shifting
//----------------------------------------------------------------------
void bit_R_shifting(unsigned char* src_buf, int start_bit, int bit_len)
{
 unsigned char R_mask, L_mask ;
 int      byt_len, i; 
 R_mask = L_mask = 0xFF;

 L_mask <<= start_bit;
 R_mask >>= (8 - start_bit); 

 byt_len = (bit_len + start_bit + 7) / 8; 

 for (i = byt_len; i > 0; i--) {
     src_buf[i] = ((src_buf[i]   & L_mask) >> start_bit)       |
                   ((src_buf[i-1] & R_mask) << (8 - start_bit));
 }
 (src_buf[0] &= L_mask) >>= start_bit; 
}
//----------------------------------------------------------------------
// ** from vgr_edr::bit_copy
//----------------------------------------------------------------------
void 
bit_OR_copy_from_Rjust_buf(unsigned char* target, 
				 TRANS_BUF_STRUCT* source,
                       		 int start_bit, int bit_len)           
{
   int i, byte_len, bits_left;

   unsigned char R_mask, L_mask;
 
   U8* buf_ptr;

   buf_ptr = source->buf ;
 
   byte_len = (start_bit + bit_len + 7) / 8;
   
   if (byte_len < source->buf_len)
      buf_ptr = &source->buf[ (source->buf_len - byte_len)];

   R_mask = L_mask = 0xFF;

   R_mask >>= (8 - start_bit);
   L_mask <<= start_bit;

//                      if (debug_on == 2)
//                      {
//
//        printf(" bit_copy: bit_len=%d,byte_len=%d, start_bit=%d, R-mask=%x, L=%x \n",
//              bit_len, byte_len, start_bit, R_mask, L_mask);
//        printf("source: ");
//        for (i=0; i< byte_len; i++) {
//              printf(" %x ", buf_ptr[i]);
//        }
//        printf("\n");
//                      }
  
   for (i = byte_len ; i > 0; i--) {
       buf_ptr[i] = (buf_ptr[i] >> start_bit) | 
                   ((buf_ptr[i - 1] & R_mask) << (8 - start_bit));
   }             
  
   bits_left = 0xFF << (8 - (int)fmod(start_bit + bit_len, 8));
   
   buf_ptr[byte_len] &= bits_left;

   for (i = 0; i < byte_len; i++) {
       target[i] |= buf_ptr[i];

   }
//                      if (debug_on == 2) printf("\n");
}


//----------------------------------------------------------------------
// expending N-bit fields into M-bit fields
//----------------------------------------------------------------------
void expend_bit_fields_Rjust(U8* in_buf, int in_buf_len, int in_bit_len, 
	                     U8* out_buf, int out_buf_len, int out_bit_len)
{

  int i;
  int byte_len;
  int in_offset, out_offset;
  int start_in_bit, bits_left;
  U8  tmp_buf[4];

       if (debug_on == 2) {
		printf ("expend_bit_fields_Rjust: in_buf_len = %d  out_buf_len = %d  in_bit_len = %d  out_bit_len = %d\n",
			in_buf_len,out_buf_len,in_bit_len,out_bit_len);
		for (i=0;i<in_buf_len;i++) {
		printf ("expend_bit_fields_Rjust :  in_buf[i=%d] =  %X\n",i,in_buf[i]);
		}
	}
  if ((int)fmod(out_bit_len, 8) > 0  || ((out_bit_len + 7)/ 8 > 4)) 
  {
     printf("copy_util: expend_bit_fields_Rjust:  cann't expend to bit length %d \n",out_bit_len);
     exit(0);
  }

  byte_len  = (in_bit_len + 7) / 8;
  in_offset = out_offset  = 0;
  // start_bit = 8 - (int)( fmod(in_bit_len, 8) );
  bits_left = 16;

  start_in_bit = 0;

  if ( ((out_bit_len + 7)/ 8 ) == 2 ) {

     U32 mask32, buf32;
     U8  tmp_buf[4];

 
     for(  out_offset= 0;  (out_offset *2) < out_buf_len && 
	in_offset < in_buf_len; out_offset++ )

     { 

       mask32 = U32MASK( start_in_bit, in_bit_len);

       bits_left = (byte_len * 8) - (in_bit_len + start_in_bit );

		if (debug_on == 2) {
	printf(" out_offset=%d  in_offset=%d bits_left=%d byte_len=%d \n",
	 out_offset,  in_offset, bits_left, byte_len);

//			fflush(stdout);
		}

       memcpy(tmp_buf, in_buf + in_offset, 2);
 
		if (debug_on == 2) { 
		    printf("expend_bit_fields_Rjust:  [%02x %02x] ", 
			tmp_buf[0], tmp_buf[1]);   
			printf ("\n");
		}
//       buf32 = (C32_TO_U32(tmp_buf) & mask32) >> bits_left;

//			if (debug_on == 2) {
//			printf(" & %08x ", mask32);
//			printf(" -> %08x ", buf32);
//			}

       U32_TO_C32(tmp_buf, buf32);
//			if (debug_on == 2) {
//                        printf("[%02x %02x %02x %02x] \n", 
//                        tmp_buf[0], tmp_buf[1],tmp_buf[2], tmp_buf[3 ]);
//			}

       memcpy ((char*)(&out_buf[ out_offset * 2]),
               (char*)&tmp_buf[0], 
	       byte_len);

//			if (debug_on == 2)
//			printf(" outbuf[%d]:: ---[%02x %02x] \n",
//		 	out_offset,out_buf[ out_offset*2], 
//			out_buf[ out_offset*2+1]);
/*
       memcpy((char*)(out_buf + out_offset), 
              (char*)(((C32_TO_U32(in_buf + in_offset) & mask32)) >> bits_left),
               byte_len);
*/


       start_in_bit = 8 - (int) fmod(bits_left, 8) ;
       start_in_bit -= ((start_in_bit / 8 ) * 8);
       in_offset  +=  (in_bit_len - bits_left + 7) / 8;


      }
	if (debug_on == 2) {
            for (i=0;i<out_buf_len;i++) {
                 printf ("expend_bit_fields_Rjust :  out_buf[i=%d] =  %X\n",i,out_buf[i]);

          }
      }
//			printf("** in_buf [");
//			for(i = 0; i < in_buf_len ; i++)
//			{
//			 printf(" %2x", in_buf[i]);
//			}
//			printf(" ] \n -> ");
//                        for(i = 0; i < out_buf_len; i++)
//                        {
//                         printf(" %2x", out_buf[i]);
//                        }
//			}

  }
}
