/* $Id: s3_shk.h,v 1.3 1998/12/07 18:12:39 ad Exp $	     */
#include "hdfi.h"

struct sshshk{
	uint32 sctime_readout;	/* 32 bit spacecraft time  */
	float64 sctime_collection; /* spacecraft time, sub-second resolution */

	uint32 QAC;	/* number of missing frames in this SR */

	uint8 HKSECTOR;	/* Housekeeping Sector    */
	uint8 P5I;	/* +5V I    */
	uint8 M5I;	/* -5V I    */
	uint8 P15I;	/* +15V I    */
	uint8 M15I;	/* -15V I    */
	uint8 P5V;	/* +5V     */
	uint8 M5V;	/* -5V     */
	uint8 P15V;	/* +15V     */
	uint8 M15V;	/* -15V     */
	uint8 _30KI;	/* 30kV I    */
	uint8 _30KV;	/* 30kV     */
	uint8 _2KI;	/* 2kV I    */
	uint8 _2KV;	/* 2kV     */
	uint8 _75I;	/* 75V I    */
	uint8 _75V;	/* 75V     */
	uint8 P5T;	/* +/-5V Temp.    */
	uint8 P15T;	/* +/-15V Temp.    */
	uint8 _2KAV;	/* 2kV A    */
	uint8 _2KBV;	/* 2kV B    */
	uint8 _2KCV;	/* 2kV C    */
	uint8 VAL1I;	/* Valve PC 1 I  */
	uint8 VAL2I;	/* Valve PC 2 I  */
	uint8 VAL3I;	/* Valve PC 3 I  */
	uint8 VAL1V;	/* Valve PC 1 V  */
	uint8 VAL2V;	/* Valve PC 2 V  */
	uint8 VAL3V;	/* Valve PC 3 V  */
	uint8 BASET;	/* Base Temp.    */
	uint8 SSD1T;	/* SSD 1 Temp.   */
	uint8 SSD2T;	/* SSD 2 Temp.   */
	uint8 SSD3T;	/* SSD 3 Temp.   */
	uint8 TANKT;	/* Tank Temp.    */
	uint8 EBOXT;	/* E-box Temp.    */
	uint8 HV30T;	/* HV Temp.    */
	uint8 COLLT;	/* Collimator Temp.    */
	uint8 PC1T;	/* PC 1 Temp.   */
	uint8 PC2T;	/* PC 2 Temp.   */
	uint8 PC3T;	/* PC 3 Temp.   */
	uint8 GRMT;	/* GRM Temp.    */
	uint8 FILL1;	/* Fill Time PC 1  */
	uint8 FILL2;	/* Fill Time PC 2  */
	uint8 FILL3;	/* Fill Time PC 3  */
	uint8 POWERS;	/* Power Status    */
	uint8 RELAYS;	/* Relay Status    */
	uint8 OVERI;	/* Over Currents    */
	uint8 P15LIM;	/* +15V Current Limit   */
	uint8 M15LIM;	/* -15V Current Limit   */
	uint8 P5LIM;	/* +5V Current Limit   */
	uint8 M5LIM;	/* -5V Current Limit   */
	uint8 _30KSTATH;	/* 30kV Discharge    */
	uint8 _30KSET;	/* 30kV Set Value   */
	uint8 _30KSTATL;	/* 30kV Plug Status   */
	uint8 _2KASTATH;	/* 2kV A Discharge   */
	uint8 _2KASET;	/* 2kV A Set Value  */
	uint8 _2KASTATL;	/* 2kV A Plug Status  */
	uint8 _2KBSTATH;	/* 2kV B Discharge   */
	uint8 _2KBSET;	/* 2kV B Set Value  */
	uint8 _2KBSTATL;	/* 2kV B Plug Status  */
	uint8 _2KCSTATH;	/* 2kV C Discharge   */
	uint8 _2KCSET;	/* 2kV C Set Value  */
	uint8 _2KCSTATL;	/* 2kV C Plug Status  */
	uint8 _75STATH;	/* 75V Discharge    */
	uint8 _75SET;	/* 75V Set Value   */
	uint8 _75STATL;	/* 75V Plug Status   */
	uint16 PC1P;	/* PC 1 Pres.   */
	uint16 PC2P;	/* PC 2 Pres.   */
	uint16 PC3P;	/* PC 3 Pres.   */
	uint16 LINEP;	/* line Pres.    */
	uint8 PC1O;	/* PC 1 On/Off   */
	uint8 PC2O;	/* PC 2 On/Off   */
	uint8 PC3O;	/* PC 3 On/Off   */
	uint8 ALARMS;	/* Alarm Flags    */
	uint8 FAN1MODE;	/* Fan 1 Mode   */
	uint8 FAN1BASE;	/* Fan 1 Baseline Subtr.  */
	uint8 FAN1LOGIC;	/* Fan 1 SSD Logic  */
	uint8 FAN1PCY;	/* Fan 1 Valid PC  */
	uint8 FAN1PCZ;	/* Fan 1 Valid PC  */
	uint8 FAN1SSD;	/* Fan 1 Valid SSD  */
	uint8 FAN1BANK;	/* Fan 1 Memory Bank  */
	uint8 FAN1BLOCK;	/* Fan 1 Memory Block  */
	uint8 FAN1DATA;	/* Fan 1 Data Selected  */
	uint8 FAN2MODE;	/* Fan 2 Mode   */
	uint8 FAN2BASE;	/* Fan 2 Baseline Subtr.  */
	uint8 FAN2LOGIC;	/* Fan 2 SSD Logic  */
	uint8 FAN2PCY;	/* Fan 2 Valid PC  */
	uint8 FAN2PCZ;	/* Fan 2 Valid PC  */
	uint8 FAN2SSD;	/* Fan 2 Valid SSD  */
	uint8 FAN2BANK;	/* Fan 2 Memory Bank  */
	uint8 FAN2BLOCK;	/* Fan 2 Memory Block  */
	uint8 FAN2DATA;	/* Fan 2 Data Selected  */
	uint8 FAN3MODE;	/* Fan 3 Mode   */
	uint8 FAN3BASE;	/* Fan 3 Baseline Subtr.  */
	uint8 FAN3LOGIC;	/* Fan 3 SSD Logic  */
	uint8 FAN3PCY;	/* Fan 3 Valid PC  */
	uint8 FAN3PCZ;	/* Fan 3 Valid PC  */
	uint8 FAN3SSD;	/* Fan 3 Valid SSD  */
	uint8 FAN3BANK;	/* Fan 3 Memory Bank  */
	uint8 FAN3BLOCK;	/* Fan 3 Memory Block  */
	uint8 FAN3DATA;	/* Fan 3 Data Selected  */
	uint8 PC1YTH;	/* PC 1 Y Threshold  */
	uint8 PC1ZTH;	/* PC 1 Z Threshold  */
	uint8 PC2YTH;	/* PC 2 Y Threshold  */
	uint8 PC2ZTH;	/* PC 2 Z Threshold  */
	uint8 PC3YTH;	/* PC 3 Y Threshold  */
	uint8 PC3ZTH;	/* PC 3 Z Threshold  */
	uint8 SSD1TH;	/* SSD 1 Threshold   */
	uint8 BIT1PERIOD;	/* BIT 1 Period   */
	uint8 SSD2TH;	/* SSD 2 Threshold   */
	uint8 BIT2PERIOD;	/* BIT 2 Period   */
	uint8 SSD3TH;	/* SSD 3 Threshold   */
	uint8 BIT3PERIOD;	/* BIT 3 Period   */
	uint8 DEDX1TH;	/* dEdX 1 Threshold   */
	uint8 DEDX2TH;	/* dEdX 2 Threshold   */
	uint8 DEDX3TH;	/* dEdX 3 Threshold   */
	uint8 DET1TRIG;	/* CAMEX 1 Trigger   */
	uint8 DET1EVENT;	/* Valid Event 1 Condition  */
	uint8 DET1GAIN;	/* SSD 1 CAMEX Gain  */
	uint16 DET1CHANNELS;	/* BIT 1 Channels   */
	uint8 DET2TRIG;	/* CAMEX 2 Trigger   */
	uint8 DET2EVENT;	/* Valid Event 2 Condition  */
	uint8 DET2GAIN;	/* SSD 2 CAMEX Gain  */
	uint16 DET2CHANNELS;	/* BIT 2 Channels   */
	uint8 DET3TRIG;	/* CAMEX 3 Trigger   */
	uint8 DET3EVENT;	/* Valid Event 3 Condition  */
	uint8 DET3GAIN;	/* SSD 3 CAMEX Gain  */
	uint16 DET3CHANNELS;	/* BIT 3 Channels   */
	uint16 ACTRCTRL;	/* ACTR Control Register   */
	uint8 FANPRIOR;	/* Fan Priority    */
	uint16 ACTRSAMPLE;	/* ACTR Sample Register   */
	uint8 ALARMOP3;	/* Overpressure Fan 3   */
	uint8 ALARMOP2;	/* Overpressure Fan 2   */
	uint8 ALARMOP1;	/* Overpressure Fan 1   */
	uint8 ALARMUP3;	/* Underpressure Fan 3   */
	uint8 ALARMUP2;	/* Underpressure Fan 2   */
	uint8 ALARMUP1;	/* Underpressure Fan 1   */
	uint8 ALARMDISCHG;	/* Discharge Alarm    */
	uint8 ALARM30KI;	/* 30kV I Alarm   */
	uint8 ALARM30KV;	/* 30kV Alarm    */
	uint8 ALARM2KVC;	/* 2kV C Alarm   */
	uint8 ALARM2KVB;	/* 2kV B Alarm   */
	uint8 ALARM2KVA;	/* 2kV A Alarm   */
	uint8 ALARM2KI;	/* 2kV I Alarm   */
	uint8 ALARM2KV;	/* 2kV Alarm    */
	uint8 ALARM75I;	/* 75V I Alarm   */
	uint8 ALARM75V;	/* 75V Alarm    */
	uint8 ALARMM15I;	/* -15V I Alarm   */
	uint8 ALARMM15V;	/* -15V Alarm    */
	uint8 ALARMP15I;	/* +15V I Alarm   */
	uint8 ALARMP15V;	/* +15V Alarm    */
	uint8 ALARMM5I;	/* -5V I Alarm   */
	uint8 ALARMM5V;	/* -5V Alarm    */
	uint8 ALARMP5I;	/* +5V I Alarm   */
	uint8 ALARMP5V;	/* +5V Alarm    */
};
