#include <stdio.h>
#include <string.h>

#include "uleis_hskp.h"
#include "df.h"

void main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, SD_id;
  struct UHskpSet testdata;
  int ii,jj,kk,retval;

  if (argc!=2)
    {
      printf("Usage: %s hdf_file\n",argv[0]);
      exit(1);
    }

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_READ, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);
  if ((SD_id=SDstart(argv[1], DFACC_RDONLY))==FAIL)
    {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
    }

  init_rd_uleis_hskp(hdf_fp, SD_id);

  /* read and print data */
printf("Sample of ULEIS housekeeping:\n");
ii=0;
  while((retval=read_uleis_hskp(&testdata,ii))!=-1) {
    printf("ii=%4d sctime=%10u QAC=%3d\n", 
	    ii++, testdata.output_sctime, testdata.QAC);
    printf("dumps this data block=%4d \n",testdata.dump_flg[128]);
    printf("status TLM's this data block=%4d \n",testdata.stat_tlm_flg[128]);
    printf("Instrument Deck Temp: ");
    for(jj=0;jj<8;jj++) { 
	printf("%4d ",testdata.DeckTemp[jj]);
    }
    printf("\n\n");
  }

  /* all done, close HDF interface */

  close_rd_uleis_hskp();
  Vend(hdf_fp);
  SDend(SD_id);
  if (Hclose(hdf_fp)==FAIL)
    {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }
  exit(0);
}
    
