#include <stdio.h>
#include <string.h>

#include "swepam_itt.h"
#include "df.h"

void main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, SD_id;
  struct TELI testdata;
  int ii,jj,kk,retval;

  if (argc!=2)
    {
      printf("Usage: %s hdf_file\n",argv[0]);
      exit(1);
    }

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_READ, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);
  if ((SD_id=SDstart(argv[1], DFACC_RDONLY))==FAIL)
    {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
    }

  init_rd_swepam_itt(hdf_fp, SD_id);

  /* read and print data */
  ii=0;
  while((retval=read_swepam_itt(&testdata,ii))!=-1) {
    printf("ii=%4d %10u %3d %3d %3d\n", 
	    ii++, testdata.output_sctime, testdata.QAC,
	    testdata.I_InstPS,testdata.I_OrdState);
    for(jj=0;jj<8;jj++)
	printf("\t%4d %4d %4d %4d %6d %4d\n", 
		testdata.SCid[jj], testdata.FmtFC[jj], 
		testdata.FmtID[jj], testdata.EF[jj], 
		testdata.CS[jj], testdata.DB[jj]);
    printf("\n");
    for(jj=0;jj<8;jj++)
	printf("\t%4d %4d %4d %4d %4d %4d\n", 
		testdata.HVMON1[jj], testdata.HVMON2[jj], 
		testdata.PSMON[jj], testdata.I_TMon[jj], 
		testdata.I_IMon[jj], testdata.I_IFTMon[jj]);
  }

  /* all done, close HDF interface */

  close_rd_swepam_itt();
  Vend(hdf_fp);
  SDend(SD_id);
  if (Hclose(hdf_fp)==FAIL)
    {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }
  exit(0);
}
    
