#include <stdio.h>
#include <string.h>

#include "s3_mbasic.h"
#include "df.h"

void main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, SD_id;
  struct mbasic testdata;
  int ii,jj,kk,retval;

  if (argc!=2)
    {
      printf("Usage: %s hdf_file\n",argv[0]);
      exit(1);
    }

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_READ, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);
  if ((SD_id=SDstart(argv[1], DFACC_RDONLY))==FAIL)
    {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
    }

  init_rd_s3_mbasic(hdf_fp, SD_id);

  /* read and print data */
  ii=0;
  while((retval=read_s3_mbasic(&testdata,ii))!=-1) {
    printf("ii=%4d %10u %6d\n", ii++, testdata.sctime_readout, testdata.QAC);
    for(jj=0;jj<MBAS_CSZ;jj++) { 
	for(kk=0;kk<MBAS_CYC;kk++)  { 
		printf("%2x ",testdata.BASIC[kk][jj]);
                if((kk%12)==11) printf("\n");
	}
     printf("\n");
    }
     printf("\n");
  }

  /* all done, close HDF interface */

  close_rd_s3_mbasic();
  Vend(hdf_fp);
  SDend(SD_id);
  if (Hclose(hdf_fp)==FAIL)
    {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }
  exit(0);
}
    
