/* $Id: s3schk.h,v 1.1 1997/05/07 16:43:45 jeff Exp $ */
#include "hdfi.h"

struct s3schk    /* Spacecraft housekeeping data for S3 instruments */
{

    uint32 sctime_readout;   /* Readout time */

    /* Sepica SCHK values */
    uint8 S3PwrCvtVol;       /* S3DPU power converter voltage */
    uint8 S3Cur;             /* S3DPU current */
    uint8 S3ConSecCur;       /* S3DPU converter secondary curent */
    uint8 S3PowSupATmp;      /* S3DPU Power Supply A temp */
    uint8 S3Log;             /* S3DPU Logic and telltale bits */
				/* bit 7: Power conv sel telltale */
				/* bit 6: Interface A/B select */
				/* bit 5: Converter A power */
				/* bit 4: Converter B power */
				/* bits 3-0: not used */


    /* Sepica SCHK values */
    uint8 SepDecTmp;        /* Deck temperature near Sepica */
    uint8 SepCur;           /* Sepica current */
    uint8 SepIsoButTmp;     /* Sepica Iso-butane tank temp */
    uint8 SepLog;           /* Sepica logic and telltales */
				/* bit 7: Sepica Gas Valve */
				/* bit 6: Sepica Main Power */
				/* bit 5: Sepica Internal Heater (1&2)*/
				/* bit 4: Sepica Interface Heater */
				/* bits 3-0: Unused */

    /* Swics SCHK values */
    uint8 SwcCur;              /* SWICS current */
    uint8 SwcIntTmp;           /* SWICS internal temp */
    uint8 SwcLog;              /* SWICS logic and telltales */
				/* bit 7: SWICS Main Power */
				/* bit 6: SWICS Internal heaters */
				/* bit 5: SWICS Interface heaters */
				/* bit 4: SWICS Pyro Main/Backup */
				/* bits 3-0: Unused */

    /* Swims SCHK values */
    uint8 SwmCur;              /* SWIMS current */
    uint8 SwmIntTmp;           /* SWIMS Internal Temp */
    uint8 SwmLog;              /* SWICS logic and telltales */
				/* bit 7: SWIMS Cover Telltale */
				/* bit 6: SWIMS Main Power */
				/* bit 5: SWIMS Internal Heater */
				/* bit 4: SWIMS Interface Heater */
				/* bit 3: SWIMS Pyro Main/Backup */
				/* bits 2-0: Unused */
};
