/* $Id: s3_ssector.h,v 1.4 1997/05/06 19:13:01 jeff Exp $	     */
#include "hdfi.h"

#define SSEC_N     20  /* number of matrix rates */
#define SSEC_S     8  /* number of sectors */
#define SSEC_CYC   6  /* number of cycles per SR = 60 / 10 */

 /* total size (in bytes) of SMON data (including slack) in a full SR */
#define SSEC_TSZ   1440  

 /* size (in bytes) of SSEC cycle (including slack) */
#define SSEC_CSZ   SSEC_TSZ/SSEC_CYC 

#define SSEC_ESZ   SSEC_TSZ/60  /* size (in bytes) of SSEC area in EDB */


struct ssector{

	uint32 sctime_readout;	/* 32 bit spacecraft time  */
	uint32 sctime_collection;/* 32 bit spacecraft time  */
	uint32 QAC;	/* Number of missing frames in this SR */

	uint16 SECTOR[SSEC_CYC][SSEC_N][SSEC_S];/* Sector rates */
};
