/* $Id: s3_smonitor.h,v 1.5 1997/05/06 19:13:01 jeff Exp $	     */
#include "hdfi.h"

#define SMON_N     12  /* number of monitor rates */
#define SMON_S     8  /* number of sectors */
#define SMON_CYC   12  /* number of cycles per SR = 60 / 5 */
#define SMON_NFILL 4  /* amount of fill data elements */

 /* total size (in bytes) of SMON data (including slack) in a full SR */
#define SMON_TSZ   1800 

 /* size (in bytes) of SMON cycle (including slack) */
#define SMON_CSZ   SMON_TSZ/SMON_CYC 
#define SMON_ESZ   SMON_TSZ/60  /* size (in bytes) of SMON in EDB */

struct smonitor{

	uint32 sctime_readout;	   /* 32 bit spacecraft time  */
	uint32 sctime_collection;  /* 32 bit spacecraft time  */
	uint32 QAC;	/* number of missing frames in this SR */

	uint16 MONITOR[SMON_CYC][SMON_N][SMON_S];/* Monitor rates */
        uint16 FILL[SMON_CYC][SMON_NFILL];    /* Fill  data   */
};
