/* $Id: s3_sbasic.h,v 1.5 1997/05/06 18:03:52 jeff Exp $	     */
#include "hdfi.h"

#define SBAS_N     16  /* number of matrix rates */
#define SBAS_S     8  /* number of sectors */
#define SBAS_CYC   12  /* number of cycles per SR = 60 / 5 */
#define SBAS_NFILL 2  /* amount of fill data per cycle */

 /* total size (in bytes) of SMON data (including slack) in a full SR */
#define SBAS_TSZ   2340  

 /* size (in bytes) of SMON cycle (including slack) */
#define SBAS_CSZ   SBAS_TSZ/SBAS_CYC 
#define SBAS_ESZ   SBAS_TSZ/60  /* size (in bytes) of SBAS area in EDB */


struct sbasic{
	uint32 sctime_readout;	/* 32 bit spacecraft time  */
	uint32 sctime_collection;/* 32 bit spacecraft time  */
	uint32 QAC;	/* number of frames of missing data in this SR */

	uint16 BASIC[SBAS_CYC][SBAS_N][SBAS_S];/* Matrix rates */
        uint16 FILL[SBAS_CYC][SBAS_NFILL];    /*  Fill data  */
};
