/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: s3_celement.h,v 1.3 1997/05/07 22:58:29 jeff Exp $           */

#include "s3_celement.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1;


/****  init write function  ****/

int32 init_wr_s3_celement(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[2];
  int32 rank;

  void s3_celement_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrps3_celement");
    Vsetclass(vgrp_id, "CVgrps3_celement");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "celement");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime_readout", DFNT_UINT32, (1) )) {
     s3_celement_error("VSfdefine sctime_readout error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "sctime_collection", DFNT_UINT32, (1) )) {
     s3_celement_error("VSfdefine sctime_collection error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     s3_celement_error("VSfdefine QAC error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime_readout, sctime_collection, QAC")){
    s3_celement_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = CTIME_TSZ;
  if((sds_id_w1=SDcreate(sd_id, "celement_ELEMENT", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create celement_ELEMENT \n");

  return(retval);
}

/****** write function ******/

int32 write_s3_celement(struct celement celement_struc)
{
int32 start[2], edges[2];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_s3_celement();

  odata = (uint8 *) malloc(sizeof(struct celement));
  pack_s3_celement(odata, &celement_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing S3 CELEMENT data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  edges[0] = 1;

  edges[1] = CTIME_TSZ;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (celement_struc.ELEMENT ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing ELEMENT data.\n");
  }
  memset(&celement_struc, 0, sizeof(struct celement));
  free(odata);
  return(retval);
}

void close_wr_s3_celement() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
}

/*     init read function    */

int32 init_rd_s3_celement(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  int32 vdata_ref;
  int32 retval=0;

  void s3_celement_error();

    if((sds_index1=SDnametoindex(sd_id, "celement_ELEMENT" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find celement_ELEMENT\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "celement"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime_readout, sctime_collection, QAC")) {
    s3_celement_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_s3_celement(struct celement *celement_struc, int32 recnum_rd)
{
int32 start[2], edges[2];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_s3_celement();

  start[0] = recnum_rd;
  start[1] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct celement));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = CTIME_TSZ;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(celement_struc->ELEMENT ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read ELEMENT\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_s3_celement(odata, celement_struc);
  free(odata);
  return(retval);
}

void s3_celement_error(int8 *mess)
  { fprintf(stderr,"S3 CELEMENT: %s\n",mess); }

void close_rd_s3_celement() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
}
/*   pack function    */

void pack_s3_celement(uint8 *data, struct celement *celement_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &celement_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &celement_ptr->sctime_collection, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &celement_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*   unpack function    */

void unpack_s3_celement(uint8 *data, struct celement *celement_ptr)
{
int32 ptr=0;

   memcpy(&celement_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&celement_ptr->sctime_collection, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&celement_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
