/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: swepam_ett.h,v 1.3 1997/02/13 01:17:20 jeff Exp $ */

#include "swepam_ett.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2, sds_id_r3, sds_id_w3, sds_id_r4, sds_id_w4, sds_id_r5, sds_id_w5, sds_id_r6, sds_id_w6, sds_id_r7, sds_id_w7, sds_id_r8, sds_id_w8, sds_id_r9, sds_id_w9, sds_id_r10, sds_id_w10, sds_id_r11, sds_id_w11, sds_id_r12, sds_id_w12;


/****  init write function  ****/

int32 init_wr_swepam_ett(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[2];
  int32 rank;

  void swepam_ett_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpswepam_ett");
    Vsetclass(vgrp_id, "CVgrpswepam_ett");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "TELE");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "output_sctime", DFNT_UINT32, (1) )) {
     swepam_ett_error("VSfdefine output_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "collect_sctime", DFNT_UINT32, (1) )) {
     swepam_ett_error("VSfdefine collect_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT8, (1) )) {
     swepam_ett_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "E_InstPS", DFNT_UINT8, (1) )) {
     swepam_ett_error("VSfdefine E_InstPS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "E_OrdState", DFNT_UINT8, (1) )) {
     swepam_ett_error("VSfdefine E_OrdState error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"output_sctime, collect_sctime, QAC, E_InstPS, E_OrdState")){
    swepam_ett_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w1=SDcreate(sd_id, "TELE_SCid", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create TELE_SCid \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w2=SDcreate(sd_id, "TELE_FmtFC", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create TELE_FmtFC \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w3=SDcreate(sd_id, "TELE_FmtID", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create TELE_FmtID \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w4=SDcreate(sd_id, "TELE_EF", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create TELE_EF \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w5=SDcreate(sd_id, "TELE_CS", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create TELE_CS \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w6=SDcreate(sd_id, "TELE_DB", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create TELE_DB \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w7=SDcreate(sd_id, "TELE_HVMON1", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create TELE_HVMON1 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w8=SDcreate(sd_id, "TELE_HVMON2", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create TELE_HVMON2 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w9=SDcreate(sd_id, "TELE_PSMON", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create TELE_PSMON \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w10=SDcreate(sd_id, "TELE_E_TMon", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create TELE_E_TMon \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w11=SDcreate(sd_id, "TELE_E_IMon", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create TELE_E_IMon \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w12=SDcreate(sd_id, "TELE_E_IFTMon", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create TELE_E_IFTMon \n");

  return(retval);
}

/****** write function ******/

int32 write_swepam_ett(struct TELE TELE_struc)
{
int32 start[2], edges[2];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_swepam_ett();

  odata = (uint8 *) malloc(sizeof(struct TELE));
  pack_swepam_ett(odata, &TELE_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing SWEPAM ETT data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  edges[0] = 1;

  edges[1] = 8;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (TELE_struc.SCid ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing SCid data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (TELE_struc.FmtFC ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing FmtFC data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w3,start,NULL,edges,(VOIDP) (TELE_struc.FmtID ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing FmtID data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w4,start,NULL,edges,(VOIDP) (TELE_struc.EF ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing EF data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w5,start,NULL,edges,(VOIDP) (TELE_struc.CS ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing CS data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w6,start,NULL,edges,(VOIDP) (TELE_struc.DB ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing DB data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w7,start,NULL,edges,(VOIDP) (TELE_struc.HVMON1 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing HVMON1 data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w8,start,NULL,edges,(VOIDP) (TELE_struc.HVMON2 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing HVMON2 data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w9,start,NULL,edges,(VOIDP) (TELE_struc.PSMON ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing PSMON data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w10,start,NULL,edges,(VOIDP) (TELE_struc.E_TMon ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing E_TMon data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w11,start,NULL,edges,(VOIDP) (TELE_struc.E_IMon ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing E_IMon data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w12,start,NULL,edges,(VOIDP) (TELE_struc.E_IFTMon ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing E_IFTMon data.\n");
  }
  memset(&TELE_struc, 0, sizeof(struct TELE));
  free(odata);
  return(retval);
}

void close_wr_swepam_ett() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
  SDendaccess(sds_id_w3);
  SDendaccess(sds_id_w4);
  SDendaccess(sds_id_w5);
  SDendaccess(sds_id_w6);
  SDendaccess(sds_id_w7);
  SDendaccess(sds_id_w8);
  SDendaccess(sds_id_w9);
  SDendaccess(sds_id_w10);
  SDendaccess(sds_id_w11);
  SDendaccess(sds_id_w12);
}

/*     init read function    */

int32 init_rd_swepam_ett(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  static int32 sds_index3;
  static int32 sds_index4;
  static int32 sds_index5;
  static int32 sds_index6;
  static int32 sds_index7;
  static int32 sds_index8;
  static int32 sds_index9;
  static int32 sds_index10;
  static int32 sds_index11;
  static int32 sds_index12;
  int32 vdata_ref;
  int32 retval=0;

  void swepam_ett_error();

    if((sds_index1=SDnametoindex(sd_id, "TELE_SCid" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find TELE_SCid\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "TELE_FmtFC" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find TELE_FmtFC\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }
    if((sds_index3=SDnametoindex(sd_id, "TELE_FmtID" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find TELE_FmtID\n");
      retval = -1;
    }
    if((sds_id_r3=SDselect(sd_id, sds_index3))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index3\n");
      retval = -1;
    }
    if((sds_index4=SDnametoindex(sd_id, "TELE_EF" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find TELE_EF\n");
      retval = -1;
    }
    if((sds_id_r4=SDselect(sd_id, sds_index4))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index4\n");
      retval = -1;
    }
    if((sds_index5=SDnametoindex(sd_id, "TELE_CS" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find TELE_CS\n");
      retval = -1;
    }
    if((sds_id_r5=SDselect(sd_id, sds_index5))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index5\n");
      retval = -1;
    }
    if((sds_index6=SDnametoindex(sd_id, "TELE_DB" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find TELE_DB\n");
      retval = -1;
    }
    if((sds_id_r6=SDselect(sd_id, sds_index6))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index6\n");
      retval = -1;
    }
    if((sds_index7=SDnametoindex(sd_id, "TELE_HVMON1" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find TELE_HVMON1\n");
      retval = -1;
    }
    if((sds_id_r7=SDselect(sd_id, sds_index7))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index7\n");
      retval = -1;
    }
    if((sds_index8=SDnametoindex(sd_id, "TELE_HVMON2" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find TELE_HVMON2\n");
      retval = -1;
    }
    if((sds_id_r8=SDselect(sd_id, sds_index8))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index8\n");
      retval = -1;
    }
    if((sds_index9=SDnametoindex(sd_id, "TELE_PSMON" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find TELE_PSMON\n");
      retval = -1;
    }
    if((sds_id_r9=SDselect(sd_id, sds_index9))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index9\n");
      retval = -1;
    }
    if((sds_index10=SDnametoindex(sd_id, "TELE_E_TMon" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find TELE_E_TMon\n");
      retval = -1;
    }
    if((sds_id_r10=SDselect(sd_id, sds_index10))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index10\n");
      retval = -1;
    }
    if((sds_index11=SDnametoindex(sd_id, "TELE_E_IMon" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find TELE_E_IMon\n");
      retval = -1;
    }
    if((sds_id_r11=SDselect(sd_id, sds_index11))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index11\n");
      retval = -1;
    }
    if((sds_index12=SDnametoindex(sd_id, "TELE_E_IFTMon" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find TELE_E_IFTMon\n");
      retval = -1;
    }
    if((sds_id_r12=SDselect(sd_id, sds_index12))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index12\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "TELE"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"output_sctime, collect_sctime, QAC, E_InstPS, E_OrdState")) {
    swepam_ett_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_swepam_ett(struct TELE *TELE_struc, int32 recnum_rd)
{
int32 start[2], edges[2];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_swepam_ett();

  start[0] = recnum_rd;
  start[1] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct TELE));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(TELE_struc->SCid ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read SCid\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(TELE_struc->FmtFC ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read FmtFC\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r3,start,NULL,edges, (VOIDP)(TELE_struc->FmtID ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read FmtID\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r4,start,NULL,edges, (VOIDP)(TELE_struc->EF ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read EF\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r5,start,NULL,edges, (VOIDP)(TELE_struc->CS ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read CS\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r6,start,NULL,edges, (VOIDP)(TELE_struc->DB ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read DB\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r7,start,NULL,edges, (VOIDP)(TELE_struc->HVMON1 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read HVMON1\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r8,start,NULL,edges, (VOIDP)(TELE_struc->HVMON2 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read HVMON2\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r9,start,NULL,edges, (VOIDP)(TELE_struc->PSMON ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read PSMON\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r10,start,NULL,edges, (VOIDP)(TELE_struc->E_TMon ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read E_TMon\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r11,start,NULL,edges, (VOIDP)(TELE_struc->E_IMon ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read E_IMon\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r12,start,NULL,edges, (VOIDP)(TELE_struc->E_IFTMon ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read E_IFTMon\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_swepam_ett(odata, TELE_struc);
  free(odata);
  return(retval);
}

void swepam_ett_error(int8 *mess)
  { fprintf(stderr,"SWEPAM ETT: %s\n",mess); }

void close_rd_swepam_ett() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
  SDendaccess(sds_id_r3);
  SDendaccess(sds_id_r4);
  SDendaccess(sds_id_r5);
  SDendaccess(sds_id_r6);
  SDendaccess(sds_id_r7);
  SDendaccess(sds_id_r8);
  SDendaccess(sds_id_r9);
  SDendaccess(sds_id_r10);
  SDendaccess(sds_id_r11);
  SDendaccess(sds_id_r12);
}
/*   pack function    */

void pack_swepam_ett(uint8 *data, struct TELE *TELE_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &TELE_ptr->output_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &TELE_ptr->collect_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &TELE_ptr->QAC, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &TELE_ptr->E_InstPS, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &TELE_ptr->E_OrdState, ((1)*(1)) );
   ptr+= ((1)*(1));
}

/*   unpack function    */

void unpack_swepam_ett(uint8 *data, struct TELE *TELE_ptr)
{
int32 ptr=0;

   memcpy(&TELE_ptr->output_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&TELE_ptr->collect_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&TELE_ptr->QAC, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&TELE_ptr->E_InstPS, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&TELE_ptr->E_OrdState, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
}
