/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: s3_ssector.h,v 1.4 1997/05/06 19:13:01 jeff Exp $	     */

#include "s3_ssector.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1;


/****  init write function  ****/

int32 init_wr_s3_ssector(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[4];
  int32 rank;

  void s3_ssector_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrps3_ssector");
    Vsetclass(vgrp_id, "CVgrps3_ssector");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "ssector");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime_readout", DFNT_UINT32, (1) )) {
     s3_ssector_error("VSfdefine sctime_readout error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "sctime_collection", DFNT_UINT32, (1) )) {
     s3_ssector_error("VSfdefine sctime_collection error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     s3_ssector_error("VSfdefine QAC error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime_readout, sctime_collection, QAC")){
    s3_ssector_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 4;
  dim_sizes[1] = SSEC_CYC;
  dim_sizes[2] = SSEC_N;
  dim_sizes[3] = SSEC_S;
  if((sds_id_w1=SDcreate(sd_id, "ssector_SECTOR", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create ssector_SECTOR \n");

  return(retval);
}

/****** write function ******/

int32 write_s3_ssector(struct ssector ssector_struc)
{
int32 start[4], edges[4];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_s3_ssector();

  odata = (uint8 *) malloc(sizeof(struct ssector));
  pack_s3_ssector(odata, &ssector_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing S3 SSECTOR data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  start[3] = 0;
  edges[0] = 1;

  edges[1] = SSEC_CYC;
  edges[2] = SSEC_N;
  edges[3] = SSEC_S;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (ssector_struc.SECTOR ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing SECTOR data.\n");
  }
  memset(&ssector_struc, 0, sizeof(struct ssector));
  free(odata);
  return(retval);
}

void close_wr_s3_ssector() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
}

/*     init read function    */

int32 init_rd_s3_ssector(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  int32 vdata_ref;
  int32 retval=0;

  void s3_ssector_error();

    if((sds_index1=SDnametoindex(sd_id, "ssector_SECTOR" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find ssector_SECTOR\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "ssector"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime_readout, sctime_collection, QAC")) {
    s3_ssector_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_s3_ssector(struct ssector *ssector_struc, int32 recnum_rd)
{
int32 start[4], edges[4];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_s3_ssector();

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;
  start[3] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct ssector));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = SSEC_CYC;
  edges[2] = SSEC_N;
  edges[3] = SSEC_S;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(ssector_struc->SECTOR ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read SECTOR\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_s3_ssector(odata, ssector_struc);
  free(odata);
  return(retval);
}

void s3_ssector_error(int8 *mess)
  { fprintf(stderr,"S3 SSECTOR: %s\n",mess); }

void close_rd_s3_ssector() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
}
/*   pack function    */

void pack_s3_ssector(uint8 *data, struct ssector *ssector_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &ssector_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ssector_ptr->sctime_collection, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ssector_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*   unpack function    */

void unpack_s3_ssector(uint8 *data, struct ssector *ssector_ptr)
{
int32 ptr=0;

   memcpy(&ssector_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ssector_ptr->sctime_collection, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ssector_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
