/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: s3_spha.h,v 1.4 1997/05/06 19:13:01 jeff Exp $	     */

#include "s3_spha.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2, sds_id_r3, sds_id_w3, sds_id_r4, sds_id_w4, sds_id_r5, sds_id_w5, sds_id_r6, sds_id_w6, sds_id_r7, sds_id_w7, sds_id_r8, sds_id_w8, sds_id_r9, sds_id_w9, sds_id_r10, sds_id_w10;


/****  init write function  ****/

int32 init_wr_s3_spha(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[3];
  int32 rank;

  void s3_spha_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrps3_spha");
    Vsetclass(vgrp_id, "CVgrps3_spha");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "spha");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime_readout", DFNT_UINT32, (1) )) {
     s3_spha_error("VSfdefine sctime_readout error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "sctime_collection", DFNT_UINT32, (1) )) {
     s3_spha_error("VSfdefine sctime_collection error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     s3_spha_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "elements", DFNT_UINT32, (1) )) {
     s3_spha_error("VSfdefine elements error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "concat", DFNT_UINT8, (1) )) {
     s3_spha_error("VSfdefine concat error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime_readout, sctime_collection, QAC, elements, concat")){
    s3_spha_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SEP_PHA_CYCLEN;
  dim_sizes[2] = SEP_PHA_CYCPERSR;
  if((sds_id_w1=SDcreate(sd_id, "spha_range", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create spha_range \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SEP_PHA_CYCLEN;
  dim_sizes[2] = SEP_PHA_CYCPERSR;
  if((sds_id_w2=SDcreate(sd_id, "spha_sector", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create spha_sector \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SEP_PHA_CYCLEN;
  dim_sizes[2] = SEP_PHA_CYCPERSR;
  if((sds_id_w3=SDcreate(sd_id, "spha_fan", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create spha_fan \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SEP_PHA_CYCLEN;
  dim_sizes[2] = SEP_PHA_CYCPERSR;
  if((sds_id_w4=SDcreate(sd_id, "spha_sys", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create spha_sys \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SEP_PHA_CYCLEN;
  dim_sizes[2] = SEP_PHA_CYCPERSR;
  if((sds_id_w5=SDcreate(sd_id, "spha_dZ", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create spha_dZ \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SEP_PHA_CYCLEN;
  dim_sizes[2] = SEP_PHA_CYCPERSR;
  if((sds_id_w6=SDcreate(sd_id, "spha_E", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create spha_E \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SEP_PHA_CYCLEN;
  dim_sizes[2] = SEP_PHA_CYCPERSR;
  if((sds_id_w7=SDcreate(sd_id, "spha_Eg", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create spha_Eg \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SEP_PHA_CYCLEN;
  dim_sizes[2] = SEP_PHA_CYCPERSR;
  if((sds_id_w8=SDcreate(sd_id, "spha_dE", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create spha_dE \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SEP_PHA_CYCLEN;
  dim_sizes[2] = SEP_PHA_CYCPERSR;
  if((sds_id_w9=SDcreate(sd_id, "spha_dEg", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create spha_dEg \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SEP_PHA_CYCLEN;
  dim_sizes[2] = SEP_PHA_CYCPERSR;
  if((sds_id_w10=SDcreate(sd_id, "spha_Y", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create spha_Y \n");

  return(retval);
}

/****** write function ******/

int32 write_s3_spha(struct spha spha_struc)
{
int32 start[3], edges[3];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_s3_spha();

  odata = (uint8 *) malloc(sizeof(struct spha));
  pack_s3_spha(odata, &spha_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing S3 SPHA data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (spha_struc.range ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing range data.\n");
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (spha_struc.sector ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing sector data.\n");
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w3,start,NULL,edges,(VOIDP) (spha_struc.fan ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing fan data.\n");
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w4,start,NULL,edges,(VOIDP) (spha_struc.sys ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing sys data.\n");
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w5,start,NULL,edges,(VOIDP) (spha_struc.dZ ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing dZ data.\n");
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w6,start,NULL,edges,(VOIDP) (spha_struc.E ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing E data.\n");
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w7,start,NULL,edges,(VOIDP) (spha_struc.Eg ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Eg data.\n");
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w8,start,NULL,edges,(VOIDP) (spha_struc.dE ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing dE data.\n");
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w9,start,NULL,edges,(VOIDP) (spha_struc.dEg ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing dEg data.\n");
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if (SDwritedata(sds_id_w10,start,NULL,edges,(VOIDP) (spha_struc.Y ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Y data.\n");
  }
  memset(&spha_struc, 0, sizeof(struct spha));
  free(odata);
  return(retval);
}

void close_wr_s3_spha() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
  SDendaccess(sds_id_w3);
  SDendaccess(sds_id_w4);
  SDendaccess(sds_id_w5);
  SDendaccess(sds_id_w6);
  SDendaccess(sds_id_w7);
  SDendaccess(sds_id_w8);
  SDendaccess(sds_id_w9);
  SDendaccess(sds_id_w10);
}

/*     init read function    */

int32 init_rd_s3_spha(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  static int32 sds_index3;
  static int32 sds_index4;
  static int32 sds_index5;
  static int32 sds_index6;
  static int32 sds_index7;
  static int32 sds_index8;
  static int32 sds_index9;
  static int32 sds_index10;
  int32 vdata_ref;
  int32 retval=0;

  void s3_spha_error();

    if((sds_index1=SDnametoindex(sd_id, "spha_range" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find spha_range\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "spha_sector" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find spha_sector\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }
    if((sds_index3=SDnametoindex(sd_id, "spha_fan" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find spha_fan\n");
      retval = -1;
    }
    if((sds_id_r3=SDselect(sd_id, sds_index3))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index3\n");
      retval = -1;
    }
    if((sds_index4=SDnametoindex(sd_id, "spha_sys" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find spha_sys\n");
      retval = -1;
    }
    if((sds_id_r4=SDselect(sd_id, sds_index4))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index4\n");
      retval = -1;
    }
    if((sds_index5=SDnametoindex(sd_id, "spha_dZ" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find spha_dZ\n");
      retval = -1;
    }
    if((sds_id_r5=SDselect(sd_id, sds_index5))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index5\n");
      retval = -1;
    }
    if((sds_index6=SDnametoindex(sd_id, "spha_E" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find spha_E\n");
      retval = -1;
    }
    if((sds_id_r6=SDselect(sd_id, sds_index6))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index6\n");
      retval = -1;
    }
    if((sds_index7=SDnametoindex(sd_id, "spha_Eg" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find spha_Eg\n");
      retval = -1;
    }
    if((sds_id_r7=SDselect(sd_id, sds_index7))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index7\n");
      retval = -1;
    }
    if((sds_index8=SDnametoindex(sd_id, "spha_dE" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find spha_dE\n");
      retval = -1;
    }
    if((sds_id_r8=SDselect(sd_id, sds_index8))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index8\n");
      retval = -1;
    }
    if((sds_index9=SDnametoindex(sd_id, "spha_dEg" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find spha_dEg\n");
      retval = -1;
    }
    if((sds_id_r9=SDselect(sd_id, sds_index9))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index9\n");
      retval = -1;
    }
    if((sds_index10=SDnametoindex(sd_id, "spha_Y" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find spha_Y\n");
      retval = -1;
    }
    if((sds_id_r10=SDselect(sd_id, sds_index10))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index10\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "spha"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime_readout, sctime_collection, QAC, elements, concat")) {
    s3_spha_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_s3_spha(struct spha *spha_struc, int32 recnum_rd)
{
int32 start[3], edges[3];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_s3_spha();

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct spha));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(spha_struc->range ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read range\n");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(spha_struc->sector ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read sector\n");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r3,start,NULL,edges, (VOIDP)(spha_struc->fan ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read fan\n");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r4,start,NULL,edges, (VOIDP)(spha_struc->sys ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read sys\n");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r5,start,NULL,edges, (VOIDP)(spha_struc->dZ ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read dZ\n");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r6,start,NULL,edges, (VOIDP)(spha_struc->E ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read E\n");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r7,start,NULL,edges, (VOIDP)(spha_struc->Eg ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Eg\n");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r8,start,NULL,edges, (VOIDP)(spha_struc->dE ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read dE\n");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r9,start,NULL,edges, (VOIDP)(spha_struc->dEg ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read dEg\n");
    retval = -1;
  }
  edges[1] = SEP_PHA_CYCLEN;
  edges[2] = SEP_PHA_CYCPERSR;
  if(SDreaddata(sds_id_r10,start,NULL,edges, (VOIDP)(spha_struc->Y ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Y\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_s3_spha(odata, spha_struc);
  free(odata);
  return(retval);
}

void s3_spha_error(int8 *mess)
  { fprintf(stderr,"S3 SPHA: %s\n",mess); }

void close_rd_s3_spha() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
  SDendaccess(sds_id_r3);
  SDendaccess(sds_id_r4);
  SDendaccess(sds_id_r5);
  SDendaccess(sds_id_r6);
  SDendaccess(sds_id_r7);
  SDendaccess(sds_id_r8);
  SDendaccess(sds_id_r9);
  SDendaccess(sds_id_r10);
}
/*   pack function    */

void pack_s3_spha(uint8 *data, struct spha *spha_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &spha_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &spha_ptr->sctime_collection, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &spha_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &spha_ptr->elements, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &spha_ptr->concat, ((1)*(1)) );
   ptr+= ((1)*(1));
}

/*   unpack function    */

void unpack_s3_spha(uint8 *data, struct spha *spha_ptr)
{
int32 ptr=0;

   memcpy(&spha_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&spha_ptr->sctime_collection, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&spha_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&spha_ptr->elements, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&spha_ptr->concat, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
}
