/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: s3_shk.h,v 1.2 1997/05/06 19:13:01 jeff Exp $	     */

#include "s3_shk.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;

/****  init write function  ****/

int32 init_wr_s3_shk(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  void s3_shk_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrps3_shk");
    Vsetclass(vgrp_id, "CVgrps3_shk");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "sshshk");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime_readout", DFNT_UINT32, (1) )) {
     s3_shk_error("VSfdefine sctime_readout error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "sctime_collection", DFNT_UINT32, (1) )) {
     s3_shk_error("VSfdefine sctime_collection error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     s3_shk_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "HKSECTOR", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine HKSECTOR error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "P5I", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine P5I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "M5I", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine M5I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "P15I", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine P15I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "M15I", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine M15I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "P5V", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine P5V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "M5V", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine M5V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "P15V", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine P15V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "M15V", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine M15V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_30KI", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _30KI error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_30KV", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _30KV error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KI", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KI error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KV", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KV error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_75I", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _75I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_75V", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _75V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "P5T", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine P5T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "P15T", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine P15T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KAV", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KAV error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KBV", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KBV error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KCV", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KCV error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VAL1I", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine VAL1I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VAL2I", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine VAL2I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VAL3I", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine VAL3I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VAL1V", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine VAL1V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VAL2V", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine VAL2V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VAL3V", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine VAL3V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "BASET", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine BASET error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SSD1T", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine SSD1T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SSD2T", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine SSD2T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SSD3T", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine SSD3T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "TANKT", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine TANKT error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "EBOXT", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine EBOXT error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "HV30T", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine HV30T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "COLLT", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine COLLT error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC1T", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine PC1T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC2T", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine PC2T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC3T", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine PC3T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRMT", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine GRMT error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FILL1", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FILL1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FILL2", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FILL2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FILL3", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FILL3 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "POWERS", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine POWERS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "RELAYS", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine RELAYS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "OVERI", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine OVERI error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "P15LIM", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine P15LIM error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "M15LIM", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine M15LIM error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "P5LIM", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine P5LIM error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "M5LIM", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine M5LIM error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_30KSTATH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _30KSTATH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_30KSET", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _30KSET error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_30KSTATL", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _30KSTATL error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KASTATH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KASTATH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KASET", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KASET error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KASTATL", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KASTATL error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KBSTATH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KBSTATH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KBSET", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KBSET error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KBSTATL", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KBSTATL error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KCSTATH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KCSTATH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KCSET", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KCSET error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_2KCSTATL", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _2KCSTATL error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_75STATH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _75STATH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_75SET", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _75SET error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "_75STATL", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine _75STATL error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC1P", DFNT_UINT16, (1) )) {
     s3_shk_error("VSfdefine PC1P error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC2P", DFNT_UINT16, (1) )) {
     s3_shk_error("VSfdefine PC2P error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC3P", DFNT_UINT16, (1) )) {
     s3_shk_error("VSfdefine PC3P error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "LINEP", DFNT_UINT16, (1) )) {
     s3_shk_error("VSfdefine LINEP error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC1O", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine PC1O error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC2O", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine PC2O error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC3O", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine PC3O error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMS", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN1MODE", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN1MODE error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN1BASE", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN1BASE error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN1LOGIC", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN1LOGIC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN1PCY", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN1PCY error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN1PCZ", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN1PCZ error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN1SSD", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN1SSD error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN1BANK", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN1BANK error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN1BLOCK", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN1BLOCK error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN1DATA", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN1DATA error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN2MODE", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN2MODE error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN2BASE", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN2BASE error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN2LOGIC", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN2LOGIC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN2PCY", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN2PCY error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN2PCZ", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN2PCZ error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN2SSD", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN2SSD error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN2BANK", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN2BANK error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN2BLOCK", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN2BLOCK error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN2DATA", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN2DATA error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN3MODE", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN3MODE error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN3BASE", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN3BASE error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN3LOGIC", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN3LOGIC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN3PCY", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN3PCY error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN3PCZ", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN3PCZ error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN3SSD", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN3SSD error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN3BANK", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN3BANK error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN3BLOCK", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN3BLOCK error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FAN3DATA", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FAN3DATA error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC1YTH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine PC1YTH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC1ZTH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine PC1ZTH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC2YTH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine PC2YTH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC2ZTH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine PC2ZTH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC3YTH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine PC3YTH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PC3ZTH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine PC3ZTH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SSD1TH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine SSD1TH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "BIT1PERIOD", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine BIT1PERIOD error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SSD2TH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine SSD2TH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "BIT2PERIOD", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine BIT2PERIOD error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SSD3TH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine SSD3TH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "BIT3PERIOD", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine BIT3PERIOD error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DEDX1TH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine DEDX1TH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DEDX2TH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine DEDX2TH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DEDX3TH", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine DEDX3TH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DET1TRIG", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine DET1TRIG error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DET1EVENT", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine DET1EVENT error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DET1GAIN", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine DET1GAIN error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DET1CHANNELS", DFNT_UINT16, (1) )) {
     s3_shk_error("VSfdefine DET1CHANNELS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DET2TRIG", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine DET2TRIG error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DET2EVENT", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine DET2EVENT error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DET2GAIN", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine DET2GAIN error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DET2CHANNELS", DFNT_UINT16, (1) )) {
     s3_shk_error("VSfdefine DET2CHANNELS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DET3TRIG", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine DET3TRIG error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DET3EVENT", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine DET3EVENT error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DET3GAIN", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine DET3GAIN error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DET3CHANNELS", DFNT_UINT16, (1) )) {
     s3_shk_error("VSfdefine DET3CHANNELS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ACTRCTRL", DFNT_UINT16, (1) )) {
     s3_shk_error("VSfdefine ACTRCTRL error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FANPRIOR", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine FANPRIOR error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ACTRSAMPLE", DFNT_UINT16, (1) )) {
     s3_shk_error("VSfdefine ACTRSAMPLE error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMOP3", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMOP3 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMOP2", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMOP2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMOP1", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMOP1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMUP3", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMUP3 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMUP2", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMUP2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMUP1", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMUP1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMDISCHG", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMDISCHG error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARM30KI", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARM30KI error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARM30KV", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARM30KV error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARM2KVC", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARM2KVC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARM2KVB", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARM2KVB error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARM2KVA", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARM2KVA error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARM2KI", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARM2KI error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARM2KV", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARM2KV error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARM75I", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARM75I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARM75V", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARM75V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMM15I", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMM15I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMM15V", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMM15V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMP15I", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMP15I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMP15V", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMP15V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMM5I", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMM5I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMM5V", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMM5V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMP5I", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMP5I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ALARMP5V", DFNT_UINT8, (1) )) {
     s3_shk_error("VSfdefine ALARMP5V error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime_readout, sctime_collection, QAC, HKSECTOR, P5I, M5I, P15I, M15I, P5V, M5V, P15V, M15V, _30KI, _30KV, _2KI, _2KV, _75I, _75V, P5T, P15T, _2KAV, _2KBV, _2KCV, VAL1I, VAL2I, VAL3I, VAL1V, VAL2V, VAL3V, BASET, SSD1T, SSD2T, SSD3T, TANKT, EBOXT, HV30T, COLLT, PC1T, PC2T, PC3T, GRMT, FILL1, FILL2, FILL3, POWERS, RELAYS, OVERI, P15LIM, M15LIM, P5LIM, M5LIM, _30KSTATH, _30KSET, _30KSTATL, _2KASTATH, _2KASET, _2KASTATL, _2KBSTATH, _2KBSET, _2KBSTATL, _2KCSTATH, _2KCSET, _2KCSTATL, _75STATH, _75SET, _75STATL, PC1P, PC2P, PC3P, LINEP, PC1O, PC2O, PC3O, ALARMS, FAN1MODE, FAN1BASE, FAN1LOGIC, FAN1PCY, FAN1PCZ, FAN1SSD, FAN1BANK, FAN1BLOCK, FAN1DATA, FAN2MODE, FAN2BASE, FAN2LOGIC, FAN2PCY, FAN2PCZ, FAN2SSD, FAN2BANK, FAN2BLOCK, FAN2DATA, FAN3MODE, FAN3BASE, FAN3LOGIC, FAN3PCY, FAN3PCZ, FAN3SSD, FAN3BANK, FAN3BLOCK, FAN3DATA, PC1YTH, PC1ZTH, PC2YTH, PC2ZTH, PC3YTH, PC3ZTH, SSD1TH, BIT1PERIOD, SSD2TH, BIT2PERIOD, SSD3TH, BIT3PERIOD, DEDX1TH, DEDX2TH, DEDX3TH, DET1TRIG, DET1EVENT, DET1GAIN, DET1CHANNELS, DET2TRIG, DET2EVENT, DET2GAIN, DET2CHANNELS, DET3TRIG, DET3EVENT, DET3GAIN, DET3CHANNELS, ACTRCTRL, FANPRIOR, ACTRSAMPLE, ALARMOP3, ALARMOP2, ALARMOP1, ALARMUP3, ALARMUP2, ALARMUP1, ALARMDISCHG, ALARM30KI, ALARM30KV, ALARM2KVC, ALARM2KVB, ALARM2KVA, ALARM2KI, ALARM2KV, ALARM75I, ALARM75V, ALARMM15I, ALARMM15V, ALARMP15I, ALARMP15V, ALARMM5I, ALARMM5V, ALARMP5I, ALARMP5V")){
    s3_shk_error("VSsetfields error");
    retval = -1;
  }
  return(retval);
}

/****** write function ******/

int32 write_s3_shk(struct sshshk sshshk_struc)
{
int32 retval = 0;
uint8 *odata;

void pack_s3_shk();

  odata = (uint8 *) malloc(sizeof(struct sshshk));
  pack_s3_shk(odata, &sshshk_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing S3 SHK data\n");
  } 
  memset(&sshshk_struc, 0, sizeof(struct sshshk));
  free(odata);
  return(retval);
}

void close_wr_s3_shk() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
}

/*     init read function    */

int32 init_rd_s3_shk(int32 hdf_fp, int32 sd_id)
{
  int32 vdata_ref;
  int32 retval=0;

  void s3_shk_error();


  if ((vdata_ref = VSfind(hdf_fp, "sshshk"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime_readout, sctime_collection, QAC, HKSECTOR, P5I, M5I, P15I, M15I, P5V, M5V, P15V, M15V, _30KI, _30KV, _2KI, _2KV, _75I, _75V, P5T, P15T, _2KAV, _2KBV, _2KCV, VAL1I, VAL2I, VAL3I, VAL1V, VAL2V, VAL3V, BASET, SSD1T, SSD2T, SSD3T, TANKT, EBOXT, HV30T, COLLT, PC1T, PC2T, PC3T, GRMT, FILL1, FILL2, FILL3, POWERS, RELAYS, OVERI, P15LIM, M15LIM, P5LIM, M5LIM, _30KSTATH, _30KSET, _30KSTATL, _2KASTATH, _2KASET, _2KASTATL, _2KBSTATH, _2KBSET, _2KBSTATL, _2KCSTATH, _2KCSET, _2KCSTATL, _75STATH, _75SET, _75STATL, PC1P, PC2P, PC3P, LINEP, PC1O, PC2O, PC3O, ALARMS, FAN1MODE, FAN1BASE, FAN1LOGIC, FAN1PCY, FAN1PCZ, FAN1SSD, FAN1BANK, FAN1BLOCK, FAN1DATA, FAN2MODE, FAN2BASE, FAN2LOGIC, FAN2PCY, FAN2PCZ, FAN2SSD, FAN2BANK, FAN2BLOCK, FAN2DATA, FAN3MODE, FAN3BASE, FAN3LOGIC, FAN3PCY, FAN3PCZ, FAN3SSD, FAN3BANK, FAN3BLOCK, FAN3DATA, PC1YTH, PC1ZTH, PC2YTH, PC2ZTH, PC3YTH, PC3ZTH, SSD1TH, BIT1PERIOD, SSD2TH, BIT2PERIOD, SSD3TH, BIT3PERIOD, DEDX1TH, DEDX2TH, DEDX3TH, DET1TRIG, DET1EVENT, DET1GAIN, DET1CHANNELS, DET2TRIG, DET2EVENT, DET2GAIN, DET2CHANNELS, DET3TRIG, DET3EVENT, DET3GAIN, DET3CHANNELS, ACTRCTRL, FANPRIOR, ACTRSAMPLE, ALARMOP3, ALARMOP2, ALARMOP1, ALARMUP3, ALARMUP2, ALARMUP1, ALARMDISCHG, ALARM30KI, ALARM30KV, ALARM2KVC, ALARM2KVB, ALARM2KVA, ALARM2KI, ALARM2KV, ALARM75I, ALARM75V, ALARMM15I, ALARMM15V, ALARMP15I, ALARMP15V, ALARMM5I, ALARMM5V, ALARMP5I, ALARMP5V")) {
    s3_shk_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_s3_shk(struct sshshk *sshshk_struc, int32 recnum_rd)
{
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_s3_shk();

  odata = (uint8 *) malloc(sizeof(struct sshshk));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_s3_shk(odata, sshshk_struc);
  free(odata);
  return(retval);
}

void s3_shk_error(int8 *mess)
  { fprintf(stderr,"S3 SHK: %s\n",mess); }

void close_rd_s3_shk() {
  VSdetach(vdata_id_r);
}
/*   pack function    */

void pack_s3_shk(uint8 *data, struct sshshk *sshshk_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &sshshk_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &sshshk_ptr->sctime_collection, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &sshshk_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &sshshk_ptr->HKSECTOR, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->P5I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->M5I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->P15I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->M15I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->P5V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->M5V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->P15V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->M15V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_30KI, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_30KV, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KI, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KV, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_75I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_75V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->P5T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->P15T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KAV, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KBV, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KCV, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->VAL1I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->VAL2I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->VAL3I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->VAL1V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->VAL2V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->VAL3V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->BASET, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->SSD1T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->SSD2T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->SSD3T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->TANKT, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->EBOXT, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->HV30T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->COLLT, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC1T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC2T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC3T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->GRMT, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FILL1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FILL2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FILL3, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->POWERS, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->RELAYS, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->OVERI, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->P15LIM, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->M15LIM, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->P5LIM, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->M5LIM, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_30KSTATH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_30KSET, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_30KSTATL, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KASTATH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KASET, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KASTATL, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KBSTATH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KBSET, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KBSTATL, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KCSTATH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KCSET, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_2KCSTATL, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_75STATH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_75SET, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->_75STATL, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC1P, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC2P, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC3P, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshshk_ptr->LINEP, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC1O, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC2O, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC3O, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMS, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN1MODE, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN1BASE, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN1LOGIC, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN1PCY, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN1PCZ, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN1SSD, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN1BANK, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN1BLOCK, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN1DATA, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN2MODE, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN2BASE, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN2LOGIC, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN2PCY, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN2PCZ, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN2SSD, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN2BANK, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN2BLOCK, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN2DATA, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN3MODE, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN3BASE, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN3LOGIC, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN3PCY, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN3PCZ, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN3SSD, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN3BANK, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN3BLOCK, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->FAN3DATA, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC1YTH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC1ZTH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC2YTH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC2ZTH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC3YTH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->PC3ZTH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->SSD1TH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->BIT1PERIOD, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->SSD2TH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->BIT2PERIOD, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->SSD3TH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->BIT3PERIOD, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->DEDX1TH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->DEDX2TH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->DEDX3TH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->DET1TRIG, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->DET1EVENT, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->DET1GAIN, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->DET1CHANNELS, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshshk_ptr->DET2TRIG, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->DET2EVENT, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->DET2GAIN, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->DET2CHANNELS, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshshk_ptr->DET3TRIG, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->DET3EVENT, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->DET3GAIN, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->DET3CHANNELS, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshshk_ptr->ACTRCTRL, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshshk_ptr->FANPRIOR, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ACTRSAMPLE, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMOP3, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMOP2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMOP1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMUP3, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMUP2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMUP1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMDISCHG, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARM30KI, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARM30KV, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARM2KVC, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARM2KVB, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARM2KVA, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARM2KI, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARM2KV, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARM75I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARM75V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMM15I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMM15V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMP15I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMP15V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMM5I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMM5V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMP5I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshshk_ptr->ALARMP5V, ((1)*(1)) );
   ptr+= ((1)*(1));
}

/*   unpack function    */

void unpack_s3_shk(uint8 *data, struct sshshk *sshshk_ptr)
{
int32 ptr=0;

   memcpy(&sshshk_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&sshshk_ptr->sctime_collection, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&sshshk_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&sshshk_ptr->HKSECTOR, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->P5I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->M5I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->P15I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->M15I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->P5V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->M5V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->P15V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->M15V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_30KI, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_30KV, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KI, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KV, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_75I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_75V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->P5T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->P15T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KAV, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KBV, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KCV, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->VAL1I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->VAL2I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->VAL3I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->VAL1V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->VAL2V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->VAL3V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->BASET, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->SSD1T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->SSD2T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->SSD3T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->TANKT, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->EBOXT, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->HV30T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->COLLT, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->PC1T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->PC2T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->PC3T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->GRMT, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FILL1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FILL2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FILL3, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->POWERS, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->RELAYS, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->OVERI, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->P15LIM, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->M15LIM, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->P5LIM, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->M5LIM, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_30KSTATH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_30KSET, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_30KSTATL, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KASTATH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KASET, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KASTATL, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KBSTATH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KBSET, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KBSTATL, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KCSTATH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KCSET, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_2KCSTATL, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_75STATH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_75SET, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->_75STATL, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->PC1P, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshshk_ptr->PC2P, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshshk_ptr->PC3P, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshshk_ptr->LINEP, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshshk_ptr->PC1O, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->PC2O, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->PC3O, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMS, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN1MODE, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN1BASE, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN1LOGIC, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN1PCY, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN1PCZ, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN1SSD, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN1BANK, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN1BLOCK, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN1DATA, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN2MODE, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN2BASE, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN2LOGIC, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN2PCY, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN2PCZ, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN2SSD, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN2BANK, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN2BLOCK, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN2DATA, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN3MODE, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN3BASE, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN3LOGIC, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN3PCY, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN3PCZ, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN3SSD, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN3BANK, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN3BLOCK, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->FAN3DATA, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->PC1YTH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->PC1ZTH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->PC2YTH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->PC2ZTH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->PC3YTH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->PC3ZTH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->SSD1TH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->BIT1PERIOD, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->SSD2TH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->BIT2PERIOD, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->SSD3TH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->BIT3PERIOD, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->DEDX1TH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->DEDX2TH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->DEDX3TH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->DET1TRIG, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->DET1EVENT, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->DET1GAIN, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->DET1CHANNELS, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshshk_ptr->DET2TRIG, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->DET2EVENT, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->DET2GAIN, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->DET2CHANNELS, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshshk_ptr->DET3TRIG, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->DET3EVENT, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->DET3GAIN, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->DET3CHANNELS, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshshk_ptr->ACTRCTRL, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshshk_ptr->FANPRIOR, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ACTRSAMPLE, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshshk_ptr->ALARMOP3, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMOP2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMOP1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMUP3, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMUP2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMUP1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMDISCHG, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARM30KI, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARM30KV, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARM2KVC, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARM2KVB, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARM2KVA, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARM2KI, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARM2KV, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARM75I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARM75V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMM15I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMM15V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMP15I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMP15V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMM5I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMM5V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMP5I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshshk_ptr->ALARMP5V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
}
