/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: schskp.h,v 1.8 1997/05/06 22:00:58 jeff Exp $ */

#include "schskp.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2, sds_id_r3, sds_id_w3, sds_id_r4, sds_id_w4, sds_id_r5, sds_id_w5, sds_id_r6, sds_id_w6, sds_id_r7, sds_id_w7, sds_id_r8, sds_id_w8, sds_id_r9, sds_id_w9, sds_id_r10, sds_id_w10, sds_id_r11, sds_id_w11, sds_id_r12, sds_id_w12, sds_id_r13, sds_id_w13, sds_id_r14, sds_id_w14, sds_id_r15, sds_id_w15, sds_id_r16, sds_id_w16, sds_id_r17, sds_id_w17, sds_id_r18, sds_id_w18, sds_id_r19, sds_id_w19, sds_id_r20, sds_id_w20, sds_id_r21, sds_id_w21, sds_id_r22, sds_id_w22, sds_id_r23, sds_id_w23, sds_id_r24, sds_id_w24, sds_id_r25, sds_id_w25;


/****  init write function  ****/

int32 init_wr_schskp(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[2];
  int32 rank;

  void schskp_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpschskp");
    Vsetclass(vgrp_id, "CVgrpschskp");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "SCHskpData");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sc_clk", DFNT_UINT32, (1) )) {
     schskp_error("VSfdefine sc_clk error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "TankA1Temp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine TankA1Temp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "TankA2Temp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine TankA2Temp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "TankB1Temp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine TankB1Temp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "TankB2Temp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine TankB2Temp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "LinesATemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine LinesATemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "LinesBTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine LinesBTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "LinesPosXTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine LinesPosXTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "LinesNegXTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine LinesNegXTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "StarTrkTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine StarTrkTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "InstDeckTemp1", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine InstDeckTemp1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "InstDeckTemp2", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine InstDeckTemp2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "InstDeckTemp3", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine InstDeckTemp3 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "InstDeckTemp4", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine InstDeckTemp4 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "InstDeckTemp5", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine InstDeckTemp5 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "InstDeckTemp6", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine InstDeckTemp6 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "InstDeckTemp7", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine InstDeckTemp7 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "InstDeckTemp8", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine InstDeckTemp8 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ScIFHeaterCur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine ScIFHeaterCur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SunSnsrTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine SunSnsrTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PosXSAPTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine PosXSAPTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PosXSAPHTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine PosXSAPHTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "NegXSAPTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine NegXSAPTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "NegXSAPHTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine NegXSAPHTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagInTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine MagInTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagOutTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine MagOutTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagInHtrPwrLvl", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine MagInHtrPwrLvl error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagOutHtrPwrLvl", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine MagOutHtrPwrLvl error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "S3DPUPwrCvtVolt", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine S3DPUPwrCvtVolt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PwrSubProACur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine PwrSubProACur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PwrSubProBCur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine PwrSubProBCur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "AxialThrstCur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine AxialThrstCur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Channel25", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Channel25 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Channel26", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Channel26 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Channel20", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Channel20 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Channel30", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Channel30 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DigTellLog0", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine DigTellLog0 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DigTellLog1", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine DigTellLog1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagSenIntTempPosY", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine MagSenIntTempPosY error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagSenIntTempNegY", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine MagSenIntTempNegY error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwepamE_8VPSMon", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine SwepamE_8VPSMon error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwepamE_HVMon1", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine SwepamE_HVMon1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwepamE_HVMon2", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine SwepamE_HVMon2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwepamI_8VPSMon", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine SwepamI_8VPSMon error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwepamI_HVMon1", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine SwepamI_HVMon1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwepamI_HVMon2", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine SwepamI_HVMon2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Epam_A1", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Epam_A1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Epam_A2", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Epam_A2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Epam_A3", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Epam_A3 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Epam_A4", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Epam_A4 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Epam_LAN1", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Epam_LAN1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Epam_LAN2A", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Epam_LAN2A error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Epam_LAN2B", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Epam_LAN2B error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Uleis_LVPSVolt", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Uleis_LVPSVolt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Cris_IntTemp1", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Cris_IntTemp1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Cris_IntTemp2", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Cris_IntTemp2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Sis_IntTemp1", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Sis_IntTemp1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Sis_IntTemp2", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Sis_IntTemp2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SunPulPhaAng0", DFNT_UINT16, (1) )) {
     schskp_error("VSfdefine SunPulPhaAng0 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "data_10_2", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine data_10_2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Cris_Cur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Cris_Cur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Sis_Cur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Sis_Cur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Epam_Cur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Epam_Cur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Epam_HtrCur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Epam_HtrCur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Uleis_Cur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Uleis_Cur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Uleis_AnaEleLVPSCur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Uleis_AnaEleLVPSCur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DCM1_Chan21", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine DCM1_Chan21 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Uleis_HtrCur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Uleis_HtrCur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwepamE_Cur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine SwepamE_Cur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwepamI_Cur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine SwepamI_Cur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Swims_Cur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Swims_Cur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Swics_Cur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Swics_Cur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Sepica_Cur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Sepica_Cur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Mag_Cur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Mag_Cur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "S3DPU_Cur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine S3DPU_Cur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "S3DPU_ConSecCur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine S3DPU_ConSecCur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PreTraCur", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine PreTraCur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Swims_IntTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Swims_IntTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Swics_IntTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Swics_IntTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Uleis_TelTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Uleis_TelTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Uleis_AnaEleTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Uleis_AnaEleTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Uleis_DPUTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Uleis_DPUTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Sepica_IsoTanTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine Sepica_IsoTanTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "S3DPU_PowSupATemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine S3DPU_PowSupATemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwepamE_IntTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine SwepamE_IntTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwepamI_IntTemp", DFNT_UINT8, (1) )) {
     schskp_error("VSfdefine SwepamI_IntTemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SunPulPhaAng8", DFNT_UINT16, (1) )) {
     schskp_error("VSfdefine SunPulPhaAng8 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "ADCPhaAng", DFNT_UINT16, (1) )) {
     schskp_error("VSfdefine ADCPhaAng error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sc_clk, TankA1Temp, TankA2Temp, TankB1Temp, TankB2Temp, LinesATemp, LinesBTemp, LinesPosXTemp, LinesNegXTemp, StarTrkTemp, InstDeckTemp1, InstDeckTemp2, InstDeckTemp3, InstDeckTemp4, InstDeckTemp5, InstDeckTemp6, InstDeckTemp7, InstDeckTemp8, ScIFHeaterCur, SunSnsrTemp, PosXSAPTemp, PosXSAPHTemp, NegXSAPTemp, NegXSAPHTemp, MagInTemp, MagOutTemp, MagInHtrPwrLvl, MagOutHtrPwrLvl, S3DPUPwrCvtVolt, PwrSubProACur, PwrSubProBCur, AxialThrstCur, Channel25, Channel26, Channel20, Channel30, DigTellLog0, DigTellLog1, MagSenIntTempPosY, MagSenIntTempNegY, SwepamE_8VPSMon, SwepamE_HVMon1, SwepamE_HVMon2, SwepamI_8VPSMon, SwepamI_HVMon1, SwepamI_HVMon2, Epam_A1, Epam_A2, Epam_A3, Epam_A4, Epam_LAN1, Epam_LAN2A, Epam_LAN2B, Uleis_LVPSVolt, Cris_IntTemp1, Cris_IntTemp2, Sis_IntTemp1, Sis_IntTemp2, SunPulPhaAng0, data_10_2, Cris_Cur, Sis_Cur, Epam_Cur, Epam_HtrCur, Uleis_Cur, Uleis_AnaEleLVPSCur, DCM1_Chan21, Uleis_HtrCur, SwepamE_Cur, SwepamI_Cur, Swims_Cur, Swics_Cur, Sepica_Cur, Mag_Cur, S3DPU_Cur, S3DPU_ConSecCur, PreTraCur, Swims_IntTemp, Swics_IntTemp, Uleis_TelTemp, Uleis_AnaEleTemp, Uleis_DPUTemp, Sepica_IsoTanTemp, S3DPU_PowSupATemp, SwepamE_IntTemp, SwepamI_IntTemp, SunPulPhaAng8, ADCPhaAng")){
    schskp_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 3;
  if((sds_id_w1=SDcreate(sd_id, "SCHskpData_LastSPTT0", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_LastSPTT0 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 16;
  if((sds_id_w2=SDcreate(sd_id, "SCHskpData_data_2_1", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_data_2_1 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 2;
  if((sds_id_w3=SDcreate(sd_id, "SCHskpData_data_2_2", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_data_2_2 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 20;
  if((sds_id_w4=SDcreate(sd_id, "SCHskpData_data_3_1", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_data_3_1 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 20;
  if((sds_id_w5=SDcreate(sd_id, "SCHskpData_data_4_1", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_data_4_1 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 20;
  if((sds_id_w6=SDcreate(sd_id, "SCHskpData_data_5_1", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_data_5_1 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 20;
  if((sds_id_w7=SDcreate(sd_id, "SCHskpData_data_6_1", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_data_6_1 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 20;
  if((sds_id_w8=SDcreate(sd_id, "SCHskpData_data_7_1", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_data_7_1 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 17;
  if((sds_id_w9=SDcreate(sd_id, "SCHskpData_data_8_1", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_data_8_1 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 3;
  if((sds_id_w10=SDcreate(sd_id, "SCHskpData_LastSPTT8", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_LastSPTT8 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 2;
  if((sds_id_w11=SDcreate(sd_id, "SCHskpData_data_10_1", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_data_10_1 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 2;
  if((sds_id_w12=SDcreate(sd_id, "SCHskpData_data_10_3", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_data_10_3 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 14;
  if((sds_id_w13=SDcreate(sd_id, "SCHskpData_PowSwiOrdBit", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_PowSwiOrdBit \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 4;
  if((sds_id_w14=SDcreate(sd_id, "SCHskpData_data_11_1", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_data_11_1 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 8;
  if((sds_id_w15=SDcreate(sd_id, "SCHskpData_StarScan", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_StarScan \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 3;
  if((sds_id_w16=SDcreate(sd_id, "SCHskpData_data_12_1", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_data_12_1 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 48;
  if((sds_id_w17=SDcreate(sd_id, "SCHskpData_CDH_HKdat", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_CDH_HKdat \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 10;
  if((sds_id_w18=SDcreate(sd_id, "SCHskpData_data_15_1", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_data_15_1 \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 16;
  if((sds_id_w19=SDcreate(sd_id, "SCHskpData_SelTelByt", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_SelTelByt \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 16;
  if((sds_id_w20=SDcreate(sd_id, "SCHskpData_SCIPhaAng", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_SCIPhaAng \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 16;
  if((sds_id_w21=SDcreate(sd_id, "SCHskpData_FormatID", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_FormatID \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 16;
  if((sds_id_w22=SDcreate(sd_id, "SCHskpData_CollForm", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_CollForm \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 11;
  if((sds_id_w23=SDcreate(sd_id, "SCHskpData_SunSensor", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_SunSensor \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 51;
  if((sds_id_w24=SDcreate(sd_id, "SCHskpData_ADCXtrDat", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_ADCXtrDat \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = 17;
  if((sds_id_w25=SDcreate(sd_id, "SCHskpData_spare", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create SCHskpData_spare \n");

  return(retval);
}

/****** write function ******/

int32 write_schskp(struct SCHskpData SCHskpData_struc)
{
int32 start[2], edges[2];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_schskp();

  odata = (uint8 *) malloc(sizeof(struct SCHskpData));
  pack_schskp(odata, &SCHskpData_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing SCHSKP data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  edges[0] = 1;

  edges[1] = 3;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (SCHskpData_struc.LastSPTT0 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing LastSPTT0 data.\n");
  }
  edges[1] = 16;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (SCHskpData_struc.data_2_1 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data_2_1 data.\n");
  }
  edges[1] = 2;
  if (SDwritedata(sds_id_w3,start,NULL,edges,(VOIDP) (SCHskpData_struc.data_2_2 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data_2_2 data.\n");
  }
  edges[1] = 20;
  if (SDwritedata(sds_id_w4,start,NULL,edges,(VOIDP) (SCHskpData_struc.data_3_1 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data_3_1 data.\n");
  }
  edges[1] = 20;
  if (SDwritedata(sds_id_w5,start,NULL,edges,(VOIDP) (SCHskpData_struc.data_4_1 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data_4_1 data.\n");
  }
  edges[1] = 20;
  if (SDwritedata(sds_id_w6,start,NULL,edges,(VOIDP) (SCHskpData_struc.data_5_1 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data_5_1 data.\n");
  }
  edges[1] = 20;
  if (SDwritedata(sds_id_w7,start,NULL,edges,(VOIDP) (SCHskpData_struc.data_6_1 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data_6_1 data.\n");
  }
  edges[1] = 20;
  if (SDwritedata(sds_id_w8,start,NULL,edges,(VOIDP) (SCHskpData_struc.data_7_1 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data_7_1 data.\n");
  }
  edges[1] = 17;
  if (SDwritedata(sds_id_w9,start,NULL,edges,(VOIDP) (SCHskpData_struc.data_8_1 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data_8_1 data.\n");
  }
  edges[1] = 3;
  if (SDwritedata(sds_id_w10,start,NULL,edges,(VOIDP) (SCHskpData_struc.LastSPTT8 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing LastSPTT8 data.\n");
  }
  edges[1] = 2;
  if (SDwritedata(sds_id_w11,start,NULL,edges,(VOIDP) (SCHskpData_struc.data_10_1 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data_10_1 data.\n");
  }
  edges[1] = 2;
  if (SDwritedata(sds_id_w12,start,NULL,edges,(VOIDP) (SCHskpData_struc.data_10_3 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data_10_3 data.\n");
  }
  edges[1] = 14;
  if (SDwritedata(sds_id_w13,start,NULL,edges,(VOIDP) (SCHskpData_struc.PowSwiOrdBit ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing PowSwiOrdBit data.\n");
  }
  edges[1] = 4;
  if (SDwritedata(sds_id_w14,start,NULL,edges,(VOIDP) (SCHskpData_struc.data_11_1 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data_11_1 data.\n");
  }
  edges[1] = 8;
  if (SDwritedata(sds_id_w15,start,NULL,edges,(VOIDP) (SCHskpData_struc.StarScan ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing StarScan data.\n");
  }
  edges[1] = 3;
  if (SDwritedata(sds_id_w16,start,NULL,edges,(VOIDP) (SCHskpData_struc.data_12_1 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data_12_1 data.\n");
  }
  edges[1] = 48;
  if (SDwritedata(sds_id_w17,start,NULL,edges,(VOIDP) (SCHskpData_struc.CDH_HKdat ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing CDH_HKdat data.\n");
  }
  edges[1] = 10;
  if (SDwritedata(sds_id_w18,start,NULL,edges,(VOIDP) (SCHskpData_struc.data_15_1 ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing data_15_1 data.\n");
  }
  edges[1] = 16;
  if (SDwritedata(sds_id_w19,start,NULL,edges,(VOIDP) (SCHskpData_struc.SelTelByt ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing SelTelByt data.\n");
  }
  edges[1] = 16;
  if (SDwritedata(sds_id_w20,start,NULL,edges,(VOIDP) (SCHskpData_struc.SCIPhaAng ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing SCIPhaAng data.\n");
  }
  edges[1] = 16;
  if (SDwritedata(sds_id_w21,start,NULL,edges,(VOIDP) (SCHskpData_struc.FormatID ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing FormatID data.\n");
  }
  edges[1] = 16;
  if (SDwritedata(sds_id_w22,start,NULL,edges,(VOIDP) (SCHskpData_struc.CollForm ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing CollForm data.\n");
  }
  edges[1] = 11;
  if (SDwritedata(sds_id_w23,start,NULL,edges,(VOIDP) (SCHskpData_struc.SunSensor ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing SunSensor data.\n");
  }
  edges[1] = 51;
  if (SDwritedata(sds_id_w24,start,NULL,edges,(VOIDP) (SCHskpData_struc.ADCXtrDat ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing ADCXtrDat data.\n");
  }
  edges[1] = 17;
  if (SDwritedata(sds_id_w25,start,NULL,edges,(VOIDP) (SCHskpData_struc.spare ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing spare data.\n");
  }
  memset(&SCHskpData_struc, 0, sizeof(struct SCHskpData));
  free(odata);
  return(retval);
}

void close_wr_schskp() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
  SDendaccess(sds_id_w3);
  SDendaccess(sds_id_w4);
  SDendaccess(sds_id_w5);
  SDendaccess(sds_id_w6);
  SDendaccess(sds_id_w7);
  SDendaccess(sds_id_w8);
  SDendaccess(sds_id_w9);
  SDendaccess(sds_id_w10);
  SDendaccess(sds_id_w11);
  SDendaccess(sds_id_w12);
  SDendaccess(sds_id_w13);
  SDendaccess(sds_id_w14);
  SDendaccess(sds_id_w15);
  SDendaccess(sds_id_w16);
  SDendaccess(sds_id_w17);
  SDendaccess(sds_id_w18);
  SDendaccess(sds_id_w19);
  SDendaccess(sds_id_w20);
  SDendaccess(sds_id_w21);
  SDendaccess(sds_id_w22);
  SDendaccess(sds_id_w23);
  SDendaccess(sds_id_w24);
  SDendaccess(sds_id_w25);
}

/*     init read function    */

int32 init_rd_schskp(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  static int32 sds_index3;
  static int32 sds_index4;
  static int32 sds_index5;
  static int32 sds_index6;
  static int32 sds_index7;
  static int32 sds_index8;
  static int32 sds_index9;
  static int32 sds_index10;
  static int32 sds_index11;
  static int32 sds_index12;
  static int32 sds_index13;
  static int32 sds_index14;
  static int32 sds_index15;
  static int32 sds_index16;
  static int32 sds_index17;
  static int32 sds_index18;
  static int32 sds_index19;
  static int32 sds_index20;
  static int32 sds_index21;
  static int32 sds_index22;
  static int32 sds_index23;
  static int32 sds_index24;
  static int32 sds_index25;
  int32 vdata_ref;
  int32 retval=0;

  void schskp_error();

    if((sds_index1=SDnametoindex(sd_id, "SCHskpData_LastSPTT0" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_LastSPTT0\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "SCHskpData_data_2_1" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_data_2_1\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }
    if((sds_index3=SDnametoindex(sd_id, "SCHskpData_data_2_2" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_data_2_2\n");
      retval = -1;
    }
    if((sds_id_r3=SDselect(sd_id, sds_index3))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index3\n");
      retval = -1;
    }
    if((sds_index4=SDnametoindex(sd_id, "SCHskpData_data_3_1" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_data_3_1\n");
      retval = -1;
    }
    if((sds_id_r4=SDselect(sd_id, sds_index4))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index4\n");
      retval = -1;
    }
    if((sds_index5=SDnametoindex(sd_id, "SCHskpData_data_4_1" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_data_4_1\n");
      retval = -1;
    }
    if((sds_id_r5=SDselect(sd_id, sds_index5))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index5\n");
      retval = -1;
    }
    if((sds_index6=SDnametoindex(sd_id, "SCHskpData_data_5_1" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_data_5_1\n");
      retval = -1;
    }
    if((sds_id_r6=SDselect(sd_id, sds_index6))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index6\n");
      retval = -1;
    }
    if((sds_index7=SDnametoindex(sd_id, "SCHskpData_data_6_1" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_data_6_1\n");
      retval = -1;
    }
    if((sds_id_r7=SDselect(sd_id, sds_index7))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index7\n");
      retval = -1;
    }
    if((sds_index8=SDnametoindex(sd_id, "SCHskpData_data_7_1" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_data_7_1\n");
      retval = -1;
    }
    if((sds_id_r8=SDselect(sd_id, sds_index8))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index8\n");
      retval = -1;
    }
    if((sds_index9=SDnametoindex(sd_id, "SCHskpData_data_8_1" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_data_8_1\n");
      retval = -1;
    }
    if((sds_id_r9=SDselect(sd_id, sds_index9))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index9\n");
      retval = -1;
    }
    if((sds_index10=SDnametoindex(sd_id, "SCHskpData_LastSPTT8" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_LastSPTT8\n");
      retval = -1;
    }
    if((sds_id_r10=SDselect(sd_id, sds_index10))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index10\n");
      retval = -1;
    }
    if((sds_index11=SDnametoindex(sd_id, "SCHskpData_data_10_1" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_data_10_1\n");
      retval = -1;
    }
    if((sds_id_r11=SDselect(sd_id, sds_index11))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index11\n");
      retval = -1;
    }
    if((sds_index12=SDnametoindex(sd_id, "SCHskpData_data_10_3" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_data_10_3\n");
      retval = -1;
    }
    if((sds_id_r12=SDselect(sd_id, sds_index12))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index12\n");
      retval = -1;
    }
    if((sds_index13=SDnametoindex(sd_id, "SCHskpData_PowSwiOrdBit" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_PowSwiOrdBit\n");
      retval = -1;
    }
    if((sds_id_r13=SDselect(sd_id, sds_index13))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index13\n");
      retval = -1;
    }
    if((sds_index14=SDnametoindex(sd_id, "SCHskpData_data_11_1" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_data_11_1\n");
      retval = -1;
    }
    if((sds_id_r14=SDselect(sd_id, sds_index14))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index14\n");
      retval = -1;
    }
    if((sds_index15=SDnametoindex(sd_id, "SCHskpData_StarScan" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_StarScan\n");
      retval = -1;
    }
    if((sds_id_r15=SDselect(sd_id, sds_index15))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index15\n");
      retval = -1;
    }
    if((sds_index16=SDnametoindex(sd_id, "SCHskpData_data_12_1" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_data_12_1\n");
      retval = -1;
    }
    if((sds_id_r16=SDselect(sd_id, sds_index16))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index16\n");
      retval = -1;
    }
    if((sds_index17=SDnametoindex(sd_id, "SCHskpData_CDH_HKdat" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_CDH_HKdat\n");
      retval = -1;
    }
    if((sds_id_r17=SDselect(sd_id, sds_index17))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index17\n");
      retval = -1;
    }
    if((sds_index18=SDnametoindex(sd_id, "SCHskpData_data_15_1" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_data_15_1\n");
      retval = -1;
    }
    if((sds_id_r18=SDselect(sd_id, sds_index18))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index18\n");
      retval = -1;
    }
    if((sds_index19=SDnametoindex(sd_id, "SCHskpData_SelTelByt" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_SelTelByt\n");
      retval = -1;
    }
    if((sds_id_r19=SDselect(sd_id, sds_index19))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index19\n");
      retval = -1;
    }
    if((sds_index20=SDnametoindex(sd_id, "SCHskpData_SCIPhaAng" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_SCIPhaAng\n");
      retval = -1;
    }
    if((sds_id_r20=SDselect(sd_id, sds_index20))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index20\n");
      retval = -1;
    }
    if((sds_index21=SDnametoindex(sd_id, "SCHskpData_FormatID" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_FormatID\n");
      retval = -1;
    }
    if((sds_id_r21=SDselect(sd_id, sds_index21))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index21\n");
      retval = -1;
    }
    if((sds_index22=SDnametoindex(sd_id, "SCHskpData_CollForm" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_CollForm\n");
      retval = -1;
    }
    if((sds_id_r22=SDselect(sd_id, sds_index22))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index22\n");
      retval = -1;
    }
    if((sds_index23=SDnametoindex(sd_id, "SCHskpData_SunSensor" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_SunSensor\n");
      retval = -1;
    }
    if((sds_id_r23=SDselect(sd_id, sds_index23))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index23\n");
      retval = -1;
    }
    if((sds_index24=SDnametoindex(sd_id, "SCHskpData_ADCXtrDat" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_ADCXtrDat\n");
      retval = -1;
    }
    if((sds_id_r24=SDselect(sd_id, sds_index24))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index24\n");
      retval = -1;
    }
    if((sds_index25=SDnametoindex(sd_id, "SCHskpData_spare" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find SCHskpData_spare\n");
      retval = -1;
    }
    if((sds_id_r25=SDselect(sd_id, sds_index25))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index25\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "SCHskpData"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sc_clk, TankA1Temp, TankA2Temp, TankB1Temp, TankB2Temp, LinesATemp, LinesBTemp, LinesPosXTemp, LinesNegXTemp, StarTrkTemp, InstDeckTemp1, InstDeckTemp2, InstDeckTemp3, InstDeckTemp4, InstDeckTemp5, InstDeckTemp6, InstDeckTemp7, InstDeckTemp8, ScIFHeaterCur, SunSnsrTemp, PosXSAPTemp, PosXSAPHTemp, NegXSAPTemp, NegXSAPHTemp, MagInTemp, MagOutTemp, MagInHtrPwrLvl, MagOutHtrPwrLvl, S3DPUPwrCvtVolt, PwrSubProACur, PwrSubProBCur, AxialThrstCur, Channel25, Channel26, Channel20, Channel30, DigTellLog0, DigTellLog1, MagSenIntTempPosY, MagSenIntTempNegY, SwepamE_8VPSMon, SwepamE_HVMon1, SwepamE_HVMon2, SwepamI_8VPSMon, SwepamI_HVMon1, SwepamI_HVMon2, Epam_A1, Epam_A2, Epam_A3, Epam_A4, Epam_LAN1, Epam_LAN2A, Epam_LAN2B, Uleis_LVPSVolt, Cris_IntTemp1, Cris_IntTemp2, Sis_IntTemp1, Sis_IntTemp2, SunPulPhaAng0, data_10_2, Cris_Cur, Sis_Cur, Epam_Cur, Epam_HtrCur, Uleis_Cur, Uleis_AnaEleLVPSCur, DCM1_Chan21, Uleis_HtrCur, SwepamE_Cur, SwepamI_Cur, Swims_Cur, Swics_Cur, Sepica_Cur, Mag_Cur, S3DPU_Cur, S3DPU_ConSecCur, PreTraCur, Swims_IntTemp, Swics_IntTemp, Uleis_TelTemp, Uleis_AnaEleTemp, Uleis_DPUTemp, Sepica_IsoTanTemp, S3DPU_PowSupATemp, SwepamE_IntTemp, SwepamI_IntTemp, SunPulPhaAng8, ADCPhaAng")) {
    schskp_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_schskp(struct SCHskpData *SCHskpData_struc, int32 recnum_rd)
{
int32 start[2], edges[2];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_schskp();

  start[0] = recnum_rd;
  start[1] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct SCHskpData));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = 3;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(SCHskpData_struc->LastSPTT0 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read LastSPTT0\n");
    retval = -1;
  }
  edges[1] = 16;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(SCHskpData_struc->data_2_1 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data_2_1\n");
    retval = -1;
  }
  edges[1] = 2;
  if(SDreaddata(sds_id_r3,start,NULL,edges, (VOIDP)(SCHskpData_struc->data_2_2 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data_2_2\n");
    retval = -1;
  }
  edges[1] = 20;
  if(SDreaddata(sds_id_r4,start,NULL,edges, (VOIDP)(SCHskpData_struc->data_3_1 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data_3_1\n");
    retval = -1;
  }
  edges[1] = 20;
  if(SDreaddata(sds_id_r5,start,NULL,edges, (VOIDP)(SCHskpData_struc->data_4_1 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data_4_1\n");
    retval = -1;
  }
  edges[1] = 20;
  if(SDreaddata(sds_id_r6,start,NULL,edges, (VOIDP)(SCHskpData_struc->data_5_1 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data_5_1\n");
    retval = -1;
  }
  edges[1] = 20;
  if(SDreaddata(sds_id_r7,start,NULL,edges, (VOIDP)(SCHskpData_struc->data_6_1 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data_6_1\n");
    retval = -1;
  }
  edges[1] = 20;
  if(SDreaddata(sds_id_r8,start,NULL,edges, (VOIDP)(SCHskpData_struc->data_7_1 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data_7_1\n");
    retval = -1;
  }
  edges[1] = 17;
  if(SDreaddata(sds_id_r9,start,NULL,edges, (VOIDP)(SCHskpData_struc->data_8_1 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data_8_1\n");
    retval = -1;
  }
  edges[1] = 3;
  if(SDreaddata(sds_id_r10,start,NULL,edges, (VOIDP)(SCHskpData_struc->LastSPTT8 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read LastSPTT8\n");
    retval = -1;
  }
  edges[1] = 2;
  if(SDreaddata(sds_id_r11,start,NULL,edges, (VOIDP)(SCHskpData_struc->data_10_1 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data_10_1\n");
    retval = -1;
  }
  edges[1] = 2;
  if(SDreaddata(sds_id_r12,start,NULL,edges, (VOIDP)(SCHskpData_struc->data_10_3 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data_10_3\n");
    retval = -1;
  }
  edges[1] = 14;
  if(SDreaddata(sds_id_r13,start,NULL,edges, (VOIDP)(SCHskpData_struc->PowSwiOrdBit ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read PowSwiOrdBit\n");
    retval = -1;
  }
  edges[1] = 4;
  if(SDreaddata(sds_id_r14,start,NULL,edges, (VOIDP)(SCHskpData_struc->data_11_1 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data_11_1\n");
    retval = -1;
  }
  edges[1] = 8;
  if(SDreaddata(sds_id_r15,start,NULL,edges, (VOIDP)(SCHskpData_struc->StarScan ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read StarScan\n");
    retval = -1;
  }
  edges[1] = 3;
  if(SDreaddata(sds_id_r16,start,NULL,edges, (VOIDP)(SCHskpData_struc->data_12_1 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data_12_1\n");
    retval = -1;
  }
  edges[1] = 48;
  if(SDreaddata(sds_id_r17,start,NULL,edges, (VOIDP)(SCHskpData_struc->CDH_HKdat ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read CDH_HKdat\n");
    retval = -1;
  }
  edges[1] = 10;
  if(SDreaddata(sds_id_r18,start,NULL,edges, (VOIDP)(SCHskpData_struc->data_15_1 ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read data_15_1\n");
    retval = -1;
  }
  edges[1] = 16;
  if(SDreaddata(sds_id_r19,start,NULL,edges, (VOIDP)(SCHskpData_struc->SelTelByt ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read SelTelByt\n");
    retval = -1;
  }
  edges[1] = 16;
  if(SDreaddata(sds_id_r20,start,NULL,edges, (VOIDP)(SCHskpData_struc->SCIPhaAng ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read SCIPhaAng\n");
    retval = -1;
  }
  edges[1] = 16;
  if(SDreaddata(sds_id_r21,start,NULL,edges, (VOIDP)(SCHskpData_struc->FormatID ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read FormatID\n");
    retval = -1;
  }
  edges[1] = 16;
  if(SDreaddata(sds_id_r22,start,NULL,edges, (VOIDP)(SCHskpData_struc->CollForm ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read CollForm\n");
    retval = -1;
  }
  edges[1] = 11;
  if(SDreaddata(sds_id_r23,start,NULL,edges, (VOIDP)(SCHskpData_struc->SunSensor ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read SunSensor\n");
    retval = -1;
  }
  edges[1] = 51;
  if(SDreaddata(sds_id_r24,start,NULL,edges, (VOIDP)(SCHskpData_struc->ADCXtrDat ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read ADCXtrDat\n");
    retval = -1;
  }
  edges[1] = 17;
  if(SDreaddata(sds_id_r25,start,NULL,edges, (VOIDP)(SCHskpData_struc->spare ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read spare\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_schskp(odata, SCHskpData_struc);
  free(odata);
  return(retval);
}

void schskp_error(int8 *mess)
  { fprintf(stderr,"SCHSKP: %s\n",mess); }

void close_rd_schskp() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
  SDendaccess(sds_id_r3);
  SDendaccess(sds_id_r4);
  SDendaccess(sds_id_r5);
  SDendaccess(sds_id_r6);
  SDendaccess(sds_id_r7);
  SDendaccess(sds_id_r8);
  SDendaccess(sds_id_r9);
  SDendaccess(sds_id_r10);
  SDendaccess(sds_id_r11);
  SDendaccess(sds_id_r12);
  SDendaccess(sds_id_r13);
  SDendaccess(sds_id_r14);
  SDendaccess(sds_id_r15);
  SDendaccess(sds_id_r16);
  SDendaccess(sds_id_r17);
  SDendaccess(sds_id_r18);
  SDendaccess(sds_id_r19);
  SDendaccess(sds_id_r20);
  SDendaccess(sds_id_r21);
  SDendaccess(sds_id_r22);
  SDendaccess(sds_id_r23);
  SDendaccess(sds_id_r24);
  SDendaccess(sds_id_r25);
}
/*   pack function    */

void pack_schskp(uint8 *data, struct SCHskpData *SCHskpData_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &SCHskpData_ptr->sc_clk, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->TankA1Temp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->TankA2Temp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->TankB1Temp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->TankB2Temp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->LinesATemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->LinesBTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->LinesPosXTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->LinesNegXTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->StarTrkTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->InstDeckTemp1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->InstDeckTemp2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->InstDeckTemp3, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->InstDeckTemp4, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->InstDeckTemp5, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->InstDeckTemp6, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->InstDeckTemp7, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->InstDeckTemp8, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->ScIFHeaterCur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->SunSnsrTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->PosXSAPTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->PosXSAPHTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->NegXSAPTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->NegXSAPHTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->MagInTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->MagOutTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->MagInHtrPwrLvl, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->MagOutHtrPwrLvl, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->S3DPUPwrCvtVolt, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->PwrSubProACur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->PwrSubProBCur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->AxialThrstCur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Channel25, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Channel26, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Channel20, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Channel30, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->DigTellLog0, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->DigTellLog1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->MagSenIntTempPosY, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->MagSenIntTempNegY, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->SwepamE_8VPSMon, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->SwepamE_HVMon1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->SwepamE_HVMon2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->SwepamI_8VPSMon, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->SwepamI_HVMon1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->SwepamI_HVMon2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Epam_A1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Epam_A2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Epam_A3, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Epam_A4, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Epam_LAN1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Epam_LAN2A, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Epam_LAN2B, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Uleis_LVPSVolt, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Cris_IntTemp1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Cris_IntTemp2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Sis_IntTemp1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Sis_IntTemp2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->SunPulPhaAng0, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->data_10_2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Cris_Cur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Sis_Cur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Epam_Cur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Epam_HtrCur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Uleis_Cur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Uleis_AnaEleLVPSCur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->DCM1_Chan21, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Uleis_HtrCur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->SwepamE_Cur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->SwepamI_Cur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Swims_Cur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Swics_Cur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Sepica_Cur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Mag_Cur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->S3DPU_Cur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->S3DPU_ConSecCur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->PreTraCur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Swims_IntTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Swics_IntTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Uleis_TelTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Uleis_AnaEleTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Uleis_DPUTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->Sepica_IsoTanTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->S3DPU_PowSupATemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->SwepamE_IntTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->SwepamI_IntTemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->SunPulPhaAng8, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SCHskpData_ptr->ADCPhaAng, ((2)*(1)) );
   ptr+= ((2)*(1));
}

/*   unpack function    */

void unpack_schskp(uint8 *data, struct SCHskpData *SCHskpData_ptr)
{
int32 ptr=0;

   memcpy(&SCHskpData_ptr->sc_clk, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SCHskpData_ptr->TankA1Temp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->TankA2Temp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->TankB1Temp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->TankB2Temp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->LinesATemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->LinesBTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->LinesPosXTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->LinesNegXTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->StarTrkTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->InstDeckTemp1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->InstDeckTemp2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->InstDeckTemp3, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->InstDeckTemp4, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->InstDeckTemp5, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->InstDeckTemp6, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->InstDeckTemp7, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->InstDeckTemp8, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->ScIFHeaterCur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->SunSnsrTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->PosXSAPTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->PosXSAPHTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->NegXSAPTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->NegXSAPHTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->MagInTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->MagOutTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->MagInHtrPwrLvl, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->MagOutHtrPwrLvl, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->S3DPUPwrCvtVolt, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->PwrSubProACur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->PwrSubProBCur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->AxialThrstCur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Channel25, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Channel26, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Channel20, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Channel30, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->DigTellLog0, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->DigTellLog1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->MagSenIntTempPosY, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->MagSenIntTempNegY, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->SwepamE_8VPSMon, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->SwepamE_HVMon1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->SwepamE_HVMon2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->SwepamI_8VPSMon, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->SwepamI_HVMon1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->SwepamI_HVMon2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Epam_A1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Epam_A2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Epam_A3, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Epam_A4, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Epam_LAN1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Epam_LAN2A, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Epam_LAN2B, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Uleis_LVPSVolt, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Cris_IntTemp1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Cris_IntTemp2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Sis_IntTemp1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Sis_IntTemp2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->SunPulPhaAng0, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SCHskpData_ptr->data_10_2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Cris_Cur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Sis_Cur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Epam_Cur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Epam_HtrCur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Uleis_Cur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Uleis_AnaEleLVPSCur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->DCM1_Chan21, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Uleis_HtrCur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->SwepamE_Cur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->SwepamI_Cur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Swims_Cur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Swics_Cur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Sepica_Cur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Mag_Cur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->S3DPU_Cur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->S3DPU_ConSecCur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->PreTraCur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Swims_IntTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Swics_IntTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Uleis_TelTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Uleis_AnaEleTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Uleis_DPUTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->Sepica_IsoTanTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->S3DPU_PowSupATemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->SwepamE_IntTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->SwepamI_IntTemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&SCHskpData_ptr->SunPulPhaAng8, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SCHskpData_ptr->ADCPhaAng, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
}
