/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: s3_dhk.h,v 1.1 1997/01/16 17:30:39 jeff Exp $ */

#include "s3_dhk.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;

/****  init write function  ****/

int32 init_wr_s3_dhk(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  void s3_dhk_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrps3_dhk");
    Vsetclass(vgrp_id, "CVgrps3_dhk");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "sshdhk");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime", DFNT_UINT32, (1) )) {
     s3_dhk_error("VSfdefine sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     s3_dhk_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "EDB", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine EDB error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VERSION", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine VERSION error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FLAGS", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine FLAGS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "LUCNT", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine LUCNT error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "IDLECTR", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine IDLECTR error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "JOB", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine JOB error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SMODENEXT", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine SMODENEXT error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SMODE", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine SMODE error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MMODENEXT", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine MMODENEXT error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MMODE", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine MMODE error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CMODENEXT", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine CMODENEXT error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CMODE", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine CMODE error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SPINCTR", DFNT_UINT32, (1) )) {
     s3_dhk_error("VSfdefine SPINCTR error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "RECORDCTR", DFNT_UINT32, (1) )) {
     s3_dhk_error("VSfdefine RECORDCTR error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MPOWER", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine MPOWER error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CPOWER", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine CPOWER error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SPOWER", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine SPOWER error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SUNSECTOR", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine SUNSECTOR error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SECTOR7LEN", DFNT_UINT16, (1) )) {
     s3_dhk_error("VSfdefine SECTOR7LEN error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SECTOR0LEN", DFNT_UINT16, (1) )) {
     s3_dhk_error("VSfdefine SECTOR0LEN error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SPINCLOCKS", DFNT_UINT16, (1) )) {
     s3_dhk_error("VSfdefine SPINCLOCKS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "TTMUX", DFNT_UINT16, (1) )) {
     s3_dhk_error("VSfdefine TTMUX error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "TTSTATUS", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine TTSTATUS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "LUSTROBE", DFNT_UINT16, (1) )) {
     s3_dhk_error("VSfdefine LUSTROBE error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "LUMASK", DFNT_UINT16, (1) )) {
     s3_dhk_error("VSfdefine LUMASK error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "LUSTATE", DFNT_UINT16, (1) )) {
     s3_dhk_error("VSfdefine LUSTATE error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CLASSMUX", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine CLASSMUX error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CMDOK", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine CMDOK error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CMDERR", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine CMDERR error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CMDHIST1", DFNT_UINT16, (1) )) {
     s3_dhk_error("VSfdefine CMDHIST1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CMDHIST2", DFNT_UINT16, (1) )) {
     s3_dhk_error("VSfdefine CMDHIST2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CMDHIST3", DFNT_UINT16, (1) )) {
     s3_dhk_error("VSfdefine CMDHIST3 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PARITYERR", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine PARITYERR error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SCMDERR", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine SCMDERR error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MCMDERR", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine MCMDERR error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CCMDERR", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine CCMDERR error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "EEFILL", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine EEFILL error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MEM0", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine MEM0 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MEM1", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine MEM1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MEM2", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine MEM2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MEM3", DFNT_UINT8, (1) )) {
     s3_dhk_error("VSfdefine MEM3 error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime, QAC, EDB, VERSION, FLAGS, LUCNT, IDLECTR, JOB, SMODENEXT, SMODE, MMODENEXT, MMODE, CMODENEXT, CMODE, SPINCTR, RECORDCTR, MPOWER, CPOWER, SPOWER, SUNSECTOR, SECTOR7LEN, SECTOR0LEN, SPINCLOCKS, TTMUX, TTSTATUS, LUSTROBE, LUMASK, LUSTATE, CLASSMUX, CMDOK, CMDERR, CMDHIST1, CMDHIST2, CMDHIST3, PARITYERR, SCMDERR, MCMDERR, CCMDERR, EEFILL, MEM0, MEM1, MEM2, MEM3")){
    s3_dhk_error("VSsetfields error");
    retval = -1;
  }
  return(retval);
}

/****** write function ******/

int32 write_s3_dhk(struct sshdhk sshdhk_struc)
{
int32 retval = 0;
uint8 *odata;

void pack_s3_dhk();

  odata = (uint8 *) malloc(sizeof(struct sshdhk));
  pack_s3_dhk(odata, &sshdhk_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing S3 DHK data\n");
  } 
  memset(&sshdhk_struc, 0, sizeof(struct sshdhk));
  free(odata);
  return(retval);
}

void close_wr_s3_dhk() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
}

/*     init read function    */

int32 init_rd_s3_dhk(int32 hdf_fp, int32 sd_id)
{
  int32 vdata_ref;
  int32 retval=0;

  void s3_dhk_error();


  if ((vdata_ref = VSfind(hdf_fp, "sshdhk"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime, QAC, EDB, VERSION, FLAGS, LUCNT, IDLECTR, JOB, SMODENEXT, SMODE, MMODENEXT, MMODE, CMODENEXT, CMODE, SPINCTR, RECORDCTR, MPOWER, CPOWER, SPOWER, SUNSECTOR, SECTOR7LEN, SECTOR0LEN, SPINCLOCKS, TTMUX, TTSTATUS, LUSTROBE, LUMASK, LUSTATE, CLASSMUX, CMDOK, CMDERR, CMDHIST1, CMDHIST2, CMDHIST3, PARITYERR, SCMDERR, MCMDERR, CCMDERR, EEFILL, MEM0, MEM1, MEM2, MEM3")) {
    s3_dhk_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_s3_dhk(struct sshdhk *sshdhk_struc, int32 recnum_rd)
{
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_s3_dhk();

  odata = (uint8 *) malloc(sizeof(struct sshdhk));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_s3_dhk(odata, sshdhk_struc);
  free(odata);
  return(retval);
}

void s3_dhk_error(int8 *mess)
  { fprintf(stderr,"S3 DHK: %s\n",mess); }

void close_rd_s3_dhk() {
  VSdetach(vdata_id_r);
}
/*   pack function    */

void pack_s3_dhk(uint8 *data, struct sshdhk *sshdhk_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &sshdhk_ptr->sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &sshdhk_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &sshdhk_ptr->EDB, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->VERSION, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->FLAGS, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->LUCNT, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->IDLECTR, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->JOB, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->SMODENEXT, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->SMODE, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->MMODENEXT, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->MMODE, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->CMODENEXT, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->CMODE, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->SPINCTR, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &sshdhk_ptr->RECORDCTR, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &sshdhk_ptr->MPOWER, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->CPOWER, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->SPOWER, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->SUNSECTOR, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->SECTOR7LEN, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshdhk_ptr->SECTOR0LEN, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshdhk_ptr->SPINCLOCKS, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshdhk_ptr->TTMUX, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshdhk_ptr->TTSTATUS, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->LUSTROBE, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshdhk_ptr->LUMASK, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshdhk_ptr->LUSTATE, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshdhk_ptr->CLASSMUX, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->CMDOK, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->CMDERR, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->CMDHIST1, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshdhk_ptr->CMDHIST2, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshdhk_ptr->CMDHIST3, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &sshdhk_ptr->PARITYERR, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->SCMDERR, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->MCMDERR, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->CCMDERR, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->EEFILL, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->MEM0, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->MEM1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->MEM2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &sshdhk_ptr->MEM3, ((1)*(1)) );
   ptr+= ((1)*(1));
}

/*   unpack function    */

void unpack_s3_dhk(uint8 *data, struct sshdhk *sshdhk_ptr)
{
int32 ptr=0;

   memcpy(&sshdhk_ptr->sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&sshdhk_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&sshdhk_ptr->EDB, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->VERSION, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->FLAGS, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->LUCNT, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->IDLECTR, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->JOB, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->SMODENEXT, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->SMODE, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->MMODENEXT, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->MMODE, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->CMODENEXT, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->CMODE, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->SPINCTR, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&sshdhk_ptr->RECORDCTR, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&sshdhk_ptr->MPOWER, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->CPOWER, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->SPOWER, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->SUNSECTOR, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->SECTOR7LEN, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshdhk_ptr->SECTOR0LEN, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshdhk_ptr->SPINCLOCKS, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshdhk_ptr->TTMUX, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshdhk_ptr->TTSTATUS, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->LUSTROBE, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshdhk_ptr->LUMASK, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshdhk_ptr->LUSTATE, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshdhk_ptr->CLASSMUX, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->CMDOK, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->CMDERR, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->CMDHIST1, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshdhk_ptr->CMDHIST2, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshdhk_ptr->CMDHIST3, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&sshdhk_ptr->PARITYERR, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->SCMDERR, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->MCMDERR, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->CCMDERR, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->EEFILL, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->MEM0, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->MEM1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->MEM2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&sshdhk_ptr->MEM3, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
}
