#include <stdio.h>
#include <string.h>

#include "epam.h"
#include "df.h"

void main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct EpamData testdata;
  int ii,jj,kk,retval;

  if (argc!=2)
    {
      printf("Usage: rd_hdf hdf_file\n");
      exit(1);
    }

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_READ, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);

if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL)
    {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
    }
  init_rd_epam_data(hdf_fp, sd_id);

  ii=0;
  while((retval= read_epam_data(&testdata,ii++))!=FAIL) {
	  printf("sc clock = %8d", testdata.sctime_readout);
	  printf("  %3x \n", testdata.QAC);
	  for(kk=0;kk<16;kk++){
	      for(jj=0;jj<21;jj++) printf("%2x ",testdata.data[kk][jj]);
	      printf("\n");
	  }
	  for(jj=0;jj<8;jj++) printf(" %2x", testdata.InCur[ii]);
	  printf("   ");
	  for(jj=0;jj<8;jj++) printf(" %2x", testdata.Cur[ii]);
	  printf("   ");
	  for(jj=0;jj<8;jj++) printf(" %2x", testdata.Sen2ATemp[ii]);
	  printf("\n");
  }

  /* all done, close HDF file */

  close_rd_epam_data();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL)
    {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
    }
  if (Hclose(hdf_fp)==FAIL)
    {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }

  exit(0);
}
    
