/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.48 1998/09/29 18:21:45 steves Exp  */

/* The include file used to create this file is: */
/* $Id: s3_ssector.h,v 1.5 1998/12/07 18:12:39 ad Exp  */

#include "s3_ssector.h"
#include "mfhdf.h"
#include "df.h"

int32 vgrp_id_s3_ssector;
static int32 vdata_id_s3_ssector;

static int32 sds_id_s3_ssector1;

  /* 1495 is the size of s3_ssector.h + 1 added line */
char Vgrp_descrp_ssector[1495];

/****----  init create function  ----****/

int32 init_cr_s3_ssector(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;

  int32 sds_ref_w1;
  int32 dim_sizes[3];
  int32 rank;

  int32 wr_Vgrp_desc_s3_ssector();

  void print_s3_ssector_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_s3_ssector = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_s3_ssector_error("init_cr_s3_ssector -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_s3_ssector, "VG_ssector"); 
  Vsetclass(vgrp_id_s3_ssector, "VG_S3_SSECTOR");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_ssector" )) ==FAIL) {
    print_s3_ssector_error("init_cr_s3_ssector -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_s3_ssector(Vgrp_descrp_ssector);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_s3_ssector_error("init_cr_s3_ssector -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_ssector, sizeof(Vgrp_descrp_ssector))) ==FAIL) {
    print_s3_ssector_error("init_cr_s3_ssector -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_s3_ssector = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_s3_ssector_error("init_cr_s3_ssector -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_s3_ssector, "ssector");
  VSsetclass(vdata_id_s3_ssector, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_s3_ssector, vdata_id_s3_ssector)) ==FAIL) {
    print_s3_ssector_error("init_cr_s3_ssector -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_s3_ssector, "sctime_readout", DFNT_UINT32, (1) )) {
    print_s3_ssector_error("init_cr_s3_ssector -> VSfdefine: Couldn't define sctime_readout");
    retval = -1;
  }
  if (VSfdefine(vdata_id_s3_ssector, "sctime_collection", DFNT_FLOAT64, (1) )) {
    print_s3_ssector_error("init_cr_s3_ssector -> VSfdefine: Couldn't define sctime_collection");
    retval = -1;
  }
  if (VSfdefine(vdata_id_s3_ssector, "QAC", DFNT_UINT32, (1) )) {
    print_s3_ssector_error("init_cr_s3_ssector -> VSfdefine: Couldn't define QAC");
    retval = -1;
  }

  if (VSsetfields(vdata_id_s3_ssector,"sctime_readout, sctime_collection, QAC")){
    print_s3_ssector_error("init_cr_s3_ssector -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

 /*  Create SDS's and add to the Vgroup  */
  rank = 3;
  dim_sizes[0] = SD_UNLIMITED;
  dim_sizes[1] = SSEC_N;
  dim_sizes[2] = SSEC_S;
  if((sds_id_s3_ssector1 = SDcreate(sd_id, "ssector_SECTOR", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    print_s3_ssector_error("init_cr_s3_ssector -> SDcreate: Couldn't create ssector_SECTOR");

  /*  Add SDS to Vgroup  */
  if((sds_ref_w1 = SDidtoref(sds_id_s3_ssector1)) == FAIL)
    print_s3_ssector_error("init_cr_s3_ssector -> SDidtoref: Couldn't get ref for ssector_SECTOR");

  if((Vaddtagref(vgrp_id_s3_ssector, DFTAG_NDG, sds_ref_w1)) == FAIL)
    print_s3_ssector_error("init_cr_s3_ssector -> Vaddtagref: Couldn't add SDS ssector_SECTOR to Vgrp");

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_s3_ssector(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_s3_ssector(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_s3_ssector(struct ssector ssector_struc, int32 recnum)
{
  int32 start[3], edges[3];
  int32 retval = 0;
  uint8 *odata;
  static int32 recnum_wr=0;

void print_s3_ssector_error();
void pack_s3_ssector();

  odata = (uint8 *) malloc(sizeof(struct ssector));
  pack_s3_ssector(odata, &ssector_struc);

  if(recnum!=-1) {
	recnum_wr=recnum;
	if(VSseek(vdata_id_s3_ssector, recnum)==-1) {
		print_s3_ssector_error("write_s3_ssector -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_s3_ssector, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_s3_ssector_error("write_s3_ssector -> VSwrite: Couldn't write data.");

  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  edges[1] = SSEC_N;
  edges[2] = SSEC_S;
  if (SDwritedata(sds_id_s3_ssector1,start,NULL,edges, (VOIDP)(ssector_struc.SECTOR)) ==FAIL)
    print_s3_ssector_error("write_s3_ssector -> SDwritedata: Problem writing SECTOR data.");

  memset(&ssector_struc, 0, sizeof(struct ssector));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_s3_ssector()
{
  VSdetach(vdata_id_s3_ssector);
  Vdetach(vgrp_id_s3_ssector);
  SDendaccess(sds_id_s3_ssector1);
}

/*----     init access function    ----*/

int32 init_acc_s3_ssector(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  static int32 sds_index1;
  int32 vdata_ref;
  int32 num_rec;

  void print_s3_ssector_error();

  if((sds_index1=SDnametoindex(sd_id, "ssector_SECTOR" )) ==FAIL) {
      print_s3_ssector_error("init_acc_s3_ssector -> SDnametoindex: Couldn't find ssector_SECTOR");
      return(-1);
  }
  if((sds_id_s3_ssector1=SDselect(sd_id, sds_index1)) ==FAIL) {
      print_s3_ssector_error("init_acc_s3_ssector -> SDselect: Couldn't select sds_index1");
      return(-1);
  }

  if ((vdata_ref = VSfind(hdf_fp, "ssector")) <= 0 ) {
    print_s3_ssector_error("init_acc_s3_ssector -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_s3_ssector = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_s3_ssector_error("init_acc_s3_ssector -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_s3_ssector, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_s3_ssector,"sctime_readout, sctime_collection, QAC")) {
      print_s3_ssector_error("init_acc_s3_ssector -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_s3_ssector(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_s3_ssector(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_s3_ssector(struct ssector *ssector_struc, int32 recnum_rd)
{
int32 start[3], edges[3];
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_s3_ssector_error();
void unpack_s3_ssector();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;

  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct ssector));
  VSinquire(vdata_id_s3_ssector, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_s3_ssector, recnum_rd)==FAIL) {
          print_s3_ssector_error("read_s3_ssector -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  edges[1] = SSEC_N;
  edges[2] = SSEC_S;

  if(SDreaddata(sds_id_s3_ssector1,start,NULL,edges, (VOIDP)(ssector_struc->SECTOR )) ==FAIL) {
    print_s3_ssector_error("read_s3_ssector -> SDreaddata: Couldn't read SECTOR");
    retval = -1;
  }
  if(VSread(vdata_id_s3_ssector, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_s3_ssector_error("read_s3_ssector -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_s3_ssector(odata, ssector_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_s3_ssector()
{
  VSdetach(vdata_id_s3_ssector);
  SDendaccess(sds_id_s3_ssector1);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_s3_ssector(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_s3_ssector_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_ssector" )) ==FAIL)
    print_s3_ssector_error("rd_Vgrp_s3_ssector -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_s3_ssector_error("rd_Vgrp_s3_ssector -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_s3_ssector_error("rd_Vgrp_s3_ssector -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_s3_ssector_error("rd_Vgrp_s3_ssector -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_ssector, HDstrlen(Vgrp_descrp_ssector)) ==FAIL)
    print_s3_ssector_error("rd_Vgrp_s3_ssector -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_ssector);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_s3_ssector_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_sepica_ssector.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_s3_ssector(uint8 *data, struct ssector *ssector_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &ssector_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ssector_ptr->sctime_collection, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &ssector_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_s3_ssector(uint8 *data, struct ssector *ssector_ptr)
{
int32 ptr=0;

   memcpy(&ssector_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ssector_ptr->sctime_collection, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&ssector_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_s3_ssector() {return(vgrp_id_s3_ssector);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_s3_ssector(char *wr_strval)
{
  strcpy(wr_strval, "The file 's3_ssector.h' is shown below, it was used to create the data in the Vgroup named 'VG_ssector'.\n\n");
  strcat(wr_strval,"/* Id: s3_ssector.h,v 1.5 1998/12/07 18:12:39 ad Exp $	     */\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#define SSEC_N     20  /* number of matrix rates */\n");
  strcat(wr_strval,"#define SSEC_S     8  /* number of sectors */\n");
  strcat(wr_strval,"#define SSEC_CYC   6  /* number of cycles per SR = 60 / 10 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval," /* total size (in bytes) of SMON data (including slack) in a full SR */\n");
  strcat(wr_strval,"#define SSEC_TSZ   1440  \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval," /* size (in bytes) of SSEC cycle (including slack) */\n");
  strcat(wr_strval,"#define SSEC_CSZ   SSEC_TSZ/SSEC_CYC \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#define SSEC_ESZ   SSEC_TSZ/60  /* size (in bytes) of SSEC area in EDB */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"/* Sectored rates are collected over 10 spins and output during the next */\n");
  strcat(wr_strval,"/* 10 spins (or edb's). There are 6 sectored rate collection cycles per */\n");
  strcat(wr_strval,"/* Science Record */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"/* sctime_readout: spacecraft clock of first minor frame of the */\n");
  strcat(wr_strval,"/* first edb of the sectored rate output cycle */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"/* sctime_collection:  time of the start of the first spin in the */\n");
  strcat(wr_strval,"/* collection cycle, in spacecraft clock time units */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"/* ssector structure contains basic rates for 1 10-spin collection cycle */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct ssector{\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"   uint32 sctime_readout;	/* 32 bit spacecraft time  */\n");
  strcat(wr_strval,"   float64 sctime_collection; /* spacecraft time, sub-second resolution */\n");
  strcat(wr_strval,"   uint32 QAC;	/* Number of missing frames in this 10-spin cycle */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"   uint16 SECTOR[SSEC_N][SSEC_S]; /* 20 Sectored rates, 8 sectors */\n");
  strcat(wr_strval,"};\n");
  return(0);
}
