      SUBROUTINE TAB6                                                   00000100
C                                                                       00000200
C   SETS UP EVENT TABLE FOR IMP-6 COUNTS TAPE ALBUMS AS INPUT TO        00000300
C   IMP RATES PLOT PROGRAM.                                             00000400
C   CHECKS FOR TIME GAPS, BIT-RATE CHANGES, AND SECTORED DATA STATUS.   00000500
C     ITAB(IENTRY):  IENTRY=1, 1ST SSHOT OF 2ND ALBUM.                  00000600
C                          =2-16, 2ND-16TH SSHOTS OF 1ST ALBUM.         00000700
C                          =18-20, SECTORED DATA PP 2-4, 1ST ALBUM.     00000800
C                          =21-24, SECTORED DATA PP 1-4, 1ST, FAIL.     00000900
C                          =25,    SECTORED DATA PG 1 OF 2ND ALBUM.     00001000
C                                                                       00001100
C   MODIFY BY HENRY LO ON 9/90                                                  
C   CHANGE EQUIVALENCE STATEMENT TO CONFORM WITH VS-FORTRAN                     
C   COMPILER SYNTAX                                                             
C                                                                               
      IMPLICIT INTEGER*2(H),LOGICAL*1(Q),REAL*8(D)                      00001200
      COMMON /BOUNDS/ ISTART,IYR1,ISTOP,IYR2,NORM2,M,N,IXRANG           00001300
CLO   COMMON /EXPON/ QEVTON(6),QEVCHK                                           
      COMMON /EXPON/  QEVTON(250),QEVCHK                                00001305
CLO   COMMON /DROP/ QDROP(6),QKILL                                              
      COMMON /DROP/   QDROP(250),QKILL                                    000014
      COMMON /FERMSG/ IMES(26)                                          00001500
      COMMON /KOUNTS/ KCNT(373,2,3),IRATE(2,3)                          00001600
CLO   COMMON /PARS/ IEVENT(6),ISECTR(6),MAP(6),IPLTPT(6),IMP(6),INOEV           
      COMMON /PARS/ IEVENT(250),ISECTR(250),MAP(6),IPLTPT(6),IMP(250),          
     *              INOEV                                                       
      COMMON /QTABS/  QTAB(3)                                           00001800
      COMMON /REJECT/ QPOINT,QFILTR                                     00001900
      COMMON /SATLIT/ QSAT(3),QDAT(3)                                   00001950
      COMMON /SEKOPT/ QFAILS,QSUN0S                                     00002000
      COMMON /TABS6/  ITAB(21),ITABT(21),ITABMX,IENT                    00002100
      COMMON /TAPE/   ITAPE,INUNIT(3)                                   00002150
      INTEGER ISNAP(16)/26,77,128,179,230,282,333,384,                  00002200
     *                435,486,538,589,640,691,742,794/                  00002300
      INTEGER ISECTT(4)/26,230,435,640/                                 00002400
      INTEGER INO(16)/2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,1/           00002500
      DIMENSION ICNT(373,2),HCNT(746,2),CNT(373,2)                      00002600
      EQUIVALENCE (IRATE1,IRATE(1,1)),(IRATE2,IRATE(2,1))               00002700
      EQUIVALENCE (KCNT(1,1,1),ICNT(1,1),HCNT(1,1),CNT(1,1))            00002800
      SECTM(A,B) = 10.0*(AMOD(A,B/4.0) + 2.5*B)                         00002900
C                                                                       00003000
      KERROR = 0                                                        00003100
      QKILL = .FALSE.                                                   00003200
      DO 10 I=1,373                                                     00003300
 10     ICNT(I,1) = ICNT(I,2)                                           00003400
      IRATE1 = IRATE2                                                   00003500
 15   CALL FREAD(ICNT(1,2),INUNIT(1),LEN,&20,&500)                      00003600
C   CHECK FOR ON/OFF STATUS OF EXPERIMENTS   (1 = IMP-6)                00003602
      IF (QEVCHK) CALL ONOFF(1)                                         00003604
      GOTO 25                                                           00003700
 20   CALL PMOUNT(2,1,QDAT(1))                                          00003800
      IF (.NOT.QDAT(1)) GOTO 200                                        00003900
      GOTO 15                                                           00004000
 25   IF (.NOT.QTAB(1)) GOTO 29                                         00004100
C   HERE IF FIRST TIME IN PLOT RANGE.                                   00004200
      QTAB(1) = .FALSE.                                                 00004300
      QSECT = .FALSE.                                                   00004400
      DO 27 K=1,INOEV                                                   00004500
        IF (IMP(K).NE.1) GOTO 27                                        00004600
        IF (IEVENT(K).GT.58) QSECT=.TRUE.                               00004700
 27     CONTINUE                                                        00004800
      IRATE1 = 1                                                        00004900
      IF (IGET(ICNT(3,1),0,0).EQ.1) IRATE1 = 4                          00005000
C   CHECK FOR TIME GAP.                                                 00005100
 29   IREF = 820*IRATE1 + 10                                            00005200
      IGAP = IDIFF(ICNT(1,2),ICNT(24,2),ICNT(1,1),ICNT(24,1))           00005300
      IF (IGAP.GT.IREF.AND.QPOINT) QKILL = .TRUE.                       00005400
      IF (IGET(ICNT(3,2),0,0).EQ.1) GOTO 35                             00005500
C   CHECK FOR BIT-RATE CHANGE.                                          00005600
C   HIGH RATE                                                           00005700
      IF (IRATE1.EQ.4.AND.QPOINT) QKILL = .TRUE.                        00005800
      IRATE2 = 1                                                        00005900
      GOTO 37                                                           00006000
C   LOW RATE.                                                           00006100
 35   IF (IRATE1.EQ.1.AND.QPOINT) QKILL = .TRUE.                        00006200
      IRATE2 = 4                                                        00006300
 37   ITABMX = 16                                                       00006400
      IBASE = ISTART + IDIFF(ICNT(1,1),ICNT(24,1),ISTART,IYR1)          00006500
C   PROCESS SNAPSHOT TIMES.                                             00006600
      DO 40 I=1,16                                                      00006700
        ITABT(I) = ISNAP(I)*IRATE1 + IBASE                              00006800
        ITAB(I) = INO(I)                                                00006900
 40     CONTINUE                                                        00007000
      IF (QKILL) ITABT(16) = IBASE + IGAP - 26*IRATE2                   00007100
      IF (.NOT.QSECT) GOTO 100                                          00007200
C   NOW, PROCESS SECTORED DATA TIMES.                                   00007300
C   SKIP 1ST ALBUM IF SECTORED DATA UNDEFINED.                          00007400
      IF (HCNT(572,1).EQ.5.OR.HCNT(638,1).EQ.10) GOTO 70                00007500
C   SKIP TO REAL IF FLAGS REAL.                                         00007600
      IF (HCNT(571,1).EQ.0.AND.HCNT(637,1).EQ.0) GOTO 48                00007700
C   SKIP 1ST ALBUM IF FAIL NOT REQUESTED.                               00007800
      IF (QFAILS) GOTO 70                                               00007900
C   1ST ALBUM, FAIL.                                                    00008000
      DO 45 IPG=1,4                                                     00008100
        ITIMES = ISECTT(IPG)*IRATE1 + IBASE                             00008200
 45     CALL PSORT(ITIMES,IPG+20,ITAB,ITABT,ITABMX)                     00008300
      GOTO 70                                                           00008400
 48   IF (IRATE1.EQ.1) GOTO 70                                          00008500
C   1ST ALBUM, LOW RATE AND OA REAL:  SECTORED DATA PP 2-4.             00008600
      DO 60 IPG=2,4                                                     00008700
        J = 354 + 4*IPG                                                 00008800
        IF (CNT(J,1).LT.0.0.OR.CNT(J+3,1).LE.0.0) GOTO 60               00008900
        IF (CNT(J,1).EQ.0.AND.QSUN0S) GOTO 60                           00009000
        ITM = SECTM(CNT(J,1),CNT(J+3,1))                                00009100
        ITM = ITM + ICNT(1,1) + 819*(IPG-2)                             00009200
        IYR = ICNT(24,1)                                                00009300
        IF (ITM.LT.0) CALL IFIXIT(ITM,IDAY,IYR)                         00009400
        ITIME = IDIFF(ITM,IYR,ICNT(1,1),ICNT(24,1)) + IBASE             00009500
        CALL PSORT(ITIME,IPG+16,ITAB,ITABT,ITABMX)                      00009600
 60     CONTINUE                                                        00009700
C   SKIP 2ND ALBUM IF FAIL OR UNDEFINED SECTORED DATA.                  00009800
 70   IF (HCNT(571,2).EQ.1.OR.HCNT(637,2).EQ.1) GOTO 100                00009900
      IF (HCNT(572,2).EQ.5.OR.HCNT(638,2).EQ.10) GOTO 100               00010000
C   2ND ALBUM, OA REAL:  SECTORED DATA ON PAGE 1.                       00010100
      DO 80 IPG=1,3                                                     00010200
        IF (ICNT(3,2).LT.0.AND.IPG.GT.1) GOTO 100                       00010300
        J = 354 + 4*IPG                                                 00010400
        IF (CNT(J,2).LT.0.0.OR.CNT(J+3,2).LE.0.0) GOTO 80               00010500
        IF (CNT(J,2).EQ.0.AND.QSUN0S) GOTO 80                           00010600
        ITM = SECTM(CNT(J,2),CNT(J+3,2))                                00010700
        ITM = ITM + ICNT(1,2) - 819                                     00010800
        IYR = ICNT(24,2)                                                00010900
        IF (ITM.LT.0) CALL IFIXIT(ITM,IDAY,IYR)                         00011000
        ITIME = IDIFF(ITM,IYR,ICNT(1,1),ICNT(24,1)) + IBASE             00011100
        GOTO 90                                                         00011200
 80     CONTINUE                                                        00011300
      GOTO 100                                                          00011400
 90   CALL PSORT(ITIME,25,ITAB,ITABT,ITABMX)                            00011500
100   IENT = 1                                                          00011600
      IF (.NOT.QKILL) GOTO 120                                          00011700
C   HERE, DROP THE IMP-6 RATES.  SINCE QDROP(1-6) USED ONLY BY IMP-6,   00011800
C   IT'S OK TO SET THEM ALL.                                            00011900
      DO 110 I=1,6                                                      00012000
110     QDROP(I) = .TRUE.                                               00012100
120   RETURN                                                            00012200
200   PRINT 2000                                                        00012300
2000  FORMAT('1ERROR IN PMOUNT CALLED BY TAB6.')                        00012400
      GOTO 600                                                          00012500
500   PRINT 2001,IMES                                                   00012600
2001  FORMAT(' READ ERROR ON INPUT TAPE FROM TAB6.'/                    00012700
     * 1X,Z8,I6,20A4,4(1X,Z8))                                          00012800
      KERROR = KERROR + 1                                               00012900
      IF (KERROR.LT.10) GOTO 15                                         00013000
      PRINT 2002                                                        00013100
2002  FORMAT('1JOB TERMINATING DUE TO 10 CONSECUTIVE READ ERRORS.')     00013200
600   CALL PMOUNT(3,1,QDAT(1))                                          00013300
      STOP                                                              00013400
      END                                                               00013500
