      SUBROUTINE MTFLX(IMP,IORB,TAPREC)                                 00000100
C                                                                       00000200
C***********************************************************************00000300
C                                                                       00000400
C   THIS SUBROUTINE MOUNTS THE OUTPUT FLUX TAPE AND                     00000500
C   COPIES ANY EXISTING DATA ONTO THE OUTPUT TAPE.                      00000600
C   THE CLSFLX ENTRY COMPLETES COPYING EXISTING FLUX DATA               00000700
C   ON THE OUTPUT TAPE AND UPDATES THE CATALOG.                         00000800
C                                                                       00000900
C***********************************************************************00001000
C                                                                       00001100
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H),REAL*8(D)                      00001200
      COMMON / CTLG / JRECNO,IRECAD,ICTLG(765)                          00001300
      COMMON / FERMSG / IMES(26)                                        00001400
      DATA QIN/F/,QOUT/F/,QADD/F/,QFRST/T/,MFILE/1/,                    00001500
     1 IDUMMY/0/,INUNIT/20/,IOUTUN/30/                                  00001600
      INTEGER TAPREC(15),FLUX,BLANK,INTAPE(15),INREC(150)               00001701
      INTEGER DSN(3)                                                    00001801
CLO                                                                     00001901
      CHARACTER*4 CFLUX/'FLUX'/,CBLANK/'BLNK'/                          00002003
      CHARACTER*4 CDSN(3)/'IMPI','IMPH','IMPJ'/                         00002203
      EQUIVALENCE(CDSN(1),DSN(1)),(CFLUX,FLUX),(CBLANK,BLANK)           00002303
CLO                                                                     00002501
C                                                                       00002600
      IF (.NOT.QFRST) GOTO 50                                           00002700
C   FIRST TIME THROUGH, COMPUTE DATE                                    00002800
      QFRST = .FALSE.                                                   00002900
      CALL DTIME(IYR,IDAY)                                              00003000
      IDATE = IYR*1000 + IDAY                                           00003100
C                                                                       00003200
C   IS AN INPUT FLUX TAPE MOUNTED?                                      00003300
 50   IF (QIN) GOTO 150                                                 00003400
      IF (QADD) GOTO 130                                                00003500
C   CHECK CATALOG FOR INPUT FLUX TAPE.                                  00003600
      IRSEQ = (IORB+59)/60                                              00003700
      CALL CATLOG(9,4,IRSEQ,IDUMMY,*60)                                 00003800
      CALL FMOVE(INTAPE,60,ICTLG(IRECAD))                               00003900
      GO TO 100                                                         00004000
C   NO INPUT TAPE IN CATALOG                                            00004100
C   IS OUTPUT TAPE MOUNTED?                                             00004200
 60   IF (QOUT) GOTO 80                                                 00004300
C   TAPE NOT MOUNTED, GET BLANK FROM CATALOG                            00004400
      CALL CATLOG(5,IDUMMY,IDUMMY,IDUMMY,*300)                          00004500
      DTAPE = DPKTN(ICTLG(IRECAD))                                      00004600
      CALL MOUNT(2,IOUTUN,DTAPE,4,DSN(IMP-5),MFILE)                     00004700
      CALL PRNTCG(1,2,IOUTUN,DTAPE)                                     00004800
      QOUT = .TRUE.                                                     00004900
C   INITIALIZE ARRAY CONTAINING CATALOG INFORMATION                     00005000
      TAPREC(1) = ICTLG(IRECAD)                                         00005100
      TAPREC(2) = FLUX                                                  00005200
      TAPREC(3) = IDATE                                                 00005300
      TAPREC(4) = IRSEQ                                                 00005400
      DO 70 I=5,15                                                      00005500
      TAPREC(I) = 0                                                     00005600
   70 CONTINUE                                                          00005700
      GO TO 90                                                          00005800
C   OUTPUT TAPE MOUNTED, POSITION TO NEXT FILE                          00005900
   80 CALL POSN(2,IOUTUN,MFILE)                                         00006000
C   UPDATE FILE COUNTED TO POINT TO NEXT FILE                           00006100
   90 MFILE = MFILE + 1                                                 00006200
      RETURN                                                            00006300
C                                                                       00006400
C   INPUT TAPE WILL BE USED, CALCULATE NUMBER FILES ON TAPE             00006500
  100 LFILE = 0                                                         00006600
      DO 110 I=13,14                                                    00006700
      DO 110 J=1,32                                                     00006800
      LFILE = LFILE + IGET(ICTLG(IRECAD+I),J-1,J-1)                     00006900
  110 CONTINUE                                                          00007000
CAN TAPE BE ADDED TO OR MUST IT BE COPIED?                              00007100
  120 IF ( IORB.LE.INTAPE(10)) GO TO 145                                00007200
C  ADD DATA ON AFTER LAST FILE                                          00007300
C   IS TAPE MOUNTED?                                                    00007400
      IF (QADD) GOTO 130                                                00007500
      DTAPE = DPKTN(INTAPE(1))                                          00007600
C   MOUNT TAPE                                                          00007700
      MFILE = LFILE + 1                                                 00007800
      QADD = .TRUE.                                                     00007900
      CALL MOUNT(2,IOUTUN,DTAPE,4,DSN(IMP-5),MFILE)                     00008000
      CALL PRNTCG(1,2,IOUTUN,DTAPE)                                     00008100
C   PUT EXISTING CATALOG INFO INTO TAPREC ARRAY                         00008200
      CALL FMOVE(TAPREC,60,INTAPE)                                      00008300
      GO TO 140                                                         00008400
C   TAPE MOUNTED, POSITION TO NEXT FILE                                 00008500
  130 CALL POSN(2,IOUTUN,MFILE)                                         00008600
C   UPDATE FILE COUNTER                                                 00008700
  140 MFILE = MFILE + 1                                                 00008800
      RETURN                                                            00008900
C                                                                       00009000
COPY INPUT TAPE ONTO NEW TAPE                                           00009100
C   IS INPUT TAPE MOUNTED                                               00009200
145   IF (QIN) GOTO 150                                                 00009300
C   MOUNT INPUT TAPE                                                    00009400
      DINTAP = DPKTN(INTAPE(1))                                         00009500
      QIN = .TRUE.                                                      00009600
      INFILE = 1                                                        00009700
      CALL MOUNT(1,INUNIT,DINTAP,4,DSN(IMP-5),INFILE)                   00009800
      CALL PRNTCG(1,1,INUNIT,DINTAP)                                    00009900
C   IS OUTPUT TAPE MOUNTED?                                             00010000
150   IF (QOUT) GOTO 180                                                00010100
C   GET BLANK FROM CATALOG AND MOUNT IT                                 00010200
      CALL CATLOG(5,IDUMMY,IDUMMY,IDUMMY,*300)                          00010300
      DTAPE = DPKTN(ICTLG(IRECAD))                                      00010400
      QOUT = .TRUE.                                                     00010500
      MFILE = 1                                                         00010600
      CALL MOUNT(2,IOUTUN,DTAPE,4,DSN(IMP-5),MFILE)                     00010700
      CALL PRNTCG(1,2,IOUTUN,DTAPE)                                     00010800
C   INITIALIZE TAPREC ARRAY                                             00010900
      TAPREC(1) = ICTLG(IRECAD)                                         00011000
      TAPREC(3) = IDATE                                                 00011100
      DO 160 I=2,4,2                                                    00011200
      TAPREC(I) = INTAPE(I)                                             00011300
  160 CONTINUE                                                          00011400
      DO 170 I=5,15                                                     00011500
      TAPREC(I) = 0                                                     00011600
  170 CONTINUE                                                          00011700
      GO TO 190                                                         00011800
C   TAPE MOUNTED POSITION TO NEW FILE                                   00011900
  180 CALL POSN(2,IOUTUN,MFILE)                                         00012000
C   UPDATE FILE COUNTED                                                 00012100
  190 MFILE = MFILE + 1                                                 00012200
C   DETERMINE ORBIT NUMBER OF FILE AT WHICH TAPE IS POSITIONED          00012300
C   ADD UP BITS IN CATALOG WORDS 14 AND 15                              00012400
  200 IF ( INFILE.GT.LFILE ) GO TO 270                                  00012500
  205 JFILE = 0                                                         00012600
      DO 210 I=1,60                                                     00012700
      JORB = (IRSEQ-1)*60 + I                                           00012800
      IWD = 15                                                          00012900
      IF ( I.GT.30 ) IWD = 14                                           00013000
      IBIT = 32 - MOD(I,30)                                             00013100
      IF ( IBIT.EQ.32 ) IBIT = 2                                        00013200
      JFILE = JFILE + IGET(INTAPE(IWD),IBIT,IBIT)                       00013300
      IF ( JFILE.EQ.INFILE ) GO TO 220                                  00013400
  210 CONTINUE                                                          00013500
C   HERE, JORB IS MAX ORBIT ON TAPE AND JFILE ARE #FILES ON TAPE.       00013600
C                                                                       00013700
  220 IF ( JORB - IORB ) 225,260,270                                    00013800
C   DATA IN INFILE MUST BE COPIED BEFORE PROCESSING IORB                00013900
  225 CALL GETPUT(-1,0,0,TAPREC(IWD),IBIT,IBIT)                         00014000
  230 CALL FREAD(INREC,INUNIT,LEN,*250,*231)                            00014100
      GOTO 233                                                          00014200
231   PRINT 232                                                         00014300
232   FORMAT(' I/O ERROR COPYING OLD FLUX TAPE IN MTFLX.')              00014400
      GOTO 230                                                          00014500
C   SAVE START AND END TIMES FOR CATALOG ENTRY                          00014600
233   IF ( TAPREC(5).GT.0 ) GO TO 240                                   00014700
      TAPREC(6) = JORB                                                  00014800
      TAPREC(7) = IGET(INREC(2),0,15)                                   00014900
      TAPREC(8) = INREC(1)                                              00015000
  240 TAPREC(10) = JORB                                                 00015100
      TAPREC(11) = IGET(INREC(2),0,15)                                  00015200
      TAPREC(12) = INREC(1)                                             00015300
      TAPREC(5) = TAPREC(5) + 1                                         00015400
      CALL FWRITE(INREC,IOUTUN,LEN)                                     00015500
      GO TO 230                                                         00015600
C   END OF FILE, POSITION OUTPUT TAPE TO NEXT FILE                      00015700
  250 CALL POSN(2,IOUTUN,MFILE)                                         00015800
      MFILE = MFILE + 1                                                 00015900
CHECK NEXT FILE ON INPUT TAPE                                           00016000
      INFILE = INFILE + 1                                               00016100
      IF ( INFILE.GT.LFILE ) GO TO 270                                  00016200
      CALL POSN(1,INUNIT,INFILE)                                        00016300
      GO TO 205                                                         00016400
C   IORB SAME AS JORB, SKIP FILE                                        00016500
  260 INFILE = INFILE + 1                                               00016600
      IF ( INFILE.GT.LFILE ) GO TO 270                                  00016700
      CALL POSN(1,INUNIT,INFILE)                                        00016800
C   IORB TO BE INSERTED BEFORE JORB, OR NO MORE FILES ON TAPE           00016900
  270 RETURN                                                            00017000
C                                                                       00017100
C   NO MORE BLANK TAPES AVAILABLE FOR OUTPUT                            00017200
  300 WRITE(6,1000)                                                     00017300
 1000 FORMAT('1 NO MORE BLANK TAPES AVAILABLE FOR OUTPUT.',             00017400
     1 ' JOB TERMINATING.')                                             00017500
      STOP                                                              00017600
C                                                                       00017700
C***************************                                            00017800
      ENTRY CLSFLX(TAPREC)                                              00017900
      ISW = 0                                                           00018000
      IF (.NOT.QIN) GOTO 450                                            00018100
C   INPUT TAPE MOUNTED, COPY REMAINING DATA                             00018200
      IF ( INFILE.GT.LFILE ) GO TO 430                                  00018300
C   POSITION OUTPUT TAPE TO NEXT FILE                                   00018400
  390 CALL POSN(2,IOUTUN,MFILE)                                         00018500
      MFILE = MFILE + 1                                                 00018600
  400 CALL FREAD(INREC,INUNIT,LEN,*420,*401)                            00018700
      GOTO 403                                                          00018800
401   PRINT 402                                                         00018900
402   FORMAT(' I/O ERROR COPYING OLF FLUX TAPE IN CLSFLX.')             00019000
      GOTO 400                                                          00019100
403   JORB = IGET(INREC(2),16,31)                                       00019200
      IYR = IGET(INREC(2),0,15)                                         00019300
      IF ( ISW.EQ.1 ) GO TO 405                                         00019400
      ISW = 1                                                           00019500
      INDEX = JORB - (IRSEQ - 1)*60                                     00019600
      IWD = 15                                                          00019700
      IF ( INDEX.GT.30 ) IWD = 14                                       00019800
      IBIT = 32 - MOD(INDEX,30)                                         00019900
      IF ( IBIT.EQ.32 ) IBIT = 2                                        00020000
      CALL GETPUT(-1,0,0,TAPREC(IWD),IBIT,IBIT)                         00020100
C   SAVE TIMES FOR CATALOG ENTRY                                        00020200
  405 IF ( TAPREC(5).GT.0 ) GO TO 410                                   00020300
      TAPREC(6) = JORB                                                  00020400
      TAPREC(7) = IYR                                                   00020500
      TAPREC(8) = INREC(1)                                              00020600
  410 TAPREC(10) = JORB                                                 00020700
      TAPREC(11) = IYR                                                  00020800
      TAPREC(12) = INREC(1)                                             00020900
      TAPREC(5) = TAPREC(5) + 1                                         00021000
      CALL FWRITE(INREC,IOUTUN,LEN)                                     00021100
      GO TO 400                                                         00021200
C   END OF FILE, CHECK NEXT FILE                                        00021300
  420 IF ( INFILE.GE.LFILE ) GO TO 430                                  00021400
      INFILE = INFILE + 1                                               00021500
      CALL POSN(1,INUNIT,INFILE)                                        00021600
      ISW = 0                                                           00021700
      GO TO 390                                                         00021800
COPYING COMPLETE, DELETE OLD TAPE FROM CATALOG                          00021900
  430 CALL CATLOG(9,1,INTAPE(1),IDUMMY,*460)                            00022000
      ICTLG(IRECAD+1) = BLANK                                           00022100
      DO 440 I=2,14                                                     00022200
      ICTLG(IRECAD+I) = 0                                               00022300
  440 CONTINUE                                                          00022400
      ICTLG(5) = ICTLG(5) + 1                                           00022500
      ICTLG(9) = ICTLG(9) - 1                                           00022600
      CALL DWRITE(25,JRECNO,ICTLG)                                      00022700
      CALL PRNTCG(2,1,INUNIT,DINTAP)                                    00022800
C   ENTER OUTPUT TAPE IN CATALOG                                        00022900
  450 ITYPE = 5                                                         00023000
      IF (QADD) ITYPE = 9                                               00023100
      CALL CATLOG(ITYPE,1,TAPREC(1),IDUMMY,*470)                        00023200
      CALL FMOVE(ICTLG(IRECAD+1),56,TAPREC(2))                          00023300
      ICTLG(ITYPE) = ICTLG(ITYPE) - 1                                   00023400
      ICTLG(9) = ICTLG(9) + 1                                           00023500
      CALL DWRITE(25,JRECNO,ICTLG)                                      00023600
C   UNLOAD TAPES                                                        00023700
      IF (QIN) CALL LEAVE(INUNIT)                                       00023800
      CALL  LEAVE(IOUTUN)                                               00023900
      CALL PRNTCG(2,2,IOUTUN,DTAPE)                                     00024000
C  INITIALIZE SWITCHES FOR SUBSEQUENT CALLS                             00024100
      QIN = .FALSE.                                                     00024200
      QOUT = .FALSE.                                                    00024300
      QADD = .FALSE.                                                    00024400
      MFILE = 1                                                         00024500
      RETURN                                                            00024600
C   ERROR MESSAGES                                                      00024700
  460 WRITE(6,1001)                                                     00024800
 1001 FORMAT('1 INPUT FLUX TAPE NO LONGER IN CATALOG. ',                00024900
     1 'JOB TERMINATED.')                                               00025000
      STOP                                                              00025100
  470 WRITE(6,1002)                                                     00025200
 1002 FORMAT('1 BLANK TAPE USED AS OUTPUT NO LONGER ON CATALOG. ',      00025300
     1 'JOB TERMINATED.')                                               00025400
      STOP                                                              00025500
C   I/O ERROR                                                           00025600
CLO                                                                     00025704
C 500 WRITE(6,1003) DINTAP,INFILE                                       00025804
 1003 FORMAT('1 I/O ERROR READING INPUT FLUX TAPE ',A6,                 00025900
     1 ' FILE ',I6,' JOB TERMINATING.')                                 00026000
CLO   WRITE(6,1004) IMES                                                00026105
 1004 FORMAT(1X,Z8,I6,20A4,4(1X,Z8))                                    00026200
CLO   STOP                                                              00026306
      END                                                               00027000
