      SUBROUTINE FLX6MT(IMP,JORB,IORB2,ITPREC,INUNIT,QTAPEI,QTAPEO,
     *                  QSKIP)                                    
C                                                                
C***********************************************************************
C                                                                      
C   SUBROUTINE TO MOUNT TAPES FOR IMP INTERMEDIATE FLUX PROGRAMS.     
C   MOUNTS APPROPRIATE INPUT (PHA) AND OUTPUT (FLUX) TAPES.          
C   SATELLITE NUMBER IS PASSED THROUGH ARGUMENT 'IMP' (=6,7, OR 8). 
C     
c   5/94
c
c   change the structure of selecting IMP-8 PHA file
c
c   search the IMP-8 PHA interval file from catalog
c    
C***********************************************************************
C
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H),REAL*8(D)    
      COMMON /CTLG/   JRECNO,IRECAD,ICTLG(765)       
CLO                                                 
      INTEGER DSN(3)                               
      CHARACTER*4 CDSN(3)/'IMPI','IMPH','IMPJ'/   
      CHARACTER*8 CMOUNT/'        '/            
CLO   DATA DMOUNT/'        '/                  
      DIMENSION ITPREC(15)                    
CLO                                          
      EQUIVALENCE(CDSN(1),DSN(1)),(CMOUNT,DMOUNT)  
CLO
C 
c5/94
c   search the IMP-8 PHA interval file from catalog
c
    call catlog(2,4,JORB,IDUMMY,*20)
c
C   SELECT INPUT TAPE
c
c************************************************************************
c 5   IRSEQ = (JORB +4) / 5
c 10  CALL CATLOG(2,4,IRSEQ,IDUMMY,*20) 
c     GOTO 30                          
C                                     
C        NO TAPE IN CATALOG FOR REQUESTED REEL SEQ #
c 20     MSGORB = IRSEQ*5                          
c        IF ( IORB2.LT.MSGORB ) MSGORB = IORB2    
c        WRITE(6,1011) JORB,MSGORB               
c1011    FORMAT('0NO PHA TAPE IN CATALOG FOR ORBITS',I4,' TO',I4)
c        IF ( MSGORB.GE.IORB2 ) GO TO 2000                      
C        CALCULATE REEL SEQ # AND START ORBIT FOR NEXT TAPE    
c        JORB = IRSEQ*5 + 1                                   
c        IRSEQ = IRSEQ +1                                    
c        GO TO 10                                           
C                                                          
c30    KWD = ICTLG(IRECAD+14)                              
c     ITAPE = ICTLG(IRECAD)                              
C   CHECK FOR REQUESTED ORBIT ON TAPE                   
c 40  IBIT = MOD(JORB,5)                               
c     IF ( IBIT.EQ.0 ) IBIT = 5                       
c     IF ( IGET(KWD,32-IBIT,32-IBIT).EQ.1 ) GO TO 50 
C                                                   
C        ORBIT NOT ON TAPE                         
c        WRITE(6,1010) JORB                       
c1010    FORMAT('0NO PHA DATA FOUND FOR ORBIT #',I4)     
c        IF ( JORB.GE.IORB2 ) GO TO 2000                
C        CHECK FOR NEXT ORBIT                          
c        JORB = JORB + 1                              
c        IF ( JORB.GT.IRSEQ*5 ) GO TO 5              
c        GO TO 40                                   
C                                                  
C   UNPACK TAPE NUMBER                            
c 50  DTAPE = DPKTN(ITAPE)                       
c
c************************************************************************
c
C   JUMP IF CORRECT TAPE MOUNTED.               
c     IF ( DMOUNT.EQ.DTAPE ) GO TO 60          
C   IF ANY INPUT TAPE IS MOUNTED, THEN DISMOUNT IT.   
      IF (QTAPEI) CALL LEAVE(INUNIT)                 
c     CALL MOUNT(1,INUNIT,DTAPE,4,DSN(IMP-5),1)     
c     CALL PRNTCG(1,1,INUNIT,DTAPE)                
c     DMOUNT = DTAPE                              
      QTAPEI = .TRUE.                            
C                                               
C   MOUNT OUTPUT TAPE                          
C                                             
c60    HREEL = (JORB+59)/60                   
      IF (QTAPEO.AND.HREEL.NE.HRSEQ) CALL CLSFLX(ITPREC)  
      CALL MTFLX(IMP,JORB,ITPREC)                        
c     HRSEQ = HREEL                                     
      QTAPEO = .TRUE.                                  
      QSKIP = .FALSE.                                 
      RETURN                                         
C                                                   
2000  QSKIP = .TRUE.                               
      RETURN                                      
      END                                        
