C******************** F L U X 8 ****************************************00000100
C                                                                       00000200
C   MAIN ROUTINE FOR THE IMP-8 INTERMEDIATE FLUX PROGRAM.               00000300
C   THIS PROGRAM SUMMARIZES FLUX DATA FROM IMP-8 PHA TAPES INTO         00000400
C   4-CONSECUTIVE-ALBUM INTERVALS AND GENERATES INTERMEDIATE            00000500
C   FLUX TAPES.  THE ENERGY BOXES (BASED ON ORBITS 7-15) ARE            00000600
C   DEFINED IN THE COMMON BLOCK SUBROUTINE 'IMPBLK'.                    00000700
C   THIS ROUTINE READS THE RUN CONTROL AND TIME CARDS.   AN ORBIT LOOP  00000800
C   IS THEN SET UP AND THE PROCESSING ROUTINES ARE CALLED.              00000900
C                                                                       00001000
C                                                                               
C   MODIFY BY HENRY LO ON 1/89 TO GENERATE A IMP-8 LOG FLIE                     
C   (SB#IM.IMP8.INTFLUX.LOG) ON UNIT 35                                         
C   THIS LOG FILE CONTAINS JOB'S RUNNING DATE, INTERVALS,                       
C   GAIN CORRECTION FACTORS AND IADDR DATA                                      
C                                                                               
C                                                                               
C   MODIFIED BY HENRY LO ON MARCH 1989 TO ADD VERSION REPORT                    
C   AND RUN DATE ON THE FIRST PAGE OF PRINTOUT                                  
C
c    5/94
c
c    replace KTIME, YDMD by IDATE
c
c    6/94
c
c    open input data card  on unit 5
c
c    open IMP-8 PHAS file on unit 15
c
c    open IMP-8 catalog file on unit 25
c
c    open IMP-8 FLUX file on unit 30
c
c    open IMP-8 flux log file on unit 35
c
c    open IMP-6 gain table on unit 36
c    open IMP-7 gain table on unit 37
c    open IMP-8 gain table on unit 38
c
c    open IMP-8 fine gain table on unit 40
c
c    call newcat to find blank entry for flux
c
c    7/94
c
c    move PHAS_FILE, FLUX_FILE and section of convert interval number to
c    ascii after statement number 200
c
c    update the FLUX entry if the FLUX interval exits
c
c    9/95
c
c    replace ft05_file,catalog_file,imp8gain_file,imp8fgain_file     
c            PHAS_file,FLUX_file imp8log_file  by
c    call getenv('FFT05',ft05_file)
c    call getenv('FCATALG',catalog_file)
c    call getenv('FGAIN',imp8gain_file)
c    call getenv('FFGAIN',imp8fgain_file)
c    call getenv('FPHAS',PHAS_file)
c    call getenv('FFLUX',FLUX_file)
c    call getenv('FLOG',imp8log_file)
c
C***********************************************************************00001100
C                                                                       00001200
      IMPLICIT INTEGER*2(H),REAL*8(D),LOGICAL*1(Q)
C
c5/94*******************************************************************
c
      dimension now(3)
      integer retcode,fopen
      byte bint(4)
      character*4 cint
      character*120 ft05_file,catalog_file,imp6gain_file,
     *              imp7gain_file,imp8gain_file,imp8fgain_file,
     *              imp8log_file,PHAS_file,FLUX_file
c
      common /CTLG/ IRECNO,IRECAD,ICTLG(816)
c
      equivalence(cint,bint(1))
c
c***********************************************************************
      CHARACTER*4 STAR(13)                                                      
      DIMENSION QAREA(21)                                                       
C                                                                               
c6/94 DIMENSION STD(5),ENDPT(5),GAIN(5),ITPREC(15),KBIN(2,38)           00001400
      DIMENSION STD(5),ENDPT(5),GAIN(5),ITPREC(16),KBIN(2,38)           00001400
      DIMENSION IBXORB(144)                                             00001500
      DATA STD/5*0.0/,ENDPT/5*0.0/,IORB1/0/,IMP/8/,KBIN/76*0/           00001600
      DATA STAR/13*'****'/                                                      
C                                                                       00001700
C   SET TAPE UNITS.  INPUT PHA IS UNIT 15, OUTPUT FLUX IS UNIT 30.      00001800
C   (INPUT FLUX TAPE IS UNIT 20.)                                       00001900
      INUNIT = 15                                                       00002000
      IOUTUN = 30                                                       00002100
      QTAPEI = .FALSE.                                                  00002200
      QTAPEO = .FALSE.                                                  00002300
C                                                                       00002400
C                                                                               
c6/94*******************************************************************
c9/95
c     ft05_file="/home/voy386/henry/flux/ft05.flux.data"
c
      call getenv('FFT05',ft05_file)
c
c9/95
c     catalog_file="/home/voy386/henry/flux/catalog.file"
c
      call getenv('FCATALG',catalog_file)
c
c
c9/95
c     imp8gain_file="/home/voy386/henry/flux/gain/sam.sun.imp8gain.data"
c
      call getenv('FGAIN',imp8gain_file)
c
c9/95
c     imp8fgain_file="/home/voy386/henry/flux/gain/ibm.finegain.table"
c
      call getenv('FFGAIN',imp8fgain_file)
c
c
c9/95
c     imp8log_file="/home/voy386/henry/flux/imp8.log"
c
      call getenv('FLOG',imp8log_file)
c
c
      open(unit=5,file=ft05_file)
c
      open(unit=35,file=imp8log_file,access='append')
c
      open(unit=38,file=imp8gain_file,access='direct',status='old',
     *     form='unformatted',recl=800)
c
      open(unit=40,file=imp8fgain_file)
C                                                                               
c**********************************************************************
CLO                                                                             
CLO       
c5/94******************************************************************
c     CALL KTIME(IYEAR,IDAY)
c     CALL YDMD(IYEAR,IDAY,IMONTH,IIDAY)
c
      call IDATE(now)
      IYEAR=now(3)
      IIDAY=now(1)
      IMONTH=now(2)
c***********************************************************************
      WRITE(6,998) IYEAR,IMONTH,IIDAY                                   00000350
      WRITE(6,999) STAR,STAR                                            00000360
998   FORMAT('1'//'  RUN DATE : ',I4,'/',I2,'/',I2)                     00000370
999   FORMAT(////////////39X,13A4,/                                     00000380
     *  39X,'*',50X,'*',/                                               00000390
     *  39X,'*',50X,'*',/                                               00000400
     *  39X,'*',50X,'*',/                                               00000410
     *  39X,'*',12X,'INTERMEDIATE  FLUX  PROGRAM',11X,'*',/             00000420
     *  39X,'*',50X,'*',/                                               00000430
     *  39X,'*',50X,'*',/                                               00000440
     *  39X,'*',50X,'*',/                                               00000450
     *  39X,'*',5X,'VERSION',6X,'DATE',5X,'FEATURES/ALTERNATIONS  *',/  00000460
     *  39X,'*',50X,'*',/                                               00000470
     *  39X,'*',7X,'2.0',5X,'MAR. 1989',3X,'USING VS FORTRAN       *',/ 00000480
     *  39X,'*',50X,'*',/                                               00000490
     *  39X,'*',7X,'3.0',5X,'JUL. 1994',3X,'USING Sun FORTRAN      *',/ 00000480
     *  39X,'*',50X,'*',/                                               00000510
     *  39X,'*',50X,'*',/                                               00000520
     *  39X,'*',50X,'*',/                                               00000530
     *  39X,13A4)                                                       00000540
CLO                                                                             
C     COMPUTE THE JOB'S RUNNING TIME                                            
C 
c5/94******************************************************************
c
c     CALL ZTIME(QAREA,9)
c     WRITE(35,123) QAREA
c
      call ITIME(now)
      IHR=now(1)
      IMIN=now(2)
      ISEC=now(3)
      write(35,123) IYEAR,IMONTH,IIDAY,IHR,IMIN,ISEC
c
123   FORMAT(///1X,'TIME TO RUN IMP-8 INTERMEDIATE FLUX PROGRAM : ',
     *   1x,i4,'/',i2,'/',i2,2x,i2,':',i2,':',i2,1x,
     *          /////8X,'INTERVAL',13X,'GAIN CORRECTION ',              
     *          'FACTORS',19X,'IADDR',4X//)                                     
c**********************************************************************
C                                                                               
C                                                                               
C   READ RUN CONTROL CARD.                                              00002500
 50   READ(5,1000,ERR=2000,END=2000) (STD(I),I=1,5)                     00002600
1000  FORMAT(5X,5F5.0)                                                  00002700
      WRITE(6,1002)                                                     00002800
 1002 FORMAT('1',30X,'IMP-8 INTERMEDIATE FLUX PROCESSING RUN'//)        00002900
      WRITE(6,1001) (STD(I),I=1,5)                                      00003000
1001  FORMAT('0RUN  CARD:',10X,5F5.2)                                   00003100
      QNEWRN = .TRUE.                                                   00003200
C                                                                       00003300
C   READ TIME CARD                                                      00003400
100   READ (5,1003,END=2000)IORB1,IORB2,(ENDPT(I),I=1,5)                00003500
1003     FORMAT(2I5,5F5.0)                                              00003600
      WRITE(6,1004) IORB1,IORB2,(ENDPT(I),I=1,5)                        00003700
 1004 FORMAT('0TIME CARD:',2(I4,1X),5F5.2)                              00003800
C                                                                       00003900
C   IF ORBIT NUMBER ZERO, NEXT CARD WILL BE RUN CONTROL CARD.           00004000
      IF (IORB1.EQ.0) GOTO 50                                           00004100
      JORB = IORB1                                                      00004200
      IF ( IORB2.LT.IORB1 ) IORB2 = IORB1                               00004300
C                                                                       00004400
C          CHECK FOR CARDS IN INCREASING TIME ORDER                     00004500
           IF (QNEWRN.OR.IORB1.GT.LSTORB) GOTO 130                      00004600
           WRITE(6,1008)                                                00004700
 1008      FORMAT(' REQUESTED DATA NOT IN INCREASING TIME ORDER,',      00004800
     1      ' TIME CARD SKIPPED.')                                      00004900
           GO TO 100                                                    00005000
C                                                                       00005100
  130 LSTORB = IORB2                                                    00005200
      QNEWRN = .FALSE.                                                  00005300
C                                                                       00005400
c7/94
c
200   continue
c
      open(unit=25,file=catalog_file,access='direct',status='old',
     *     form='unformatted',recl=3264)
c
c9/95
c     PHAS_file="/home/voy386/cosmicra/imp/data/IMP8/PHAS/PHAS"
c
      call getenv('FPHAS',PHAS_file)
c
c9/95
c     FLUX_file="/home/voy386/cosmicra/imp/data/IMP8/FLUX/FLUX"
c
      call getenv('FFLUX',FLUX_file)
c
      inter = JORB
      bint(1)=inter/1000
      bint(2)=(inter-bint(1)*1000)/100
      bint(3)=(inter-bint(1)*1000-bint(2)*100)/10
      bint(4)=inter-bint(1)*1000-bint(2)*100-bint(3)*10
c
      do i =1,4
      bint(i) = bint(i) + 48
      end do
c    
C   SET GAIN FACTORS FOR CURRENT TIME CARD.                             00005500
      CALL FLXGNN(IMP,JORB,STD,ENDPT,GAIN,IADDR)                        00005600
c200  CALL FLXGNN(IMP,JORB,STD,ENDPT,GAIN,IADDR)                        00005600
      PRINT 1010,(GAIN(I),I=1,5)                                        00005700
1010  FORMAT('0',10X,'THE FOLLOWING GAIN FACTORS ARE BEING USED:',      00005800
     *3X,'A=',F5.2,3X,'B=',F5.2,3X,'D=',F5.2,3X,'E=',F5.2,3X,           00005900
     *'F=',F5.2/)                                                       00006000
C                                                                       00006005
C   THE IMP-8 PENETRATING EVENTS ARE NORMALIZED TO IMP-6 (AS            00006010
C   OBTAINED FROM FLXGNN).  HOWEVER, STOPPING EVENTS ARE TO BE          00006015
C   NORMALIZED TO IMP-8 STANDARD, SO MUST CANCEL OUT IMP-6/IMP-8        00006020
C   NORMALIZATION FACTORS, VIZ., D(IMP-6)/D(IMP-8) = .8522,             00006025
C   E(IMP-6)/E(IMP-8) = .9386  .                                        00006030
C     TO CHANGE NORMALIZATION FACTORS NEED CHANGES TO THIS ROUTINE,     00006035
C   FLXGNN, AND PHACT8.                                                 00006040
      STOPD = GAIN(3)/.8522                                             00006045
      STOPE = GAIN(4)/.9386                                             00006050
      PRINT 1011,STOPD,STOPE                                            00006055
1011  FORMAT(11X,'THE FOLLOWING GAIN FACTORS ARE USED FOR MED ',        00006060
     *'STOPPING EVENTS ONLY:',3X,'D=',F5.2,3X,'E=',F5.2//)              00006065
C                                                                       00006100
c6/94******************************************************************
c   comment out CALL FLX6MT
c
C   MOUNT APPROPRIATE INPUT (PHA) AND OUTPUT (FLUX) TAPES.              00006200
c     CALL FLX6MT(IMP,JORB,IORB2,ITPREC,INUNIT,QTAPEI,QTAPEO,QSKIP)     00006300
c     IF (QSKIP) GOTO 100                                               00006400
c
      PHAS_file=PHAS_file(:LNBLNK(PHAS_file)) // cint(:LNBLNK(cint))
c
      FLUX_file=FLUX_file(:LNBLNK(FLUX_file)) // cint(:LNBLNK(cint))
c
c     open IMP-8 PHAS and FLUX files
c
      retcode=fopen(1,15,PHAS_file,0,'FB',4656,1552)
c
c7/94
c     search the FLUX entry for that interval
c
c     call NEWCAT(9,0,inter,0,*185)
      call NEWCAT(9,0,inter,0,*295)
c
c     write(6,379) IRECNO,IRECAD
379   format(' OLD ENTRY IRECNO IRECAD = ',2i5)
c
c7/94
      ICTLG(5) = ICTLG(5) + 1
      ICTLG(9) = ICTLG(9) - 1
      goto 301
c
c     find blank entry from catalog file for flux
c
295   continue
c
      call NEWCAT(5,0,0,0,*185)
c
c
c     write(6,380) IRECNO,IRECAD
380   format('  BLANK ENTRY IRECNO IRECAD = ',2i5)  
c
c**********************************************************************
c7/94
c
301   continue
c
      retcode=fopen(2,30,FLUX_file,0,'FB',5880,588)
C                                                                       00006500
C   PROCESS THE ORBIT                                                   00006600
      CALL FLX8PR(JORB,ITPREC,INUNIT,IOUTUN,GAIN,KBIN,IBXORB,IADDR)     00006700
      CALL FLX8SM(JORB,KBIN,IBXORB)                                     00006800
C     CALL ABEND(1)                                                     00006900
C                                                                               
C     WRITE INTERVAL, GAIN CORRECTION FACTORS AND IADDR DATA ON UNIT 35         
C                                                                               
      WRITE(35,321) JORB,GAIN,IADDR                                             
321   FORMAT(10X,I4,2X,5F10.3,I10,4X)                                           
C                                                                               
c6/94
c
c     update the catalog file
c
      ICTLG(5) = ICTLG(5) - 1
      ICTLG(9) = ICTLG(9) + 1
c
c7/94 debug
c
c     write(6,269) IRECNO,IRECAD,JORB
269   format(3i10)
c     write(6,270) ITPREC
270   format(4i15)
c
      ICTLG(IRECAD) = ITPREC(1)
      ICTLG(IRECAD+1) = ITPREC(2)
      ICTLG(IRECAD+4) = ITPREC(5)
      ICTLG(IRECAD+5) = ITPREC(6)
      ICTLG(IRECAD+7) = ITPREC(8)
      ICTLG(IRECAD+8) = ITPREC(9)
      ICTLG(IRECAD+9) = ITPREC(10)
      ICTLG(IRECAD+10) = ITPREC(11)
      ICTLG(IRECAD+11) = ITPREC(12)
      ICTLG(IRECAD+12) = ITPREC(13)
      ICTLG(IRECAD+13) = ITPREC(14)
      ICTLG(IRECAD+14) = ITPREC(15)
      ICTLG(IRECAD+15) = ITPREC(16)
c
      write(unit=25,rec=IRECNO) ICTLG
c
      JORB = JORB + 1                                                   00007000
c7/94
c
      do l = 1,16
      ITPREC(l) = 0
      end do
c
c     close PHAS_FIEL AND FLUX_FILE
c
      call fclose(15)
      call fclose(30)
      close(25)
c
      IF (JORB.LE.IORB2) GOTO 200                                       00007100
C   IF THRU WITH CURRENT TIME CARD, READ ANOTHER TIME CARD.             00007200
      GOTO 100                                                          00007300
C                                                                       00007400
C   END OF DATA ON CARD READER -- UNLOAD PHA AND FLUX TAPES.            00007500
c6/94
c
c2000 IF ( QTAPEI ) CALL UNLOAD(INUNIT)                                 00007600
2000  IF ( QTAPEI ) CALL fclose(INUNIT)                                 00007600
c6/94
c     IF ( QTAPEO.AND.ITPREC(5).GT.0 ) CALL CLSFLX(ITPREC)              00007700
c
c7/94 call fclose(IOUTUN)
c     close(25)
c
      WRITE(6,1012)                                                     00007800
 1012 FORMAT(' END OF JOB')                                             00007900
c
      stop
c6/94
c
185   write(6,169)
169   format(' No blank entry found')
c
      STOP                                                              00008000
      END                                                               00008100
