      SUBROUTINE FLXGNN(IMP,JORB,STD,ENDPT,GAIN,IADDR)                  00000100
C                                                                       00000200
C***********************************************************************00000300
C                                                                       00000400
C   SUBROUTINE IN IMP   INTERMEDIATE FLUX PROGRAM.                      00000500
C   COMPUTES GAIN FACTORS                                               00000600
C   IF NON-ZERO GAIN INPUT ON PARAMETER CARDS, THEN INPUT VALUES        00000700
C   WILL BE USED.  IF ZERO GAIN INPUT PARAMETERS, THEN IMP              00000800
C   GAIN FACTOR TABLE WILL BE SEARCHED FOR MED FACTORS.                 00000900
C   LED FACTORS WILL BE ASSUMED TO BE 1.0                               00001000
C   IF BAD TABLE VALUES, THEN ALL GAIN FACTORS WILL BE SET              00001100
C   TO 1.0.                                                             00001200
C                                                                       00001210
C   ALL IMP-7 AND IMP-8 GAIN FACTORS ARE CALCULATED RELATIVE TO THE     00001220
C   IMP-6 STANDARD.  THE FOLLOWING RATIOS WERE DETERMINED BY            00001230
C   C. PAIZIS (12/21/77):                                               00001240
C       D(IMP-6)/D(IMP-7) = 1.04        D(IMP-6)/D(IMP-8) = .8522       00001250
C       E(IMP-6)/E(IMP-7) = .9804       E(IMP-6)/E(IMP-8) = .9386       00001260
C       F(IMP-6)/F(IMP-7) = 1.20        F(IMP-6)/F(IMP-8) = .8926       00001270
C                                                                       00001300
C***********************************************************************00001400
C                                                                       00001500
      IMPLICIT LOGICAL*1(Q)                                             00001600
      DIMENSION STD(5),ENDPT(5),GAIN(5),GAININ(5),GAINTB(3)             00001700
      REAL*4 XBNORM(5,3)/1.0  , 1.0  , 1.0  , 1.0  , 1.0  ,             00001750
     *                   1.0  , 1.0  , 1.04 , .9804, 1.20 ,             00001760
     *                   1.0  , 1.0  , .8522, .9386, .8826/             00001770
c6/94
c     DATA IYR/0/,ISTART/0/,QP/T/                                       00001800
      DATA IYR/0/,ISTART/0/
      QP=.true.
C                                                                       00001900
      QCALL = .FALSE.                                                   00002000
C   CHECK ON INPUTTED VALUES AND VERIFY NEED FOR TABLE LOOKUP.          00002100
      DO 20 I=1,5                                                       00002200
        GAININ(I) = -1.0                                                00002300
        IF (STD(I).EQ.0.0.OR.ENDPT(I).EQ.0.0) GOTO 10                   00002400
        GAININ(I) = STD(I)/ENDPT(I)                                     00002500
        GOTO 20                                                         00002600
 10     IF (I.GE.3) QCALL = .TRUE.                                      00002700
 20     CONTINUE                                                        00002800
C                                                                       00002900
C   FETCH TABLE VALUES IF NECESSARY; QBAD SET FOR BAD VALUES.           00003000
C   IFITIALIZE IADDR TO 0 , IN GAINS ARE TO BE ON INPUT CARDS           00003001
      IF(.NOT. QCALL) IADDR=0                                           00003011
      IF (QCALL) CALL FLXGMD(IMP,JORB,IYR,ISTART,GAINTB,IADDR,QP,QBAD)  00003100
C                                                                       00003600
C   SET GAIN VALUES AS PER PRIORITY ABOVE.                              00003700
      DO 40 I=1,5                                                       00003800
        GAIN(I) = 1.0                                                   00003900
C       CHECK FOR INPUTTED VALUE.                                       00004000
        IF (GAININ(I).EQ.-1.0) GOTO 30                                  00004100
        GAIN(I) = GAININ(I)                                             00004200
        GOTO 40                                                         00004300
 30     IF (I.GT.2.AND.QCALL.AND..NOT.QBAD) GAIN(I) = GAINTB(I-2) *     00004400
     *                                          XBNORM(I,IMP-5)         00004450
 40     CONTINUE                                                        00004500
      RETURN                                                            00004600
      END                                                               00004700
