      SUBROUTINE FLXFG(INPHA,IADDR,GAIN)                                00000010
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00000020
C                                                                       00000030
C   FLXFG  -  ROUTINE TO RETURN GAIN FACTORS FROM FINE GAIN TABLE       00000040
C   GIVEN INPUT PHA RECORD.                                             00000050
C   CALLING SEQUENCE:                                                   00000060
C         CALL FLXFG(INPHA,IADDR,GAIN)                                  00000070
C   WHERE:                                                              00000080
C           INPHA I   ARRAY (SIZE 388)   I*4    INPUT IMP-7,-8 PHA      00000090
C                                               RECORD                  00000100
C           IADDR I                      I*4    RECORD NUMBER IN FINE   00000110
C                                               GAIN TABLE              00000120
C           GAIN  O   ARRAY (SIZE 5)     R*4    GAIN FACTORS FOR A,B,D, 00000130
C                                                                       00000140
C   EXPECTS 'K3.ZBJDC.FINEGAIN' ON UNIT 40.                             00000150
C   XNORM NORMALIZATION FACTORS ARE EXPLAINED IN FLXGNN PROLOGUE.       00000155
C                                                                       00000160
C   MODIFIED BY HENRY LO ON MARCH 1989 TO CONFORM TO                            
C   VS-FORTRAN COMPILER SYNTAX                                                  
C                                                                               
C   MODIFIED BY HENRY LO ON MARCH 1992 TO ADD WARNING MESSAGE                   
C   AND STOP , WHEN HOUR INDEX IS GREATER THAN 96                               
C                                                                               
c   5/94
c
c   replace DREAD by read
c
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00000170
      IMPLICIT INTEGER*2(H)                                             00000180
      DIMENSION INPHA(388),GAIN(5)                                      00000190
      DIMENSION RFGAIN(3,97),IGAIN(3,97),HGAIN(2,3,97)                  00000200
      DATA JADDR/0/,JNDEX/0/                                            00000210
      REAL*4 XNORM(3,3)/1.0  ,1.0  ,1.0  ,                              00000212
     *                  1.04 ,.9804,1.2  ,                              00000214
     *                  .8522,.9386,.8826/                              00000216
      EQUIVALENCE (RFGAIN(1,1),IGAIN(1,1),HGAIN(1,1,1))                 00000220
C                                                                       00000230
C   READ IN FINE GAIN TABLE ENTRY IF NOT ALREADY IN.                    00000240
      IF (JADDR.EQ.IADDR) GOTO 20                                       00000250
         JADDR = IADDR                                                  00000260
c
c5/94
c        CALL DREAD(40,IADDR,RFGAIN,*3000)                              00000270
c
         read(unit=40,rec=IADDR,err=3000) RFGAIN
c
         IMP = HGAIN(1,1,97)                                            00000280
         INTVAL = HGAIN(2,1,97)                                         00000290
C   GET START YEAR AND DAY OF YEAR FROM INTERVAL                        00000300
         CALL FGDATE(INTVAL,IYR1,IDAY1)                                 00000310
C   SUBTRACT 1 DAY AND CONVERT TO DECISECONDS OF YEAR.                  00000312
         ISTART = IDAY1 - 1                                             00000314
         IF (ISTART.GE.0) GOTO 15                                       00000316
            IYR1 = IYR1 - 1                                             00000318
            LEAP = ((IYR1/4)*4)/IYR1                                    00000320
            ISTART = 365 + LEAP                                         00000322
15       ISTART = ISTART*864000                                         00000324
C                                                                       00000330
C   CALCULATE TIME OF YEAR RELATIVE TO YEAR AT START OF INTERVAL        00000340
20    INTIME = INPHA(1)                                                 00000350
      IF (INPHA(24).EQ.IYR1) GOTO 30                                    00000360
      LEAP = ((IYR1/4)*4)/IYR1                                          00000370
      INTIME = INTIME + (365+LEAP)*864000                               00000380
C                                                                       00000390
30    INDEX = (INTIME - ISTART)/36000 + 1                               00000400
      IF (INDEX.EQ.JNDEX) GOTO 40                                       00000410
C                                                                       00000420
C   CALCULATE HOUR INDEX INTO INTERVAL (96 IN ALL)                      00000430
      JNDEX = INDEX                                                     00000440
      IF (INDEX.LT.1) INDEX = 1                                         00000450
C                                                                               
C     STOP THE PROGRAM WHEN HOUR INDEX IS GREATER THAN 96                       
C                                                                               
      IF (INDEX.LE.96) GO TO 35                                                 
C                                                                               
      WRITE(6,1001) INDEX                                                       
      STOP 999                                                                  
C                                                                               
C                                                                               
C     IF (INDEX.GT.96) INDEX = 96                                       00000460
35    GAIN(3) = RFGAIN(1,INDEX)*XNORM(1,IMP-5)                          00000470
      GAIN(4) = RFGAIN(2,INDEX)*XNORM(2,IMP-5)                          00000480
      GAIN(5) = RFGAIN(3,INDEX)*XNORM(3,IMP-5)                          00000490
      PRINT 1000,INDEX,INPHA(1),INPHA(24),GAIN                          00000500
1000  FORMAT(10X,3I10,5F10.5)                                           00000510
1001  FORMAT(10X,' HOUR INDEX = ',I5,'   IS OUT OF LIMIT 96'/)          00000510
C                                                                       00000520
40    CONTINUE                                                          00000530
      RETURN                                                            00000540
C                                                                       00000550
3000  CALL ABEND(123)                                                   00000560
      STOP                                                              00000570
      END                                                               00000580
