      SUBROUTINE FLX8PR(JORB,ITPREC,INUNIT,IOUTUN,GAIN,KBIN,IBXORB,     00000100
     *                  IADDR)                                          00000101
C***********************************************************************00000200
C  SUBROUTINE FLX8PR IS A MODIFIED VERSION OF FLX6PR.  THIS             00000300
C    SUBROUTINE READS INPUT PHA RECORDS AND PROCESSES DATA FOR ONE      00000400
C    ORBIT.                                                             00000500
C                                                                       00000600
C  CALLING ARGUMENTS                                                    00000700
C    ARGUMENT  I/O    TYPE             DESCRIPTION                      00000800
C    JORB      I      I*4              INTERVAL NUMBER.                 00000900
C    ITPREC    O      I*4 (ARRAY 15)   TAPE DESCRIPTION FOR TAPE        00001000
C                                      CATALOG.                         00001100
C    INUNIT    I      I*4              LOGICAL UNIT FOR INPUT PHA       00001200
C                                      TAPE USED BY FTIO.               00001300
C    IOUTUN    I      I*4              LOGICAL UNIT FOR OUTPUT FLUX     00001400
C                                      TAPE USED BY FTIO.               00001500
C    GAIN      I      R*4 (ARRAY 5)    GAIN CORRECTION FACTORS PASSED   00001600
C                                      TO PHACT8.                       00001700
C    KBIN      O      I*4 (ARRAY 4,9)  COUNTS RECORDS SUCCESSFULLY      00001800
C                                      READ, RECORDS ACCEPTED AND       00001900
C                                      RECORDS REJECTED.                00002000
C    IBXORB    O      I*4 (ARRAY 144)  ACCUMULATED BOX COUNTS FOR       00002100
C                                      PRESENT ORBIT.                   00002200
C                                                                       00002300
C  COMMON FERMSG IS USED TO WRITE AN ERROR MESSAGE FOR ERRORS           00002400
C    ENCOUNTERED USING FTIO.                                            00002500
C                                                                       00002600
C  PROGRAMMERS: J. CHILDS AND E. ENG, COMPUTER SCIENCES CORP., JAN. 77  00002700
C  SATELLITE:  IMP-8                                                    00002800
C                                                                       00002900
C  MODIFIED BY HENRY LO ON MARCH 1989 TO CONFORM TO                             
C  VS-FORTRAN COMPILER SYNTAX                                                   
C                                                                               
C  MODIFIED BY HENRY LO ON 6/1991 TO COMMENT OUT                                
C  THE STATEMENT IF (INPHA(1).GT.316224000)                                     
C                                                                               
c  5/94
c
c  comment out some statements at the end of this routine
c
c  6/94
c
c  move INPHA(69-388) to HPHA(1-640) before call PHACT8
c
c  7/94
c
c  replace IGET(GFTRND(I),0,7) by bftrnd(I)
c
C***********************************************************************00003000
C                                                                       00003100
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H),REAL*8(D)                      00003200
      COMMON /FERMSG/ IMES(26)                                          00003300
C                                                                       00003400
c7/94 LOGICAL*1 QFTRND(15)                                              00003500
      LOGICAL*1 QFTRND(18)                                              00003500
      DIMENSION INPHA(388),IFLUX(147),HNPHA(2,388),HFLUX(2,147)         00003600
c6/94 DIMENSION KBIN(2,38),ITPREC(15),HBXSUM(144),IBXORB(144)           00003700
      DIMENSION KBIN(2,38),ITPREC(16),HBXSUM(144),IBXORB(144)           00003700
      DIMENSION GAIN(5),HDATA(4,18)                                     00003800
c6/94
c     DATA IMP8/8/,IZERO/ZF8000000/                                     00003900
      DATA IMP8/8/,IZERO/X'F8000000'/
      INTEGER NEVENT(11)/11*0/,IDATA(2,18)                              00004000
c6/94
c
      byte bftrnd(18)
      integer*2 HPHA(640)
      integer iarray(3)
      integer plat/'SUN '/,storage/'HD  '/,satid/'IMP8'/,flux/'FLEX'/
c     equivalence(QFTRND(1),bftrnd(1))
c
      EQUIVALENCE (INPHA(1),HNPHA(1,1)),(IFLUX(1),HFLUX(1,1)),          00004100
c7/94*(INPHA(32),QFTRND(1)),(IDATA(1,1),HDATA(1,1))                     00004200
     *(INPHA(32),bftrnd(1)),(IDATA(1,1),HDATA(1,1))                     00004200
C                                                                       00004300
c6/94
c     nrec = 0
c
C   READ FIRST PHA RECORD.                                              00006300
  5   CALL FREAD(INPHA,INUNIT,JLEN,*400,*10)                            00006400
c
c     nrec = nrec + 1
c     if (nrec.gt.4) stop
c
CLO   IF(INPHA(1) .GT. 316224000) GO TO 5                               00006410
      IF (JLEN.NE.1552) CALL ABEND(99)                                  00006500
      GOTO 20                                                           00006600
C                                                                       00006700
C       I/0 ERROR                                                       00006800
 10     PRINT 1000,JLEN,(IMES(I),I=1,26)                                00006900
1000    FORMAT(' I/O ERROR ON PHA TAPE, LENGTH=',I10/                   00007000
     *         1X,Z8,I6,20A4,4(1X,Z8))                                  00007100
        GOTO 5                                                          00007200
C                                                                       00007300
C   CHECK INTERVAL NUMBER                                               00007400
   20 KORB = HNPHA(1,26)                                                00007500
      IF(KORB .LT. 0)KORB =-KORB                                        00007600
      IF(KORB .LT. JORB)GO TO 5                                         00007605
      IF(KORB .GT. JORB)GO TO 400                                       00007610
      IF (IADDR.GT.0) CALL FLXFG(INPHA,IADDR,GAIN)                      00007615
C                                                                       00007700
C   INITIALIZE VALUES FOR AN ORBIT.                                     00007800
      DO 25 I=1,2                                                       00007900
        DO 25 J=1,38                                                    00008000
 25       KBIN(I,J) = 0                                                 00008100
      KBIN(1,19) = 1                                                    00008200
      DO 26 I=1,144                                                     00008300
   26   IBXORB(I) = 0                                                   00008400
      QEND = .FALSE.                                                    00008500
C                                                                       00008600
C   INITIALIZE VALUES FOR 5 MINUTE INTERVAL (=3000 DECISECS).           00008700
 28   QLOBR = .FALSE.                                                   00008800
      QHIBR = .FALSE.                                                   00008900
      DO 30 I=1,144                                                     00009000
 30     HBXSUM(I) = 0                                                   00009100
      DO 35 I=1,18                                                      00009200
        DO 35 J=1,2                                                     00009300
 35     IDATA(J,I) = 0                                                  00009400
      DO 40 I=1,11                                                      00009500
 40     NEVENT(I) = 0                                                   00009600
C     CLEAR SUMS                                                        00009700
      IFLUX(15) = 0                                                     00009800
C                                                                       00009900
      DO 42 I=137,147                                                   00010000
      IFLUX(I) = 0                                                      00010100
   42 CONTINUE                                                          00010200
      KLO = (INPHA(1)/3000)*3000                                        00010300
      KHI = KLO + 3000                                                  00010400
      KYEAR = INPHA(24)                                                 00010500
C   INITIALIZE OUTPUT FLUX RECORD.                                      00010600
      IFLUX(1) = KLO                                                    00010700
      HFLUX(1,2) = KYEAR                                                00010800
      HFLUX(2,2) = JORB                                                 00010900
      IFLUX(5) = INPHA(11)                                              00011000
      IFLUX(4) = HNPHA(2,4)                                             00011100
C     SET COORDINATES                                                   00011200
      IFLUX(6) = INPHA(12)                                              00011300
      IFLUX(7) = INPHA(13)                                              00011400
      IFLUX(8) = INPHA(14)                                              00011500
C                                                                       00011600
      IFLUX(9) = INPHA(15)                                              00011700
      IFLUX(10) = INPHA(16)                                             00011800
      IFLUX(11) = INPHA(17)                                             00011900
C                                                                       00012000
      IFLUX(12) = INPHA(18)                                             00012100
      IFLUX(13) = INPHA(19)                                             00012200
      IFLUX(14) = INPHA(20)                                             00012300
C                                                                       00012400
      IFLUX(16) = INPHA(28)                                             00012500
      IFLUX(17) = INPHA(29)                                             00012600
      IFLUX(3) = 1600                                                   00012700
      IF (IGET(INPHA(3),0,0).EQ.1) IFLUX(3) = 400                       00012800
C                                                                       00012900
C   BEGIN PROCESSING -- DO THE FOLLOWING FOR EACH PHA RECORD THAT LIES  00013000
C   WITHIN THE SUMMARY INTERVAL KLO TO KHI.                             00013100
 45   IBRATE = 1                                                        00013200
      IF (IGET(INPHA(3),0,0).EQ.1) IBRATE = 4                           00013300
C                                                                       00013400
C   CHECK TREND CHECK.                                                  00013500
      DO 500 I = 1,18                                                   00013600
C                                                                       00013700
      IDAT = INPHA(36 + I)                                              00013800
c6/94******************************************************************
c
c     HDATA(4,I) = HDATA(4,I) + IGET(QFTRND(I),0,7)                     00013900
c     KBIN(2,I) = KBIN(2,I) + IGET(QFTRND(I),0,7)                       00014000
c
c7/94
c     itrnd = bftrnd(I)
c     HDATA(4,I) = HDATA(4,I) + IGET(itrnd,0,7)
c     KBIN(2,I) = KBIN(2,I) + IGET(itrnd,0,7)
c
      HDATA(4,I) = HDATA(4,I) + bftrnd(I)      
      KBIN(2,I) = KBIN(2,I) + bftrnd(I)
c
C        CHECK FOR ZERO READOUTS.                                       00014100
      IF(IDAT .EQ. IZERO) GO TO 500                                     00014200
      IDATA(1,I)   = IDATA(1,I)   + IGET(IDAT,4,31)                     00014300
C   SAVE ACCEPTED RATES READOUTS FOR SUMMARY LISTING.                   00014305
      KBIN(1,I+20) = KBIN(1,I+20) + IGET(IDAT,4,31)                     00014310
      HDATA(3,I)   = HDATA(3,I)   + (16 - IGET(IDAT,0,3))*IBRATE        00014400
      KBIN(1,I)    = KBIN(1,I)    + (16 - IGET(IDAT,0,3))*IBRATE        00014500
  500 CONTINUE                                                          00014600
c
c6/94
c
c     CALL PHACT8(INPHA(69),NEVENT,IBXORB,HBXSUM,GAIN,IMP8)             00014700
c
      call FMOVE(HPHA(1),1280,INPHA(69))
c
      CALL PHACT8(HPHA,NEVENT,IBXORB,HBXSUM,GAIN,IMP8) 
c     CALL PHACT8(NEVENT,IBXORB,GAIN,IMP8,HPHA,HBXSUM) 
c
C*****SUM FOR 5 MINUTE INTERVAL.                                        00014800
      HFLUX(1,15) = HFLUX(1,15) + HNPHA(1,25)                           00014900
      HFLUX(2,15) = HFLUX(2,15) + HNPHA(2,25)                           00015000
C                                                                       00015100
      IFLUX(137) = IFLUX(137) + INPHA(58)                               00015200
C                                                                       00015300
      DO 550 IN=59,67                                                   00015400
      HFLUX(1,IN+79) = HFLUX(1,IN+79) + HNPHA(1,IN)                     00015500
      HFLUX(2,IN+79) = HFLUX(2,IN+79) + HNPHA(2,IN)                     00015600
  550 CONTINUE                                                          00015700
      HFLUX(1,147) = HFLUX(1,147) + HNPHA(1,68)                         00015800
C**********                                                             00015900
C   JUMP IF LAST RECORD OF ORBIT.                                       00016000
      IF (QEND) GOTO 130                                                00016100
C   READ NEXT RECORD.                                                   00016200
 90   CALL FREAD(INPHA,INUNIT,JLEN,*400,*100)                           00016300
c6/94
c     nrec = nrec + 1
c     if (nrec.gt.4) stop
CLO   IF(INPHA(1) .GT. 316224000) GO TO 90                              00016310
      IF (IADDR.GT.0) CALL FLXFG(INPHA,IADDR,GAIN)                      00016350
      KBIN(1,19) = KBIN(1,19) + 1                                       00016400
      GOTO 120                                                          00016500
C                                                                       00016600
C       I/O ERROR                                                       00016700
100     PRINT 1000,JLEN,(IMES(I),I=1,26)                                00016800
        KBIN(2,19) = KBIN(2,19) + 1                                     00016900
        GOTO 90                                                         00017000
C                                                                       00017100
C   TEST FOR END OF INTERVAL.                                           00017200
  120 IF(HNPHA(1,26) .LT. 0)QEND = .TRUE.                               00017300
C                                                                       00017400
C   JUMP BACK IF NEW PHA RECORD WITHIN SAME SUMMARY INTERVAL.           00017500
      IF (INPHA(24).EQ.KYEAR.AND.INPHA(1).LT.KHI) GOTO 45               00017600
C                                                                       00017700
C   INTERVAL IS DONE -- FINISH UP AND WRITE OUT SUMMARY RECORD.         00017800
130   CONTINUE                                                          00017900
C                                                                       00017905
C   ACCUMULATE XMATR FOR AN INTERVAL.                                   00017910
      KBIN(2,24) = KBIN(2,24) + NEVENT(1)                               00017915
      KBIN(2,25) = KBIN(2,25) + NEVENT(2)                               00017920
      KBIN(2,26) = KBIN(2,26) + NEVENT(3)                               00017925
      KBIN(2,27) = KBIN(2,27) + NEVENT(4)                               00017930
      KBIN(2,28) = KBIN(2,28) + NEVENT(5)                               00017940
      KBIN(2,29) = KBIN(2,29) + NEVENT(6)                               00017950
      KBIN(2,34) = KBIN(2,34) + NEVENT(7)                               00017962
      KBIN(2,35) = KBIN(2,35) + NEVENT(8)                               00017965
      KBIN(2,36) = KBIN(2,36) + NEVENT(9)                               00017973
      KBIN(2,37) = KBIN(2,37) + NEVENT(10)                              00017981
      KBIN(2,38) = KBIN(2,38) + NEVENT(11)                              00017989
C                                                                       00017990
      CALL FMOVE(IFLUX(18),48,IDATA(1,4))                               00018000
      CALL FMOVE(IFLUX(30),40,IDATA(1,14))                              00018100
      CALL FMOVE(IFLUX(40),24,IDATA(1,1))                               00018200
      CALL FMOVE(IFLUX(46),32,IDATA(1,10))                              00018300
      CALL FMOVE(IFLUX(54),288,HBXSUM(1))                               00018400
      CALL FMOVE(IFLUX(126),44,NEVENT(1))                               00018500
C                                                                       00018600
      CALL FWRITE(IFLUX,IOUTUN,LEN)                                     00018700
      KBIN(1,20) = KBIN(1,20) + 1                                       00018800
C********** DEBUG PRINT - TEST FEW PHA RECORDS ONLY **********          00018900
C     IF(KBIN(1,20) .GT. 20) GO TO 400                                  00019000
C                                                                       00019100
c6/94
C   SAVE START TIMES FOR CATALOG.                                       00019200
c     IF (ITPREC(5).GT.0) GOTO 140                                      00019300
c     ITPREC(6) = HFLUX(2,2)                                            00019400
c     ITPREC(7) = KYEAR                                                 00019500
c     ITPREC(8) = KLO                                                   00019600
c     ITPREC(9) = INPHA(2)                                              00019700
c140  ITPREC(5) = ITPREC(5) + 1                                         00019800
c
      IF (ITPREC(16).GT.0) GOTO 140
c
      ITPREC(1) = plat
      ITPREC(2) = storage
      ITPREC(5) = satid
      ITPREC(6) = flux
      ITPREC(8) = HFLUX(2,2)
      ITPREC(10) = KYEAR
      ITPREC(11) = KLO
140   ITPREC(16) = ITPREC(16) + 1
c
      IF (.NOT.QEND) GOTO 28                                            00019900
C                                                                       00020000
C   END OF ORBIT.                                                       00020100
c     ITPREC(10) = JORB                                                 00020200
c     ITPREC(11) = KYEAR                                                00020300
c     ITPREC(12) = KLO                                                  00020400
c     ITPREC(13) = INPHA(2)                                             00020500
c
      ITPREC(9) = JORB
      ITPREC(12) = KYEAR
      ITPREC(13) = KLO
c
c     find the generation date
c
      call idate(iarray)
      igendt=iarray(3)*10000+iarray(2)*100+iarray(1)
c
      call itime(iarray)
      igentm=iarray(1)*10000+iarray(2)*100+iarray(3)
c
      ITPREC(14)=igendt
      ITPREC(15)=igentm
c
c5/94
c     IBIT = MOD(JORB,60)                                               00020600
c     IF (IBIT.EQ.0) IBIT = 60                                          00020700
c     IWRD = 15                                                         00020800
c     IF (IBIT.GT.30) IWRD = 14                                         00020900
c     IF (IBIT.GT.30) IBIT = IBIT - 30                                  00021000
c     CALL GETPUT(-1,0,0,ITPREC(IWRD),32-IBIT,32-IBIT)                  00021100
C                                                                       00021200
400   CONTINUE                                                          00021300
C********** DEBUG - WRITE NEVENT(11) **********                         00021400
C     WRITE(6,600)NEVENT                                                00021500
C 600 FORMAT(1X,5I10)                                                   00021600
      RETURN                                                            00021700
      END                                                               00021800
