/* idde.c
 * $Id: idde.c,v 1.1 1991/10/08 21:13:03 esp Exp $
 *
 * Converts an IBM format double precision floating point representation to
 * IEEE format.
 * ------------------------------------------------------------------------
 * Nand Lal - GSFC - January 91
 * E.S.Panduranga - S.T.X. - 04/18/91
 * ------------------------------------------------------------------------
 * $Log: idde.c,v $
 * Revision 1.1  1991/10/08  21:13:03  esp
 * Initial revision
 *
 */

static char	*rcsid = "$Id: idde.c,v 1.1 1991/10/08 21:13:03 esp Exp $";

int sign_mask = 0x80000000;
double zero = 0.;
int exp_tab[128] = {766,770,774,778,782,786,790,794,
                    798,802,806,810,814,818,822,826,
                    830,834,838,842,846,850,854,858,
                    862,866,870,874,878,882,886,890,
                    894,898,902,906,910,914,918,922,
                    926,930,934,938,942,946,950,954,
                    958,962,966,970,974,978,982,986,
                    990,994,998,1002,1006,1010,1014,1018,
                    1022,1026,1030,1034,1038,1042,1046,1050,
                    1054,1058,1062,1066,1070,1074,1078,1082,
                    1086,1090,1094,1098,1102,1106,1110,1114,
                    1118,1122,1126,1130,1134,1138,1142,1146,
                    1150,1154,1158,1162,1166,1170,1174,1178,
                    1182,1186,1190,1194,1198,1202,1206,1210,
                    1214,1218,1222,1226,1230,1234,1238,1242,
                    1246,1250,1254,1258,1262,1266,1270,1274,
                   };
int shift_tab[16] = {4,4,3,3,2,2,2,2,1,1,1,1,1,1,1,1};
int add_tab[16]   = {0,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0};

double idde(ibmdouble) /* Convert ibm double precision to IEEE */
unsigned ibmdouble[];
{
   union {
      unsigned undef[2];
      double ieee;
   } number;
   unsigned sign_part,exponent_part;
   unsigned ibm_fraction,high_nibble,ieee_exponent,ieee_fraction;
   unsigned ibmfloat,temp;

   ibmfloat = ibmdouble[0];
   sign_part = ibmfloat & sign_mask;
   ibmfloat -= sign_part;
   if (ibmfloat == 0) return(zero);

   exponent_part = (ibmfloat & 0xff000000);
   ibm_fraction = ibmfloat - exponent_part;
   high_nibble = (ibmfloat & 0x00f00000) >> 20;

   ieee_exponent = exp_tab[exponent_part >> 24] - add_tab[high_nibble];
   ieee_fraction = (ibm_fraction << shift_tab[high_nibble]) & 0x00ffffff;
   temp = (ibmdouble[1] >> (32-shift_tab[high_nibble]));
   ieee_fraction |= temp;
   number.undef[1] = (ibmdouble[1] << shift_tab[high_nibble]) >> 4;
   temp = ieee_fraction  << 28;
   number.undef[1] |= temp;
   ieee_fraction = (ieee_fraction >> 4);
   number.undef[0] = (sign_part | (ieee_exponent << 20) | ieee_fraction);
   return (number.ieee);
}
double idde_(ibmdouble) /* Convert ibm double precision to IEEE */
unsigned ibmdouble[];
{
	double idde();
	return (idde(ibmdouble));
}
