CH1   SUBROUTINE FLXPTC(KIMP,TCFACT,QFAIL)                              00000010
CH                                                                      00000020
CH2  FUNCTIONAL DESCRIPTION:                                            00000030
CH2       FLUX PLOT PROGRAM EVENT-TYPE RATE TREND CHECKER.              00000040
CH                                                                      00000050
CH3  CALLING ROUTINES:  FLXPSS                                          00000060
CH                                                                      00000070
CH4  SUBROUTINES CALLED:  PDUMP.                                        00000080
CH                                                                      00000090
CH5  VARIABLE CROSS REFERENCE:                                          00000100
CH5    NAME         TYPE   I/O        DESCRIPTION                       00000110
CH5   KIMP           I*4    I   IMP NUMBER (1=IMP-6, 2=IMP-7, 3=IMP-8)  00000120
CH5   TCFACT         R*8    I   FACTOR TO BE USED IN TREND CHECK CAL'N  00000130
CH5   QFAIL          L*1    O   RETURN FLAG:                            00000140
CH5                                     TRUE  - PASSES TREND CHECK      00000150
CH5                                     FALSE - FAILED TREND CHECK      00000160
CH5   ILOC(3)        I*4        STARTING LOCATION IN FLUX TAPE          00000170
CH5                             RECORD FOR RATES DATA (3 IMPS)          00000180
CH5   IUP(3)         I*4        STOPPING LOCATION IN FLUX TAPE          00000190
CH5                             RECORD FOR RATES DATA (3 IMPS)          00000200
CH5   IMAX(3)        I*4        TOTAL NUMBER OF EVENT-TYPE RATES        00000210
CH5                                                       (3 IMPS)      00000220
CH5   OLDRAT(11,3)   R*4        STORAGE FOR OLD RATE VALUE TO BE        00000230
CH5                             COMPARED WITH CURRENT VALUE             00000240
CH5                             (11 RATES, 3 IMPS)                      00000250
CH5   HFLUX(2,150,3) I*2        HALFWORD EQUIVALENCE OF FLUX            00000260
CH5                             RECORD (2 HW,150 WORDS,3 IMPS)          00000270
CH5   N2             I*4        UPPER INDEX ON NUMBER OF RATES          00000280
CH5   M1,M2          I*4        WORK INDICES                            00000290
CH5   INDEX          I*4        LOOP INDEX                              00000300
CH5   IREAD          I*4        CURRENT READOUT VALUE                   00000310
CH5   ICOUNT         I*4        CURRENT COUNTS VALUE                    00000320
CH5   RATE           R*4        CURRENT RATE VALUE                      00000330
CH5   IFLUX(150,3)   I*4        FLUX RECORDS                            00000340
CH                                                                      00000350
CH6  METHOD:                                                            00000360
CH6       THIS ROUTINE PERFORMS THE STANDARD IMP RATE TREND CHECK       00000370
CH6       ON EVENT-TYPE RATES OBTAINED FROM THE IMP FLUX TAPES.         00000380
CH                                                                      00000390
CH7  PROGRAMMER:  J. CHILDS, 4/78.                                      00000400
CH                                                                      00000410
CH9  IMP-6/7/8, FLUX PLOT, FLXPTC, V1.                                  00000420
CH**********************************************************************00000430
C                                                                       00000440
      SUBROUTINE FLXPTC(KIMP,TCFACT,QFAIL)                              00000450
C                                                                       00000460
      IMPLICIT LOGICAL*1(Q)                                             00000470
      INTEGER*4 KIMP,ILOC(3),IUP(3),IMAX(3),M1,M2,N2,INDEX,IREAD,       00000480
     *          ICOUNT                                                  00000490
      INTEGER*2 HFLUX(2,150,3)                                          00000500
      REAL*4    RATE,OLDRAT(11,3),TCFACT                                00000510
      DATA      OLDRAT/33*1.0/,ILOC/18,21,18/,IUP/33,50,53/,            00000520
     *          IMAX/8,8,11/                                            00000530
      COMMON /REKORD/ IFLUX(150,3)                                      00000540
      EQUIVALENCE (IFLUX(1,1),HFLUX(1,1,1))                             00000550
      QTREND(A,B) = A.LE.TCFACT*B.AND.B.LE.TCFACT*A                     00000560
C                                                                       00000570
      N2 = IMAX(KIMP)                                                   00000580
CP  INITIALIZE RETURN FAIL FLAG TO FALSE                                00000590
      QFAIL = .FALSE.                                                   00000600
CP  DO FOR EACH RATE                                                    00000610
      DO 100 INDEX=1,N2                                                 00000620
         M1 = ILOC(KIMP) + 2*(INDEX-1)                                  00000630
         M2 = M1 + 1                                                    00000640
CP     FETCH NUMBER OF READOUTS                                         00000650
         IREAD  = HFLUX(1,M2,KIMP)                                      00000660
CP     FETCH NUMBER OF COUNTS                                           00000670
         ICOUNT = IFLUX(M1,KIMP)                                        00000680
CP     IF (READOUTS = 0 OR COUNTS = 0) NEXT RATE                        00000690
         IF (IREAD.EQ.0.OR.ICOUNT.EQ.0) GOTO 100                        00000700
CP     CALCULATE RATE                                                   00000710
         RATE = FLOAT(ICOUNT)/FLOAT(IREAD)                              00000720
CP     IF (RATE FAILS TREND CHECK)                                      00000730
         IF (QTREND(RATE,OLDRAT(INDEX,KIMP))) GOTO 90                   00000740
CP        SET FAIL FLAG TO TRUE                                         00000750
         QFAIL = .TRUE.                                                 00000760
         PRINT 1000,INDEX,OLDRAT(INDEX,KIMP),RATE                       00000770
1000     FORMAT(5X,'TREND CHECK FAIL:',I5,1P2E15.5)                     00000780
CP     FI                                                               00000790
CP     STORE CURRENT VALUE OF RATE                                      00000800
 90      OLDRAT(INDEX,KIMP) = RATE                                      00000810
CP  OD                                                                  00000820
100      CONTINUE                                                       00000830
C                                                                       00000840
      IF (.NOT.QFAIL) GOTO 200                                          00000850
CP  IF (FAIL FLAG SET) PDUMP THE RATES                                  00000860
         CALL PDUMP(IFLUX(ILOC(KIMP),KIMP),IFLUX(IUP(KIMP),KIMP),0)     00000870
C                                                                       00000880
200   RETURN                                                            00000890
      END                                                               00000900
