CH1   SUBROUTINE FLXPPR                                                 00000010
CH                                                                      00000020
CH2  FUNCTIONAL DESCRIPTION:                                            00000030
CH2    GENERATES LINE PRINTER LISTING OF FLUX CALCULATIONS.             00000040
CH                                                                      00000050
CH3  CALLING ROUTINES:  FLXPMN                                          00000060
CH                                                                      00000070
CH4  SUBROUTINES CALLED:  IFIXIT, UNPACK                                00000080
CH                                                                      00000090
CH5  VARIABLE CROSS REFERENCE:                                          00000100
CH5    NAME         TYPE   I/O        DESCRIPTION                       00000110
CH5  DPART(20)       R*8     I    PARTICLE LABELS                       00000120
CH5  ELOBN(100)      R*4     I    LOWER BIN ENERGY, MEV                 00000130
CH5  EUPBN(100)      R*4     I    UPPER BIN ENERGY, MEV                 00000140
CH5  IMP(100)        I*4     I    IMP NUMBER (1=6,2=7,3=8)              00000150
CH5  IPTS            I*4    I,O   NUMBER OF POINTS PER FRAME            00000160
CH5  ITIME(250)      I*4     I    TIME-HISTORY TIMES, DECISEC OFIYR1   00000170
CH5  JCHAR(100)      I*4     I    PLOT POINT CHARACTERS                 00000180
CH5  JPRTBN(100)     I*4     I    BIN PARTICLE NUMBERS                  00000190
CH5  JTITLE(20)      I*4     I    USER TITLE                            00000200
CH5  KTITLE(8)       I*4     I    TITLE                                 00000210
CH5  LINENO          I*4          NUMBER OF LINES PER PAGE              00000220
CH5  NUMBIN          I*4     I    NUMBER OF REQUESTED BINS              00000230
CH5  QFILTR          L*1     I    IMP-6 PERIGEE FILTER FLAG             00000240
CH5  QPER(250)       L*1     I    IMP-6 PERIGEE FLAG ARRAY              00000250
CH5  QSAT(3)         L*1     I    SATELLITE REQUEST FLAG                00000260
CH5  QTHIST          L*1     I    T=TIME HIST; F=SPECTRAL               00000270
CH5  Q6EV            L*1          IMP-6 REQUEST FLAG                    00000280
CH5  S(100)          R*4    I,O   SPECTRAL FLUX                         00000290
CH5  SDEL(100)       R*4    I,O   SPECTRAL FLUX ERROR                   00000300
CH5  XPERIG          R*4     I    IMP-6 PERIGEE ALTITUDE, METERS        00000310
CH5  Y(250)          R*4    I,O   TIME HISTORY FLUX                     00000320
CH5  YDEL(250)       R*4    I,O   TIME HISTORY FLUX ERROR               00000330
CH                                                                      00000340
CH6  METHOD:                                                            00000350
CH                                                                      00000360
CH7  PROGRAMMER:  J. CHILDS, 2/77.                                      00000370
CH                                                                      00000380
CH8  MODIFICATION:  P.SCHUSTER, 10/86  REDIMENSION ARRAYS               00000390
CH                                                                      00000400
CH9  IMP-6/7/8, FLUX PLOT, FLXPPR, V2.                                  00000410
CH**********************************************************************00000420
C                                                                       00000430
      SUBROUTINE FLXPPR                                                 00000440
C                                                                       00000450
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H),REAL*8(D)                      00000460
C*******  25 -> 100   144 -> 500                                        00000470
      COMMON /BINS/   NUMBIN,JBOX(10,100),IMP(100),JFRAME(100),         00000480
     *                JCHAR(100),XNORM(100),JPRTBN(100),ELOBN(100),     00000490
     *                EUPBN(100),QBOX(500,3),QFB(10,100)                00000500
C*******   CHANGE MINENG,MAXENG,MINFLX,MAXFLX, TO BE DIMENSIONED        00000510
C          TO 50 (FRAMES)                                               00000520
      COMMON /FRAME / ISTART,IYR1,ISTOP,IYR2,NORM2,MINENG(50),          00000530
     *                MAXENG(50),MINFLX(50),MAXFLX(50),                 00000540
     *                JRANGE,JRANUN,JAVER,NOAVU,IAVU,IFRMAX,QLINEX      00000550
      COMMON /LABELP/ DPART(43)                                         00000560
      COMMON /MONTH/  MONAT(12)                                         00000570
      COMMON /PERIGE/ XPERIG,JUP,IUP(100),JDN,IDN(100),QFILTR,QPER(250) 00000580
C*******   S, SDEL 25 ->100 ; Y , YDEL 6 ->100                          00000590
      COMMON /POINTS/ S(100),SDEL(100),Y(250,100),YDEL(250,100),        00000600
     *                ITIME(250),IPTS,JKEY,QTHIST                       00000610
      COMMON /SATLIT/ QSAT(3),QDAT(3)                                   00000620
      COMMON /USRTTL/ JTITLE(20)                                        00000630
C                                                                       00000640
      DIMENSION IIMP(100)                                               00000650
      INTEGER STAR,BLANK,ITEST/315360000/                               00000660
      CHARACTER*4 CSTAR/'*'/, CBLANK/'    '/                                    
      EQUIVALENCE (STAR,CSTAR), (BLANK,CBLANK)                                  
      INTEGER KTITLE(5)                                                 00000670
      CHARACTER*4 CKTITL(5)/'IMP ','FLUX',' PLO','T  -','--  '/         00000670
      EQUIVALENCE (CKTITL(1),KTITLE(1))                                         
C                                                                       00000680
CP  GET IMP NUMBERS FOR EACH BIN                                        00000690
      DO 200 J=1,NUMBIN                                                 00000700
200     IIMP(J) = IMP(J) + 5                                            00000710
CP  PRINT USER TITLE                                                    00000720
      WRITE(6,1000)(KTITLE(I),I=1,5),(JTITLE(I),I=1,20)                 00000730
1000  FORMAT(1H1,5A4,20A4/)                                             00000740
CP  IF (IMP-6 TIME HISTORY PLOTS, AND FILTERING REQUESTED)              00000750
CP     PRINT PERIGEE MESSAGE                                            00000760
CP  FI                                                                  00000770
      IF (QTHIST.AND.QSAT(1).AND.QFILTR) PRINT 1100,XPERIG              00000780
1100  FORMAT(' ',6X,'STARS DENOTE IMP-6 DATA BELOW',F10.1,' KM.')       00000790
CP  PRINT SYMBOL TABLE                                                  00000800
      PRINT 1200,(J,JCHAR(J),IIMP(J),DPART(JPRTBN(J)),ELOBN(J),         00000810
     *            EUPBN(J),J=1,NUMBIN)                                  00000820
1200  FORMAT(2(8X,I5,3X,A1,' = IMP-',I1,1X,A8,F7.2,' TO ',F7.2,' MEV')/)00000830
CP  IF (TIME HISTORY PLOT)                                              00000840
      IF (.NOT.QTHIST) GOTO 600                                         00000850
      WRITE(6,4000)                                                     00000860
4000  FORMAT(1H1)                                                       00000870
C                                                                       00000880
      DO 500 II = 1,NUMBIN,6                                            00000890
CP    SET UP PRINTOUT, MAX OF 6 BINS PER LINE                           00000900
          IS = II                                                       00000910
          IFF = II + 5                                                  00000920
          IF(IFF .GT. NUMBIN) IFF = NUMBIN                              00000930
          NB = IFF - IS + 1                                             00000940
          Q6EV = .TRUE.                                                 00000950
          IF (NB .LT. 6) Q6EV = .FALSE.                                 00000960
CP     PRINT COLUMN HEADINGS                                            00000970
      IF (.NOT.Q6EV) WRITE(6,2000) (I,JCHAR(I),I=IS,IFF)                00000980
2000  FORMAT(1H ,8X,'BIN#',9X,I5,3X,A1,4(13X,I5,3X,A1))                 00000990
      IF (Q6EV) WRITE(6,2001) (I,JCHAR(I),I=IS,IFF)                     00001000
2001  FORMAT(1H ,8X,'BIN#',6X,I5,3X,A1,5(10X,I5,3X,A1))                 00001010
CP     SET NUMBER OF LINES PER PAGE                                     00001020
      WRITE(6,2002)                                                     00001030
2002  FORMAT('  DDMONYY HH:MM:SS')                                      00001040
      LINENO = 65                                                       00001050
      FRSTLN = LINENO - 6                                               00001060
      QMORE = .FALSE.                                                   00001070
      IF (IPTS.GT.FRSTLN) QMORE = .TRUE.                                00001080
      I1 = 1                                                            00001090
      I2 = FRSTLN                                                       00001100
      IF (IPTS.LT.FRSTLN) I2 = IPTS                                     00001110
CP     DO FOR EACH OUTPUT PAGE NECESSARY                                00001120
CP        DO FOR ALL AVAILABLE LINES ON PAGE                            00001130
300   DO 490 I = I1,I2                                                  00001140
      KTIME = ITIME(I)                                                  00001150
        IYY = IYR1                                                      00001160
CP           GET TIME                                                   00001170
        IF(KTIME.GE.ITEST) CALL IFIXIT(KTIME,IDAY,IYY)                  00001180
        CALL UNPACK(IYY,KTIME,IMO,IDAYM,IHR,IMIN,ISEC)                  00001190
CP           GET PERIGEE MARKERS                                        00001200
        IPER = BLANK                                                    00001210
        IF (QPER(I)) IPER = STAR                                        00001220
        IYEAR = IYY - 1900                                              00001230
      WRITE(6,304)                                                      00001240
304   FORMAT(1H )                                                       00001250
CP           PRINT TIME AND PERIGEE MARKERS                             00001260
        WRITE(6,305) IPER,IDAYM,MONAT(IMO),IYEAR,IHR,IMIN,ISEC          00001270
305    FORMAT(1H+,A1,I2,A3,I2,1X,I2,':',I2,':',I2)                      00001280
CP           PRINT TIME HISTORY FLUX                                    00001290
      IF (Q6EV) GOTO 400                                                00001300
      GOTO (350,340,330,320,310),NB                                     00001310
310   IF (Y(I,IS+4).NE.-1.0) PRINT 311,Y(I,IS+4),YDEL(I,IS+4)           00001320
311   FORMAT(1H+,T110,1PE9.2,'+/-',E7.1)                                00001330
320   IF (Y(I,IS+3).NE.-1.0) PRINT 321,Y(I,IS+3),YDEL(I,IS+3)           00001340
321   FORMAT(1H+,T88 ,1PE9.2,'+/-',E7.1)                                00001350
330   IF (Y(I,IS+2).NE.-1.0) PRINT 331,Y(I,IS+2),YDEL(I,IS+2)           00001360
331   FORMAT(1H+,T66 ,1PE9.2,'+/-',E7.1)                                00001370
340   IF (Y(I,IS+1).NE.-1.0) PRINT 341,Y(I,IS+1),YDEL(I,IS+1)           00001380
341   FORMAT(1H+,T44 ,1PE9.2,'+/-',E7.1)                                00001390
350   IF (Y(I,IS).NE.-1.0) PRINT 351,Y(I,IS),YDEL(I,IS)                 00001400
351   FORMAT(1H+,T22 ,1PE9.2,'+/-',E7.1)                                00001410
      GOTO 490                                                          00001420
C                                                                       00001430
400   IF (Y(I,IS+5).NE.-1.0) PRINT 409,Y(I,IS+5),YDEL(I,IS+5)           00001440
409   FORMAT(1H+,T114,1PE9.2,'+/-',E7.1)                                00001450
      IF (Y(I,IS+4).NE.-1.0) PRINT 411,Y(I,IS+4),YDEL(I,IS+4)           00001460
411   FORMAT(1H+,T95 ,1PE9.2,'+/-',E7.1)                                00001470
      IF (Y(I,IS+3).NE.-1.0) PRINT 421,Y(I,IS+3),YDEL(I,IS+3)           00001480
421   FORMAT(1H+,T76 ,1PE9.2,'+/-',E7.1)                                00001490
      IF (Y(I,IS+2).NE.-1.0) PRINT 431,Y(I,IS+2),YDEL(I,IS+2)           00001500
431   FORMAT(1H+,T57 ,1PE9.2,'+/-',E7.1)                                00001510
      IF (Y(I,IS+1).NE.-1.0) PRINT 441,Y(I,IS+1),YDEL(I,IS+1)           00001520
441   FORMAT(1H+,T38 ,1PE9.2,'+/-',E7.1)                                00001530
      IF (Y(I,IS).NE.-1.0) PRINT 451,Y(I,IS),YDEL(I,IS)                 00001540
451   FORMAT(1H+,T19 ,1PE9.2,'+/-',E7.1)                                00001550
CP        OD                                                            00001560
490     CONTINUE                                                        00001570
      IF (.NOT.QMORE) GOTO 500                                          00001580
CP        PRINT HEADER LABEL                                            00001590
      IF (Q6EV) WRITE(6,2001)(I,JCHAR(I),I=IS,IFF)                      00001600
      IF (.NOT.Q6EV) WRITE(6,2000)(I,JCHAR(I),I=IS,IFF)                 00001610
      I1 = I2 + 1                                                       00001620
      I2 = I1 + LINENO - 1                                              00001630
      IF (IPTS.GT.I2) GOTO 300                                          00001640
      I2 = IPTS                                                         00001650
      QMORE = .FALSE.                                                   00001660
CP     OD                                                               00001670
      GOTO 300                                                          00001680
C                                                                       00001690
C    END OF THIST PRINTOUT LOOP                                         00001700
500   CONTINUE                                                          00001710
      GO TO 700                                                         00001720
CP  ELSE                                                                00001730
C   PRINT SPECTRAL DATA                                                 00001740
600   CONTINUE                                                          00001750
      IIYR1 = IYR1 - 1900                                               00001760
      IIYR2 = IYR2 - 1900                                               00001770
      CALL UNPACK(IYR1,ISTART,IMO1,ID1,IH1,IM1,IS1)                     00001780
      CALL UNPACK(IYR2,ISTOP ,IMO2,ID2,IH2,IM2,IS2)                     00001790
CP     PRINT TIMES                                                      00001800
      PRINT 610,ID1,MONAT(IMO1),IIYR1,IH1,IM1,IS1,ID2,MONAT(IMO2),      00001810
     *          IIYR2,IH2,IM2,IS2                                       00001820
610   FORMAT(1H0,6X,'SPECTRAL DATA FOR ',I2,1X,A3,2I3,':',I2,':',I2,    00001830
     *' TO ',I2,1X,A3,2I3,':',I2,':',I2/)                               00001840
      PRINT 611                                                         00001850
611   FORMAT(1H ,16X,'PLOT',4X,'AVERAGE'/16X,'SYMBOL   ENERGY',         00001860
     *4X,'PARTICLE',4X,'FLUX',9X,'ERROR')                               00001870
CP     DO FOR EACH BIN REQUESTED                                        00001880
      DO 620 J=1,NUMBIN                                                 00001890
        AVENER = (EUPBN(J) + ELOBN(J))/2.0                              00001900
CP        PRINT FLUX, ERROR, AND ASSOCIATED DATA                        00001910
        PRINT 615, J,JCHAR(J),AVENER,DPART(JPRTBN(J)),S(J),SDEL(J)      00001920
615     FORMAT(1H0,9X,I5,3X,A1,F11.2,5X,A8,3X,1PE10.3,' +/- ',E10.2)    00001930
CP     OD                                                               00001940
620     CONTINUE                                                        00001950
      PRINT 630                                                         00001960
630   FORMAT(1H1)                                                       00001970
CP  FI                                                                  00001980
700   RETURN                                                            00001990
      END                                                               00002000
