CH1   SUBROUTINE FLXPCL(QFIRST,QMORE)                                   00000010
CH                                                                      00000020
CH2  FUNCTIONAL DESCRIPTION:                                            00000030
CH2   CALCULATES TIME BOUNDARIES OF PLOT FRAME INTERVALS.               00000040
CH                                                                      00000050
CH3  CALLING ROUTINES:  FLXPMN                                          00000060
CH                                                                      00000070
CH4  SUBROUTINES CALLED:  UNPACK, PACK, IDIFF, IFIXIT.                  00000080
CH                                                                      00000090
CH5  VARIABLE CROSS REFERENCE:                                          00000100
CH5    NAME         TYPE   I/O        DESCRIPTION                       00000110
CH5  QFIRST          L*1    I    FLAG FOR FIRST TIME THRU               00000120
CH5  QMORE           L*1    O    FLAG FOR MORE TIME TO PROCESS          00000130
CH5  IBEGIN,IYEAR1   I*4    I    REQUESTED START TIME                   00000140
CH5  IEND,IYEAR2     I*4    I    REQUESTED STOP TIME                    00000150
CH5  ISTART,IYR1     I*4    O    FRAME START TIME                       00000160
CH5  ISTOP,IYR2      I*4    O    FRAME STOP TIME                        00000170
CH5  NORM2           I*4    O    ISTOP, WITH RESPECT TO IYR1            00000180
CH5  QTHIST          L*1    I    T=TIME HIST; F=SPECTRAL                00000190
CH5  JKEY            I*4    I    INPUT KEY                              00000200
CH5                                                                     00000210
CH                                                                      00000220
CH6  METHOD:                                                            00000230
CH6   CALCULATES SUCCESSIVE PLOT INTERVALS FOR IMP FLUX PLOT PROGRAM.   00000240
CH6   OUTPUTS ISTART,IYR1,ISTOP,IYR2,NORM2.  ALIGNS ISTART TO BOUNDARY. 00000250
CH                                                                      00000260
CH7  PROGRAMMER:  J. CHILDS, 7/77.                                      00000270
CH                                                                      00000280
CH8                 P. SCHUSTER, 5/21/80, SDEL AND YDEL INITIALIZED     00000290
CH8                             TO -1.0 INSTEAD OF 0.0                  00000300
CH                                                                      00000310
CH8  MODIFICATION: P. SCHUSTER, 10/86  IMPLEMENT R. MCGUIRE             00000320
CH8                REQUESTED CHANGES; COMMON REDIMENSIONING, LOOP       00000330
CH8                INDEX = ONLY CHANGES                                 00000340
CH                                                                      00000350
CH9  IMP-6/7/8, FLUX PLOT, FLXPCL, V2.                                  00000360
CH**********************************************************************00000370
C                                                                       00000380
      SUBROUTINE FLXPCL(QFIRST,QMORE)                                   00000390
C                                                                       00000400
      IMPLICIT LOGICAL*1(Q)                                             00000410
C*******   CHANGE MINENG,MAXENG,MINFLX,MAXFLX, TO BE DIMENSIONED        00000420
C          TO 50 (FRAMES)                                               00000430
      COMMON /FRAME / ISTART,IYR1,ISTOP,IYR2,NORM2,MINENG(50),          00000440
     *                MAXENG(50),MINFLX(50),MAXFLX(50),                 00000450
     *                JRANGE,JRANUN,JAVER,NOAVU,IAVU,IFRMAX,QLINEX      00000460
C                                                                       00000470
      COMMON /LIMITS/ IBEGIN,IYEAR1,IEND,IYEAR2,JBEGIP(3),JYEAP1(3)     00000480
      COMMON /PERIGE/ XPERIG,JUP,IUP(100),JDN,IDN(100),QFILTR,QPER(250) 00000490
C*******  LOOP INDEX BECOMES  VARIABLE FROM NEW COMMON BLOCK LOOPS      00000500
      COMMON/LOOPS/ICOUNT(50),I144,I25,I50,I6,IFR80                     00000510
C*******   S, SDEL 25 ->100 ; Y , YDEL 6 ->100                          00000520
      COMMON /POINTS/ S(100),SDEL(100),Y(250,100),YDEL(250,100),        00000530
     *                ITIME(250),IPTS,JKEY,QTHIST                       00000540
      COMMON /SATLIT/ QSAT(3),QDAT(3)                                   00000550
      COMMON /TREND / TCFACT,QTC,QDEBUG                                 00000560
      LOGICAL*1 QDUMMY/.TRUE./                                          00000570
      INTEGER IDUMMY/0/                                                 00000580
      INTEGER IBEGP(4)/0,864000,36000,36000/                            00000590
C                                                                       00000600
CP  IF (NON-PERIODIC SPECTRAL PLOT)                                     00000610
      IF (QTHIST.OR.JKEY.EQ.2) GOTO 4                                   00000620
C                                                                       00000630
CP     SET FRAME TIMES TO REQUESTED TIMES                               00000640
      ISTART = IBEGIN                                                   00000650
      IYR1 = IYEAR1                                                     00000660
      ISTOP = IEND                                                      00000670
      IYR2 = IYEAR2                                                     00000680
      NORM2 = ISTOP                                                     00000690
      IF (IYR1.NE.IYR2) NORM2 = ISTART + IDIFF(ISTOP,IYR2,ISTART,IYR1)  00000700
CP     JUMP TO 200                                                      00000710
      GOTO 200                                                          00000720
CP  FI                                                                  00000730
CP  IF (FIRST TIME)                                                     00000740
  4   IF (.NOT.QFIRST) GOTO 100                                         00000750
C                                                                       00000760
C   FIRST TIME THROUGH.                                                 00000770
CP     SET START TIME TO EARLIEST DATA TIME                             00000780
C   SET IBEGIP,IYEAP1 EQUAL TO EARLIEST STARTING DATA TIME.             00000790
      IYEAP1 = 2000                                                     00000800
      DO 10 I=1,3                                                       00000810
        IF (.NOT.QDAT(I)) GOTO 10                                       00000820
        IF (IYEAP1.EQ.2000) GOTO 5                                      00000830
        IF (IDIFF(JBEGIP(I),JYEAP1(I),IBEGIP,IYEAP1).GE.0) GOTO 10      00000840
   5    IYEAP1 = JYEAP1(I)                                              00000850
        IBEGIP = JBEGIP(I)                                              00000860
 10     CONTINUE                                                        00000870
CP     IF (NOT MONTHLY PLOTS)                                           00000880
      IF (JRANUN.EQ.1) GOTO 50                                          00000890
C                                                                       00000900
CP        IF (TIME HISTORY OR PERIODIC SPECTRAL)                        00000910
      IF (.NOT.QTHIST.AND.JKEY.NE.2) GOTO 20                            00000920
CP           ALIGN START TIME TO FRAME BOUNDARY                         00000930
      ISTART = (IBEGIP/IBEGP(JRANUN))*IBEGP(JRANUN)                     00000940
      IYR1 = IYEAP1                                                     00000950
CP           SET FRAME STOP BOUNDARY                                    00000960
      NORM2 = ISTART + JRANGE                                           00000970
      ISTOP = NORM2                                                     00000980
      IYR2 = IYR1                                                       00000990
      IF (ISTOP.GE.315360000) CALL IFIXIT(ISTOP,IDAY,IYR2)              00001000
      IF(.NOT.QDEBUG) GO TO 6005                                        00001010
           PRINT 6000,IYEAP1,IBEGIP,JRANUM,IYR1,ISTART,ISTOP,JRANGE     00001020
 6000      FORMAT(1H ,'FLXPCL 1ST ENTRY ',I5,5X,I15,5X,I5,2X,I5,5X,2I15,00001030
     X  5X,I15)                                                         00001040
 6005     CONTINUE                                                      00001050
CP           JUMP TO 200                                                00001060
      GOTO 200                                                          00001070
CP        ELSE                                                          00001080
C   SPECTRAL PLOTS WITH NO PERIODIC ACCUMULATION --                     00001090
CP           START TIME = FIRST DATA TIME FOUND                         00001100
 20   ISTART = IBEGIP                                                   00001110
      IYR1 = IYEAP1                                                     00001120
CP           STOP TIME = REQUESTED END TIME                             00001130
      ISTOP = IEND                                                      00001140
      IYR2 = IYEAR2                                                     00001150
      NORM2 = ISTOP                                                     00001160
      IF (IYR1.NE.IYR2) NORM2 = ISTART + IDIFF(ISTOP,IYR2,ISTART,IYR1)  00001170
CP           JUMP TO 200                                                00001180
      GOTO 200                                                          00001190
CP        FI                                                            00001200
C                                                                       00001210
CP     ELSE                                                             00001220
C   CASE OF MONTHLY PLOT RANGES.                                        00001230
CP        ALIGN START TIME TO START OF MONTH                            00001240
 50   CALL UNPACK(IYEAP1,IBEGIP,JMONT1,IDAYM,IHR,IMIN,ISEC)             00001250
      CALL PACK(IYEAP1,ISTART,JMONT1,1,0,0,0,QDUMMY)                    00001260
      IYR1 = IYEAP1                                                     00001270
CP        SET FRAME STOP TIME                                           00001280
      JMONT2 = JMONT1 + JRANGE                                          00001290
      IYR2 = IYR1                                                       00001300
      IF (JMONT2.LE.12) GOTO 60                                         00001310
      JMONT2 = JMONT2 - 12                                              00001320
      IYR2 = IYR2 + 1                                                   00001330
 60   CALL PACK(IYR2,ISTOP,JMONT2,1,0,0,0,QDUMMY)                       00001340
      NORM2 = ISTART + IDIFF(ISTOP,IYR2,ISTART,IYR1)                    00001350
CP        JUMP TO 200                                                   00001360
      GOTO 200                                                          00001370
C                                                                       00001380
CP  ELSE                                                                00001390
C IF NOT THE FIRST CALL OF A PLOT SET, PROCEED HERE.                    00001400
CP     IF (NO MORE DATA)                                                00001410
100   IF (QDAT(1).OR.QDAT(2).OR.QDAT(3)) GOTO 110                       00001420
CP        SET QMORE = FALSE                                             00001430
      QMORE = .FALSE.                                                   00001440
CP        RETURN                                                        00001450
CP     FI                                                               00001460
      GOTO 250                                                          00001470
110   CONTINUE                                                          00001480
CP     IF (NOT MONTHLY PLOTS)                                           00001490
      IF (JRANUN.EQ.1) GOTO 150                                         00001500
CP        RESET START TO PREVIOUS STOP                                  00001510
      ISTART = ISTOP                                                    00001520
      IYR1 = IYR2                                                       00001530
      NORM2 = ISTART + JRANGE                                           00001540
CP        SET NEW STOP                                                  00001550
      ISTOP = NORM2                                                     00001560
      IF (ISTOP.GE.315360000) CALL IFIXIT(ISTOP,IDUMMY,IYR2)            00001570
      IF(.NOT.QDEBUG) GO TO 6020                                        00001580
        PRINT 6010,IYR1,ISTART,IYR2,ISTOP                               00001590
        PRINT 6011,IYR1,ISTART,IYR2,ISTOP                               00001600
 6010   FORMAT(1H ,'FLXPCL  QFIRST=FALSE #1 ',2(I5,5X,I15))             00001610
 6011   FORMAT(1H ,'FLXPCL  QFIRST=FALSE #2 ',2(I5,5X,I15))             00001620
 6020   CONTINUE                                                        00001630
CP        JUMP TO 200                                                   00001640
      GOTO 200                                                          00001650
C                                                                       00001660
CP     ELSE                                                             00001670
CP        RESET START TO PREVIOUS STOP                                  00001680
150   JMONT1 = JMONT2                                                   00001690
      IYR1 = IYR2                                                       00001700
      ISTART = ISTOP                                                    00001710
CP        SET NEW STOP                                                  00001720
      JMONT2 = JMONT1 + JRANGE                                          00001730
      IYR2 = IYR1                                                       00001740
C   CALCULATE NORM2 HERE!!!!!!                                          00001750
      IF (JMONT2.LE.12) GOTO 160                                        00001760
      JMONT2 = JMONT2 - 12                                              00001770
      IYR2 = IYR2 + 1                                                   00001780
160   CALL PACK(IYR2,ISTOP,JMONT2,1,0,0,0,QDUMMY)                       00001790
      NORM2 = ISTART + IDIFF(ISTOP,IYR2,ISTART,IYR1)                    00001800
CP        JUMP TO 200                                                   00001810
CP     FI                                                               00001820
CP  FI                                                                  00001830
CP 200 QMORE = TRUE                                                     00001840
C                                                                       00001850
200   QMORE = .TRUE.                                                    00001860
CP  IF (START TIME LATER THAN REQUESTED STOP TIME)                      00001870
CP     QMORE = FALSE                                                    00001880
CP  FI                                                                  00001890
      IF (IDIFF(ISTART,IYR1,IEND,IYEAR2).GE.0) QMORE = .FALSE.          00001900
CP  INITIALIZE PLOT ARRAYS                                              00001910
C   INITIALIZE ALL DATA                                                 00001920
      DO 210 I=1,250                                                    00001930
        ITIME(I) = 0                                                    00001940
          QPER(I) = .FALSE.                                             00001950
        DO 210 J=1,I6                                                   00001960
          Y(I,J) = -1.0                                                 00001970
210       YDEL(I,J) = -1.0                                              00001980
      IPTS = 0                                                          00001990
CP  IF (SPECTRAL PLOTS REQUESTED)                                       00002000
CP     INITIALIZE ACCUMULATORS FOR SPECTRAL PLOTS                       00002010
      IF (QTHIST) GOTO 215                                              00002020
C   INITIALIZE FOR SPECTRAL PLOTS.                                      00002030
        IPTS = 1                                                        00002040
      DO 212 I=1,I25                                                    00002050
        S(I) = -1.0                                                     00002060
212     SDEL(I) = -1.0                                                  00002070
        GOTO 250                                                        00002080
CP  ELSE                                                                00002090
CP     SET UP TIME HISTORY TIME ARRAY                                   00002100
C   SET UP DATA TIMES FOR TIME HISTORY.                                 00002110
215   IPTS = (NORM2 - ISTART)/JAVER                                     00002120
      PRINT 216, IPTS, NORM2, ISTART                                    00002121
216   FORMAT(1H ,'FLXPCL  ** IPTS,NORM2,ISTART = ',I5,3X,2I20)          00002122
      IF (IDIFF(ISTOP,IYR2,IEND,IYEAR2).GT.0)                           00002130
     *              IPTS = IDIFF(IEND,IYEAR2,ISTART,IYR1)/JAVER         00002140
      ITIME(1) = ISTART + JAVER/2                                       00002150
      DO 220 I=2,IPTS                                                   00002160
220     ITIME(I) = ITIME(I-1) + JAVER                                   00002170
CP     INITIALIZE PERIGEE PLOT MARKERS                                  00002180
C   INITIALIZE PERIGE PLOT MARKERS.                                     00002190
      JUP = 0                                                           00002200
      JDN = 0                                                           00002210
      DO 230 I=1,100                                                    00002220
        IUP(I) = 0                                                      00002230
230     IDN(I) = 0                                                      00002240
CP  FI                                                                  00002250
250   RETURN                                                            00002260
      END                                                               00002270
