CH1   SUBROUTINE FLXPBL (BLOCK DATA SUBROUTINE)                         00000010
CH                                                                      00000020
CH2  FUNCTIONAL DESCRIPTION:                                            00000030
CH2    BLOCK DATA SUBROUTINE FOR IMP FLUX PLOT PROGRAM.                 00000040
CH                                                                      00000050
CH3  CALLING ROUTINES:  TO BE LINKED WITH FLXPMN                        00000060
CH                                                                      00000070
CH4  SUBROUTINES CALLED:  NONE                                          00000080
CH                                                                      00000090
CH5  VARIABLE CROSS REFERENCE:                                          00000100
CH5     ALL VARIABLES ARE DEFINED AS BELOW.                             00000110
CH                                                                      00000120
CH6  METHOD:                                                            00000130
CH6  FOR EACH OF THE POTENTIAL 500 BOXES OF THE THREE IMP SATELLITES,   00000140
CH6  HERE ARE DEFINED THE GEOMETRY FACTORS (GEOM), THE ENERGY           00000150
CH6  RANGES (ELO AND EUP), THE PARTICLE TYPE (IPART), AND THE EVENT     00000160
CH6  ASSOCIATED WITH THE BOX (KEVENT).                                  00000170
CH6    GEOM IS IN CM**2 * STR                                           00000180
CH6    ENERGIES IN MEV/NUCLEON                                          00000190
CH6    IPART IS INDEX INTO DPART LABEL ARRAY (500 BINS BY 3 IMPS).      00000200
CH6    EVENT FOR IMP-6 AND -7:                                          00000210
CH6           1 = A.-B.-C              5 = D.E.F.G                      00000220
CH6           2 = (A+B)1.-B.-C         6 = D.E.-F.-G                    00000230
CH6           3 = A.B.-C               7 = D.E.F.-G                     00000240
CH6           4 = (A+B)1.B.-C          8 = (D+E)2.E.-F.-G               00000250
CH6  SINGLES RATES ADDED 10/86  FOR IMP-7 ONLY                          00000260
CH6     9 = A                                                           00000270
CH6    10 = B                                                           00000280
CH6    11 = C                                                           00000290
CH6    12 = D                                                           00000300
CH6    13 = E                                                           00000310
CH6    14 = F                                                           00000320
CH6    15 = G                                                           00000330
CH6    EVENT FOR IMP-8:                                                 00000340
CH6           1 = A.-B.-C              7 = D.E.F                        00000350
CH6           2 = (A+B)1.-B.-C         8 = D.E.-F.-G                    00000360
CH6           3 = (A+B)2.-B.-C         9 = D.E.F.-G                     00000370
CH6           4 = A.B.-C              10 = (D+E)1.-F.-G                 00000380
CH6           5 = (A+B)1.B.-C         11 = (D+E)2.-F.-G                 00000390
CH6           6 = (A+B)2.B.-C                                           00000400
CH6  SINGLES RATES ADDED 10/86                                          00000410
CH6    12 = A                                                           00000420
CH6    13 = B                                                           00000430
CH6    14 = C                                                           00000440
CH6    15 = D                                                           00000450
CH6    16 = E                                                           00000460
CH6    17 = F                                                           00000470
CH6    18 = G                                                           00000480
CH6  THIS VERSION WAS GENERATED ON 8 JUNE 76.  ALL IMP-6 VALUES         00000490
CH6  LOOK OK FOR ALPHAS, BUT THE PROTON ENERGIES ARE PROBABLY OFF       00000500
CH6  SINCE THEY GENERATE A BAD SPECTRA FOR QUIET TIME PENETRATING       00000510
CH6  PROTONS.   THE IMP-7 AND IMP-8 VALUES ARE PRECISELY THE IMP-6      00000520
CH6  VALUES --- THEY HAVE BEEN CARRIED OVER DIRECTLY AND WILL PROBABLY  00000530
CH6  REQUIRE MODIFICATIONS.                                             00000540
CH                                                                      00000550
CH7  PROGRAMMER:  J. CHILDS, 8/76.                                      00000560
CH                                                                      00000570
CH8  MODIFICATIONS:                                                     00000580
CH8   J. CHILDS, 7/77 -- NEW ENERGY DEFINITIONS FOR IMP-7 AND IMP-8     00000590
CH8                      BOXES 1 THRU 19.                               00000600
CH8   J. CHILDS, 9/77 -- NEW ENERGIES, PARTICLE NUMBERS, AND EVENT      00000610
CH8                      NUMBERS FOR IMP-7 AND IMP-8 BOXES 20-28 AND    00000620
CH8                      111-120.  ALSO CHANGES IN IMP-6 GEOMETRIES.    00000630
CH8   J. CHILDS,11/77 -- COMMON /MISC/ INTRODUCED, WHEREIN ARE DEFINED  00000640
CH8                      THE ACCUMULATION TIMES FOR EACH SATELLITE      00000650
CH8                      TACCUM, THE ZK AND HLGRAT ARRAYS.              00000660
CH8   J. CHILDS, 1/78 -- GEOMS FOR IMP-7/8 BOXES 110-120.               00000670
CH8   J. CHILDS, 4/79 -- CORRECT RATE ACCUMULATION TIMES PUT IN TACCUM  00000680
CH8                      AND HLGRAT INTRODUCED (REPLACES HT2RAT).       00000690
CH8   J. CHILDS, 5/79 -- ENERGIES FOR IMP-7/8 (BOXES 6,12,15,11,16,19). 00000700
CH8   EWR,6/79 -- BOX 132, CORRELATED WITH BOX 78 CHANGED KEVENT,HMP8ST 00000710
CH8  EWR,6/79 -- BOX 67,68 LABEL = PR+ALPHA                             00000720
CH8  P. SCHUSTER 2/2/82 -  CHANGE ENERGY BOUNDARIES AS PER R.           00000730
CH8                        MCGUIRE REQUEST (REEVALUATION OF             00000740
CH8                        RANGE/ENERGY CALIBRATION DATA) FOR THE       00000750
CH8                        FLUX BOXES 1-11 FOR IMP7 AND 8.              00000760
CH8  MODIFICATION:  P. SCHUSTER, 10/86  IMPLEMENT MCGUIRE TASK          00000770
CH8                 ASSIGNMENT CHANGES                                  00000780
CH                                                                      00000790
CH                                                                      00000800
CH                                                                      00000810
CH9  IMP-6/7/8, FLUX PLOT, FLXPBL, V2.                                  00000820
CH**********************************************************************00000830
C                                                                       00000840
      BLOCK DATA                                                        00000850
C                                                                       00000860
      IMPLICIT INTEGER*2(H),LOGICAL*1(Q),REAL*8(D)                      00000870
      DIMENSION EL6(500),EU6(500),EL7(500),EU7(500),EL8(500),EU8(500)   00000880
      CHARACTER*8 CDPART(43)                                                    
      CHARACTER*4 CMONAT(12)                                                    
      EQUIVALENCE (DPART(1),CDPART(1))                                          
      EQUIVALENCE (MONAT(1),CMONAT(1))                                          
      COMMON /GEOMF/  GEOM(500,3),ELO(500,3),EUP(500,3),IPART(500,3),   00000890
     *                KEVENT(500,3),HMP8ST(500)                         00000900
      COMMON /LABELP/ DPART(43)                                         00000910
      COMMON /LOOPS/  ICOUNT(50),I144,I25,I50,I6,IFR80                  00000920
      COMMON /MISC/   TACCUM(18,3),ZK(500,3),HLGRAT(18,3)               00000930
      COMMON /MONTH/  MONAT(12)                                         00000940
      COMMON /TAPE/   INUNIT(3)                                         00000950
      EQUIVALENCE (ELO(1,1),EL6(1)),(ELO(1,2),EL7(1))                   00000960
      EQUIVALENCE (ELO(1,3),EL8(1))                                     00000960
      EQUIVALENCE (EUP(1,1),EU6(1)),(EUP(1,2),EU7(1))                   00000960
      EQUIVALENCE (EUP(1,3),EU8(1))                                     00000960
COLD *            (EUP(1),EU6(1)),(EUP(501),EU7(1)),(EUP(1001),EU8(1))  00000970
C                                                                       00000980
      DATA GEOM/29*.39, 2.56, 3.15, 3.10, 2.98, 2.80, 2.53,2.56 ,       00000990
     *          3.15, 3.10, 2.98, 2.80, 2.53, 8*2.35, 7*4.70,           00001000
     *          3*1.0, 6*2.35, 1.0,3*4.70,2*1.0, 5*4.70, 68*1.0,        00001010
     *          356*1.0,                                                00001020
C                                                                       00001030
     *          29*.39, 2.56, 3.15, 3.10, 2.98, 2.80, 2.53, 2.56,       00001040
     *          3.15, 3.10, 2.98, 2.80, 2.53, 8*2.57, 7*5.14,           00001050
     *          3*1.0, 6*2.57, 1.0, 3*5.14, 2*1.0, 5*5.14, 34*1.0,      00001060
     *          10*.39, 24*1.0,356*1.0,                                 00001070
C                                                                       00001080
     *          29*.39, 3.18, 3.11, 3.03, 2.91, 2.76, 2.52,             00001090
     *          3.18, 3.11, 3.03, 2.91, 2.76, 2.52, 8*2.49, 7*4.98,     00001100
     *          3*1.0, 6*2.49, 1.0, 3*4.98, 2*1.0, 5*4.98, 3.22,        00001110
     *          3.22, 32*1.0, 10*.39, 24*1.0, 356*1.0/                  00001120
C                                                                       00001130
      DATA EL6/0.93, 1.25, 1.57, 2.00, 2.55, 3.32, 1.20, 1.54, 2.00,    00001140
     *         2.55, 3.30, 4.00, 6.02, 8.30, 13.4, 4.00, 6.02, 8.29,    00001150
     *         13.4, 1.56, 2.00, 2.58, 3.28, 6*1.0, 24.0, 29.00,        00001160
     *         35.3, 42.7, 50.7, 63.1, 24.0, 29.0, 35.1, 42.6,          00001170
     *         51.0, 62.7, 82.0, 82.0, 82.0, 82.0, 1.00, 1.00,          00001180
     *         101.0,101.0,117.8,134.5,168.8,198.5,250., 307.,          00001190
     *         381.5,3*1., 82.0, 82.0, 82.0, 82.0, 82.0,82.0,           00001200
     *         1.0, 87.0, 92.5, 107.3, 1.0, 1.0, 121.0, 154.5,          00001210
     *         178.0, 229.5, 327.0, 68*1.0, 356*1.0/                    00001220
C                                                                       00001230
C                                                                       00001240
C    MODIFIED 2/2/82 FOR NEW ENERGIES BOXES 1-11                        00001250
      DATA EL7/0.89, 1.16, 1.44, 1.84, 2.37, 3.13, 1.15, 1.52, 1.91,    00001260
     *         2.41, 3.09, 4.20, 5.98, 8.67, 13.94,4.10, 5.95, 8.76,    00001270
     *         13.71,1.55, 1.93, 2.40, 3.09, 4.03, 5.85,  5.8, 6.1,     00001280
     *         8.8,  1.0, 24.0 , 29.0 ,                                 00001290
     *         35.3, 42.7, 50.7, 63.1, 24.0, 29.0, 35.1, 42.6,          00001300
     *         51.0, 62.7, 82.0, 82.0, 82.0, 82.0, 1.00, 1.00,          00001310
     *         101.0,101.0,117.8,134.5,168.8,198.5,250., 307.,          00001320
     *         381.5,3*1., 82.0, 82.0, 82.0, 82.0,  82.0, 82.0,         00001330
     *         1.0, 87., 92.5, 107.3,                                   00001340
     *         2*1., 121.0,154.5,178., 229.5,327.,   34*1.0,            00001350
     *         8.8,  8.8,  8.8,  11.1, 13.8, 21.9, 11.2, 11.2,11.2,     00001360
     *         13.8, 3.5,6.5,10.,7.5,13., 3.5,6.5,10.,7.5,13., 14*1.0,  00001370
     *         356*1.0/                                                 00001380
C                                                                       00001390
C    MODIFIED 2/2/82 FOR NEW ENERGIES BOXES 1-11                        00001400
      DATA EL8/0.88, 1.15, 1.43, 1.79, 2.27, 3.03, 1.14, 1.36, 1.88,    00001410
     *         2.37, 3.06, 4.10, 5.96, 8.65, 13.6, 3.95, 5.82, 8.75,    00001420
     *         13.78,1.49, 1.92, 2.40, 3.10, 4.02, 5.85, 5.8, 5.9,      00001430
     *         8.8, 1.0, 24.25, 28.74,                                  00001440
     *         35.20, 42.93, 51.03, 63.21,    24.16, 28.64, 35.15,      00001450
     *         42.96, 51.02, 63.27, 81.0, 81.0, 81.0, 81.0, 1.00, 1.00, 00001460
     *         101. ,101. ,117.8,134.5,168.8,198.5,250., 307.,          00001470
     *         381.5,3*1., 81.0, 81.0, 81.0, 81.0, 81.0, 81.0,          00001480
     *         1.0, 87.0, 92.5, 107.3, 2*1.0, 121.0, 154.5, 178.0,      00001490
     *         229.5, 327.0, 19.35, 19.45, 32*1.0,                      00001500
     *         8.6, 8.8, 8.8, 10.7, 13.8, 22.0, 10.6, 10.6, 10.7,       00001510
     *         13.8, 3.6,6.,9.5,7.,12.5, 3.6,6.0,9.5,7.,12.5, 14*1.0,   00001520
     *         356*1.0/                                                 00001530
C                                                                       00001540
      DATA EU6/1.25, 1.57, 2.00, 2.55, 3.32, 3.97, 1.54, 2.00, 2.55,    00001550
     *         3.30, 3.99, 6.02, 8.30, 13.4, 22.7, 6.02, 8.29, 13.4,    00001560
     *         22.7, 2.00, 2.58, 3.28, 4.01, 6*2.0, 29.00, 35.30,       00001570
     *         42.7, 50.7, 63.1, 82.0, 29.0, 35.1, 42.6, 51.0,          00001580
     *         62.7, 82.0,101.0,101.0, 101.0,101.0,2.00, 2.00,          00001590
     *         117.8,117.8,134.5,168.8,198.5,250., 307., 381.5,         00001600
     *         455.5,3*2., 87.0, 87.0, 87.0, 87.0, 87.0, 87.0,          00001610
     *         2.0,  92.5, 107.3,121., 2.0, 2.0, 154.5,178.0, 229.5,    00001620
     *         327.0, 485.0, 68*2.0, 356*2.0/                           00001630
C                                                                       00001640
C    MODIFIED 2/2/82 FOR NEW ENERGIES BOXES 1-11                        00001650
      DATA EU7/1.16, 1.44, 1.84, 2.37, 3.13, 4.20, 1.52, 1.91, 2.41,    00001660
     *         3.09, 4.14, 5.98, 8.67, 13.94,22.80,5.95, 8.76, 13.71,   00001670
     *         22.80, 1.93,  2.40,  3.09,  4.03,  5.85,  8.75,  11.2,   00001680
     *         8.8,  13.8,  2.0,  29.00,  35.30,                        00001690
     *         42.7, 50.7, 63.1, 82.0, 29.0, 35.1, 42.6, 51.0,          00001700
     *         62.7, 82.0,101.0,101.0, 101.0,101.0,2.00, 2.00,          00001710
     *         117.8,117.8,134.5,168.8,198.5,250., 307., 381.5,         00001720
     *         455.5,3*2., 87.0, 87.0,  87.0, 87.0, 87.,  87.,          00001730
     *         2.0, 92.5, 107.3, 121.,                                  00001740
     *         2*2., 154.5,178., 229.5,327., 485.,   34*2.0,            00001750
     *         40.7,  41.0,  11.1, 13.8, 21.9, 40.8, 40.8, 40.9, 40.8,  00001760
     *         40.8, 7.5,10.,15.,13.,19., 7.5,10.,15.,13.,19., 14*2.0,  00001770
     *         356*2.0/                                                 00001780
C                                                                       00001790
C    MODIFIED 2/2/82 FOR NEW ENERGIES BOXES 1-11                        00001800
      DATA EU8/1.15, 1.43, 1.79, 2.27, 3.03, 4.20, 1.36, 1.88, 2.37,    00001810
     *         3.06, 3.98, 5.96, 8.65, 13.60,22.70,5.82, 8.75, 13.78,   00001820
     *         22.70,1.92, 2.40, 3.10, 4.02, 5.85,  8.4,  10.7,         00001830
     *         8.8,  13.2,  2.0,  28.74,                                00001840
     *         35.2, 42.9, 51.0, 63.2, 81.0 , 28.64, 35.15, 42.96,      00001850
     *         51.02, 63.27, 81.0, 101., 101., 101. ,101. ,2.00, 2.00,  00001860
     *         117.8,117.8,134.5,168.8,198.5,250., 307., 381.5,         00001870
     *         455.5,3*2., 87.0, 87.0, 87.0, 87.0, 87.0, 87.0,          00001880
     *         2.0, 92.5, 107.3, 121.0, 2*2.0, 154.5, 178.0,            00001890
     *         229.5, 327.0, 485.0, 24.25, 24.16, 32*2.0,               00001900
     *         40.4,  40.6,  10.7,  13.8, 22.0, 40.8, 40.8, 40.9,       00001910
     *         40.9, 40.9, 7.,9.5,14.5,12.5,18.5, 7.,9.5,14.5,12.5,     00001920
     *         18.5, 14*2.0, 356*2.0/                                   00001930
C                                                                       00001940
      DATA IPART/6*1, 5*2, 4*1, 4*2, 4*4, 6*0, 6*1, 10*2, 2*0, 9*2,     00001950
     *           3*0, 6*1, 0, 3*1, 2*0, 5*1, 57*0, 11*0, 256*0,         00001960
     *           26,27,0,29,30,0,32,33,34,0,36, 7*0, 82*0,              00001970
C                                                                       00001980
     *           6*1, 5*2, 4*1, 4*2, 6*4, 1*12, 2*11, 1*0, 6*1, 10*2,   00001990
     *           2*0, 9*2, 3*0, 6*1, 0, 3*1, 2*0, 5*1, 34*0, 1*5,       00002000
     *           1*6, 4*7, 1*8, 1*9, 1*10, 1*11, 13, 14, 15,            00002010
     *           16, 17, 18, 19, 20, 21, 22,  3*0, 11*0, 256*0,         00002020
     *           26,27,0,29,30,0,32,33,34,0,36,                         00002030
     *           37,38,39,40,41,42,43, 82*0,                            00002040
C                                                                       00002050
     *           6*1, 5*2, 4*1, 4*2, 6*4, 1*12, 2*11, 1*0, 6*1, 10*2,   00002060
     *           2*0, 9*2, 3*0, 6*1, 0, 2*23,1, 2*0, 6*1, 2, 32*0, 5,   00002070
     *           1*6, 4*7, 1*8, 1*9, 1*10, 1*11, 13, 14, 15, 16,        00002080
     *           17, 18, 19, 20, 21, 22, 1, 2, 0, 11*0, 256*0,          00002090
     *           26,27,28,29,30,31,32,33,34,35,36,                      00002100
     *           37,38,39,40,41,42,43, 82*0/                            00002110
C                                                                       00002120
      DATA KEVENT/11*1, 8*3, 4*2, 6*0, 12*6, 4*7, 2*0, 9*7, 3*0,        00002130
     *             6*7, 0, 3*7, 2*0, 5*7, 57*0, 11*0, 256*0,            00002140
     *             1,2,0,3,4,0,5,6,7,0,8, 7*0, 82*0,                    00002150
C                                                                       00002160
     *            11*1, 8*3, 9*2, 1*0, 12*6, 4*7, 2*0, 9*7, 3*0,        00002170
     *             6*7,0,3*7,2*0,5*7,34*0,10*4,10*6,3*0,11*0,256*0,     00002180
     *             1,2,0,3,4,0,5,6,7,0,8,9,10,11,12,13,14,15, 82*0,     00002190
C                                                                       00002200
     *            11*1, 8*4, 9*2, 1*0, 12*8, 4*9, 2*0, 9*9, 3*0, 6*9,   00002210
     *            0, 3*9, 2*0, 5*9, 2*8, 0, 11*3, 8*6, 12*10,           00002220
     *            10*5, 10*8, 0, 10, 0, 11*0, 256*0,                    00002230
     *            1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,         00002240
     *            82*0/                                                 00002250
C                                                                       00002260
C   HMP8ST ARRAY FOR IMP-8 ONLY:  INDEX IS BOX NUMBER;  NON-ZERO ENTRY  00002270
C   IS CORRESPONDING 'ALPHA-ONLY' BOX TO BE ALSO ACCUMULATED.           00002280
      DATA HMP8ST/7*0,87,88,89,90,4*0,95,96,97,98,16*0,                 00002290
     *            105,106,107,108,109,110,36*0,132,66*0, 356*0/         00002300
C                                                                       00002310
C   TABLE OF RATE ACCUMULATION TIMES IN SECONDS:                        00002320
C          EVENT             IMP-6     IMP-7     IMP-8                  00002330
C         A.-B.-C            4.76      10.24     10.24                  00002340
C         (A+B)1.-B.-C       4.76      10.24     10.24                  00002350
C         (A+B)2.-B.-C        *          *        9.20                  00002360
C         A.B.-C             4.76      10.24     10.24                  00002370
C         (A+B)1.B.-C        5.12      10.24     10.24                  00002380
C         (A+B)2.B.-C         *          *        9.20                  00002390
C         D.E.F              5.12      10.24     10.24                  00002400
C         D.E.-F.-G          4.76      10.24     10.24                  00002410
C         D.E.F.-G           4.76      10.24     10.24                  00002420
C         (D+E)1.-F.-G        *          *       10.24                  00002430
C         (D+E)2.-F.-G       4.76      10.24     10.24                  00002440
C            A                *        10.24     10.24                  00002450
C            B                *        10.24     10.24                  00002460
C            C                *        10.24     10.24                  00002470
C            D                *        10.24     10.24                  00002480
C            E                *        10.24     10.24                  00002490
C            F                *        10.24     10.24                  00002500
C            G                *        10.24     10.24                  00002510
C   TACCUM(18,3) -- 18 RATES BY 3 IMPS.                                 00002520
      DATA TACCUM/ 3*4.76, 2*5.12, 3*4.76, 3*0.0, 7*0.0,                00002530
     *             8*10.24,7*10.24,        3*0.0,                       00002540
     *             2*10.24, 9.20, 2*10.24, 9.20, 5*10.24, 7*10.24/      00002550
C                                                                       00002560
C   TABLE OF RATE CORRECTIONS.  EFFECTIVE RATE IS DIFFERENCE OF RATES.  00002570
C       EFFECTIVE RATE        RATE FORMULA                              00002580
C         A.-B.-C           A.-B.-C - (A+B)1.-B.-C                      00002590
C         (A+B)1.-B.-C      NO CHANGE                                   00002600
C       * (A+B)2.-B.-C      (A+B)2.-B.-C  -  (A+B)1.-B.-C               00002610
C         A.B.-C            A.B.-C  -  (A+B)1.B.-C                      00002620
C         (A+B)1.B.-C       NO CHANGE                                   00002630
C       * (A+B)2.B.-C       (A+B)2.B.-C  -  (A+B)1.B.-C                 00002640
C         D.E.F             NO CHANGE                                   00002650
C         D.E.-F.-G         D.E.-F.-G  -  (D+E)2.E.-F.-G                00002660
C         D.E.F.-G          NO CHANGE                                   00002670
C       * (D+E)1.-F.-G      (D+E)1.E.-F.-G  -  (D+E)2.E.-F.-G           00002680
C         (D+E)2.-F.-G      NO CHANGE                                   00002690
C     * DENOTES RATES FOR IMP-8 ONLY.                                   00002700
C   DOUBLE RATE INDEX ARRAY: HLGRAT(18,3)  --  18 RATES BY 3 IMPS.      00002710
      DATA HLGRAT/  2, 0, 4, 0, 0, 8, 0, 0,      0, 0, 0, 7*0,          00002720
     *              2, 0, 4, 0, 0, 8, 0, 0,      0, 0, 0, 7*0,          00002730
     *              2, 0, 2, 5, 0, 5, 0,11, 0,11, 0, 7*0/               00002740
C                                                                       00002750
C   ARRAY OF NUMBER OF BOXES IN SAME MATRIX VERSUS BOX ID               00002760
      DATA ZK/11*11., 8*8., 9*9., 0., 12*12., 4*24., 2*0., 9*24., 3*0., 00002770
     *   6*24., 6*0., 5*24., 3*0., 11*11., 8*8., 12*12., 10*10., 24*0., 00002780
     *   356*0.,                                                        00002830
     *        11*11., 8*8., 9*9., 0., 12*12., 4*24., 2*0., 9*24., 3*0., 00002790
     *   6*24., 6*0., 5*24., 3*0., 11*11., 8*8., 12*12., 10*10., 24*0., 00002800
     *   356*0.,                                                        00002830
     *        11*11., 8*8., 9*9., 0., 12*12., 4*24., 2*0., 9*24., 3*0., 00002810
     *   6*24., 6*0., 5*24., 3*0., 11*11., 8*8., 12*12., 10*10., 24*0., 00002820
     *   356*0./                                                        00002830
C                                                                       00002840
      DATA CMONAT/'JAN ','FEB ','MAR ','APR ','MAY ','JUN ',            00002850
     *           'JUL ','AUG ','SEP ','OCT ','NOV ','DEC '/             00002860
C                                                                       00002870
C   GENERIC BOX LABELS.                                                 00002880
      DATA CDPART/'PROTON  ','ALPHA   ',                                00002890
     *                                 'ELECTRON','CNO     ','CARBON  ',00002890
     *           'NITROGEN','OXYGEN  ','NEON    ','MG      ','SILICON ',00002900
     *           'IRON    ','NESI    ','ELECT-1 ','ELECT-2 ','ELECT-3 ',00002910
     *           'ELECT-4 ','ELECT-5 ','BKGND-1A','BKGND-2A','BKGND-3A',00002920
     *           'BKGND-4A','BKGND-5A','PR+ALPHA','        ','        ',00002930
     *           'A.-B.-C ','AB1.-B-C','AB2.-B-C','A.B.-C  ','AB1.B.-C',00002940
     *           'AB2.B.-C','D.E.F   ','D.E.-F-G','D.E.F.-G','DE1.-F-G',00002950
     *           'DE2.-F-G','A       ','B       ','C       ',           00002960
     *           'D       ','E       ','F       ','G       '/           00002970
C                                                                       00002980
C   FORTRAN UNIT NUMBERS FOR IMP-6, IMP-7, AND IMP-8 INPUT FLUX TAPES.  00002990
      DATA INUNIT/16,17,18/                                             00003000
      DATA ICOUNT/50*0/, I144/500/, I25/100/, I50/50/, I6/100/          00003010
C                                                                       00003020
      END                                                               00003030
