CH1   SUBROUTINE FLXPSS(DELJAY,RJAY,NOREC,IUPPER,IAVLEN,NSTAT,          00000010
CH1  *KIMP,IDAT)                                                        00000020
CH                                                                      00000030
CH2  FUNCTIONAL DESCRIPTION:                                            00000040
CH2   CALCULATES FLUX OVER AVERAGING INTERVALS.                         00000050
CH                                                                      00000060
CH3  CALLING ROUTINES:  FLXPA                                           00000070
CH                                                                      00000080
CH4  SUBROUTINES CALLED:  FLXPAA, FLXPTC, FLXPMT                        00000090
CH                                                                      00000100
CH5  VARIABLE CROSS REFERENCE:                                          00000110
CH5    NAME         TYPE   I/O        DESCRIPTION                       00000120
CH5  DELJAY(144,3)   R*4    I,O   'FLUX' ERROR                          00000130
CH5  HLGRAT(18,3)    I*2     I    DOUBLE RATE ID INDEX                  00000140
CH5  IAVEND          I*4     O    END OF AVERAGING PERIOD, DECISEC      00000150
CH5  IAVLEN          I*4     I    AVERAGING INTERVAL, DECISEC           00000160
CH5  IFLUX(150,3)    I*4     I    FLUX TAPE RECORDS                     00000170
CH5  INUNIT(3)       I*4     I    INPUT FLUX TAPE UNITS                 00000180
CH5  IRECTM          I*4          CURRENT FLUX RECORD TIME, DECISE      00000190
CH5  IUPPER          I*4          AVERAGING PERIOD UPPER TIME           00000200
CH5  IYR1            I*4     I    YEAR AT START OF FRAME                00000210
CH5  JAVER           I*4     I    PLOT POINT SIZE, DECISECONDS          00000220
CH5  JKEY            I*4     I    INPUT KEY PARAMETER                   00000230
CH5  JOLD            I*4     I    PREVIOUS INPUT KEY PARAMETER          00000240
CH5  KEVENT(500,3)   I*4     I    BOX EVENT NUMBER                      00000250
CH5  NSTAT(10,500)   I*4     O    STATISTICS ACCUMULATION ARRAYS        00000260
CH5  QBOX(500,3)     L*1     I    BOX REQUEST FLAG ARRAY                00000270
CH5  QDAT(3)         L*1     I    SATELLITE REQUEST FLAG ARRAY          00000280
CH5  QDEBUG          L*1     I    DEBUG REQUEST FLAG                    00000290
CH5  QFAIL           L*1          TREND CHECK FAIL FLAG                 00000300
CH5  QFILTR          L*1     I    IMP-6 PERIGEE FILTER FLAG             00000310
CH5  QPER(250)       L*1     I    IMP-6 PERIGEE FLAG                    00000320
CH5  QTC             L*1     I    TREND CHECK REQUEST FLAG              00000330
CH5  QTHIST          L*1     I    T=TIME HIST; F=SPECTRAL               00000340
CH5  RJAY(500,3)     R*4     O    'FLUX' FOR AVERAGING PERIOD           00000350
CH5  TACCUM(18,3)    R*4     I    EVENT-TYPE RATE ACCUMULATION TIMES    00000360
CH5  TCFACT          R*4     I    TREND CHECK FACTOR                    00000370
CH5  XPERIG          R*4     I    IMP-6 PERIGEE ALTITUDE, METERS        00000380
CH5  ZMATR(500)      R*4          ACCUMULATOR FOR MATRIX COUNTS         00000390
CH5  ZNOBOX(500)     R*4          ACCUMULATOR FOR BOX COUNTS            00000400
CH5  ZPATCT(500)     R*4          ACCUMULATOR FOR LOW GAIN RATE COUNTS  00000410
CH5  ZPATED(500)     R*4          ACCUMULATOR FOR LOW GAIN RATE TIME    00000420
CH5  ZRATCT(500)     R*4          ACCUMULATOR FOR RATE COUNTS           00000430
CH5  ZRATED(500)     R*4          ACCUMULATOR FOR RATE TIME             00000440
CH                                                                      00000450
CH6  METHOD:                                                            00000460
CH6   SUBROUTINE FOR IMP FLUX PLOT PROGRAM.   ACCUMULATES FLUX DATA     00000470
CH6   OFF IMP INTERMEDIATE FLUX TAPES.  DATA ACCUMULATED OVER AVERAGING 00000480
CH6   PERIODS.  AVERAGING PERIODS ARE ACCUMULATED OVER PLOT POINTS.     00000490
CH6   AN AVERAGING PERIOD IS LESS OR EQUAL TO THE PLOT POINT INTERVAL.  00000500
CH                                                                      00000510
CH7  PROGRAMMER:  J. CHILDS  AND E. ENG, 2/77.                          00000520
CH                                                                      00000530
CH8  MODIFICATION:  J. CHILDS, 4/79 -- RATES ACCUMULATION TIMES         00000540
CH8                 CORRECTED FOR ALPHA-ONLY RATES.                     00000550
CH8                 J. CHILDS, 5/79 -- ACCUMULATION PROBLEM CORRECTED.  00000560
CH8      P. SCHUSTER, 10/09/79, REJECT DATA RECORDS IF SINGLES RATES    00000570
CH8                   C (LED) OR D1+E (MED) ARE ZERO, IMPLYING OFF      00000580
CH8                   SUPOSSEDLY DONE IN DBG PRODUCTION                 00000590
CH8                   11/86 - IMP-8 LED OFF CRITERIA IS NOW B SINGLES   00000600
CH8     P. SCHUSTER,12/20/79, RELATIVE TO IMP 6 DATABASE YEAR           00000610
CH8                 PROBLEM: ADDED CHECK FOR BAD YEARS, RECORDS         00000620
CH8                 HAVING BAD YEARS ARE BYPASSED, A MESSAGE IS         00000630
CH8                 PRINTED OUT                                         00000640
CH                                                                      00000650
CH8       1/22/80  P. SCHUSTER  ADDITIONAL TIME CHECKING CODE           00000660
CH8                ADDED, TO TRY TO VERIFY CONTINUITY IN DECISECOND     00000670
CH8                RECORD DATA, AS WELL AS IN YEARS                     00000680
CH8                 FLUX DATA BASE SURVEY OF IMP6,7,8 SHOWS             00000690
CH8                 ONLY IMP 6 WITH RECORD TIME PROBLEMS                00000700
CH                                                                      00000710
CH8  MODIFICATION  P. SCHUSTER, 10/86  IMPLEMENT MCGUIRE CHANGES        00000720
CH                                                                      00000730
CH8  MODIFICATION  P. SCHUSTER, 8/87  CHANGE ON/OFF CRITERIA AS PER     00000731
CH8                             MCGUIRE REQUEST (SEE BELOW)             00000732
CH8  VERSION OF 1/29/93 SPECIAL USE, TO ALLOW APPLICATION OF AN                 
CH8                EXCLUDE FLUX CRITERION                                       
CH8  VERSION OF 8/29/94 REWORK METHOD, TO TRY TO FIX UP ERROR BARS              
CH8                AND FLUX PROBLEMS WITH SUBSUMMARY AS ORIGINALLY              
CH8                WRITTEN                                                      
CH                                                                      00000740
CH                                                                      00000750
CH9  IMP-6/7/8, FLUX PLOT, FLXPSS, V2.                                  00000760
CH**********************************************************************00000770
C                                                                       00000780
      SUBROUTINE FLXPSS(DELJAY,RJAY,NOREC,IUPPER,IAVLEN,NSTAT,          00000790
     X KIMP,IDAT)                                                       00000800
C                                                                       00000810
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H)                                00000820
      DIMENSION HFLUX(300,3),RFLUX(150,3)                               00000830
      DIMENSION NSTAT(10,500)                                           00000840
      CHARACTER*4 CFLUX(150,3)
      DIMENSION IRSTOR(7,3)                                             00000850
      INTEGER ILEN(3)                                                           
      INTEGER KCLC
      DATA ILEN /452,520,588/                                           00000850
C     ABOVE IS STORAGE FOR SINGLES RATES A - G FOR DEBUG PRINTOUT       00000860
      DIMENSION IARATE(3),IBRATE(3),ICRATE(3),IDRATE(3),IERATE(3)       00000870
      DIMENSION IFRATE(3),IGRATE(3),IABNC(3),IDEFNG(3),IDENFG(3)        00000871
      REAL*4 DELJAY(500)                                                00000880
      DIMENSION IRDOT(500),RJAY(500),NOREC(500)                         00000890
      DIMENSION ZNOBOX(500),ZMATR(500),ZRATCT(500),ZRATED(500)          00000900
      DIMENSION ZPATED(500),ZPATCT(500)                                 00000910
      DIMENSION WNOBOX(500),WMATR(500),WRATCT(500),WRATED(500)          00000900
      DIMENSION WPATED(500),WPATCT(500)                                 00000910
      DIMENSION KLABEL(3),L1(3),L2(3),L3(3),L4(3)                       00000920
      CHARACTER*4 CKLABL(3)                                                     
      CHARACTER*4 EOF /'$EOF'/  , CHKEOF
      CHARACTER*8 EOV /'$EOF$EOF'/  , CHKEOV
      EQUIVALENCE (KLABEL(1),CKLABL(1))                                         
      DATA CKLABL/'IMP6','IMP7','IMP8'/                                 00000930
      DATA L1/33,39,33/,L2/66,100,106/,L3/105,122,125/,L4/16,19,16/     00000940
C   DATA FOR SINGLES RATES CHECKS                                       00000950
      DATA IARATE/0,37,40/,IBRATE/0,39,42/,IDRATE/0,43,46/              00000960
C           SINGLES  A               B      D                           00000970
      DATA IERATE/0,45,48/, ICRATE/0,41,44/, IABNC/0,25,24/             00000980
C                E                 C              A.B.^C                00000990
      DATA IFRATE/0,47,50/, IGRATE/0,49,52/, IDEFNG/0,33,34/            00000991
C              F               G              D.E.F.^G                  00000992
      DATA IDENFG/0,31,32/                                              00000993
C           D.E.^F.^G                                                   00000994
C*******  25 -> 100   144 -> 500                                        00001000
      COMMON /BINS/   NUMBIN,JBOX(10,100),IMP(100),JFRAME(100),         00001010
     *                JCHAR(100),XNORM(100),JPRTBN(100),ELOBN(100),     00001020
     *                EUPBN(100),QBOX(500,3),QFB(10,100)                00001030
C*******   CHANGE MINENG,MAXENG,MINFLX,MAXFLX, TO BE DIMENSIONED        00001040
C          TO 50 (FRAMES)                                               00001050
      COMMON /FRAME / ISTART,IYR1,ISTOP,IYR2,NORM2,MINENG(50),          00001060
     *                MAXENG(50),MINFLX(50),MAXFLX(50),                 00001070
     *                JRANGE,JRANUN,JAVER,NOAVU,IAVU,IFRMAX,QLINEX      00001080
      COMMON /GAP/    JOLD                                              00001090
C*******     144 -> 500                                                 00001100
      COMMON /GEOMF / GEOM(500,3),ELO(500,3),EUP(500,3),IPART(500,3),   00001110
     *                KEVENT(500,3),HMP8ST(500)                         00001120
      COMMON /MISC/   TACCUM(18,3),ZK(500,3),HLGRAT(18,3)               00001130
      COMMON /PERIGE/ XPERIG,JUP,IUP(100),JDN,IDN(100),QFILTR,QPER(250) 00001140
C*******  LOOP INDEX BECOMES I144 VARIABLE FROM NEW COMMON BLOCK LOOPS  00001150
      COMMON/LOOPS/ICOUNT(50),I144,I25,I50,I6                           00001160
C*******   ICOUNT COUNTS THE NUMBER OF DATA ITEMS FOR EACH SPECIFIED    00001170
C*******   S, SDEL 25 ->100 ; Y , YDEL 6 ->100                          00001180
      COMMON /POINTS/ S(100),SDEL(100),Y(250,100),YDEL(250,100),        00001190
     *                ITIME(250),IPTS,JKEY,QTHIST                       00001200
      COMMON /REKORD/ IFLUX(150,3)                                      00001210
      COMMON /SATLIT/ QSAT(3),QDAT(3)                                   00001220
      COMMON /TAPE  / INUNIT(3)                                         00001230
      COMMON /TREND / TCFACT,QTC,QDEBUG                                 00001240
      COMMON /DECICK/ QTIMCK                                            00001250
      COMMON /EXCLCR/ IXCBOX,EXCVAL,IAVTIM                              00001250
C                                                                       00001260
      EQUIVALENCE (IFLUX(1,1),HFLUX(1,1),RFLUX(1,1),CFLUX(1,1))         00001270
C     VARIABLES FOR TIME CHECKING                                       00001280
      INTEGER QGOOD, QONE, QTWO, QZERO, QSJOB                                   
      DATA QGOOD/0/,QONE/1/,QTWO/2/,QZERO/0/                            00001290
C     FIRST RECORD IN JOB FLAG                                          00001300
      DATA QSJOB/0/, QSTOPA/.FALSE./                                    00001310
C   CHECK ADDED TO PREVENT LOOPING IF I/O ERRORS ON DISK DATA          00001470
      IEOFER=0                                                          00001500
C                                                                       00001480
C   THE VARIABLES QSTOPA AND QSTOPB ARE ARRANGED TO AVOID               00001320
C   DUPLICATE (AND THUS MISLEADING) PRINT OUT MESSAGES                  00001330
C   REGARDING TIME CHECK CODE; THIS CAN OCCUR AT THE END                00001340
C   OF AN AVERAGING PERIOD/PLOT POINT PERIOD DUE TO                     00001350
C   THE NATURE OF THE FLXPLOT PROGRAM DETERMINING WHEN                  00001360
C   IT IS FINISHED FOR THE AVERAGING / PLOT POINT PERIOD .              00001370
C   THIS GENERAL FLXPLOT METHOD INVOLVES ENTRY-REENTRY INTO             00001380
C   FLXPSS  WITHOUT READING ANY NEW DATA INTO THE ARRAY                 00001390
C   IFLUX                                                               00001400
C   EXERCISE CAUTION IN ANY LOGIC MODIFICATIONS REGARDING               00001410
C   TIME AND THE DIFFERENT FLXPLOT OPTIONS                              00001420
C                                                                       00001430
C                                                                       00001440
C   SEE COMMENTS IN FLXTCK REGARDING TIME CHECKING                      00001450
C                                                                       00001460
C  INITIALIZE AT EACH ENTRY FOR TIME CHECKING WITHIN PLOT POINT         00001490
      IBADYR=0                                                          00001500
      NYRCNG=0                                                          00001510
      IBADDC=0                                                          00001520
      IBTWO=0                                                           00001530
      IBTHRE=0                                                          00001540
       QSTOPB=.FALSE.                                                   00001550
C                                                                       00001560
C   INITIALIZE STATISTICS ARRAYS, UNLESS CASE OF SPECTRUM OF MORE THAN  00001570
C   ONE TIME PERIOD, AND SOME DATA ALREADY ACCUMULATED.                 00001580
C                                                                       00001590
CP  IF (NO CURRENT DATA ACCUMULATED)                                    00001600
      IF (JOLD.EQ.1) GOTO 7                                             00001610
CP     ZERO OUT STATISTICS ARRAYS                                       00001620
      DO 5 I=1,10                                                       00001630
         DO 5 J=1,I144                                                  00001640
CP  FI                                                                  00001650
5           NSTAT(I,J) = 0                                              00001660
7     CONTINUE                                                          00001670
C                                                                       00001680
CP  INITIALIZE STOP TIME FOR AVERAGING PERIOD LOOP                      00001690
      IF (QTHIST) IAVEND = IUPPER - JAVER                               00001700
      IF (.NOT.QTHIST) IAVEND = ISTART                                  00001710
C                                                                       00001720
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00001730
C   START OF LOOP OVER PLOT POINT INTERVAL.                             00001740
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00001750
C                                                                       00001760
CP  DO FOR ALL DATA IN PLOT POINT                                       00001770
CP     GET RECORD TIME WITH RESPECT TO IYR1                             00001780
 10   IRECTM = IFLUX(1,KIMP)                                            00001790
      IRECY=HFLUX(3,KIMP)                                               00001800
      IRECD=IFLUX(1,KIMP)                                               00001810
      IF (.NOT.QDEBUG) GO TO 6005                                       00001820
            PRINT 6000,IRECTM,HFLUX(3,KIMP),IUPPER,QDAT(KIMP)           00001830
 6000       FORMAT(1H ,'FLXPSS STMT 6000',I15,5X,I5,5X,I15,5X,L1)       00001840
 6005       CONTINUE                                                    00001850
C                                                                       00001860
C   BEGIN TIME CHECKING CODE SECTION                                    00001870
C                                                                       00001880
      IF(QSJOB.NE.QZERO) GO TO 420                                      00001890
C   FIRST TIME JOB ENTRY FO FLXPSS ASSUMES RECORD IS OK, IT SHOULD      00001900
C   BE BECAUSE FLXPMT STOPS ONLY WHEN IT HAS FOUND YEAR AND DECISECS    00001910
C   AS GOOD                                                             00001920
      QSJOB=QONE                                                        00001930
      QGOOD=QTWO                                                        00001940
      IGYR=HFLUX(3,KIMP)                                                00001950
      IGDECI=IFLUX(1,KIMP)                                              00001960
C  FIRST TIME, BRANCH AROUND COMPARISON SECTION                         00001970
      GO TO 499                                                         00001980
 420  CONTINUE                                                          00001990
      IF(HFLUX(3,KIMP).EQ.IYR1 .AND. IRECTM.GE.IUPPER)QSTOPB=.TRUE.     00002000
      IF(QSTOPB) GO TO 20                                               00002010
C  NEED YEAR CHECK BELOW BECAUSE MAY HAVE 'NEXT YEAR' WITHIN            00002020
C  AVE PERIOD AND IRECTM CHECK AT STMT 20 NEEDS TO USE MODIFIED         00002030
C  RECORD DECISECS TO CORRECTLY COMPARE AT 20                           00002040
C                                                                       00002050
      IF(HFLUX(3,KIMP).EQ.IYR1.AND.QSTOPA) GO TO 20                     00002060
      IBRNCH=3                                                          00002070
      IF(HFLUX(3,KIMP).EQ.IYR1)IBRNCH=2                                 00002080
      IF (HFLUX(3,KIMP).EQ.IYR1) GOTO 399                               00002090
C  RECORD TIME DOES NOT EQUAL REQUESTED PLOT POINT START YEAR           00002100
C  IS THE YEAR ONE GREATER?                                             00002110
      IYRF=IYR1+1                                                       00002120
      IF(HFLUX(3,KIMP).EQ.IYRF) IBRNCH=1                                00002130
      IF(HFLUX(3,KIMP) .EQ.IYRF) GO TO 450                              00002140
C  YEAR IS PROBABLY BAD.  DECISECS MAY NOT BE MEANINGFUL  OR MAY BE     00002150
C       A DUPLICATE RECORD: BYPASS THE RECORD, FREAD THE NEXT           00002160
      IBADYR=IBADYR+1                                                   00002170
      QGOOD=QZERO                                                       00002180
      IBYR=HFLUX(3,KIMP)                                                00002190
      IBDECI=IFLUX(1,KIMP)                                              00002200
      PRINT 401, HFLUX(3,KIMP),IFLUX(1,KIMP),IGYR,IGDECI,IYR1,IBADYR    00002210
 401  FORMAT(1H ,'FLXPSS BAD YEAR FOUND- RECORD =',I6,5X,'DECISECS =',  00002220
     X I15,5X,'PREVIOUS GOOD=',I6,2X,I15,/1X,'REQUESTED IYR1 = ',I6,2X, 00002230
     XI10)                                                              00002240
      CALL PDUMP(IFLUX(1,KIMP),150,1,5,0)
      GO TO 210                                                         00002260
 450  CONTINUE                                                          00002270
C  PROBABLE YEAR CHANGE                                                 00002280
        IRECTM = IRECTM + 315360000                                     00002290
        IF (MOD(IYR1,4).EQ.0) IRECTM = IRECTM + 864000                  00002300
C                                                                       00002310
       IF(IRECTM.GE.IUPPER) QSTOPB=.TRUE.                               00002320
       IF(QSTOPB) GO TO 20                                              00002330
       IF(QSTOPA) GO TO 20                                              00002340
C                                                                       00002350
C   THE PREVIOUSLY STORED YEAR AND DECISEC MAY OR MAY NOT BE IN THE     00002360
C   'NEXT' YEAR FOR THIS AVERAGING PERIOD/PLOT POINT                    00002370
C   COUNT THE NUMBER OF ENTRIES TO THIS BRANCH OF CODE                  00002380
C                                                                       00002390
      NYRCNG=NYRCNG+1                                                   00002400
C      IS 'PREVIOUS' ALSO A YEAR CHANGE                                 00002410
C      BRANCH FOR DECISECOND CHECK ACCORDING TO QGOOD                   00002420
 399   CONTINUE                                                         00002430
       IF(KIMP.NE.1) GO TO 499                                          00002440
       IF(.NOT.QTIMCK) GO TO 499                                        00002450
      ICALL=1                                                           00002460
      CALL FLXTCK(IYR1,IRECTM,IBRNCH,ICALL,IBYR,IBDECI,IGYR,            00002470
     X     IGDECI,IRECY,IRECD,IBTWO,IBTHRE,IBADDC,IRET,QSJOB,QGOOD)     00002480
      IF(IRET.EQ.1) GO TO 210                                           00002490
C                                                                       00002500
 499   CONTINUE                                                         00002510
C   END OF TIME CHECK CODE                                              00002520
C                                                                       00002530
C                                                                       00002540
C                                                                       00002550
CP     IF (DATA TIME > POINT STOP TIME OR NO MORE DATA) EXIT            00002560
 20   IF (IRECTM.GE.IUPPER.OR..NOT.QDAT(KIMP)) GOTO 500                 00002570
      IF (JOLD.EQ.1.AND.IAVTIM.EQ.0) GOTO 39                            00002640
C 8/94  INITIALIZE AT START OF PLOT POINT PERIOD                                
C   SKIP THIS IF CASE OF SPECTRUM OF MANY TIME PERIODS,                 00002610
C   SOME DATA ACCUMULATED ALREADY, AND ENTIRE TIME TO BE AVERAGED.      00002620
      DO 38 I=1,I144                                                    00002650
         WRATED(I) = 0.0                                                00002660
         WNOBOX(I) = 0.0                                                00002670
         WMATR(I)  = 0.0                                                00002680
         WRATCT(I) = 0.0                                                00002690
         WPATCT(I) = 0.0                                                00002700
         WPATED(I) = 0.0                                                00002710
38       CONTINUE                                                       00002720
         ICNT2= 0                                                               
C-------------------------------8/94 LOOP FOR AVERAGING  ---------      00002580
C-------------------------------                         ---------      00002580
C     COME BACK TO THIS POINT UNTIL IAVLEN PERIODS EXCEED IUPPER                
C     IUPPER IS THE STOP TIME FOR FLUX ACCUM FOR THIS POINT                     
C     (OR JKEY=2 PERIODIC TIME , OR JKEY=0 AND 1 COMB TIMES                     
39    CONTINUE                                                          00002730
C                                                                       00002580
CP     INITIALIZE BOX ARRAYS FOR ACCUMULATING DATA OVER THE AVERAGE     00002590
CP     INTERVAL.                                                        00002600
C                                                                       00002630
C OLD IF (JOLD.EQ.1.AND.IAVLEN.EQ.0) GOTO 35                            00002640
C 8/94  ASSUME IAVLEN ALWAYS > 0 ; THESE ARRAYS ALWAYS                          
C       ZEROED, AT END OF FLUX CRITERION CHECK = AVERAGING                      
C       PERIOD LOOP                                                             
C       IF THE CRITERION QCRIT = .FALSE. THESE ARRAYS                           
C       ARE ADDED TO THE 'TOTAL TIME FOR PLOT POINT' ARRAYS                     
C                                                                               
C                                                                               
C 8/94 INITIALIZE FOR EACH SUBSUMMARY PERIOD                                    
      DO 30 I=1,I144                                                    00002650
         ZRATED(I) = 0.0                                                00002660
         ZNOBOX(I) = 0.0                                                00002670
         ZMATR(I)  = 0.0                                                00002680
         ZRATCT(I) = 0.0                                                00002690
         ZPATCT(I) = 0.0                                                00002700
         ZPATED(I) = 0.0                                                00002710
30       CONTINUE                                                       00002720
         ICNT = 0                                                               
35    CONTINUE                                                          00002730
CP     SET STOP TIME FOR AVERAGING INTERVAL.                            00002750
C   IF FLUX AVERAGE OVER ALL TIME (IAVLEN .LE. 0) THEN SET IUPPER       00002760
C   AS END ACCUMULATION TIME.                                           00002770
      IF (IAVLEN.EQ.0) IAVEND = IUPPER                                  00002780
C   IF AVERAGING PERIOD < POINT TIME, THEN END ACCUMULATION TIME        00002790
C   IS START PLUS AVERAGING INTERVAL.                                   00002800
      IF (IAVLEN.GT.0) IAVEND = IAVEND + IAVLEN                         00002810
C   IF NEW END TIME BEYOND END POINT TIME, RESET TO END POINT TIME.     00002820
      IF (IAVEND.GT.IUPPER) IAVEND = IUPPER                             00002830
      QSTOPA=.FALSE.                                                    00002840
C                                                                       00002850
C-----------------------------------------------------------------------00002860
C   START OF LOOP OVER AVERAGING PERIOD.                                00002870
C-----------------------------------------------------------------------00002880
C                                                                       00002890
CP     DO FOR ALL DATA IN AVERAGING TIME                                00002900
CP        GET RECORD TIME WITH RESPECT TO IYR1.                         00002910
40    IRECTM = IFLUX(1,KIMP)                                            00002920
      IRECY=HFLUX(3,KIMP)                                               00002930
      IRECD=IFLUX(1,KIMP)                                               00002940
      IF(.NOT.QDEBUG) GO TO 6010                                        00002950
         PRINT 6009,IRECTM,HFLUX(3,KIMP),IAVEND,IUPPER                  00002960
 6009    FORMAT(1H ,'FLXPSS STMT 6009',I15,5X,I5,5X,2I15)               00002970
 6010    CONTINUE                                                       00002980
C   IF FIRST RECORD OF JOB BYPASS TIME COMPARISON                       00002990
         IF(QSJOB.EQ. QONE) GO TO 799                                   00003000
C CHECK FOR END OF AVE PERIOD, AVOID DOUBLE P.O. FROM TIME CHECK        00003010
      IF(HFLUX(3,KIMP).EQ.IYR1.AND.IRECTM.GE.IAVEND)QSTOPA=.TRUE.       00003020
      IF(QSTOPA) GO TO 250                                              00003030
      IBRNCH=3                                                          00003040
      IF(HFLUX(3,KIMP).EQ.IYR1) IBRNCH=2                                00003050
      IF(HFLUX(3,KIMP).EQ.IYR1) GO TO 789                               00003060
C  RECORD TIME DOES NOT EQUAL REQUESTED PLOT POINT START YEAR           00003070
C  IS THE YEAR ONE GREATER?                                             00003080
      IYRF=IYR1+1                                                       00003090
      IF(HFLUX(3,KIMP).EQ.IYRF)IBRNCH=1                                 00003100
      IF(HFLUX(3,KIMP).EQ.IYRF) GO TO 451                               00003110
C  YEAR IS PROBABLY BAD.  DECISECS MAY NOT BE MEANINGFUL  OR MAY BE     00003120
C       A DUPLICATE RECORD: BYPASS THE RECORD, FREAD THE NEXT           00003130
      IBADYR=IBADYR+1                                                   00003140
      QGOOD=QZERO                                                       00003150
      IBYR=HFLUX(3,KIMP)                                                00003160
      IBDECI=IFLUX(1,KIMP)                                              00003170
      PRINT 401, HFLUX(3,KIMP),IFLUX(1,KIMP),IGYR,IGDECI,IYR1,IBADYR    00003180
      CALL PDUMP(IFLUX(1,KIMP),150,1,5,1)                               00002250
      GO TO 210                                                         00003200
 451  CONTINUE                                                          00003210
C  PROBABLE YEAR CHANGE                                                 00003220
        IRECTM = IRECTM + 315360000                                     00003230
        IF (MOD(IYR1,4).EQ.0) IRECTM = IRECTM + 864000                  00003240
      IF(IRECTM.GE.IAVEND)QSTOPA=.TRUE.                                 00003250
      IF(QSTOPA) GO TO 250                                              00003260
C                                                                       00003270
C   THE PREVIOUSLY STORED YEAR AND DECISEC MAY OR MAY NOT BE IN THE     00003280
C   'NEXT' YEAR FOR THIS AVERAGING PERIOD/PLOT POINT                    00003290
C   COUNT THE NUMBER OF ENTRIES TO THIS BRANCH OF CODE                  00003300
C                                                                       00003310
      NYRCNG=NYRCNG+1                                                   00003320
 789   CONTINUE                                                         00003330
       IF(KIMP.NE.1) GO TO 799                                          00003340
       IF(.NOT.QTIMCK) GO TO 799                                        00003350
      ICALL=2                                                           00003360
      CALL FLXTCK(IYR1,IRECTM,IBRNCH,ICALL,IBYR,IBDECI,IGYR,            00003370
     X    IGDECI,IRECY,IRECD,IBTWO,IBTHRE,IBADDC,IRET,QSJOB,QGOOD)      00003380
      IF(IRET.EQ.1) GO TO 210                                           00003390
C                                                                       00003400
 799   CONTINUE                                                         00003410
C   END OF TIME CHECK CODE                                              00003420
C                                                                       00003430
C                                                                       00003440
C                                                                       00003450
C                                                                       00003460
CP        IF (DATA TIME > AVERAGING END TIME) EXIT                      00003470
C   EXIT FROM AVERAGING LOOP IF RECORD TIME OUTSIDE OF AVERAGING PERIOD.00003480
50     IF (IRECTM.GE.IAVEND) GOTO 250                                   00003490
C                                                                       00003500
CP        CHECK FOR CROSSING IMP-6 PERIGEE ALTITUDE                     00003510
      IF (KIMP.NE.1) GOTO 60                                            00003520
      IF (QTHIST) CALL FLXPAA                                           00003530
C   IF SUBPERIGEE AND QFILTR IS ON, SKIP TO NEXT INPUT DATA RECORD      00003540
      IF (.NOT.QFILTR.OR.RFLUX(5,1).GT.XPERIG) GOTO 60                  00003550
         QPER(IDAT) = .TRUE.                                            00003560
         GOTO 210                                                       00003570
C                                                                       00003580
CP        PERFORM TREND CHECK ON RATES IF REQUESTED.                    00003590
C   IF ANY RATE FAILS TREND CHECK, SKIP 5-MINUTE FLUX RECORD.           00003600
60    IF (QTC) CALL FLXPTC(KIMP,TCFACT,QFAIL)                           00003610
      IF (QTC.AND.QFAIL) GOTO 210                                       00003620
C                                                                       00003630
C   ACCUMULATE FLUX CALCULATION PARAMETERS FOR ALL REQUIRED BOXES.      00003640
C     ZNOBOX = COUNTS IN FLUX BOX      ZMATR = COUNTS IN EVENT MATRIX   00003650
C     ZRATED = RATE TIME, SEC.         ZRATCT = RATE COUNTS             00003660
C                                                                       00003670
CP        DO FOR ALL REQUESTED BOXES                                    00003680
C                                                                       00003690
       IF(KIMP.EQ.1) GO TO 99                                           00003700
      IF(.NOT.QDEBUG) GO TO 99                                          00003710
      IRSTOR(1,1)=0                                                     00003720
      CALL FMOVE(IRSTOR(2,1),80,IRSTOR(1,1))                            00003730
  99  CONTINUE                                                          00003740
      DO 100 I=1,I144                                                   00003750
        IF (.NOT.QBOX(I,KIMP)) GOTO 100                                 00003760
        LEVENT = KEVENT(I,KIMP)                                         00003770
        IF (LEVENT .EQ. 0) GO TO 100                                    00003780
C  IF IMP 6  BYPASS THIS SINGLES RATE CHECK                             00003790
      IF(KIMP.EQ.1) GO TO 105                                           00003800
C                                                                       00003810
C   FOR IMP 7 & 8 USE LEVENT TO DETERMINE IF THIS RATE IS LED OR MED.   00003820
C   USE SUM OF A+B+C+(A.B.^C) RATES FOR LED  OR                         00003830
C   SUM OF D+E+F+G+(D.E.F.^G)+(D.E.^F.^G) RATES FOR MED  TO GATE OUT    00003840
C   RECORDS THAT MAY BE 'OFF'                                           00003850
C   FOR IMP 7    LED  EVENT TYPES HAVE LEVENT = 1-4                     00003860
C                MED    "    "     "     "    = 5-8                     00003870
C   FOR IMP 8    LED    "    "     "     "    = 1-6                     00003880
C                MED    "    "     "     "    = 7-11                    00003890
C                                                                       00003900
C   FOR THE USE OF FLUXPLOT(DISPLACEMENT INTO FLUX RECORD), SINGLES     00003910
C      RATES USE EVENT TYPES :                                          00003920
C     FOR IMP-7  9-11  A,B,C                                            00003930
C                12-15   D,E,F,G                                        00003940
C     FOR IMP-8  12-14 A,B,C                                            00003950
C                15-18   D,E,F,G                                        00003960
C     FOR THESE CASES LEVEL WILL BE SET AS 12(IMP-7) OR                 00003970
C                                          15(IMP-8)                    00003980
C   IT IS ASSUMED THAT IF SINGLES RATES ARE REFERENCED, THAT            00003990
C   NO BOX COUNTS OR MATRIX COUNTS WILL BE AVAILABLE TO ACCUMULATE      00004000
C                                                                       00004010
C                                                                       00004020
      IATHIS = IFLUX(IARATE(KIMP),KIMP)                                 00004021
      IBTHIS = IFLUX(IBRATE(KIMP),KIMP)                                 00004025
      ICTHIS = IFLUX(ICRATE(KIMP),KIMP)                                 00004027
      IA1HIS = IFLUX(IABNC(KIMP),KIMP)                                  00004028
      IDTHIS = IFLUX(IDRATE(KIMP),KIMP)                                 00004029
      IETHIS = IFLUX(IERATE(KIMP),KIMP)                                 00004030
      IFTHIS = IFLUX(IFRATE(KIMP),KIMP)                                 00004031
      IGTHIS = IFLUX(IGRATE(KIMP),KIMP)                                 00004032
      IE1HIS = IFLUX(IDEFNG(KIMP),KIMP)                                 00004033
      IE2HIS = IFLUX(IDENFG(KIMP),KIMP)                                 00004034
      IRTHIS=0                                                          00004035
      LEVEL=5                                                           00004050
      IF(KIMP.EQ.3) LEVEL=7                                             00004060
      IF(KIMP .EQ.2 .AND. LEVENT .GT. 8) LEVEL = 12                     00004070
      IF(KIMP .EQ.3 .AND. LEVENT .GT.11) LEVEL = 15                     00004080
      IRTHIS= IATHIS + IBTHIS + ICTHIS + IA1HIS                         00004090
      IF(LEVENT.GE.LEVEL) IRTHIS= IDTHIS + IETHIS + IFTHIS + IGTHIS +   00004110
     X                    IE1HIS + IE2HIS                               00004111
      IF(.NOT.QDEBUG) GO TO 109                                         00004130
       PRINT 108,I,LEVENT,LEVEL,IRTHIS                                  00004140
 108  FORMAT(1H ,'LOOP AT 100',2X,3I5,10X,2I20)                         00004150
 109  CONTINUE                                                          00004160
C  IF LEVENT .GE. LEVEL  THIS IS A MED EVENT                            00004170
C   CHECK SUM OF D AND E RATES                                          00004180
      IF(LEVENT.GE.LEVEL) GO TO 106                                     00004190
C  LED EVENT                                                            00004200
      IF(IRTHIS .GT.0) GO TO 105                                        00004210
      GO TO 100                                                         00004220
 106  IF(IRTHIS .GT. 0) GO TO 105                                       00004230
      GO TO 100                                                         00004240
 105  CONTINUE                                                          00004250
C                                                                       00004260
C  END CHECK FOR SINGLES RATES                                          00004270
CP           ACCUMULATE RATE READ OUT TIMES                             00004280
        ZRATED(I) = ZRATED(I) + HFLUX(L1(KIMP)+LEVENT*4,KIMP)           00004290
     *                                       *TACCUM(LEVENT,KIMP)       00004300
CP           ACCUMULATE RATE COUNTS                                     00004310
        ZRATCT(I) = ZRATCT(I) + IFLUX(L4(KIMP)+LEVENT*2,KIMP)           00004320
CP           ACCUMULATE BOX COUNTS                                      00004330
C      AGAIN, IF SINGLES RATES ARE REFERENCED, NO DATA APPLIES          00004340
            IF(KIMP.EQ.1 .AND. LEVENT .GT. 8) GO TO 98                  00004350
            IF(KIMP.EQ.2 .AND. LEVENT .GT. 8) GO TO 98                  00004360
            IF(KIMP.EQ.3 .AND. LEVENT .GT. 11) GO TO 98                 00004370
C                                                                       00004380
C      FOR ZNOBOX ACCUMULATION, +I IS ADDED TO L2(KIMP) TO OBTAIN       00004390
C      DISPLACEMENT INDEX INTO FLUX RECORD.  FOR BOXES GREATER THAN     00004400
C      144, THIS CALC. IS INVALID. AS OF 4/87 NO PHA BOXES GREATER      00004410
C      THAN 144 EXIST.  IF SUCH DID EXIST, A VIRTUAL BOX CROSS          00004420
C       REFERENCE COULD BE MADE, IE, II=VIRBOX(I), AND                  00004430
C      DISPLACEMENT = L2(KIMP)+II                                       00004440
        ZNOBOX(I) = ZNOBOX(I) + HFLUX(L2(KIMP)+I       ,KIMP)           00004450
CP           ACCUMULATE MATRIX COUNTS                                   00004460
        ZMATR(I)  = ZMATR(I)  + IFLUX(L3(KIMP)+LEVENT  ,KIMP)           00004470
98    CONTINUE                                                          00004480
C                                                                       00004490
C   IF EVENT TYPE REQUIRES RATE DIFFERENCE, ACCUMULATE LOW GAIN RATE.   00004500
C  'MEVENT' IS LOW GAIN RATE FOR EVENT RATE 'LEVENT'.                   00004510
CP           IF (BOX REQUIRES LOW GAIN RATE)                            00004520
        MEVENT = HLGRAT(LEVENT,KIMP)                                    00004530
        IF (MEVENT.EQ.0) GOTO 100                                       00004540
CP              ACCUMULATE LOW GAIN RATE READ OUT TIMES                 00004550
        ZPATED(I) = ZPATED(I) + HFLUX(L1(KIMP)+MEVENT*4,KIMP)           00004560
     *                                       *TACCUM(MEVENT,KIMP)       00004570
CP              ACCUMULATE LOW GAIN RATE COUNTS                         00004580
        ZPATCT(I) = ZPATCT(I) + IFLUX(L4(KIMP)+MEVENT*2,KIMP)           00004590
CP           FI                                                         00004600
CP        OD                                                            00004610
100     CONTINUE                                                        00004620
C                                                                       00004630
C   PRINT OUT RATES IF DEBUG OPTION IS ON                               00004640
C                                                                       00004650
      IF(KIMP.EQ.1) GO TO 101                                           00004660
      IF(.NOT. QDEBUG) GO TO 101                                        00004670
      PRINT 107,KIMP,IRECTM                                             00004680
 107  FORMAT(1H ,'SINGLES RATES FOR IMP',I3,'      TIME(DECISECONDS)=', 00004690
     X I15)                                                             00004700
      ISTRT=IARATE(KIMP)                                                00004710
      ISTP = ISTRT + 12                                                 00004720
      IPLACE=0                                                          00004730
      DO 103 IRATE=ISTRT,ISTP,2                                         00004740
                  IPLACE=IPLACE+1                                       00004750
                 IRSTOR(IPLACE,1) = IFLUX(IRATE,KIMP)                   00004760
                 IRSTOR(IPLACE,2) = HFLUX( (2*IRATE+1),KIMP)            00004770
                 IRSTOR(IPLACE,3) = HFLUX( (2*IRATE+2),KIMP)            00004780
 103  CONTINUE                                                          00004790
      PRINT 104,((IRSTOR(IP1,IP2),IP2=1,3),IP1=1,7)                     00004800
 104  FORMAT(1X ,3(I15,2I10),/1X,3(I15,2I10),/1X,I15,2I10)              00004810
 101  CONTINUE                                                          00004820
C                                                                       00004830
C                                                                       00004840
C                                                                       00004850
C   READ NEXT DATA RECORD.                                              00004860
CP        READ NEXT DATA RECORD                                         00004870
210   CONTINUE                                                          00004880
      CALL FREAD(IFLUX(1,KIMP),INUNIT(KIMP),LEN,*220,*211)              00004880
C                                                                               
      LENF = ILEN(KIMP)                                                         
C                                                                               
C                                                                               
C     CHECK FOR LOGICAL END OF FILE ON  DISK FILE                               
      CALL FMOVE(CHKEOV,8,CFLUX(1,KIMP))
      CALL CNVEBC(CHKEOV,8)
      IEOV   = KCLC(CHKEOV,1,EOV,1,8)
      IF (IEOV .EQ. 0)  GO TO 220
      CALL FMOVE(CHKEOF,4,CFLUX(1,KIMP))
      CALL CNVEBC(CHKEOF,4)
      IEOF   = KCLC(CHKEOF,1,EOF,1,4)
      IF (IEOF .EQ. 0)  GO TO 220
C                                                                       00001160
C                                                                               
C                                                                               
         ICNT = ICNT + 1                                                        
C     SET QSJOB  FOR PART OF TIME CHECK CODE LOGIC                      00004890
         QSJOB=QTWO                                                     00004900
      GOTO 40                                                           00004910
C                                                                       00004920
C   I/O ERROR READING INPUT RECORD.                                     00004930
211   PRINT 212, KLABEL(KIMP)                                           00004940
212   FORMAT(' I/O ERROR ON ',A4,' FLUX TAPE.')                         00004950
      IEOFER = IEOFER + 1
      IF (IEOFER .GT. 20) STOP 777
      GOTO 210                                                          00004960
220   CALL FLXPMT(2,KIMP,QDATA)                                         00004970
C      IF(.NOT.QDEBUG) GO TO 6020                                       00004980
         PRINT 6019,QDATA , IEOV, IEOF                                  00004990
 6019    FORMAT(1H ,'FLXPSS -  FLXPMT JUST CALLED, QDATA= ',L1,2I6)     00005000
 6020    CONTINUE                                                       00005010
      IF (QDATA) GOTO 210                                               00005020
      QDAT(KIMP) = .FALSE.                                              00005030
      GOTO 250                                                          00005040
CP     OD        (END OF DATA AVERAGING INTERVAL LOOP)                  00005050
C-----------------------------------------------------------------------00005060
C   END OF LOOP OVER AVERAGING PERIOD.                                  00005070
C-----------------------------------------------------------------------00005080
C                                                                       00005090
250   CONTINUE                                                          00005100
      IF (.NOT.QDEBUG) GOTO 251                                         00005110
C                                                                       00005120
CP     DEBUG PRINTOUT IF REQUESTED                                      00005130
C   TEST PRINTOUT *********************************************         00005140
      DO 2000 I=1,I144                                                  00005150
         IF (.NOT.QBOX(I,KIMP)) GOTO 2000                               00005160
         PRINT 2001,I,ZRATED(I),ZNOBOX(I),ZMATR(I),ZRATCT(I),           00005170
     *              ZPATCT(I),ZPATED(I)                                 00005180
2001     FORMAT(5X,I3,5X,6E15.8)                                        00005190
2000     CONTINUE                                                       00005200
C   END TEST PRINTOUT *****************************************         00005210
C                                                                       00005220
251   CONTINUE                                                          00005230
C                                                                       00005240
C                                                                       00005290
C 2/1/93 CRITERION CHECKING SEGMENT AND 8/94 MODIFICATIONS                      
C                                                                               
         WRITE(9,88) ICNT,ICNT2,IRECTM,IAVEND,IUPPER                            
88       FORMAT(1H ,'FLXPSS CRICHK CALL ',2I5,2X,3I12)                          
         QCRIT = .FALSE.                                                        
         CALL CRICHK(KIMP,IRECY,IRECD,ZRATCT,ZRATED,ZMATR,ZNOBOX,       00005290
     X               ZPATCT,ZPATED,QCRIT)                                       
C                                                                       00002740
C 8/94   USE 'W' ARRAYS FOR TOTAL TIME ACCUMULATORS                             
      IF (QCRIT)  GOTO 489                                              00002640
      DO 488 I=1,I144                                                   00002650
         WRATED(I) = WRATED(I) + ZRATED(I)                              00002660
         WNOBOX(I) = WNOBOX(I) + ZNOBOX(I)                              00002670
         WMATR(I)  = WMATR(I)  + ZMATR(I)                               00002680
         WRATCT(I) = WRATCT(I) + ZRATCT(I)                              00002690
         WPATCT(I) = WPATCT(I) + ZPATCT(I)                              00002700
         WPATED(I) = WPATED(I) + ZPATED(I)                              00002710
488      CONTINUE                                                       00002720
         ICNT2     = ICNT2 + ICNT                                               
489   CONTINUE                                                          00002730
C     BRANCH BACK TO CRITERION LOOPING SECTION START                    00002740
C                                                                       00006160
C   ADD FOR DISK VSN                                                    00006160
C   FOR EOF,EOV FROM DISK FILES, QDAT(KIMP) = FALSE SHOULD BYPASS
C   IUPPER CHECK NOW BECAUSE NO MORE DATA = DO FLUX CALC SEGMENT        00006160
C   OTHERWISE, THE PROGRAM WANTS TO TREAT THE EOF,EOV TYPE RECORDS      00006160
C   AS FLUX DATA AND FINDS BAD TIMES  AT THE BRANCH TO 39
      IF(.NOT. QDAT(KIMP)) GO TO 588
      IF (IRECTM .LT. IUPPER .AND. IAVTIM .EQ. 0) GO TO 39
588   CONTINUE                                                          00002730
C                                                                       00005290
C   IF CURRENT DATA IS TO BE ADDED TO (JKEY=1) AND AVERAGING IS OVER    00005250
C   ALL REQUESTED TIMES, EXIT ROUTINE FOR NEW TIME PERIOD.              00005260
CP     IF (MORE DATA TO READ FROM INPUT CARDS) EXIT                     00005270
C OLD IF (JKEY.EQ.1.AND.IAVLEN.EQ.0) GOTO 500                           00005280
      IF (JKEY.EQ.1.AND.IAVTIM.EQ.0) GOTO 500                           00005280
C     WHEN JKEY IS 0 BELOW WILL BE EXECUTED,                            00002740
C     IAVTIM = 0 FORCES TOTAL TIME FLUX CALCULATIONS NOW                00002740
C     OR WHEN JKEY IS 2  (WHICH IMPLIES FINISH OF PERIODIC TIME)        00005290
C                                                                       00005290
589   CONTINUE                                                          00002730
C   CALCULATE AVERAGING SUMS                                            00005300
C   RESET BOX ARRAYS TO FINAL COUNTS FROM WORK ARRAYS                   00005310
      DO 366 I=1,I144                                                   00002650
         ZRATED(I) = WRATED(I)                                          00002660
         ZNOBOX(I) = WNOBOX(I)                                          00002670
         ZMATR(I)  = WMATR(I)                                           00002680
         ZRATCT(I) = WRATCT(I)                                          00002690
         ZPATCT(I) = WPATCT(I)                                          00002700
         ZPATED(I) = WPATED(I)                                          00002710
366      CONTINUE                                                       00002720
         ICNT = ICNT2                                                           
367      CONTINUE                                                       00002720
CP     DO FOR EACH BOX REQUESTED                                        00005320
         WRITE(6,368)                                                           
         WRITE(9,368)                                                           
368      FORMAT(1H ,'FLXPSS   FLUX CODE ENTERED ')                      00002720
      DO 270 I=1,I144                                                   00005330
         IF (.NOT.QBOX(I,KIMP)) GOTO 270                                00005340
         LEVENT = KEVENT(I,KIMP)                                        00005350
         IF (LEVENT .EQ. 0) GO TO 270                                   00005360
C                                                                       00005370
CP        IF (ZERO RATE READOUTS)  SKIP THE BOX                         00005380
C                                                                       00005390
C        NSTAT(1,I) = # PERIODS PROCESSED.                              00005400
         NSTAT(1,I) = NSTAT(1,I) + 1                                    00005410
C                                                                       00005420
         IF (ZRATED(I).GT.0.0) GOTO 280                                 00005430
C           NSTAT(2,I) = # PERIODS REJECTED DUE TO ZERO RATE READOUTS   00005440
            NSTAT(2,I) = NSTAT(2,I) + 1                                 00005450
            GOTO 270                                                    00005460
C                                                                       00005470
C  FOR BOXES 401-418:                                                   00005480
C  BOX STORAGE AREAS IN THIS PROGRAM ARE NOW REFERENCED TO              00005490
C  EVENT TYPES AS CODED IN THE MEMBER FLXPBL:COMMON/KEVENT/             00005500
C  ACTUAL BOXES FOR 401-418 ARE NOT DEFINED (THISDATE=10/18/79)         00005510
C  AND IT WAS DESIRED TO HAVE ACCESS TO RATES AS WELL AS FLUXES         00005520
C  IN THE OUTPUT TAPES OF THE FLXPLOT PROGRAM.                          00005530
C  THERE MAY BE OTHER IMPLICATIONS OF THIS CHANGE, AS WOULD BE          00005540
C  REFLECTED IN THE POSITIONS CORRESPONDING TO BOXES 401-418, IN OTHER  00005550
C  OF THE COMMON BLOCKS IN MEMBER FLXPBL.  THIS LIKELYHOOD NEEDS TO     00005560
C  BE THOUGHT THROUGH FOR SURE!                                         00005570
C                                                                       00005580
C  FOLLOWING CODE WAS ADDED:                                            00005590
C                                                                       00005600
C  LOGIC FOR RATE BOXES (ADDED 10/01/79 BY R. MCGUIRE)                  00005610
CP        IF(RATE BOXES 401-418 SELECTED) CALCULATE CTS/SEC AND ERROR   00005620
CP             AND SKIP FLUX CALCULATION.                               00005630
280       IF(I .LE. 400 .OR. I .GT. 418) GO TO 253                      00005640
          RATE = ZRATCT(I)/ZRATED(I)                                    00005650
          ERRATE = 1.0                                                  00005660
          IF(ZRATCT(I).GT.0.) ERRATE = 1./SQRT(ZRATCT(I))               00005670
C  SET UP AND APPLY EXCLUDE CRITERIA  1/29/93 VERSION                           
C        IF (IXCBOX .EQ. 0) GO TO 252                                           
C        IF (I .EQ. IXCBOX) GO TO 252                                           
C        IF (QCRIT) GO TO 269                                                   
252      CONTINUE                                                       00005950
          RJAY(I) = RJAY(I) + RATE                                      00005680
          NOREC(I) = NOREC(I) + 1                                       00005690
          DELJAY(I) = DELJAY(I) + ERRATE*ERRATE*RATE*RATE               00005700
          GO TO 270                                                     00005710
C                                                                       00005720
CP        IF (MATRIX COUNTS = 0 AND RATE COUNTS > 0)  SKIP BOX          00005730
253      IF (ZMATR(I).GT.0.0) GOTO 256                                  00005740
C           NSTAT(3,I) = # PERIODS WITH ZERO MATRIX COUNTS              00005750
            NSTAT(3,I) = NSTAT(3,I) + 1                                 00005760
            IF (ZRATCT(I).GT.0.0) GOTO 270                              00005770
C                                                                       00005780
C        NSTAT(4,I) = # PERIODS WITH ZERO RATE COUNTS                   00005790
256      IF (ZRATCT(I).EQ.0.0) NSTAT(4,I) = NSTAT(4,I) + 1              00005800
C                                                                       00005810
C        NSTAT(5,I) = # PERIODS WITH ZERO BOX COUNTS                    00005820
         IF (ZNOBOX(I).EQ.0.0) NSTAT(5,I) = NSTAT(5,I) + 1              00005830
C                                                                       00005840
CP        CALCULATE RATE AND ERROR IN RATE                              00005850
         RATE = ZRATCT(I)/ZRATED(I)                                     00005860
         ERRATE = 1.0                                                   00005870
         IF (ZRATCT(I).GT.0.0) ERRATE = 1.0/SQRT(ZRATCT(I))             00005880
CP        IF RATE DIFFERENCE REQUIRED, SUBTRACT CORRESP. LOW GAIN RATE. 00005890
         IF (HLGRAT(LEVENT,KIMP).EQ.0.OR.ZPATED(I).EQ.0.0) GOTO 260     00005900
         PRMRAT = ZPATCT(I)/ZPATED(I)                                   00005910
         ERRATE = SQRT(RATE/ZRATED(I) + PRMRAT/ZPATED(I))               00005920
         IF (RATE.GT.PRMRAT) RATE = RATE - PRMRAT                       00005930
         IF (RATE.GT.0.0) ERRATE = ERRATE/RATE                          00005940
260      CONTINUE                                                       00005950
C                                                                       00005960
CP        CALCULATE 'FLUX' RJAY AND 'FLUX ERROR' DELJAY                 00005970
         RIJAY = 0                                                      00005980
         IF (ZMATR(I).GT.0.0) RIJAY = (ZNOBOX(I)/ZMATR(I))*RATE         00005990
C   KEEP THE NEXT ALTERNATIVE?  NO, SAYS R. MCGUIRE, 11/14/77           00006000
C        IF (ZMATR(I).EQ.0.0) RIJAY = (1.0/ZK(I,KIMP))*RATE             00006010
C  SET UP AND APPLY EXCLUDE CRITERIA  1/29/93 VERSION                           
            YNOBOX = AMAX1(ZNOBOX(I),1.0)                               00006050
            YMATR  = AMAX1(ZMATR(I) ,1.0)                               00006060
C        IF (IXCBOX .EQ. 0) GO TO 268                                           
C        IF (I .EQ. IXCBOX) GO TO 268                                           
C        IF (QCRIT) GO TO 269                                                   
268      CONTINUE                                                       00005950
         RJAY(I) = RJAY(I) + RIJAY                                      00006020
         NOREC(I) = NOREC(I) + 1                                        00006030
C                                                                       00006040
            RJJAY  = RIJAY                                              00006070
            IF (RJJAY.EQ.0.0) RJJAY = (1.0/YMATR)*RATE                  00006080
C   ERRORS CALCULATED HERE OVERESTIMATE ERROR BECAUSE SAME EVENTS       00006090
C   MAY CONTRIBUTE TO RATE, MATRIX, AND/OR BOX COUNTS.                  00006100
         DELJAY(I) = DELJAY(I) + (RJJAY*RJJAY)*                         00006110
     *               ((1.0/YNOBOX) + (1.0/YMATR) + ERRATE*ERRATE)       00006120
C                                                                       00006130
CP     OD         (END OF BOX LOOP)                                     00006140
      GO TO 270                                                                 
269   CONTINUE                                                          00006150
      ISKIP = I                                                                 
C     CALL RAWPRT(ISKIP,IRECY,IRECD,EXCVAL,RIJAY,YNOBOX,YMATR,RATE,             
C    X            QCRIT)                                                        
270   CONTINUE                                                          00006150
271   CONTINUE                                                          00006150
C                                                                       00006160
C   GO BACK TO TEST IF CURRENT DATA STILL WITHIN POINT-TIME             00006170
C                                                                       00006160
C   ADD FOR DISK VSN                                                    00006160
C   FOR EOF,EOV FROM DISK FILES, QDAT(KIMP) = FALSE SHOULD EXIT HERE
C    SEE COMMENTS AT LABEL 588 ALSO
      IF(.NOT. QDAT(KIMP)) GO TO 500
      GOTO 10                                                           00006180
CP  OD            (END OF PLOT POINT LOOP)                              00006190
C                                                                       00006200
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00006210
C   END OF LOOP OVER PLOT POINT INTERVAL.                               00006220
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00006230
C                                                                       00006240
500   CONTINUE                                                          00006250
      WRITE(6,501)NYRCNG,IBTWO,IBTHRE                                   00006260
      WRITE(9,501)NYRCNG,IBTWO,IBTHRE                                   00006260
 501   FORMAT(1H ,'FLXPSS EXITING - NYRCNG,IBTWO,IBTHRE= ',3I5)         00006270
      RETURN                                                            00006280
      END                                                               00006290
