CH1   SUBROUTINE FLXPMT(IPATH,L,QDATA)                                  00000010
CH                                                                      00000020
CH2  FUNCTIONAL DESCRIPTION:                                            00000030
CH2   MANAGES MOUNTING AND POSITIONING OF INPUT FLUX TAPES.             00000040
CH                                                                      00000050
CH3  CALLING ROUTINES:  FLXPMN, FLXPSS.                                 00000060
CH                                                                      00000070
CH4  SUBROUTINES CALLED:  CATSUP, IDIFF, DPKTN, UNLOAD, PRNSUP, MOUNT,  00000080
CH4                       FREAD, POSN, UNPACK, IFIXIT                   00000090
CH                                                                      00000100
CH5  VARIABLE CROSS REFERENCE:                                          00000110
CH5    NAME         TYPE   I/O        DESCRIPTION                       00000120
CH5  DTAPE           R*8            INPUT TAPE NAME                     00000130
CH5  DMOUNT(3)       R*8            MOUNTED TAPE LABELS                 00000140
CH5  IBEGIN,IYEAR1   I*4     I      REQUESTED START TIME                00000150
CH5  IBEGIP(3),                                                         00000160
CH5    IYEAP(3)      I*4     O      FOUND START TIME                    00000170
CH5  ICTLG(765,3)    I*4     I      CURRENT TAPE CATALOG RECORDS        00000180
CH5  IDSN(3)         I*4     I      TAPE DATA SET NAMES                 00000190
CH5  IFILNO(3)       I*4     I      CURRENT TAPE FILE NUMBERS           00000200
CH5  IFLUX(150,3)    I*4    I,O     FLUX TAPE RECORDS                   00000210
CH5  ILEN(3)         I*4     I      EXPECTED TAPE RECORD LENGTHS        00000220
CH5  INUNIT(3)       I*4     I      TAPE UNIT NUMBERS                   00000230
CH5  IPATH           I*4     I      CONTROL NUMBER FOR ROUTINE          00000240
CH5  IRECAD(3)       I*4     I      TAPE CATALOG RECORD ADDRESSES       00000250
CH5  IRESEQ(3)       I*4     I      TAPE REEL SEQUENCE NUMBERS          00000260
CH5  JRECNO(3)       I*4     I      TAPE CATALOG RECORD NUMBERS         00000270
CH5  JTIMES          I*4            NUMBER OF ATTEMPTS TO SEEK TAPE     00000280
CH5  KERROR          I*4            NUMBER OF I/O ERRORS TO ACCEPT      00000290
CH5  L               I*4     I      IMP NUMBER (1=6,2=7,3=8)            00000300
CH5  QDATA           I*4    I,O     DATA PRESENCE FLAG                  00000310
CH                                                                      00000320
CH6  METHOD:                                                            00000330
CH6   MOUNTS INPUT TAPES FOR IMP FLUX PLOTTER.  SATELLITE NUMBER L=1,2,300000340
CH6   FOR IMP-6,-7,-8.                                                  00000350
CH6   IPATH = 1 FOR 1ST MOUNT; =2 FOR NEXT REEL/FILE;                   00000360
CH6         =3 FOR POSITION AT BEGINNING OF TAPE.                       00000370
CH6   QDATA IS TRUE IF THERE EXISTS DATA FOR SATELLITE L IN THE PLOT    00000380
CH6     RANGE IBEGIN-IEND.                                              00000390
CH                                                                      00000400
CH7  PROGRAMMER:  J. CHILDS, 2/77.                                      00000410
CH                                                                      00000420
CH8  MODIFICATION:  J. CHILDS, 5/79 -- NO LONGER REWINDS TAPES, BUTS    00000430
CH8                 CHECKS IF EACH NEW REQUESTED TAPE IS AL(EADY        00000440
CH8                 MOUNTED.  EXPECTS TIMES ON INPUT CARDS TO BE        00000450
CH8                 IN ASCENDING ORDER.                                 00000460
CH                                                                      00000470
CH8                P. SCHUSTER 2/80 -- PRINTS OUT FILE CHANGE MESSAGE   00000480
CH                                                                      00000490
CH9  IMP-6/7/8, FLUX PLOT, FLXPMT, V1.                                  00000500
CH**********************************************************************00000510
C                                                                       00000520
      SUBROUTINE FLXPMT(IPATH,L,QDATA)                                  00000530
C                                                                       00000540
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H),REAL*8(D)                      00000550
      COMMON /CTLGP/  JRECNO(3),IRECAD(3),ICTLG(765,3)                  00000560
      COMMON /FERMSG/ IMES(26)                                          00000570
      COMMON /LIMITS/ IBEGIN,IYEAR1,IEND,IYEAR2,IBEGIP(3),IYEAP1(3)     00000580
      COMMON /FRAME / JDUMMY(14),IFRMAX,QDUMMY                          00000590
      COMMON /MONTH/  MONAT(12)                                         00000600
      COMMON /REKORD/ IFLUX(150,3)                                      00000610
      COMMON /TAPE/   INUNIT(3)                                         00000620
      COMMON /TREND / TCFACT,QTC,QDEBUG                                 00000625
      COMMON /FILEMT/ DMOUNT,CFILE,CLOCAT,CNAMEF
      INTEGER KCLC
      CHARACTER*55 CNAMEF(3)
      CHARACTER*30 CLOCAT(3)
      CHARACTER*23 DMOUNT(3),CFILE(3),CNAME,DTAPE                       00000650
      INTEGER IDUMMY/0/,ILEN(3)/452,520,588/                            00000630
      CHARACTER*4 CDSN(3)/'IMPI','IMPH','IMPJ'/                         00000640
      INTEGER IDSN(3)                                                   00000640
      EQUIVALENCE (IDSN(1),CDSN(1))                                             
CPAS  REAL*8 DMOUNT(3)/'        ','        ','        '/                00000650
CPAS  REAL*8 DBLANK/'        '/                                         00000660
      CHARACTER*8 DBLKTP/'        '/                                    00000660
      CHARACTER*8 CDTAPE/'        '/                                    00000660
      REAL*8 DDTAPE                                                             
      CHARACTER*8 EOV /'$EOF$EOF'/  , CHKEOV
      CHARACTER*4 EOF /'$EOF'/      , CHKEOF
      EQUIVALENCE (CDTAPE,DDTAPE)                                               
      CHARACTER*23 DBLANK   /'                      '/                  00000650
      CHARACTER*4 CFLUX(150,3)
      DIMENSION IFILE(3),IFILNO(3),ITAPNO(3),IRSEQN(3),HFLUX(300,3)     00000670
      DIMENSION IFLUX6(113),IFLUX7(130),IFLUX8(147)                             
      EQUIVALENCE (IFLUX(1,1),HFLUX(1,1),CFLUX(1,1))                    00000680
C                                                                       00000690
      IIMP = L + 5                                                      00000700
      GOTO (100,200,300), IPATH                                         00000710
C                                                                       00000720
CP**********************************************************************00000730
CP    FIRST ENTRY - MOUNT TAPE FOR NEW TIME CARD                        00000740
CP**********************************************************************00000750
C                                                                       00000760
100   KERROR = 0                                                        00000770
      JTIMES = 0                                                        00000780
      DMOUNT(L) = DBLANK                                                        
CP  GET START TIME REQUESTED                                            00000790
      IBEGIP(L) = IBEGIN                                                00000800
      IYEAP1(L) = IYEAR1                                                00000810
C                                                                       00000760
C  ***CATSUP - THE NEW CATLOG WITH THE 3 IMP TAPE CATALOGS.             00000820
CP  DO UNTIL TAPE FOUND                                                 00000830
CP     PERFORM CATALOG SEARCH                                           00000840
CP     IF (SOUGHT TAPE IN CATALOG)                                      00000850
105   CONTINUE                                                          00000860
C                                                                               
CPAS  CATSUP REPLACEMENT TAKES START TIME AND CALCULATES                        
CPAS  A REEL SEQUENCE NUMBER, THEN PROVIDES A FILE NAME                         
CPAS  WHICH CAN BE DYNAMICALLY OPENED                                           
CPAS  TENTATIVELY USE A SUBROUTINE WITH HARD CODED FILE                         
CPAS  NAMES- USE REVISED ARGUMENTS AS NEEDED TO RETURN A                        
CPAS  FILE POINTER, OR NAME                                                     
CPAS  CALL CATSUP(L,9,8,IBEGIP(L),IYEAP1(L),*180)                       00000860
C                                                                       00000760
      IERR = 0                                                                  
      CALL FLUXFL(1,L,IBEGIP(L),IYEAP1(L),IREEL,IFILES,IERR,CNAME)      00000860
      IF((IERR+49) .LT. 0) GO TO 180                                            
CPAS  CNAME CONTAINS FILE NAME FOR DATA                                         
      IF (IBEGIP(L).EQ.IBEGIN.AND.IYEAP1(L).EQ.IYEAR1) GOTO 107         00000870
CP        IF (TAPE TIME > END TIME) EXIT TO NO DATA                     00000880
      IF (IDIFF(IEND,IYEAR2,IBEGIP(L),IYEAP1(L)).LE.0) GOTO 570         00000890
C                                                                       00000760
CPAS  IBEGIP(L) = ICTLG(IRECAD(L)+7,L)                                  00000900
CPAS  IYEAP1(L) = ICTLG(IRECAD(L)+6,L)                                  00000910
C   HERE, IBEGIP(L) AND IYEAP1(L) IS TIME OF 1ST AVAILABLE DATA.        00000920
CPAS FREAD CODE WILL FIND FIRST AVAILABLE DATA > = INPUT TIME                   
C                                                                       00000760
107   CONTINUE                                                          00000930
C                                                                               
CPAS  HERE REPLACE THE DPKTN/MOUNT FUNCTION WITH STUBBS
CPAS  ALLOCATION CODE.  WILL NEED TO RETURN THE OLD NUMBER
CPAS  OF FILES WHICH ARE EXPECTED FOR THE COMBINED FILE                         
C ----------------   REPLACE  --------------------------------------            
C ----------------   REPLACE  --------------------------------------            
CPAS  ITAPNO(L) = ICTLG(IRECAD(L),L)                                    00000930
CPAS  DTAPE = DPKTN(ITAPNO(L))                                          00000940
C                                                                       00000760
           DTAPE = CNAME                                                        
           CDTAPE = DBLKTP                                                      
           CDTAPE = CNAME(1:6)
C                                                                               
C   IF TAPE NOT MOUNTED:  MOUNT IT, GET RSN, AND COUNT # OF FILES.      00000950
CP        IF (MOUNTED TAPE IS NOT SOUGHT TAPE)                          00000960
      IF (DMOUNT(L).EQ.DTAPE) GOTO 110                                  00000970
C   IF OLD TAPE MOUNTED, UNLOAD IT.                                     00000980
      IF (DMOUNT(L).EQ.DBLANK) GOTO 160                                 00000990
CP           UNLOAD MOUNTED TAPE                                        00001000
         CALL UNLOD(L,INUNIT(L))                                        00001010
         CALL PRNSUP(L,2,1,INUNIT(L),DDTAPE)                            00001020
CP        FI                                                            00001030
CP        MOUNT SOUGHT TAPE                                             00001040
160   IFILE(L) = 1                                                      00001050
      CALL CMOUNT(L,1,INUNIT(L),DTAPE,4,IDSN(L),IFILE(L))               00001060
      IBLKSZ = ILEN(L) * 10                                                     
      WRITE(6,113) CNAMEF(L) , IBLKSZ, IREEL, IFILES
113   FORMAT(1H ,'FLXPMT  STMT 160 AT MOUNT OF FILE ',A55,2X,3I6)
C                                                                               
      CALL PRNSUP(L,1,1,INUNIT(L),DDTAPE)                               00001070
      DMOUNT(L) = DTAPE                                                 00001080
      CFILE(L)  = CNAME                                                         
C                                                                       00000760
CP        GET REEL SEQUENCE NUMBER, AND NUMBER OF FILES ON TAPE         00001090
CPAS  IRSEQN(L) = ICTLG(IRECAD(L)+3,L)                                  00001100
CPAS  IFILNO(L) = 0                                                     00001110
      IRSEQN(L) = IREEL                                                 00001100
      IFILNO(L) = IFILES                                                00001110
CPAS  DO 108 I=13,14                                                    00001120
CPAS    DO 108 J=1,32                                                   00001130
C108       IFILNO(L) = IFILNO(L) + IGET(ICTLG(IRECAD(L)+I,L),J-1,J-1)   00001140
C                                                                               
C ----------------   REPLACE  SECTION END --------------------------            
C ----------------   REPLACE  SECTION END --------------------------            
C                                                                               
CP        READ UP TO REQUESTED START TIME                               00001150
110   CONTINUE                                                          00001160
C                                                                               
C     WRITE(6,112) CNAMEF(L),LEN, IFILE(L) ,IFILNO(L) ,INUNIT(L),L
112   FORMAT(1H ,'FLXPMT  STMT 112 AT FREAD OF FILE ',/1X,A55,/2X,5I5)
      CALL FREAD(IFLUX(1,L),INUNIT(L),LEN,*150,*510)                    00001160
C     CALL FREAD(IFLUX8,INUNIT(L),LEN,*150,*510)
      LENF = ILEN(L)                                                            
C     CALL FMOVE(IFLUX(1,L),LENF,IFLUX8(1))
C                                                                               
C     CHECK FOR LOGICAL END OF FILE ON  DISK FILE                               
      CALL FMOVE(CHKEOV,8,CFLUX(1,L))
      CALL CNVEBC(CHKEOV,8)
      IEOV   = KCLC(CHKEOV,1,EOV,1,8)
      IF (IEOV .EQ. 0)  GO TO 150                                               
      CALL FMOVE(CHKEOF,4,CFLUX(1,L))
      CALL CNVEBC(CHKEOF,4)
      IEOF   = KCLC(CHKEOF,1,EOF,1,4)
      IF (IEOF .EQ. 0)  GO TO 150                                               
C                                                                       00001160
      IF (LEN.NE.ILEN(L)) GOTO 520                                      00001170
      ITTTT = IFLUX(1,L)
      IOOOO = HFLUX(4,L)
      IYYYY = HFLUX(3,L)
      IF (HFLUX(3,L).NE.IYEAP1(L)) GOTO 110                             00001180
      IF ((IFLUX(1,L)).LT.IBEGIP(L)) GOTO 110                           00001190
C   GOOD RECORD HERE.                                                   00001200
      IF (IBEGIP(L).EQ.IBEGIN) GOTO 115                                 00001210
CP        SET AVAILABLE DATA TIME                                       00001220
      IBEGIP(L) = IFLUX(1,L)                                            00001230
      IYEAP1(L) = HFLUX(3,L)                                            00001240
115   CONTINUE                                                          00001250
      CALL UNPACK(IYYYY,ITTTT,IMO,IDAYM,IHR,IMIN,ISEC)
      IYY = IYYYY  - 1900
      WRITE(6,1051)IIMP,IMO,IDAYM,IYY,IHR,IMIN,ISEC,IOOOO
1051  FORMAT(' FLXPMT -',I1,' FOUND FIRST TIME RECORD ',
     *I2,'/',I2,'/',I2,I3,':',I2,':',I2,3X,I6)
      QDATA = .TRUE.                                                    00001250
CP        EXIT (RETURN NORMALLY)                                        00001260
      RETURN                                                            00001270
C   EOF ENCOUNTERED.  IF MORE FILES ON TAPE, CONTINUE.                  00001280
150   CONTINUE
      CALL UNPACK(IYYYY,ITTTT,IMO,IDAYM,IHR,IMIN,ISEC)
      IYY = IYYYY - 1900
      WRITE(6,1052)IIMP,IFILE(L),IMO,IDAYM,IYY,IHR,IMIN,ISEC,IOOOO
1052  FORMAT(' FLXPMT -',I1,' EOF  FILE= ', I3,3X,
     *I2,'/',I2,'/',I2,I3,':',I2,':',I2,3X,I6)
      IFILE(L) = IFILE(L) + 1                                           00001290
      IF (IFILE(L).GT.IFILNO(L)) GOTO 500                               00001300
      CALL CPOSN(L,1,INUNIT(L),IFILE(L))                                00001310
      GOTO 110                                                          00001320
C   HERE TAPE NOT FOUND IN CATALOG.                                     00001330
CP     ELSE                                                             00001340
180   CALL UNPACK(IYEAP1(L),IBEGIP(L),IMO,IDAYM,IHR,IMIN,ISEC)          00001350
      IYY = IYEAP1(L) - 1900                                            00001360
CP        PRINT MESSAGE                                                 00001370
      WRITE(6,1000)IIMP,IDAYM,MONAT(IMO),IYY,IHR,IMIN,ISEC
1000  FORMAT('  NO IMP-',I1,' FLUX TAPE CAN BE FOUND TO SPAN ',         00001390
     *I2,A3,I2,I3,':',I2,':',I2/' WILL INCREMENT BY ONE ORBIT.')        00001400
      JTIMES = JTIMES + 1                                               00001410
      IF (JTIMES.GT.40) GOTO 550                                        00001420
CP        BUMP TIME BY ONE INTERVAL                                     00001430
CP     FI                                                               00001440
      IBEGIP(L) = IBEGIP(L) + 3456000                                   00001450
      CALL IFIXIT(IBEGIP(L),IDAYY,IYEAP1(L))                            00001460
      GOTO 105                                                          00001470
CP  OD                                                                  00001480
C                                                                       00001490
CP**********************************************************************00001500
CP    SECOND ENTRY - NEXT FILE OR REEL.                                 00001510
CP**********************************************************************00001520
C                                                                       00001530
200   JTIMES = 0                                                        00001540
CP  BUMP FILE NUMBER BY ONE                                             00001550
      IFILE(L) = IFILE(L) + 1                                           00001560
CP  IF (NEW FILE STILL ON CURRENT TAPE)                                 00001570
      IF (IFILE(L).GT.IFILNO(L)) GOTO 220                               00001580
CP     POSITION TO NEW FILE                                             00001590
C     IF(.NOT. QDEBUG) GO TO 6001                                       00001592
      WRITE(6,6000)IFILE(L),IFILNO(L)
6000  FORMAT(1H ,'FLXPMT ------ NEW FILE',2I5)                          00001610
CP    TIME PRINT FOR DEBUG WORK  BUT EXPECT $EOF$EOF TYPE WORD 1 HERE
      IF(.NOT. QDEBUG) GO TO 6001                                       00001592
      ITTTT = IFLUX(1,L)
      IOOOO = HFLUX(4,L)
      IYYYY = HFLUX(3,L)
      CALL UNPACK(IYYYY,ITTTT,IMO,IDAYM,IHR,IMIN,ISEC)
      IYY = IYYYY - 1900
      WRITE(6,1050)IIMP,IMO,IDAYM,IYY,IHR,IMIN,ISEC,IOOOO
1050  FORMAT(' FLXPMT -',I1,' TIME OF LAST RECORD ',
     *I2,'/',I2,'/',I2,I3,':',I2,':',I2,3X,I6)
6001     CONTINUE                                                       00001612
C   NEXT FILE IS FOUND, BUT NOT READ. RETURN AS OK.                     00001630
      CALL CPOSN(L,1,INUNIT(L),IFILE(L))                                00001620
      QDATA = .TRUE.                                                    00001640
CP     EXIT (RETURN NORMALLY)                                           00001650
      RETURN                                                            00001660
C   MOUNT NEXT REEL.                                                    00001670
CP  ELSE                                                                00001680
CP     UNLOAD CURRENT TAPE                                              00001690
220   CONTINUE                                                                  
      CALL UNLOD(L,INUNIT(L))                                           00001700
      CALL PRNSUP(L,2,1,INUNIT(L),DDTAPE)                               00001710
C   IF SPECIAL TAPE (ZERO REEL SEQUENCE NO.), SKIP THROUGH.             00001720
      IF (IRSEQN(L).EQ.0) GOTO 580                                      00001730
CP     BUMP REEL SEQUENCE NUMBER BY 1                                   00001740
      IRSEQN(L) = IRSEQN(L) + 1                                         00001750
CP     DO UNTIL NEW TAPE MOUNTED                                        00001760
CP        IF (NEW REEL EXISTS)                                          00001770
230   CONTINUE                                                                  
C     CALL CATSUP(L,9,4,IRSEQN(L),IDUMMY,*280)                          00001780
      IREEL = IRSEQN(L)                                                         
      IERR = 0                                                                  
      CALL FLUXFL(2,L,IBEGIP(L),IYEAP1(L),IREEL,IFILES,IERR,CNAME)      00000860
      IF((IERR+49) .LT. 0) GO TO 280                                            
           DTAPE = CNAME                                                        
           CDTAPE = DBLKTP                                                      
           CDTAPE = CNAME(1:6)
CPAS  ITAPNO(L) = ICTLG(IRECAD(L),L)                                    00001790
CPAS  DTAPE = DPKTN(ITAPNO(L))                                          00001800
      IFILE(L) = 1                                                      00001810
CP           MOUNT NEW TAPE                                             00001820
      CALL CMOUNT(L,1,INUNIT(L),DTAPE,4,IDSN(L),IFILE(L))               00001830
      WRITE(6,117) CNAMEF(L)
117   FORMAT(1H ,'FLXPMT  STMT 230 AT MOUNT OF FILE ',A55)
      IBLKSZ = ILEN(L) * 10                                                     
      CALL PRNSUP(L,1,1,INUNIT(L),DDTAPE)                               00001840
      DMOUNT(L) = DTAPE                                                 00001850
      CFILE(L)  = CNAME                                                         
C                                                                               
CP           COUNT NUMBER OF FILES ON NEW TAPE                          00001860
      IFILNO(L) = 0                                                     00001870
      IFILNO(L) = IFILES                                                00001870
CPAS  DO 235 I=13,14                                                    00001880
CPAS    DO 235 J=1,32                                                   00001890
C235       IFILNO(L) = IFILNO(L) + IGET(ICTLG(IRECAD(L)+I,L),J-1,J-1)   00001900
C   NEXT REEL MOUNTED, BUT NOT READ.  RETURN AS OK.                     00001910
      QDATA = .TRUE.                                                    00001920
CP           EXIT (RETURN NORMALLY)                                     00001930
CP        FI                                                            00001940
      RETURN                                                            00001950
C   NEXT TAPE NOT FOUND.  LOOK FOR ANOTHER.                             00001960
280   JTIMES = JTIMES + 1                                               00001970
      WRITE(6,1005) IRSEQN(L)
1005  FORMAT('0CANNOT FIND NEXT TAPE IN CATALOG, REEL SEQ NO. ',I5)     00001990
      IF (JTIMES.GT.5) GOTO 560                                         00002000
CP        TRY NEXT REEL SEQUENCE NUMBER                                 00002010
      IRSEQN(L) = IRSEQN(L) + 1                                         00002020
CP     OD                                                               00002030
CP  FI                                                                  00002040
      GOTO 230                                                          00002050
C                                                                       00002060
CP**********************************************************************00002070
CP    LAST ENTRY - CLOSE UP INPUT TAPES.                                00002080
CP**********************************************************************00002090
C                                                                       00002100
300   CONTINUE                                                          00002110
CP  SET 'NO DATA' FLAG                                                  00002120
      QDATA = .FALSE.                                                   00002130
CP  EXIT (RETURN NORMALLY)                                              00002140
      RETURN                                                            00002150
C                                                                       00002160
C***********************************************************************00002170
C    ERROR MESSAGES BEGIN HERE.                                         00002180
C***********************************************************************00002190
C                                                                       00002200
500   PRINT 1100,IIMP                                                   00002210
1100  FORMAT('0END OF IMP-',I1,' FLUX TAPE ENCOUNTERED IN TRYING ',     00002220
     *'TO FIND START PLOT TIME.')                                       00002230
      QDATA = .FALSE.                                                   00002240
      IFRMAX = 0                                                        00002250
      RETURN                                                            00002260
C                                                                       00002270
510   PRINT 1200,IIMP,IMES                                              00002280
1200  FORMAT(' ERROR IN READING INPUT IMP-',I1,' FLUX TAPE.'/           00002290
     * 1X,Z8,I6,20A4,4(1X,Z8))                                          00002300
      KERROR = KERROR + 1                                               00002310
      IF (KERROR.LT.10) GOTO 110                                        00002320
      QDATA = .FALSE.                                                   00002330
      RETURN                                                            00002340
C                                                                       00002350
520   PRINT 1300,IIMP                                                   00002360
1300  FORMAT('0WRONG RECORD LENGTH ON INPUT IMP-',I1,' FLUX TAPE.')     00002370
      QDATA = .FALSE.                                                   00002380
      IFRMAX = 0                                                        00002390
      RETURN                                                            00002400
C                                                                       00002410
550   PRINT 1400,IIMP                                                   00002420
1400  FORMAT('0CANNOT SATISFY START TIME REQUIREMENTS TO WITHIN ',      00002430
     *'40 ORBITS ON IMP-',I1)                                           00002440
      QDATA = .FALSE.                                                   00002450
      IFRMAX = 0                                                        00002460
      RETURN                                                            00002470
C                                                                       00002480
560   PRINT 1500,IIMP                                                   00002490
1500  FORMAT('0CANNOT CONTINUE PLOTTING TO WITHIN NEXT 4 REELS ',       00002500
     *'ON IMP-',I1)                                                     00002510
      QDATA = .FALSE.                                                   00002520
      RETURN                                                            00002530
C                                                                       00002540
570   PRINT 1600,IIMP                                                   00002550
1600  FORMAT('0CANNOT FIND DESIRED PLOT RANGE FOR IMP-',I1)             00002560
      QDATA = .FALSE.                                                   00002570
      IFRMAX = 0                                                        00002580
      RETURN                                                            00002590
C                                                                       00002600
580   PRINT 1700                                                        00002610
1700  FORMAT('0END OF SPECIAL TAPE.')                                   00002620
      QDATA = .FALSE.                                                   00002630
      RETURN                                                            00002640
C                                                                       00002600
999   PRINT 1800, CNAME                                                 00002610
1800  FORMAT('0DISK FILE OPEN ERROR .',A)                               00002620
      QDATA = .FALSE.                                                   00002630
      RETURN                                                            00002640
      END                                                               00002650
