CH1   SUBROUTINE FLXPT1                                                 00000010
CH                                                                      00000020
CH2  FUNCTIONAL DESCRIPTION:                                            00000030
CH2    GENERATES FLUX OUTPUT DISK DATA SETS (IE, FOR USE ON PDP-11/70). 00000040
CH2    NEW FT31,FT32 DISK DATASET OUTPUT                                00000050
CH                                                                      00000060
CH3  CALLING ROUTINES:  FLXPMN                                          00000070
CH                                                                      00000080
CH4  SUBROUTINES CALLED:  FWRITE,  FMOVE, ZTIME, UNPACK, GETSAT         00000090
CH                                                                      00000100
CH5  VARIABLE CROSS REFERENCE:                                          00000110
CH5    NAME         TYPE   I/O        DESCRIPTION                       00000120
CH5   QFIRST         L*1           FLAG FOR FIRST TIME THRU             00000130
CH5   RDATA(2,101)   R*4    O      OUTPUT DISK DATASET FT32 DATA        00000140
CH5   IBUF(202)      I*4    O      FWRITE OUTPUT BUFFER AREA            00000150
CH5   JTITLE(20)     I*4    I      USER INPUTTED TITLE                  00000160
CH5   JRANGE         I*4    I      PLOT POINT SIZE, DECISECONDS         00000170
CH5   IAVLEN         I*4    I      AVERAGING PERIOD SIZE, DECISEC       00000180
CH5   NUMBIN         I*4    I      NUMBER OF REQUESTED BINS             00000190
CH5   DPART(36)      R*8    I      PARTICLE LABELS                      00000200
CH5   JPRTBN(100)     I*4    I      PARTICLE NUMBER FOR EACH BIN        00000210
CH5   ELOBN(100)      R*4    I      LOWER BIN ENERGY, MEV               00000220
CH5   EUPBN(100)      R*4    I      UPPER BIN ENERGY, MEV               00000230
CH5   XNORM(100)      R*4    I      FLUX MULTIPLICATIVE NORMALIZATION   00000240
CH5   ISTOP,IYR2     I*4    I      STOP TIME OF INTERVAL                00000250
CH5   S(100)          R*4    I      FLUX FOR EACH BIN                   00000260
CH5   SDEL(100)       R*4    I      FLUX ERROR FOR EACH BIN             00000270
CH                                                                      00000280
CH6  METHOD:                                                            00000290
CH6   3 ENTRIES:                                                        00000300
CH6       FLXPT1 - WRITES OUT HEADER RECORDS OF FT32 DATASET            00000310
CH6       FLXPT2 - WRITES OUT DATA RECORDS                              00000320
CH6       FLXPT3 - WRITES FT31 DISK DATASET                             00000330
CH6   CURRENTLY THERE IS A MAXIMUM OF 100 POSSIBLE BINS TO PROCESS.     00000340
CH6   FLXPT1,3 ARE USED FOR ONLY ONE SET OF INPUT CARDS PER JOB,        00000350
CH6   FLXPT2 PROCESSES ALL REQUESTED TIME DATA FOR ONE SET OF INPUT     00000360
CH6   CARDS ONLY!                                                       00000370
CH6   STACKED INPUT DECKS MAY BE USED IF THIS PDP11/70 OPTION IS        00000380
CH6   NOT USED IN THE JOB!                                              00000390
CH                                                                      00000400
CH7  PROGRAMMER:  P. SCHUSTER, 12/86                                    00000410
CH8  MODIFICATION 5/87  REFORMAT BIN DESCRIPTIONS AS PER MCGUIRE        00000411
CH8  MODIFICATION 6/87  UNDO EFFECT OF NORMALIZATION FACTOR FOR         00000412
CH7                     11/70 TAPE                                      00000413
CH8  MODIFICATION 12/88 ADD DPART FIELD ASIS TO FT32 LABEL DESCRIP.     00000420
CH8                     BYTE 54 ->  TO CORRECTLY PASS RATE DESCRIP              
CH8                     OR PARTICLE IF FLUX                                     
CH8   REMOVED:          ADD CODE TO FLXPT2 ENTRY TO SET STOP TIME               
CH8                     FOR FT31 FOR SPECTRAL DATA IN FT31                      
CH8                                                                             
CH8  MODIFICATION 10/90 SEGMENT FOR HANDLING IMP6 DATA MUST GIVE                
CH8                     BASEYR AS 1971 AND TIMES RELATIVE TO THAT               
CH8                     HENCE, NRMJDD                                           
CH8  MODIFICATION 4/92  SEGMENT IN FLXPT2- MODIFY DOUBLE PRECIS-                
CH8                     ION SECS FROM BASEYR CALC TO AVOID ROUNDOFF             
CH8                     ERRORS                                                  
CH                                                                      00000430
CH9  IMP-6/7/8, FLUX PLOT, FLXPT1, V2.                                  00000440
CH**********************************************************************00000450
C                                                                       00000460
      SUBROUTINE FLXPT1                                                 00000470
C                                                                       00000480
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H),REAL*8(D)                      00000490
      COMMON /AVE/    IAVLEN,QSTAT                                      00000500
      COMMON /BINS/   NUMBIN,JBOX(10,100),IMP(100),JFRAME(100),         00000510
     *                JCHAR(100),XNORM(100),JPRTBN(100),ELOBN(100),     00000520
     *                EUPBN(100),QBOX(500,3),QFB(10,100)                00000530
      COMMON /FRAME / ISTART,IYR1,ISTOP,IYR2,NORM2,MINENG(50),          00000540
     *                MAXENG(50),MINFLX(50),MAXFLX(50),                 00000550
     *                JRANGE,JRANUN,JAVER,NOAVU,IAVU,IFRMAX,QLINEX      00000560
      COMMON /LIMITS/ IBEGIN,IYEAR1,IEND,IYEAR2,IBEGIP(3),IYEAP1(3)     00000990
      COMMON /LABELP/ DPART(43)                                         00000570
      COMMON /POINTS/ S(100),SDEL(100),Y(250,100),YDEL(250,100),        00000580
     *                ITIME(250),IPTS,JKEY,QTHIST                       00000590
C                                                                       00000600
      COMMON/HD31  /  QFNAME(28),HBINSS,HRECRD,HLREC,HLRECB,HBLOCK,     00000610
     X                HBAS,DSTTIM,DENTIM,DAVSES,QCREAT(12),QTIMCR(8),   00000620
     X                HSPARE(2),QPGNAM(8),QSPARE(37)                    00000630
      COMMON/HD32  /  HBINS,HRECS,DAVSEC,HBASYR,QSAT(12),               00000640
     X                QLABEL(132,100)                                   00000650
      COMMON/TREND /  TCFACT,QTC,QDEBUG                                         
      CHARACTER*9 CENERG,CENBLK                                                 
      CHARACTER*4 CBOXES,CBXBLK                                                 
      DATA CENBLK/'         '/, CBXBLK/'    '/                                  
      CHARACTER*1 CCREAT(12), CTIMCR(8), CQDATE(12), CQTIME(8)                  
      EQUIVALENCE (QCREAT(1),CCREAT(1)), (QTIMCR(1),CTIMCR(1))                  
      EQUIVALENCE (QDATE(1),CQDATE(1)), (CQTIME(1),QTIME(1))                    
C                                                                       00000660
      DIMENSION QAREAT(12),QAREA(9),QTIME(8),QAREAD(16),QDATE(12)       00000670
      DIMENSION QMEV(3), QNORM(6), QBOXES(7),QFLUX(4),QRATE(4)          00000680
      DIMENSION QQBLAN(9)                                               00000690
      DIMENSION Q876(8,3),Q8(8),Q7(8),Q6(8)                             00000700
      DIMENSION IBUF(202)                                               00000710
      DIMENSION RDATA(2,101), EDATA(2,100)                              00000720
      DIMENSION  QF(28),QP(8)                                           00000730
      CHARACTER*9 CQQBLN                                                        
      CHARACTER*8 CQ8,CQ7,CQ6,CQP                                               
      CHARACTER*4 CQFLUX,CQRATE                                                 
      CHARACTER*1 CQBLNK,CQDASH,CQSLSH                                          
      CHARACTER*1 CQPARL, CQDOT, CQSEMI, CQPARR                                 
      CHARACTER*3 CQMEV                                                         
      CHARACTER*6 CQNORM                                                        
      CHARACTER*7 CQBXES                                                        
      CHARACTER*28 CQF                                                          
      EQUIVALENCE (CQF,QF(1)), (CQP,QP(1))                                      
      EQUIVALENCE (CQ8,Q8(1)), (CQ7,Q7(1)), (CQ6,Q6(1))                         
      EQUIVALENCE (Q876(1,1),Q6), (Q876(1,2),Q7), (Q876(1,3),Q8)        00000760
      EQUIVALENCE (CQFLUX,QFLUX(1)), (CQRATE,QRATE(1))                          
      EQUIVALENCE (CQBLNK,QBLANK), (CQDASH,QDASH)                               
      EQUIVALENCE (CQSLSH,QSLASH), (CQPARL,QPAREL)                              
      EQUIVALENCE (CQDOT,QDOT), (CQSEMI,QSEMI)                                  
      EQUIVALENCE (CQPARR,QPARER)                                               
      EQUIVALENCE (CQMEV,QMEV(1)), (CQNORM,QNORM(1))                            
      EQUIVALENCE (CQBXES,QBOXES(1))                                            
      EQUIVALENCE (CQQBLN,QQBLAN(1))                                            
      EQUIVALENCE (RDATA(1,2),EDATA(1,1))                               00000740
      EQUIVALENCE (RDATA(1,1),DSECSN)                                   00000750
      DATA CQ8 /'I8      '/,CQ7 /'I7      '/, CQ6 /'I6      '/          00000770
      DATA CQFLUX /'FLUX'/, CQRATE /'RATE'/ ,CQQBLN /'         '/       00000780
      DATA CQBLNK /' '/, CQDASH /'-'/, CQSLSH/'/'/, CQPARL/'('/         00000790
      DATA CQDOT/'.'/, CQSEMI/':'/                                      00000800
      DATA CQPARR/')'/ , CQMEV /'MEV'/, CQNORM /'NORM= '/,              00000810
     X     CQBXES /'BOXES= '/                                           00000820
      DATA CQF/'                            '/                          00000830
      DATA CQP/'FLUXPLOT'/                                              00000840
C  FOR FLEXPLOT USE FLEXPLOT                                            00000850
C  ONLY DIFF FOR THAT VERSION OF PGM                                    00000860
      DATA QFIRST/.TRUE./                                               00000870
      DATA I31 /31/, I32 /32/
C                                                                       00000880
      IF (.NOT. QFIRST) GO TO 20                                        00000890
      DO 1 I=1,28                                                       00000900
           QFNAME(I) = QF(I)                                            00000910
           IF (I .GT. 8) GO TO 1                                        00000920
           QPGNAM(I) = QP(I)                                            00000930
1     CONTINUE                                                          00000940
C                                                                       00000950
C                                                                       00000960
CP  STORE BIN LABEL INFO IN THE FOLLOWING FORMAT:                       00000970
C   RATES BOXES WILL BE TRUNCATED ON THE RIGHT FOR THE FIELD WHICH      00000980
C   APPENDS THE I8 (FOR EX.) TO THE PARTICLE NAME TO TAKE 8             00000990
C   TOTAL CHARACTERS                                                    00001000
C   THIS FORMAT IS FOR THE 11/70 READ IN PROGRAM                        00001010
C5678901234567890123456789012345678901234567890123456789012345678901234500001020
CCI8 5.103E+01 - 6.320E+01  MEV I8PROTON   FLUX   PROTON     BOXES=  40000001030
C  CONTINUES COLUMN 76 -> 401 402 403 404 405 406 407 408 409           00001040
C                                                                       00001050
CCI8           -            MEV I8D.E.F.   RATE   D.E.F.^G   BOXES=  40900001030
C                                                                       00001060
      IRCTR = 0                                                         00001070
C     IRCTR IS A RECORDS WRITTEN COUNTER                                00001080
CP  CHECK FOR MIXED SATELLITE DATA                                      00001090
      CALL GETSAT(IERRO,QSAT)                                           00001100
      HRECS = 0                                                         00001110
      HBINS = NUMBIN                                                    00001120
CP  AVERAGING INTERVAL IS NEGATIVE TO TELL 11/70 PROGRAM THAT           00001130
CP  BASE YEAR IS OTHER THAN 1977                                        00001140
      IF (QTHIST) DAVSEC = - (JAVER / 10.0)                             00001150
      IF (.NOT. QTHIST) DAVSEC = - (JRANGE / 10.0)                      00001160
      IF(.NOT. QTHIST .AND. JRANGE .LT. 0) DAVSEC = - 0.0               00001170
C   FOR JKEY = 0,1 AND SPECTRAL PLOT, IAVLEN MAY BE 0 OR NEGATIVE       00001180
C   IN FLXPIN JRANGE IS SET TO IAVLEN FOR JKEY= 0,1, AND SPECTRAL       00001190
C   PLOT REQUESTED.                                                     00001200
C                                                                       00001210
      HBASYR = 1972                                                     00001220
      IF (IYEAR1 .EQ. 1971) HBASYR = 1971                                       
      WRITE(6,5) HBASYR, IYEAR1                                                 
 5    FORMAT(1H ,'FLXPT1    HBASYR FOR TIME CALCS IS ',I6,3X,I6)                
C                                                                       00001230
C                                                                       00001240
      IRECLN = MAX0(33,2*NUMBIN + 2)                                    00001250
      NBYTES = IRECLN * 4                                               00001260
C     CALL SETDCB('FT32F001',NBYTES,IBLOCK)                             00001270
C     SETDCB SETS THE DCB FOR UNIT 32, RETURNING IBLOCK , THE           00001280
C     DATASET BLOCKSIZE ALLOCATED                                       00001290
C FOR UNIX VERSION USE LOCAL SETDCB                                     00001300
      CALL SETDCB(NBYTES,IBLOCK,IERROR)                                 00001270
C          IF IERROR IS -1 NBYTES EXCEEDS 19000 HARD CODE BLKSIZE       00001310
CP WRITE RECORD 1 OF FT32: FIRST 14 BYTES OF HD32 ARRAY                 00001320
C  ZERO WRITE BUFFER AREA                                               00001330
         IBUF(1) = 0                                                    00001340
         CALL FMOVE(IBUF(2),804,IBUF(1))                                00001350
         CALL FMOVE(IBUF(1),14,HBINS)                                   00001360
      CALL FWRITE(IBUF,I32,NBYTES)                                       00001370
CP WRITE RECORD 2: SATELLITE NAME                                       00001380
         IBUF(1) = 0                                                    00001390
         CALL FMOVE(IBUF(2),12,IBUF(1))                                 00001400
         CALL FMOVE(IBUF(1),12,QSAT(1))                                 00001410
      CALL FWRITE(IBUF,I32,NBYTES)                                       00001420
C  INITIALIZE QLABEL WITH BLANKS                                        00001430
      QLABEL(1,1) = QBLANK                                              00001440
      CALL FMOVE(QLABEL(2,1),13199, QLABEL(1,1))                        00001450
CP PACK AND WRITE BIN LABEL RECORDS                                     00001460
      DO 10 I=1,NUMBIN                                                  00001470
         L = IMP(I)                                                     00001480
         CALL FMOVE(QLABEL(6,I),2,Q876(1,L))                            00001490
         CALL FMOVE(QLABEL(36,I),2,Q876(1,L))                           00001500
         CALL FMOVE(QLABEL(38,I),6,DPART(JPRTBN(I)))                    00001510
         NARG7 = 7                                                              
C OLD    CALL INCORE(ELOBN(I),QLABEL(9,I),16,1,9,3,1)                   00001520
         CENERG = CENBLK                                                        
         CALL FTOR4(NARG7,ELOBN(I),CENERG,16,1,9,3,1)                   00001520
         CALL FMOVE(QLABEL(9,I),9,CENERG)                               00001540
C OLD    CALL INCORE(EUPBN(I),QLABEL(21,I),16,1,9,3,1)                  00001530
         CENERG = CENBLK                                                        
         CALL FTOR4(NARG7,EUPBN(I),CENERG,16,1,9,3,1)                   00001530
         CALL FMOVE(QLABEL(21,I),9,CENERG)                              00001540
         CALL FMOVE(QLABEL(19,I),1,QDASH)                               00001540
         CALL FMOVE(QLABEL(32,I),3,QMEV(1))                             00001550
         CALL FMOVE(QLABEL(47,I),4,QFLUX(1))                            00001560
C    FOR RATES BOXES, SET IN 'RATE' AND SET ENERGY LIMITS               00001570
C    TO BLANK ; ALSO SET IN ACTUAL RATE DESCRIPTION INTO 54-61          00001580
C    FOR FLUXES, PUT IN ACTUAL PARTICLE TYPE                                    
         CALL FMOVE(QLABEL(54,I),8,DPART(JPRTBN(I)))                    00001600
         IF(JBOX(1,I) .GE. 401 .AND. JBOX(1,I) .LE. 418)                00001590
     X   CALL FMOVE(QLABEL(47,I),4,QRATE(1))                            00001600
         IF(JBOX(1,I) .GE. 401 .AND. JBOX(1,I) .LE. 418)                00001610
     X   CALL FMOVE(QLABEL(9,I),9,QQBLAN(1))                            00001620
         IF(JBOX(1,I) .GE. 401 .AND. JBOX(1,I) .LE. 418)                00001630
     X   CALL FMOVE(QLABEL(21,I),9,QQBLAN(1))                           00001640
         CALL FMOVE(QLABEL(65,I),7,QBOXES(1))                           00001650
C  BOXES:                                                               00001660
         JJ = 0                                                         00001670
         DO 8 IB = 1,10                                                 00001680
            IF(JBOX(IB,I) .EQ. 0) GO TO 9                               00001690
                   IBB = 71 + JJ                                        00001700
C OLDCALL   CALL INCORE(JBOX(IB,I),QLABEL(IBB,I),19,1,4)                00001710
            NARG5 = 5                                                           
            CBOXES = CBXBLK                                                     
            CALL ITOI4(NARG5,JBOX(IB,I),CBOXES,19,1,4)                  00001710
            CALL FMOVE(QLABEL(IBB,I),4,CBOXES)                          00001710
            JJ = JJ + 4                                                 00001720
8        CONTINUE                                                       00001730
9        CONTINUE                                                       00001740
CP WRITE BIN LABEL RECORD                                               00001750
         CALL FMOVE(IBUF(1),132,QLABEL(1,I))                            00001760
         CALL FWRITE(IBUF,I32,NBYTES)                                    00001770
10    CONTINUE                                                          00001780
      IRCTR = 2 + NUMBIN                                                00001790
C    RECORD COUNTER FOR RECORDS WRITTEN                                 00001800
20    CONTINUE                                                          00001810
      RETURN                                                            00001820
C                                                                       00001830
C                                                                       00001840
      ENTRY FLXPT2                                                      00001850
CP WRITE DATA RECORDS TO FT32; SEPARATE BY SPECTRAL OR TIME HISTORY     00001860
CP  GET TIME FOR START OF INTERVAL                                      00001870
      CALL UNPACK(IYR1,ISTART,IMON,IDAY,IHOUR,IMIN,ISEC)                00001880
         HYR = IYR1 - 1900                                              00001890
         HMON= IMON                                                     00001900
         HDAY= IDAY                                                     00001910
         IF (HBASYR .EQ. 1972)CALL DRMJD(HYR,HMON,HDAY,HMJD)            00001920
         IF (HBASYR .EQ. 1971)CALL NDRMJD(HYR,HMON,HDAY,HMJD)           00001920
         HMJD = HMJD - 1                                                00001930
         RHMJD = HMJD                                                   00001940
         DMJD =  RHMJD                                                          
         DMJD =  DMJD * (8.64D4 )                                               
         DOTH = (IHOUR * 3600 ) + (IMIN * 60) + ISEC                            
         DSECS = DMJD + DOTH                                            00001950
         DSECSN = DSECS                                                 00001960
C   SAVE FIRST TIME OF DATA                                             00001970
         IF(QFIRST) DSAVSR = DSECS                                      00001980
         IF(QFIRST) QFIRST = .FALSE.                                    00001990
CP  GET TIME FOR STOP OF INTERVAL                                       00001870
C     CALL UNPACK(IYR2,ISTOP,IMON,IDAY,IHOUR,IMIN,ISEC)                 00001880
C        HYR = IYR1 - 1900                                              00001890
C        HMON= IMON                                                     00001900
C        HDAY= IDAY                                                     00001910
C        CALL DRMJD(HYR,HMON,HDAY,HMJD)                                 00001920
C        HMJD = HMJD - 1                                                00001930
C        RHMJD = HMJD                                                   00001940
C        DSECS1 = RHMJD* 86400. + IHOUR * 3600 + IMIN*60 + ISEC         00001950
      IF(QTHIST) GO TO 400                                              00002000
CP  PROCESS SPECTRAL DATA                                               00002010
      DO 90 II = 1,100                                                  00002020
            EDATA(1,II) = -1.0                                          00002030
            EDATA(2,II) = -1.0                                          00002040
90    CONTINUE                                                          00002050
      DO 100 II = 1,NUMBIN                                              00002060
C      UNDO EFFECT OF NORMALIZATION FACTOR HERE, FOR NOW 6/87           00002061
            EDATA(1,II) = S(II)/ XNORM(II)                              00002070
            EDATA(2,II) = SDEL(II)/ XNORM(II)                           00002080
100   CONTINUE                                                          00002090
C     DSAVST = DSECS1                                                           
      DSAVST = DSECS                                                            
      CALL FWRITE(RDATA,I32,NBYTES)                                      00002100
      IRCTR = IRCTR + 1                                                 00002110
      IF(QDEBUG)WRITE(6,129)DSECSN,(EDATA(1,LL),EDATA(2,LL),                    
     XLL=1,NUMBIN)                                                              
  129 FORMAT(1H ,'FLXPT1 AT SPECTRAL BRANCH WRITE ',1PG20.10/1X,                
     X 5X,100(2(1PE10.4,2X),/6X))                                               
      RETURN                                                            00002120
C                                                                       00002130
C                                                                       00002140
400   CONTINUE                                                          00002150
CP  PROCESS TIME HISTORY DATA                                           00002160
CP  EXPECTED POINTS = JRANGE / JAVER                                    00002170
CP  EACH SUCCESSIVE POINT = ISTART + N*JAVER  FOR TIME ASSIGNMENT       00002180
       JPTS = JRANGE / JAVER                                            00002190
       PRINT 401,IPTS,JPTS,JRANGE,JAVER                                 00002200
401    FORMAT(1H ,'FLXPT2 ** IPTS,JPTS,JRANGE,JAVER =',2I4,2I20)        00002210
       DO 500 JJ = 1,IPTS                                               00002220
          DN = (JJ-1) * (JAVER / 10.0)                                  00002230
          DSECSN = DSECS + DN                                           00002240
          DO 450 I = 1,100                                              00002250
              EDATA(1,I) = -1.0                                         00002260
              EDATA(2,I) = -1.0                                         00002270
450       CONTINUE                                                      00002280
          DO 460 III = 1,NUMBIN                                         00002290
C      UNDO EFFECT OF NORMALIZATION FACTOR HERE, FOR NOW 6/87           00002291
              EDATA(1,III) = Y(JJ,III) / XNORM(III)                     00002300
              EDATA(2,III) = YDEL(JJ,III)/ XNORM(III)                   00002310
460       CONTINUE                                                      00002320
          CALL FWRITE(RDATA,I32,NBYTES)                                  00002330
          IRCTR = IRCTR + 1                                             00002340
500   CONTINUE                                                          00002350
          DSAVST = DSECSN                                               00002360
      RETURN                                                            00002370
C                                                                       00002380
C                                                                       00002390
      ENTRY FLXPT3                                                      00002400
CP WRITE FT31 DATASET                                                   00002410
      HBINSS = NUMBIN                                                   00002420
      HRECRD = IRCTR                                                    00002430
      HLREC = IRECLN                                                    00002440
      HLRECB = 4 * HLREC                                                00002450
      HBLOCK =  IBLOCK                                                  00002460
      HBAS = HBASYR                                                     00002470
      DSTTIM = DSAVSR                                                   00002480
      DENTIM = DSAVST                                                   00002490
      DAVSES = DAVSEC                                                   00002500
      HSPARE(1) = 0                                                     00002510
      HSPARE(2) = 0                                                     00002520
CP SET UP CREATION TIMES                                                00002530
C INITIALIZE AREAS                                                      00002540
       QCREAT(1) = QBLANK                                               00002550
       QTIMCR(1) = QBLANK                                               00002560
       CALL FMOVE(QCREAT(2),11,QCREAT(1))                               00002570
       CALL FMOVE(QTIMCR(2),7,QTIMCR(1))                                00002580
C     CALL ZTIME(QAREAT,1)                                              00002590
C     CALL FMOVE(QTIME(1),8,QAREAT(1))                                  00002600
C     CALL ZTIME(QAREAD,2)                                              00002610
C     CALL FMOVE(QDATE(1),2,QAREAD(9))                                  00002620
C     CALL FMOVE(QDATE(4),3,QAREAD(5))                                  00002630
C     CALL ZTIME(QAREA,4)                                               00002640
C     CALL FMOVE(QDATE(8),2,QAREA(1))                                   00002650
      DO 600 I = 1,12                                                   00002660
             CCREAT(I) = CQDATE(I)                                      00002670
             IF (CCREAT(I) .EQ. CQDOT .OR. CCREAT(I) .EQ. CQSLSH)       00002680
     X          CCREAT(I) = CQDASH                                      00002690
             IF(CCREAT(I) .EQ. CQSEMI) CCREAT(I) = CQDASH               00002700
             IF (I .GT. 8) GO TO 600                                    00002710
             CTIMCR(I) = CQTIME(I)                                      00002720
             IF (CTIMCR(I) .EQ. CQDOT .OR. CTIMCR(I) .EQ. CQSLSH)       00002730
     X          CTIMCR(I) = CQDASH                                      00002740
             IF(CTIMCR(I) .EQ. CQSEMI) CTIMCR(I) = CQDASH               00002750
600   CONTINUE                                                          00002760
      CALL FWRITE(QFNAME(1),I31,132)
      CALL CLEAVE(I31)
      RETURN
      END                                                               00002800
      SUBROUTINE GETSAT(IERR,QSATS)                                     00002810
      COMMON /SATLIT/ QSAT(3),QDAT(3)                                   00002820
      LOGICAL*1 QSAT,QDAT,QSATS(12)                                     00002830
      CHARACTER*12 IMP6,IMP7,IMP8,IMP67,IMP68,                          00002840
     X          IMP78,IMP678                                            00002850
      DATA IMP6 /'IMP-6       '/                                        00002860
      DATA IMP7 /'IMP-7       '/                                        00002870
      DATA IMP8 /'IMP-8       '/                                        00002880
      DATA IMP67 /'IMP-6,-7    '/                                       00002890
      DATA IMP68 /'IMP-6,-8    '/                                       00002900
      DATA IMP78 /'IMP-7,-8    '/                                       00002910
      DATA IMP678 /'IMP-6,-7,-8 '/                                      00002920
      ISUM = 0                                                          00002930
      IERR = 0                                                          00002940
      IF( QSAT(1)) ISUM = ISUM + 6                                      00002950
      IF( QSAT(2)) ISUM = ISUM + 7                                      00002960
      IF( QSAT(3)) ISUM = ISUM + 8                                      00002970
      IF(ISUM .LT. 13) GO TO 10                                         00002980
      IF(ISUM .GT. 12 .AND. ISUM .LT. 21) GO TO 20                      00002990
      IF(ISUM .EQ. 21) GO TO 30                                         00003000
      PRINT 5,ISUM                                                      00003010
5     FORMAT(1H ,'**GETSAT (FLXPT1) WARNING IN ISUM ,= ',I5)            00003020
      STOP                                                              00003030
10    CONTINUE                                                          00003040
      IS = ISUM - 5                                                     00003050
      GO TO (12,13,14),IS                                               00003060
      IERR = 1                                                          00003070
12    CALL FMOVE(QSATS(1),12,IMP6)                                      00003080
      RETURN                                                            00003090
13    CALL FMOVE(QSATS(1),12,IMP7)                                      00003100
      RETURN                                                            00003110
14    CALL FMOVE(QSATS(1),12,IMP8)                                      00003120
      RETURN                                                            00003130
20    CONTINUE                                                          00003140
      ISS = ISUM - 12                                                   00003150
      GO TO (22,23,24),ISS                                              00003160
      IERR = 2                                                          00003170
22    CALL FMOVE(QSATS(1),12,IMP67)                                     00003180
      RETURN                                                            00003190
23    CALL FMOVE(QSATS(1),12,IMP68)                                     00003200
      RETURN                                                            00003210
24    CALL FMOVE(QSATS(1),12,IMP78)                                     00003220
      RETURN                                                            00003230
30    CONTINUE                                                          00003240
      CALL FMOVE(QSATS(1),12,IMP678)                                    00003250
      RETURN                                                            00003260
      END                                                               00003270
