pro xfr2_updateoverlay
  @xfr2_common
  
  ; get a fresh copy of the image
  wset, 1
  device, copy = [0, 0, 600, 600, 0, 0, 2]
   
  ; draw slice lines
  sliceAngle = 2.0D * !pi / double(nSlices)

  bigRad = double(earthRadius * maxL)

  for i = 0.0D, nSlices - 1 do begin
      c = cos(sliceAngle * i + angleOffset)
      s = sin(sliceAngle * i + angleOffset)
      plots, [299 + (bigRad - 10) * c, 299 + bigRad * c], $
             [299 + (bigRad - 10) * s, 299 + bigRad * s], $
             /device, color = linecolor
;      plots, [299 - (bigRad - 10) * c, 299 - bigRad * c], $
;             [299 - (bigRad - 10) * s, 299 - bigRad * s], $
;             /device, color = linecolor
      plots, [299 + (earthRadius + 5) * c, 299 + earthRadius * c], $
             [299 + (earthRadius + 5) * s, 299 + earthRadius * s], $
             /device, color = linecolor
;      plots, [299 - (earthRadius + 5) * c, 299 - earthRadius * c], $
;             [299 - (earthRadius + 5) * s, 299 - earthRadius * s], $
;             /device, color = linecolor
  end

  c = cos(angleOffset - sliceAngle * 0.5 * relWidth)
  s = sin(angleOffset - sliceAngle * 0.5 * relWidth)
  plots, [299 + earthradius * c, 299 + bigRad * c], $
         [299 + earthradius * s, 299 + bigRad * s], $
         /device, color = linecolor

  c = cos(angleOffset + sliceAngle * 0.5 * relWidth)
  s = sin(angleOffset + sliceAngle * 0.5 * relWidth)
  plots, [299 + earthradius * c, 299 + bigRad * c], $
         [299 + earthradius * s, 299 + bigRad * s], $
         /device, color = linecolor

  ; display image
  wset, h_draw
  device, copy = [0, 0, 600, 600, 0, 0, 1]
end
