pro xfr2_event, ev
  @xfr2_common

  widget_control, ev.id, get_uvalue = id
  
  case id of
      'w_slider1': begin
          widget_control, w_slider1, get_value = v
          if v eq nSlices then return
          nSlices = v
          widget_control, w_label2, set_value = zeropad(v, 0)
          if fileOpen then xfr2_updateoverlay
        end

      'w_slider2': begin
          widget_control, w_slider2, get_value = v
          vv = v / 360.0 * !pi
          v = v / 2.0
          if vv eq angleOffset then return
          angleOffset = vv
          if angleMode eq 1 then v = v / 360.0 * 24.0
          widget_control, w_label4, set_value = ftoa(v, 2)
          if fileOpen then xfr2_updateoverlay          
        end

      'w_slider3': begin
          widget_control, w_slider3, get_value = v
          if abs(v) lt 5 then v = 0
          vv = (v + 100) / 100.0D
          if vv eq relWidth then return
          relWidth = vv
          widget_control, w_label6, set_value = zeropad(v, 0) + '%'
          if fileOpen then xfr2_updateoverlay          
        end

      'w_slider4': begin
          widget_control, w_slider4, get_value = v
          widget_control, w_label8, set_value = zeropad(v, 0)
          if fileOpen then lstep = maxL / double(v)
        end

      'b_MLT': begin
          angleMode = 1
          xfr2_updatelabels
        end

      'b_MLON': begin
          angleMode = 0
          xfr2_updatelabels
      end

      'calcsingle': begin
           if fileOpen eq 0 then return

           xfr2_calculate, 0

           widget_control, w_label4, get_value = v

           numGroups = ((maxL - 1) / lstep)

           outfname = strmid(fileName, 0, strpos(strlowcase(fileName), $
                                                 '.fits')) + $
                      '_xfr2_s_' + v + '_' + zeropad(numGroups, 3) + '.dat'
                 
           xfr2_updateoverlay

           print, outfname

           x = dblarr(2, numGroups)
           x[0, 0:numGroups - 1] = grpX
           x[1, 0:numGroups - 1] = grpY

           get_lun, fh
           openw, fh, outfname
	   printf, "           L-val       Avg Count"
	   printf, "# --------------  --------------"
           printf, fh, x
           close, fh
           free_lun, fh
         end

      'calcall': begin
         if fileOpen eq 0 then return

         numGroups = ((maxL - 1) / lstep)
         storedZ = dblarr(nSlices)
         storedY = dblarr(nSlices, numGroups)       
         if angleMode eq 0 then aOffset = angleOffset / !pi * 180.0 $
                           else aOffset = angleOffset / !pi * 12.0
         print, aOffset
         for i = 0, nSlices - 1 do begin
             if angleMode eq 0 then sliceAngle = 360.0 / double(nSlices) $
                               else sliceAngle = 24.0 / double(nSlices)
             storedZ[i] = sliceAngle * i + aOffset             
             xfr2_calculate, i
             storedY[i, 0:numGroups - 1] = grpY
             j = (i + 1.0D) / nSlices * 100
             widget_control, w_button4, $
                             set_value = 'Calculating ... (' + $
                             ftoa(j, 1) + '%)'
         end
         storedX = grpX
         xfr2_updateoverlay
         widget_control, w_button4, $
                         set_value = 'Calculate all'

         outfname = strmid(fileName, 0, strpos(strlowcase(fileName), '.fits'))$
                    + '_xfr2_m_' + zeropad(nSlices, 2) + '_' + $
                    zeropad(numGroups, 3) + '.dat'
                 
         outfname2 = strmid(fileName, 0, $
                            strpos(strlowcase(fileName), '.fits')) $
                    + '_xfr2_m_' + zeropad(nSlices, 2) + '_' + $
                    zeropad(numGroups, 3) + '.xyz'
                 
         get_lun, fh

         ; unfortunate array names:
         ;    storedX = r values
         ;    storedY = Z values
         ;    storedZ = theta values (0-360 or 0-24)

         ; write the first output file, in table form
         openw, fh, outfname         
         fmt0 = strjoin(replicate(', E11.3', nSlices)) + ')'
         fmt1 = '("           "' + fmt0
         fmt2 = '(E11.3' + fmt0
         printf, fh, format = fmt1, storedZ
         for i = 0, numGroups - 1 do begin
             printf, fh, format = fmt2, storedX[i], storedY[0:nSlices - 1, i]
         end         
         close, fh

         ; write the second output file, in X/Y/Z form
         openw, fh, outfname2
         for j = 0, nSlices - 1 do begin
             theta = storedZ[j]
             if angleMode eq 0 then theta = theta / 180.0 * !pi $
                               else theta = theta / 12.0 * !pi
             for i = 0, numGroups - 1 do begin
                 r = storedX[i]
                 z = storedY[j, i]
                 x = r * cos(theta)
                 y = r * sin(theta)
                 printf, fh, x, y, z
             end
         end
         close, fh

         free_lun, fh

         window, 3
         plot, grpX, storedY[0, 0:numGroups - 1], yrange = [1, max(storedY)], /ylog, /nodata
         for i = 0, nSlices - 1 do begin
             c = (i + 1.0D) / nSlices
             c = floor(c * 127)
             print, c
             c = c * '000102'XUL + 'FF7700'XUL
             plots, grpX, storedY[i, 0:numGroups - 1], color = c
         end
     end   

      else: print, 'Unhandled event: ' + id
  end
end
