pro makegraph
  common graph_common, background, foreground, colors, dataX, dataY,firstDate,$
                       textX, textY, textT

  ymin = min(dataY[where(dataY ne -1)])
  ymax = 0.0 > max(dataY)
  
  xmin = min(dataX[where(dataX ne -1)])
  xmax = max(dataX)
  xrange = xmax - xmin
  xmin = xmin - 0.025 * xrange
  xmax = xmax + 0.025 * xrange
  
  yrange = ymax - ymin
  ymax = ymax + yrange * 0.05
  ymin = ymin - yrange * 0.05


  plot, [0], [0], /nodata, background = background, color = foreground, $
        xrange = [xmin, xmax], xstyle = 1, $
        xtitle = 'Time after ' + firstDate + ' UT (hours)', $
        yrange = [ymin, ymax], ystyle = 1, $
        ytitle = 'Magnetic Longitude (degrees)', $
        xtickinterval = 10, ytickinterval = 20, yminor = 4, xticklen = -0.02, $
        yticklen = -0.015

  smoothness = 32.0D
  xs = dblarr(smoothness)
  ys = dblarr(smoothness)
  xs = cos(indgen(smoothness) / smoothness * 2 * !pi)
  ys = sin(indgen(smoothness) / smoothness * 2 * !pi)
  usersym, xs, ys, /fill

  for g = 0, 9 do begin
      dY = dataY[*, g]
      ind = where(dY ne -1)
      if ind[0] ne -1 then begin
          dX = dataX[where(dY ne -1)]
          dY = dY[where(dY ne -1)]
          oplot, dX, dY, color = colors[g], psym = 8, thick = 2, symsize = 4
      endif
  endfor

  for i = 0, n_elements(textX) - 1 do begin
      print, textX[i], textY[i]
      xyouts, textX[i], textY[i] + 20, textT[i], charsize = 5, /data, color = 0, $
              alignment = 0.5
      oplot, [textX[i], textX[i]], [textY[i] + 9, textY[i] + 18], color = 0, $
             thick = 2
  endfor
end

pro graph, filenum
  common graph_common
  
  background = 'ffffff'XUL
  foreground = '000000'XUL
  colors = ['000000'XUL, '00aa00'XUL, 'ff0000'XUL, 'ff00ff'XUL, 'ff7700'XUL]

  device, retain = 2

  hard = 0
  if hard then begin
      !p.thick=3
      !p.charsize=1.0
      !p.charthick=3
      !x.thick=3
      !y.thick=3
      !y.margin=[4,1]
      !p.linestyle = 0
  
      !p.font = 0
      set_plot,'ps'
      device, /helvetica
      device,filename = 'out.ps'
      device,/landscape
      device,BITS = 8, /color

      r = intarr(256)
      g = intarr(256)
      b = intarr(256)
      r[0] = background mod 256
      g[0] = fix((background mod 65536L) / 256)
      b[0] = fix(background / (65536L))
      background = 0

      r[1] = foreground mod 256
      g[1] = fix((foreground mod 65536L) / 256)
      b[1] = fix(foreground / (65536L))
      foreground = 1

      for i = 0, n_elements(colors) - 1 do begin
          r[2 + i] = colors[i] mod 256
          g[2 + i] = fix((colors[i] mod 65536L) / 256)
          b[2 + i] = fix(colors[i] / (65536L))
          colors[i] = 2 + i
      endfor
      
      tvlct, r, g, b

  endif else begin
      window, 1, /pixmap, xsize = 1600, ysize = 1200
      wset, 1
      !p.thick=3
      !p.charsize=6
      !p.charthick=3
      !x.thick=3
      !y.thick=3
      !x.margin=[6.57,1.1]
      !y.margin=[3.63,0.93]
      !p.linestyle = 0
  
      !p.font = 1
  endelse

;  !p.multi = [0, 2, 2]
  !p.multi = 0

  files = findfile('*.dat')
  
;  for fileNum = 0, n_elements(files) - 1 do begin
  fileNum = 2
  dataX = dblarr(5000) - 1
  dataY = fltarr(5000, 10) - 1

  textX = dblarr(300)
  textY = dblarr(300)
  textT = strarr(300)

  filename = files[fileNum]
  print, filename
  
  openr, 1, filename
  ti = 0
  year = 0.0D
  doy = 0.0D
  hour = 0.0D
  min = 0.0D
  grp = 0D
  mlon = 0.0D
  mlt = 0.0D
  minl = 0.0D
  lastmlt = 0.0D
  for i = 0, numlines(filename) - 1 do begin
      readf, 1, year, doy, hour, min, grp, mlon, mlt, minl
      jd = julday(1.0D, doy, year) + (hour + (min / 60.0D)) / 24.0D ; - 2450000
      if i eq 0 then begin
          firstDate = zeropad(year, 4) + '-' + zeropad(doy, 3) + '/' + $
                      zeropad(hour, 2) + ':' + zeropad(min, 2)
          n = 0
      endif else begin
          if jd ne lastjd then begin
              if lastmlt lt 6 and mlt ge 6 then begin
                  pct = (6 - lastmlt) / (mlt - lastmlt)
                  textX[ti] = lastjd + pct * (jd - lastjd)
                  textY[ti] = mlon
                  textT[ti] = 'Dawn'
                  ti = ti + 1
              endif
              if lastmlt lt 18 and mlt ge 18 then begin
                  pct = (18 - lastmlt) / (mlt - lastmlt)
                  textX[ti] = lastjd + pct * (jd - lastjd)
                  textY[ti] = mlon
                  textT[ti] = 'Dusk'
                  ti = ti + 1
              endif
              n = n + 1
          endif
      endelse
      print, mlt
      lastmlt = mlt
      dataX[n] = jd
      dataY[n, grp] = mlon
      lastjd = jd
  endfor
  close, 1

  dataX = dataX[0:n]
  textX = (textX - min(dataX)) * 24.0D
  dataX = (dataX - min(dataX)) * 24.0D
  textX = textX[0:(ti - 1) > 0]
  textY = textY[0:(ti - 1) > 0]
  textT = textT[0:(ti - 1) > 0]

  makegraph

;  endfor
  if hard then begin
      device, /close
      set_plot, 'x'
  endif else begin
      a = tvrd(true = 3)
      write_png, 'out.png', a[*, *, 0], indgen(256), indgen(256), indgen(256)
      window, xsize = 800, ysize = 600
      a = rebin(a, 800, 600, 3)
      write_png, 'out_small.png', a[*, *, 0], indgen(256), indgen(256), indgen(256)
      tv, a, true = 3
  endelse
end
