function intToStr, i
  return, strmid(strcompress(string(i)), 1, 1000)
end

pro tracer_event, ev
  @tracer_common
  @euv_imtool-commons

  widget_control, ev.id, get_uvalue = info

  if info eq 'changeframeslider' then begin
      v = 0
      widget_control, w_slider10, get_value = v
      tracer_load, v
      return
  endif

  if subback and info eq 'draw' then begin
      if ev.type eq 0 and ev.press eq 1 then begin
          subback_y1 = ev.y > 0 < 299
      endif

      if subback_y1 eq -1 then return

      if ev.type ne 1 then begin
          y2 = ev.y > 0 < 299
          ymin = min([subback_y1, y2])
          height = abs(y2 - subback_y1) + 1
          wset, 3
          Device, Copy = [0, 0, 280, 300, 0, 300, 1]        
          Device, Copy = [0, ymin, 280, height, 0, 300 + ymin, 3]
          wset, drawHandle
          Device, Copy = [0, 300, 280, 300, 0, 0, 3]
      endif

      if ev.type eq 1 and ev.release eq 1 then begin         
          info = 'subback'
          y = ev.y > 0 < 299
          y1 = min([y, subback_y1])
          y2 = max([y, subback_y1])
          darrayL = 10 ^ darray
          for i = 0, 139 do begin
              a = mean(darrayL[i * 2, y1:y2])
              darrayL[(i * 2):(i * 2 + 1), *] = darrayL[(i * 2):(i * 2 + 1), *] - a
          endfor
          displayArray = alog10(darrayL > 1)          
      endif          
  endif

  if info eq 'subback' then begin
      subback = not subback
      if not subback then begin
          widget_control, w_subback, set_value = 'Subtract background'
          subback_y1 = -1
          redrawX
          wset, drawHandle
          Device, Copy = [0, 0, 280, 300, 0, 0, 2]        
          return
      endif else begin
          widget_control, w_subback, set_value = 'Cancel bkgd. subtract'
          backup = displayArray
          displayArray = darray
          redrawX
          wset, drawHandle
          Device, Copy = [0, 0, 280, 300, 0, 0, 1]         
          displayArray = backup
      endelse
      return
  endif

  if subback then return

  if info eq 'slider' and fileLoaded gt -1 then begin
      redrawX
      return
  endif

  if info eq 'slider' then return

  if info eq 'next' then begin
      tracer_load, fileLoaded + 1
      return
  endif

  if info eq 'prev' then begin
      tracer_load, fileLoaded - 1
      return
  endif

  if info eq 'recenter' then begin
      foundEarth = 0
      widget_control, w_save, sensitive = 0
      widget_control, w_recenter, sensitive = 0
      redraw
      return
  endif

  if info eq 'save' then begin
      widget_control, w_text1, get_value = fname
      print, 'Saving ' + strmid(strcompress(string(numPoints)), 1, 1000) + $
             ' points to ' + fname + '...'
      openw, 1, fname
      printf, 1, '# version 2.0'      
      for i = 0, numPoints - 1 do begin
          x = xSpots[i]
          y = ySpots[i]
          sm = [0, 0, 0]
          convertxy, x, y, minl, mlt, maglon, sm
          printf, 1, format = '(F8.2, F8.2, F8.2, I8, I8, I8, I8, I3)', $
                     maglon, mlt, minl, x, y, cir_x, cir_y, cSpots[i]
      endfor
      close, 1
;      if fileLoaded lt (n_elements(filesList) - 1) then tracer_load, fileLoaded + 1
      return
  endif 

  if info eq 'toggleHL' then begin
      if doHL then begin
          doHL = 0
          redraw
          widget_control, w_toggleHL, set_value = 'Enable Highlighting'
      endif else begin
          doHL = 1
          redraw
          widget_control, w_toggleHL, set_value = 'Disable Highlighting'
      endelse
      return
  endif

  if info eq 'hide' then begin
      wset, drawHandle
      Device, Copy = [0, 0, 280, 300, 0, 0, 1]
      return
  endif

  if foundEarth eq 0 then begin
      drawEarth, ev.x, ev.y, drawHandle
      if ev.press eq 1 then begin
          cir_x = ev.x
          cir_y = ev.y
          foundEarth = 1
          redraw
          widget_control, w_save, sensitive = 1
          widget_control, w_recenter, sensitive = 1
      endif
      return
  endif

  if info eq 'draw' and ev.press gt 0 and (fileLoaded gt -1) then begin  
      if ev.press eq 1 then begin
          sm = [0, 0, 0]
;          print, minl, mlt, maglon          
          widget_control, w_slider4, get_value = oldval
          val = fix(darray[dropX, dropY] / 3.1 * 255)
          if lastX gt -1 then val = fix((2 * val + oldval) / 3)
          widget_control, w_slider4, set_value = val
          lastX = dropX
          lastY = dropY
          xSpots[numPoints] = dropX
          ySpots[numPoints] = dropY
          cSpots[numPoints] = nextisconnected
          numPoints = numPoints + 1
          nextisconnected = 1
          redraw
      endif else if ev.press eq 4 then begin
          wset, 2
          Device, Copy = [0, 0, 280, 300, 0, 0, 1]
          numPoints = numPoints - 1
          if numPoints gt 0 then begin
              dist = (xSpots[0:numPoints] - ev.x) ^ 2 + $
                     (ySpots[0:numPoints] - ev.y) ^ 2
              i = where(dist eq min(dist))
              i = i[0]
              if i eq 0 then begin
                  xSpots[0:numPoints - 1] = xSpots[1:numPoints]
                  ySpots[0:numPoints - 1] = ySpots[1:numPoints]
                  cSpots[0:numPoints - 1] = cSpots[1:numPoints]
                  cSpots[0] = 0
              endif else if i lt numPoints then begin
                  xSpots[0:numPoints - 1] = [xSpots[0:i - 1], xSpots[i + 1:numPoints]]
                  ySpots[0:numPoints - 1] = [ySpots[0:i - 1], ySpots[i + 1:numPoints]]
                  cSpots[i + 1] = 0
                  cSpots[0:numPoints - 1] = [cSpots[0:i - 1], cSpots[i + 1:numPoints]]
              endif else begin
                  lastX = -1
                  nextisconnected = 0
              endelse
              start = 0
              for i = 1, numPoints - 1 do begin
                  if cSpots[i] eq 0 then begin
                      plots, xSpots[start:i - 1], ySpots[start:i - 1], /device, $
                             color = 'ffffcc'XUL
                      start = i
                  endif
              endfor
              plots, xSpots[start:numPoints - 1], ySpots[start:numPoints - 1], /device, $
                             color = 'ffddcc'XUL
              plots, xSpots[0:numPoints - 1], ySpots[0:numPoints - 1], /device, $
                     psym = 6, color = '000000'XUL, symsize = 0.33333
              plots, xSpots[0:numPoints - 1], ySpots[0:numPoints - 1], /device, $
                     psym = 3, color = 'ffffff'XUL
          endif else numPoints = 0
          drawEarth, cir_x, cir_y, 2
          wset, drawHandle
          Device, Copy = [0, 0, 280, 300, 0, 0, 2]
      endif else begin
          convertxy, ev.x, ev.y, minl, mlt, maglon, sm
          print, '---------------------------------------------------------------------------'
          print, format = '("IMAGE at:       ", F15.4, F15.4, F15.4)', image_smx/ 6378.0, $
                 image_smy / 6378.0, image_smz / 6378.0
          print, format = '("Look vector:    ", F15.4, F15.4, F15.4)', lookv
          print, format = '("Center at:      ", I15, I15)', cir_x, cir_y
          print, ''
          print, format = '("Point selected: ", I15, I15)', ev.x, ev.y
          print, format = '("MinL:           ", F15.4)', minl
          print, format = '("MLT:            ", F15.4)', mlt
          print, format = '("Magnetic Long.: ", F15.4)', maglon
          print, format = '("SM coordinates: ", F15.4, F15.4, F15.4)', sm

          lastX = -1
          lastY = -1
          nextisconnected = 0
      endelse
  endif else begin
      Device, Copy = [0, 0, 280, 300, 0, 0, 2]
      if lastX eq -1 then begin
          dropX = ev.x
          dropY = ev.y
      endif else begin
          difX = ev.x - lastX
          difY = ev.y - lastY
          if difX eq 0 then difX = 0.00001
          difX = double(difX)
          difY = double(difY)
          angle = atan(difY, difX)
          dropX = fix(lastX + fixedDist * cos(angle))
          dropY = fix(lastY + fixedDist * sin(angle))
      endelse
      plots, [dropX], [dropY], /device, psym = 7, color = '0000ff'xul, symsize = 1
  endelse
  
end
