;		procedure name: get_lookv
;		author: D. Gallagher NASA/MSFC/SD50
;		date: February 14, 2001
;    Modified 2 August 2002 by Bill Sandel
;      to correct the transformation from pixel coordinates
;      to the look direction vector lookv.
;
;  Procedure for obtaining a unit LOS look vector in SM coordinates
;  look vector is defined by the user ponting to a position in an image
;  and passing the indicies of that position into this routine.
;
;  (ix,iy) = indicies of position in current image where user wants LOS vector
;  (isize,jsize) = (x,y) dimensions of EUV image
;  pos = (x,y,z) position of the observer in solar magnetic (SM) coordinates
;  upvec = (x,y,z) vector in SM coordinates that defines "up" in the EUV
;           instrument field of view.  Recommended that the IMAGE spacecraft
;           velocity vector or its negative be used.
;  lookv = (x,y,z) unit vector in SM coordinates of LOS vector corresponding to
;          provided (ix,iy) image indicies
;
;  In obtaining this vector it is assumed that there are 140 pixels across in the
;  image x-direction (horizontal) and that there are 0.6 degrees per pixel.  If the
;  image referenced in calling this routine has more or less pixels in the x-direction
;  then the degrees per pixel are scaled correspondingly.
;
pro new_get_lookv,ix,iy,isize,jsize,pos,upvec,lookv
  get_lookv,ix,iy,isize,jsize,pos,upvec,lookv
end
