pro convertXY, xx, yy, minL, mlt_look, tp_maglon, sm
  @clkfix_common
  @euv_imtool-commons
  minL = 0
  mlt_look = 0
  tp_maglon = 0

  x = fix(xx)
  y = fix(yy)

  delta_x = cir_x - (280 / 2)
  delta_y = cir_y - (300 / 2)
  new_get_lookv, x - delta_x, y - delta_y, 280, 300, $
             [image_smx/6378.0, image_smy/6378.0, image_smz/6378.0], $
             [-image_smvx, -image_smvy, -image_smvz], lookv

  retVal = { minLret, minL:0D, px:0D, py:0D, pz:0D }

  zzz = get_min_l([double(image_smx/6378.0), double(image_smy/6378.0), $
                   double(image_smz/6378.0)], $
                  [double(lookv[0]), double(lookv[1]), double(lookv[2])], 0)

  minL = zzz[0]
  px = zzz[1]
  py = zzz[2]
  pz = zzz[3]

  sm = [px, py, pz]

  along = atan(py, px)


  mlt_look = ((along + !PI) * !RADEG) / 15.0
  if(mlt_look gt 24.0) then mlt_look = mlt_look - 24.0
  tp_sm = [px, py, pz]
  tp_mag = tp_saved##tp_sm
  tp_maglon = atan(tp_mag[1], tp_mag[0]) * !RADEG

  if(tp_maglon lt 0.0) then tp_maglon = tp_maglon + 360.0
end
