pro clkfix
  @euv_imtool-commons
  @clkfix_common

  clkFiles = findfile('old/*.clk')
  fitsFiles = findfile('old/*.fits')

  files = clkFiles
  goodfiles = ['']
  badfiles = ['']
  outclks = ['']

  filesN = n_elements(files)
  if filesN eq 0 then begin
      print, 'clkfix: No CLK files found'
      return
  endif
  
  for i = 0, n_elements(files) - 1 do begin
      files[i] = strmid(clkFiles[i], 0, $
                        strpos(clkFiles[i], '.', /reverse_search))

      ind = where(fitsFiles eq (files[i] + '.fits'))
      if ind[0] eq -1 then badfiles = [badfiles, files[i]] $
      else begin
          outclk = strmid(files[i], strpos(files[i], '/', $
                                           /reverse_search) + 1, 100)
          outclk = 'new/' + outclk
          goodfiles = [goodfiles, files[i]]
          outclks = [outclks, outclk]
      endelse
  endfor

  for i = 1, n_elements(badfiles) - 1 do begin
      print, 'clkfix: ' + badfiles[i] + '.fits is missing'
  endfor

  if n_elements(goodfiles) eq 1 then begin
      print, 'clkfix: No usable CLK files found, exiting ...'
      return
  endif

  files = goodFiles[1:(n_elements(goodFiles) - 1)]
  outclks = outclks[1:(n_elements(outclks) - 1)]

  get_lun, u
  get_lun, u2

  a = ''
  maglon = 0.0D
  mlt = 0.0D
  minl = 0.0D
  x = 0.0D
  y = 0.0D
  cir_x = 0.0D
  cir_y = 0.0D
  conn = 0.0D
  sm = [0, 0, 0]

  window

  for i = 0, n_elements(files) - 1 do begin
      print, 'clkfix: Processing ' + files[i] + '.clk ...'

      print, 'clkfix: - opening input click file ...'
      openr, u, files[i] + '.clk'
      numPoints = numlines(files[i] + '.clk') - 1    

      print, 'clkfix: - opening output click file ...'
      openw, u2, outclks[i] + '.clk'

      print, 'clkfix: - opening FITS file ...'
      clkfix_loadfits, files[i] + '.fits'
      calc_sm_coords
      tp_saved = t5##t1##transpose(t2)##transpose(t3)##transpose(t4)

      print, 'clkfix: - recalculating points and writing output file ...'
      readf, u, a ; header
      printf, u2, a
      for j = 0, numPoints - 1 do begin
          readf, u, maglon, mlt, minl, x, y, cir_x, cir_y, conn
          convertxy, x, y, minl, mlt, maglon, sm
          printf, u2, format = '(F8.2, F8.2, F8.2, I8, I8, I8, I8, I3)', $
                      maglon, mlt, minl, x, y, cir_x, cir_y, conn
      endfor

      print, 'clkfix: - closing click files ...'
      close, u2
      close, u
  endfor

  free_lun, u2
  free_lun, u
end
